<?php
require_once __DIR__ . '/../environment.php';

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

// Establecemos unas rutas básicas para el funcionamiento de la web sin la parte de visitas. Lo ponemos aquí para que no interfiera con Visitas
if (ENVIRONMENT == 'development') {
    define('URLPATH', $domainLink . '/wp-content/plugins/visitas/');
    define('BASEPATH', '/server/www/html/' . $_SERVER['HTTP_HOST'] . '/httpdocs/wp-content/plugins/visitas/');
} elseif (ENVIRONMENT == 'preproduction') {
    define('URLPATH', $domainLink . '/wp-content/plugins/visitas/');
    define('BASEPATH', '/server/www/html/' . $_SERVER['HTTP_HOST'] . '/httpdocs/wp-content/plugins/visitas');
    // Production
} else {
    define('URLPATH', $domainLink . '/wp-content/plugins/visitas/');
    define('BASEPATH', $_SERVER['DOCUMENT_ROOT'].'/wp-content/plugins/visitas');
}

// Definimos las variables comunes. Carpetas donde se encuentran los controladores
define('CONTROLLERSFOLDER', BASEPATH . '/controllers/');

// Lanzamos una sesión si no se ha creado todavía
if (!isset($_SESSION)) {
    session_start();
}

// Configuramos el apartado de idiomas de la web que afecta al header y al footer. La parte central de Visitas se llama y organiza desde otro sitio; cuidado con los nombres de las variables para no sobreescribirse.
require_once BASEPATH . '/libs/I18N.php';

I18N::changeLanguage(I18N::getLang());
I18N::init('messages', './i18n', 'es_ES', array(
    '/^en((-|_).*?)?$/i' => 'en_GB',
    '/^es((-|_).*?)?$/i' => 'es_ES',
));

require_once BASEPATH . '/libs/Language.php';
$language = Language::singleton();

// Cargamos todos los controladores para que los reconozca la apliación.
require_once BASEPATH . '/libs/Autoloader.php';
$autoloader = new Autoloader();

// Incluimos el FrontController y recogemos el punto actual de la pagina
require_once BASEPATH . '/libs/FrontController.php';
$frontController = new FrontController();
$controlador     = $frontController->getControllerName();
$accion          = $frontController->getActionName();
$parametros      = $frontController->getParamsUrl();

require  BASEPATH .'/modules/visitas/reservas/lib/autoload.php';
use Dotenv\Dotenv;
$dotenv = Dotenv::create(BASEPATH );
$dotenv->load();

if(!DEFINED('ANALITICS_REGISTRO_COMPRA')){
    define('ANALITICS_REGISTRO_COMPRA', $_ENV['ANALITICS_REGISTRO_COMPRA']);
}
if(!DEFINED('ANALITICS_CODIGO')){
    define('ANALITICS_CODIGO',          $_ENV['ANALITICS_CODIGO']);
}
if(!DEFINED('ANALITICS_CLAVE')){
    define('ANALITICS_CLAVE',           $_ENV['ANALITICS_CLAVE']);
}
