<?php
/**
 * Plugin Name: Visitas JIG
 * Plugin URI: https://www.jig.es
 * Description: Display visits using a shortcode to insert in a page or post
 * Version: 1.0
 * Text Domain: visits-plugin
 * Author: JIG
 * Author URI: https://www.jig.es
 */
if (!isset($_SESSION)) {
    session_start();
}

function shutdownHandler() //will be called when php script ends.

{
    $lasterror = error_get_last();

    if (!isset($_SESSION['fatal']) && $lasterror['type'] == E_ERROR) {
        $error             = "[SHUTDOWN]:" . $lasterror['type'] . " | msg:" . $lasterror['message'] . " | file:" . $lasterror['file'] . " | ln:" . $lasterror['line'];
        $_SESSION['fatal'] = $error;
        if (http_response_code() != 404) {
            require_once dirname(__DIR__) . '/visitas/errors/500.php';
            die();
        }
    }
}


function visitas_shortcode()
{
    
    /*if(headers_sent($filename, $linenum)){
        print "<pre>" . print_r(session_status(), true) . "</pre>";
        print "<pre>" . print_r(PHP_SESSION_NONE, true) . "</pre>";
        print "<pre>" . print_r(PHP_SESSION_ACTIVE, true) . "</pre>";
        echo "Headers already sent in $filename on line $linenum\n";
        //exit;
    }*/


    

    if (!isset($_SESSION['fatal'])) {
        //Carga la plantilla con la header y el footer
        
        ob_start();
        require_once 'templates/layout.php';
        $content = ob_get_clean();
        return $content;
    } else {
        $error             = $_SESSION['fatal'];
        $_SESSION['fatal'] = null;
        unset($_SESSION['fatal']);
    
        require_once dirname(__DIR__) . '/visitas/errors/500.php';
        die();
    }

    register_shutdown_function("shutdownHandler");
}

add_shortcode('svisitas', 'visitas_shortcode');