<?php

require_once CONTROLLERSFOLDER . 'EnoturismoController.php';
require_once CONTROLLERSFOLDER . 'EnoexperienciaController.php';
require_once CONTROLLERSFOLDER . 'ProductosController.php';
require_once CONTROLLERSFOLDER . 'TusvisitasController.php';
require_once CONTROLLERSFOLDER . 'ErrorsController.php';
require_once CONTROLLERSFOLDER . 'RegalosController.php';

/**
 * Clase Front Controller muy básica.
 * En este caso no vamos a utilizar un MVC dado que la parte de Visitas tiene su propio funcionamiento y no lo podemos adaptar.
 * Para que se parezca a los demas gestores de visitas, vamos a limitarnos a llamar a los phps correspondientes como si estuvieramos en un gestor de contenidos.
 */

class FrontController
{

    const DEFAULT_CONTROLLER = "EnoturismoController";
    const DEFAULT_ACTION     = "index";
    const DEFAULT_LANG       = "es";

    protected $lang       = self::DEFAULT_LANG;
    protected $controller = self::DEFAULT_CONTROLLER;
    protected $action     = self::DEFAULT_ACTION;
    protected $params     = array();
    protected $basePath   = "/";

    public function main()
    {
        //Iniciamos el controlador y su accion que hemos procesado anteriormente

        $controllerPath = CONTROLLERSFOLDER . $this->controller . '.php';

        //Comprobamos una vez mas si algo va a fallar antes de empezar
        if (!is_file($controllerPath)) {
            die('El controlador no existe - 404 not found');
        }

        //Si no existe la clase que buscamos y su acción, mostramos un error 404
        if (is_callable(array($this->controller, $this->action)) == false) {
            trigger_error($this->controller . '->' . $this->action . '` no existe', E_USER_NOTICE);
            return false;
        }

        $accion = (String) $this->action;

        //Si todo esta bien, creamos una instancia del controlador y llamamos a la acción.
        $controller = new $this->controller();
        $controller->$accion($this->params);
    }

    public function run()
    {
        call_user_func_array(array(new $this->controller, $this->action), $this->params);
    }

    public function __construct(array $options = array())
    {

        if (empty($options)) {
            $this->parseUri();
        } else {
            if (isset($options["lang"])) {
                $this->setLang($options["lang"]);
            }
            if (isset($options["controller"])) {
                $this->setController($options["controller"]);
            }
            if (isset($options["action"])) {
                $this->setAction($options["action"]);
            }
            if (isset($options["params"])) {
                $this->setParams($options["params"]);
            }
        }
    }

    protected function parseUri()
    {
        $path = trim(parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH), "?");

        $path = $_SERVER["REQUEST_URI"];

        //Recuperamos todos los datos y establecemos sus valores
        $lista = explode("?", $path, 4);

        switch ($lista[0]) {
            case '/enoexperiencia/':
                $controller = 'enoexperiencia';
                $lang       = 'es';

                //Si no tenemos la informacion del servicio redireccionamos a las visitas
                if ( sizeof($lista) == 1){                     

                    ob_start();        
                    echo "<script>location.href = '/visitas/';</script>";
                    ob_end_flush();                
                    die();
                }
                break;
            case '/en/enoexperience/':
                $controller = 'enoexperiencia';
                $lang       = 'en';

                //Si no tenemos la informacion del servicio redireccionamos a las visitas
                if ( sizeof($lista) == 1){                     

                    ob_start();        
                    echo "<script>location.href = '/en/visits/';</script>";
                    ob_end_flush();                
                    die();
                }
                break;
             case '/fr/enoexperience-fr/':
                $controller = 'enoexperiencia';
                $lang       = 'fr';
                break;
            case '/tusvisitas/':
                $controller = 'tusvisitas';
                $lang       = 'es';
                break;
            case '/en/yourvisits/':
                $controller = 'tusvisitas';
                $lang       = 'en';
                break;
             case '/fr/vos-visites/':
                $controller = 'tusvisitas';
                $lang       = 'fr';
                break;
            case '/visitas/':
                $controller = 'enoturismo';
                $lang       = 'es';
                break;
            case '/visits/':
                $controller = 'enoturismo';
                $lang       = 'en';
                break;
             case 'fr/visites/':
                $controller = 'enoturismo';
                $lang       = 'fr';
                break;
            case '/agenda-cultural/':
                $controller = 'enoturismo';
                $lang       = 'es';
                break;
            case '/winery-events/':
                $controller = 'enoturismo';
                $lang       = 'en';
                break;
            case '/gastro-bar/':
                $controller = 'productos';
                $lang       = 'es';
                break;
            case '/en/bar-gastro/':
                $controller = 'productos';
                $lang       = 'en';
                break;
            case '/regalar/':
                $controller = 'regalos';
                $lang       = 'es';
                break;
            case '/en/give-away/':
            case '/en/gift-card/':
                $controller = 'regalos';
                $lang       = 'en';
                break;
            case '/fr/cadeau/':
                $controller = 'regalos';
                $lang       = 'en';
                break;
            default:
                $controller = 'enoturismo';
                $lang       = 'es';
                break;
        }

        if (isset($lista[1])) {
            $partes = explode("&", $lista[1]);

            $action = isset($partes[0]) ? $partes[0] : null;
            $params = isset($partes[1]) ? $partes[1] : null;
        }else{
            $action = null;
            $params = null;
        }

        if (isset($lang) && $lang != null) {
            if ($this->isSoportedLang($lang)) {
                $this->setLang($lang);
            } else {
                // $path = '/' . $this->lang . '/' . $path;
                // header("LOCATION: " . $path);
            }
        }

        if (isset($controller)) {
            //Para traducciones aceptadas
            if ($controller == 'winetourism') {
                $controller = 'enoturismo';
            }
            if ($controller == 'enoexperience') {
                $controller = 'enoexperiencia';
            }
            if ($controller == 'yourwinetours') {
                $controller = 'tusvisitas';
            }
            $this->setController($controller);
        }

        if (isset($action)) {
            //Para traducciones aceptadas
            if ($action == 'purchase') {
                $action = 'comprar';
            }
            if ($action == 'cancel') {
                $action = 'anular';
            }
            if ($action == 'NotFound') {
                $action = 'noEncontrado';
            }
            /*if ($action == 'invoicerequest') {
            $action = 'solicituddefactura';
            }*/
            $this->setAction($action);
        }

        if (isset($params) || isset($action)) {
            $params_aux = array();
            if(!empty($params)){
                $params_aux = explode("/", $params);
            }
            $this->setParams($params_aux, $action);
        } else {
            if (isset($_REQUEST['id'])) {
                $this->setParams(array(0 => $_REQUEST['id']), $action);
            }
        }
    }

    public function isSoportedLang($lang)
    {
        return ($lang == 'es' || $lang == 'en');
    }

    public function setController($controller)
    {
        $controller     = ucfirst(strtolower($controller)) . "Controller";
        $controllerPath = CONTROLLERSFOLDER . $controller . '.php';

        //Si no existe el controlador cuando estamos inicializando la clase lanzamos un error casero
        if (!is_file($controllerPath)) {
            $this->thorwError('404', 'Not Found');
        }
        $this->controller = $controller;

        return $this;
    }

    public function setAction($action)
    {
        $reflector = new ReflectionClass($this->controller);

        //Comprobamos si el controlador tiene una accion con el nombre establecido o una por defecto (index)
        if (!$reflector->hasMethod($action)) {
            if (!$reflector->hasMethod(self::DEFAULT_ACTION)) {
                $this->thorwError('404', 'Not Found');
            } else {
                $action = self::DEFAULT_ACTION;
            }
        }

        $this->action = $action;
        return $this;
    }

    public function setParams(array $params, $action)
    {
        $reflector = new ReflectionClass($this->controller);
        if (!$reflector->hasMethod($action)) {
            if (!empty($params[0])) {
                //Esto ya no es necesario
                //array_unshift($params, $action);
            } else {
                $params[0] = $action;
            }
        }

        $this->params = $params;
        return $this;
    }

    public function setLang($lang)
    {
        $this->lang = $lang;

        return $this;
    }

    public function getControllerName()
    {
        $controlador = str_replace('Controller', '', $this->controller);

        return strtolower($controlador);
    }

    public function getActionName()
    {
        return $this->action;
    }

    public function getParamsUrl()
    {
        return implode('/', $this->params);
    }

    /**
     * Función para lanzar errores
     * 404 y 500 aunque el 500 lo lanzamos también desde el index cuando detectamos un error de php.
     * Para el error 404 cargamos la página normal pero con una seccion definida.
     * Para el error 500 cargamos una plantilla propia ya que vamos a forzar una recarga de la página.
     */
    public function thorwError($code, $message)
    {
        header('HTTP/1.0 ' . $code . ' ' . $message);
        http_response_code(404);
        switch ($code) {
            case '404':
                if ($this->lang == 'en') {
                    header("Location: " . URLPATH . $this->lang . '/errors/NotFound');
                } else {
                    header("Location: " . URLPATH . $this->lang . '/errors/noEncontrado');
                }
                break;

            case '500':
                header("Location: " . URLPATH . $this->lang . '/errors/error');
                break;
        }

        die();
    }
}
