<?php

class Language
{

    private static $instance;

    /**
     * Funcion que devuelve la palabra, frase o direccion en el idioma contrario, lo controlamos a través de I18n pero lo centralizamos todo aquí para tener un único fichero de idiomas
     */
    public function get($var)
    {
        $traducciones                            = array();
        $traducciones['Español']                = _('Español');
        $traducciones['Inglés']                 = _('Inglés');
        $traducciones['Enoturismo']              = _('Enoturismo');
        $traducciones['enoturismo']              = _('enoturismo');
        $traducciones['Bodega']                  = _('Bodega');
        $traducciones['Nuestros vinos']          = _('Vinos');
        $traducciones['Celebra tu evento']       = _('Eventos');
        $traducciones['Noticias']                = _('Blog');
        $traducciones['Contacto']                = _('Contacto');
        $traducciones['lang']                    = _('es');
        $traducciones['URLBodega']               = _('');
        $traducciones['URLNuestrosVinos']        = _('');
        $traducciones['URLCelebraTuEvento']      = _('');
        $traducciones['URLNoticias']             = _('');
        $traducciones['URLContacto']             = _('');
        $traducciones['Tus Visitas']             = _('Tus Visitas');
        $traducciones['Politica de Privacidad']  = _('Política de Privacidad');
        $traducciones['URLPoliticaDePrivacidad'] = _('');
        $traducciones['Politica de Cookies']     = _('Política de Cookies');
        $traducciones['URLPoliticaDeCookies']    = _('');
        $traducciones['Aviso Legal']             = _('Aviso Legal');
        $traducciones['URLAvisoLegal']           = _('');
        $traducciones['EstasPerdido']            = _('¿Estás perdido?');
        $traducciones['PageNotFound']            = _('La página que estabas buscando no existe');
        $traducciones['ContactaConNosotros']     = _('Contacta con nosotros');
        $traducciones['QuieresVisitarnos']       = _('¿Quieres visitarnos?');
        $traducciones['Oops']                    = _('Oops! Algo ha fallado...');
        $traducciones['PaginaNoDisponible']      = _('La página no está disponible ahora, inténtalo más tarde o ponte en contacto con nosotros');

        return (isset($traducciones[$var])) ? $traducciones[$var] : $var;
    }

    /**
     * Función que nos devuelve siempre la traducción al inglés independientemente del idioma actual.
     */
    public function getInverse($var)
    {
        $traducciones                   = array();
        $traducciones['enoturismo']     = _('winetourism');
        $traducciones['enoexperiencia'] = _('enoexperience');
        $traducciones['comprar']        = _('purchase');

        return (isset($traducciones[$var])) ? $traducciones[$var] : $var;
    }

    public static function singleton()
    {
        if (!isset(self::$instance)) {
            $c              = __CLASS__;
            self::$instance = new $c;
        }

        return self::$instance;
    }
}
