<?php

/**************    Include cabecera  ***********************************/
require_once dirname(__DIR__) . '/../index_ajax.php';

// Valido fecha de la reserva a anular
if ($_POST['fecha'] == 0) {
    echo 0;
} else {

    // Compruebo que la fecha introducida es válida
    $fecha_intr           = cambiaf_a_mysql($_POST['fecha']);
    $_POST['localizador'] = strtoupper(trim($_POST['localizador']));

    $filtro_instalacion = "";
    $lista_instalacion  = "";
   
    if (arrayHasOnlyInts((array)json_decode($_ENV['FILTROINSTALACION_ARRAY'],true))){          
        $lista_instalacion  = implode(",", (array)json_decode($_ENV['FILTROINSTALACION_ARRAY'], true));
        $filtro_instalacion = " AND r.instalacion_id in ( $lista_instalacion ) " ;
    }
    
    $sql_reservas = "SELECT sh.fecha, sh.hora_inicio, r.fecha_reserva, r.sala_horario_id, r.cancelada, s.s_instalacion, s.antelacion_maxima_cancelacion
                     FROM reservas r JOIN sala_horarios sh ON r.sala_horario_id = sh.id
                     JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                     JOIN servicios s ON ss.servicio_id = s.id
                     AND localizador = :localizador 
                     AND sh.fecha = :fecha_intr " . $filtro_instalacion . "                     
                     ORDER BY r.id ASC";
 
    $result_reserva = $conexion->prepare($sql_reservas);
    $result_reserva->execute(array( 
        ':localizador' => $_POST['localizador'],
        ':fecha_intr'  => $fecha_intr,      
    ));  

    if ($result_reserva->rowCount() > 0) {
        $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);

        // Reserva con la fecha introducida ha sido anteriormente cancelada
        if ($row_reserva['cancelada'] == 1) {
            echo 3;
        } else {
            // Compruebo que puede modificar reserva
            $horas_antelacion_maxima = $row_reserva['antelacion_maxima_cancelacion'];
            $fecha_hora_actual       = date('Y-m-d H:i:s');

            // Fecha y hora hasta la cual puedo modificar la reserva
            // Fecha y hora que muestro -horas de antelacion máxima
            $fecha_hora_reserva            = $row_reserva['fecha'] . ' ' . $row_reserva['hora_inicio'];
            $fecha_hora_maxima_cancelacion = date("Y-m-d H:i:s", strtotime($fecha_hora_reserva . " -$horas_antelacion_maxima hour"));

            // Puede modificar reserva
            if ($fecha_hora_actual < $fecha_hora_maxima_cancelacion) {
                echo 1;
            } else {
                echo 2;
            }
        }

    } else {
        echo 0;
    }
}
