<?php

/**************    Include cabecera  ***********************************/
require_once dirname(__DIR__) . '/../index_ajax.php';

// Valida localizador de compra
$_POST['localizador'] = strtoupper(trim($_POST['localizador']));

$filtro_instalacion = "";
$lista_instalacion  = "";

if (arrayHasOnlyInts( (array)json_decode($_ENV['FILTROINSTALACION_ARRAY'],true))){          
    $lista_instalacion= implode(",", (array)json_decode($_ENV['FILTROINSTALACION_ARRAY'],true));
    $filtro_instalacion = " AND instalacion_id in ( $lista_instalacion ) " ;
}

$sql_localizador = "SELECT *
                    FROM localizadores
                    WHERE localizador = :localizador 
                    AND estado = 'pagado'
                    AND (web = 1 OR pago_instalacion = 1) " . $filtro_instalacion;

$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(':localizador' => $_POST['localizador'] ));


if ($result_localizador->rowCount() > 0) {

    $row_localizador = $result_localizador->fetch();

    // Localizador anulado anteriormente
    if ($row_localizador['anulado'] == 1) {
        echo 2;
    }
    // Localizador de pago en instalación
    elseif ($row_localizador['pago_instalacion'] == 1) {
        echo 3;
    }
    elseif ($row_localizador['regalo'] == 1) {
        echo 7;
    } else {
        // COMPRUEBO QUE NO TIENE RESERVAS ASOCIADAS TODAVÍA
        $sql_reservas = "SELECT sh.fecha, r.fecha_reserva, sh.hora_inicio
                         FROM reservas r JOIN sala_horarios sh ON r.sala_horario_id = sh.id
                         AND localizador = :localizador 
                         ORDER BY r.id ASC ";

        $result_reserva = $conexion->prepare($sql_reservas);
        $result_reserva->execute(array(':localizador' => $_POST['localizador'] ));
      

        // Tiene reservas asociadas todavía
        if ($result_reserva->rowCount() > 0) {
            echo 4;
        } else {
            // Fechas para poder anular la compra
            $fecha_actual        = date('Y-m-d H:i:s');
            $fecha_cambio_30dias = date("Y-m-d H:i:s", strtotime($row_localizador['fecha_compra'] . " +30 day"));

            // Compruebo si está usado
            // Compruebo que no se haya impreso si es un bono
            // (caso de uso sólo en la instalación) y si es entrada
            // tenga pases > 0
            $sql_servicio = "SELECT pases
                             FROM servicios
                             WHERE id = :servicio_id  ";

            $result_servicio = $conexion->prepare($sql_servicio);
            $result_servicio->execute(array(':servicio_id' => $row_localizador['servicio_id'] ));

            if ($result_servicio->rowCount() > 0) {
                $row_servicio = $result_servicio->fetch(PDO::FETCH_ASSOC);

                // Es un bono, si está impreso en taquilla está usado
                if ($row_servicio['pases'] > 1) {

                    if ($row_localizador['impreso_en_taquilla'] == 1) {
                        echo 5; //Usado
                    } else {
                        // Puede anular la compra en los 30 días posteriores
                        // a la fecha de compra
                        if ($fecha_actual < $fecha_cambio_30dias) {
                            // Puede anular compra
                            // Devuelvo estado y fecha de compra
                            $datos_compra = array();

                            $datos_compra['estado']       = 1;
                            $fecha_compra                 = date("Y-m-d", strtotime($row_localizador['fecha_compra']));
                            $datos_compra['fecha_compra'] = $fecha_compra;

                            echo json_encode($datos_compra);
                        } else {
                            echo 6; //ha superado los días
                        }
                    }
                } else {
                    if ($row_localizador['servicio_pases'] == 0) {
                        echo 5; //Usado
                    } else {
                        // Puede anular la compra en los 30 días posteriores
                        // a la fecha de compra
                        if ($fecha_actual < $fecha_cambio_30dias) {
                            // Puede anular compra
                            // Devuelvo estado y fecha de compra
                            $datos_compra = array();

                            $datos_compra['estado'] = 1;
                            $fecha_compra           = date("Y-m-d", strtotime($row_localizador['fecha_compra']));
                            $fecha_compra           = cambiaf_a_mysql($fecha_compra);
                            $datos_compra['fecha']  = $fecha_compra;

                            echo json_encode($datos_compra);
                        } else {
                            echo 6; //ha superado los días
                        }
                    }
                }
            }
        }
    }
} else {
    echo 0;
}
