<?php

/**************    Include cabecera  ***********************************/
require_once dirname(__DIR__) . '/../index_ajax.php';

// Sólo se puede realizar la solicitud de factura a partir de haber
// realizado la visita
// Valida localizador de compra
$_POST['localizador'] = strtoupper(trim($_POST['localizador']));

$filtro_instalacion   = "";
$filtro_instalacion_r = "";
$lista_instalacion    = "";

if (arrayHasOnlyInts( (array)json_decode($_ENV['FILTROINSTALACION_ARRAY'], true))){          
    $lista_instalacion    = implode(",", (array)json_decode($_ENV['FILTROINSTALACION_ARRAY'], true));
    $filtro_instalacion   = " AND instalacion_id in ( $lista_instalacion ) " ;
    $filtro_instalacion_r = " AND r.instalacion_id in ( $lista_instalacion ) " ;
}

$sql_localizador = "SELECT *
                    FROM localizadores
                    WHERE localizador = :localizador " . $filtro_instalacion;

$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(':localizador' => $_POST['localizador'] ));

if ($result_localizador->rowCount() > 0) {

    // Compruebo si la visita ha pasado
    $sql_reserva = "SELECT sh.fecha, sh.hora_inicio, sh.hora_fin
                    FROM reservas r JOIN sala_horarios sh  ON r.sala_horario_id = sh.id
                    AND r.localizador = :localizador " . $filtro_instalacion_r ;

    $result_reserva = $conexion->prepare($sql_reserva);  
    $result_reserva->execute(array(':localizador' => $_POST['localizador'] ));
    
    if ($result_reserva->rowCount() > 0) {

        $row_reserva = $result_reserva->fetch();

        $fecha_dia_hoy    = date('Y-m-d H:i:s');
        $fecha_dia_visita = $row_reserva['fecha'] . ' ' . $row_reserva['hora_inicio'];

        // La fecha y hora actual es mayor a la de la visita
        if ($fecha_dia_hoy >= $fecha_dia_visita) {
            echo 1; // Puedo solicitar factura
        } else {
            echo 0; // No puedo solicitar factura
        }
    } else {
        echo 3; // No tiene reservas asociadas
    }
} else {
    echo 2; // Localizador no válido
}
