<?php
ini_set('display_errors', '0');
ini_set("log_errors", 1);
ini_set("error_log", "../logs/error.log");

require_once __DIR__ . '/../../../environment.php';

date_default_timezone_set('Europe/Madrid');

require __DIR__ . '/../reservas/lib/autoload.php';
use Dotenv\Dotenv;
$dotenv = Dotenv::create(__DIR__ .'/../../..');
$dotenv->load();

$protocol   = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

define('CARPETAPROYECTO',   $_ENV['CARPETAPROYECTO']);
define('DIRECCIONPROYECTO', $domainLink . '/wp-content/plugins/visitas');
define('DIRECCIONGESTOR',   $_ENV['DIRECCIONGESTOR']);

// Datos de la BBDD local
define('BDENGINEMISPHP',   $_ENV['BDENGINE']);
define('BDHOSTMISPHP',     $_ENV['BDHOST']);
define('BDDATABASEMISPHP', $_ENV['BDDATABASE']);
define('BDUSERMISPHP',     $_ENV['BDUSER']);
define('BDPASSMISPHP',     $_ENV['BDPASS']);

define('MAILHOST',     $_ENV['MAILHOST']);
define('MAILSMTPAUTH', $_ENV['MAILSMTPAUTH']);
define('MAILUSER',     $_ENV['MAILUSER']);
define('MAILPASS',     $_ENV['MAILPASS']);
define('MAILFROM',     $_ENV['MAILFROM']);
define('MAILPORT',     $_ENV['MAILPORT']);
define('FILTROINSTALACION_ARRAY', $_ENV['FILTROINSTALACION_ARRAY']);

//Directorios de la aplicación
define('DLIB',                 CARPETAPROYECTO . '/modules/visitas/reservas/lib/');
define('DTPL',                 CARPETAPROYECTO . '/modules/visitas/mis_php_web/templates');
define('DLIBMISPHP',           CARPETAPROYECTO . '/modules/visitas/mis_php_web/lib/');
define('DIRLANGUAGESTRINGS',   CARPETAPROYECTO . '/modules/visitas/mis_php_web/php_strings/');
define('DIRLANGUAGETEMPLATES', CARPETAPROYECTO . '/modules/visitas/mis_php_web/templates/');

define('DIRCSS',       DIRECCIONPROYECTO . '/modules/visitas/mis_php_web/css/');
define('DIRJSTARIFAS', DIRECCIONPROYECTO . '/modules/visitas/mis_php_web/js/');
define('DIRJ',         DIRECCIONPROYECTO . '/modules/visitas/mis_php_web/js/');
define('DIRJRESERVAS', DIRECCIONPROYECTO . '/modules/visitas/reservas/js/');

define('DOMRESERVAS',      DIRECCIONPROYECTO . '/modules/visitas/reservas/');
define('DOMINIOPRINCIPAL', DIRECCIONPROYECTO . '/modules/visitas/reservas/');
define('DOM',              DIRECCIONPROYECTO . '/');

// Constantes varias
// Establece el segmento de la url que contiene el idioma, varía de producción a desarrollo
define('SEGMENT_URL_LANG', $_ENV['SEGMENT_URL_LANG']);

define('ANALITICS_REGISTRO_COMPRA', $_ENV['ANALITICS_REGISTRO_COMPRA']);
define('ANALITICS_CODIGO',          $_ENV['ANALITICS_CODIGO']);
define('ANALITICS_CLAVE',           $_ENV['ANALITICS_CLAVE']);

define('PASSBOOK_P12_FILE',             CARPETAPROYECTO . '/modules/visitas/reservas/files/' . $_ENV['PASSBOOK_FILE']);
define('PASSBOOK_P12_PASSWORD',         $_ENV['PASSBOOK_P12_PASSWORD']);
define('PASSBOOK_WWDR_FILE',            CARPETAPROYECTO . '/modules/visitas/reservas/files/WWDR.pem');
define('PASSBOOK_PASS_TYPE_IDENTIFIER', $_ENV['PASSBOOK_PASS']);
define('PASSBOOK_TEAM_IDENTIFIER',      $_ENV['PASSBOOK_TEAM_IDENTIFIER']);
define('PASSBOOK_ORGANIZATION_NAME',    $_ENV['PASSBOOK_ORGANIZATION_NAME']);
define('PASSBOOK_OUTPUT_PATH_BASE',     CARPETAPROYECTO . '/modules/visitas/reservas/files/passbook/');
define('PASSBOOK_ICON_FILE',            CARPETAPROYECTO . '/modules/visitas/reservas/images/' . $_ENV['PASSBOOK_ICON_FILE']);
define('PASSBOOK_BACKGROUND_FILE',      CARPETAPROYECTO . '/modules/visitas/reservas/images/'. $_ENV['PASSBOOK_BACKGROUND_FILE']);
