jQuery(function() {
    // VALIDO LOCALIZADOR
    // Si es válido paso al paso siguiente
    jQuery("#ObtenerLocalizador").click(function() {
        var localizador = jQuery("#LocalizadorAnulacion").val();
        // Comprobar plazas en el momento de comprar
        jQuery.ajax({
            type : 'POST',
            url  : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/mis_php_web/ajax/anular/validar_localizador_anular.php',
            data : {
                "localizador": localizador
            },
            cache: false
        }).done(function(valido) {
            // Localizador válido, muestro siguiente paso
            if (valido == 1) {
                jQuery.ajax({
                    type  : 'POST',
                    url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/mis_php_web/modulos/anular/anular_reserva.php',
                    data  : {
                        "localizador": localizador
                    },
                    cache : false
                }).done(function(response) {
                    // Oculto primer paso
                    div               = document.getElementById("IntroducirLocalizador");
                    div.style.display = "none";
                    // Muestro segundo
                    div               = document.getElementById("IntroducirFechaAnulacion");
                    div.style.display = "";
                    // Muestro siguiente paso y cargo js
                    jQuery.getScript('//' + location.host + '/wp-content/plugins/visitas/modules/visitas/mis_php_web/js/anular_reserva.js');
                    jQuery.getScript('//' + location.host + '/wp-content/plugins/visitas/modules/visitas/mis_php_web/js/calendario.js');
                    jQuery("#IntroducirFechaAnulacion").html(response);
                    jQuery("#IntroducirFechaAnulacion").show();
                });
            }
            // Localizador no apto para ser anulado
            else if (valido == 2) {
                div               = document.getElementById("ValidaLocalizadorAnular");
                div.style.display = "";
                jQuery("#ValidaLocalizadorAnular").html(js_traducciones['anular_reserva']['servicio_no_anulable']);
            }
            else if (valido == 3) {              
                div               = document.getElementById("ValidaLocalizadorAnular");
                div.style.display = "";
                jQuery("#ValidaLocalizadorAnular").html(js_traducciones['anular_reserva']['reserva_con_extras']);
            }
            // Localizador no válido, muestro mensaje de error
            else {
                div               = document.getElementById("ValidaLocalizadorAnular");
                div.style.display = "";
                jQuery("#ValidaLocalizadorAnular").html(js_traducciones['anular_reserva']['introduzca_localizador_valido']);
            }
        });
        return false;
    });
    // VALIDO FECHA DE RESERVA
    var FormAnulacionReserva = jQuery('#FormAnularReserva'),
        AnmularReservaAction = FormAnulacionReserva.attr('action');
    FormAnulacionReserva.removeAttr('action');
    jQuery("#ValidaAnularReserva").click(function() {
        var localizador = jQuery('#Localizador').val();
        var fecha       = jQuery('#FechaAnulacion').val();
        // Comprobar plazas en el momento de comprar
        jQuery.ajax({
            type  : 'POST',
            url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/mis_php_web/ajax/anular/validar_fecha_anular.php',
            data  : {
                "localizador" : localizador,
                "fecha"       : fecha
            },
            cache : false
        }).done(function(valida) {
            // Fecha no válida
            if (valida == 0) {
                div               = document.getElementById("ValidaFechaAnulacion");
                div.style.display = "";
                jQuery("#ValidaFechaAnulacion").html(js_traducciones['anular_reserva']['introduzca_fecha_valida']);
            }
            // No puede anular la reserva (queda menos de 1hora para el inicio)
            else if (valida == 2) {
                div               = document.getElementById("ValidaFechaAnulacion");
                div.style.display = "";
                jQuery("#ValidaFechaAnulacion").html(js_traducciones['anular_reserva']['no_puede_anular_reserva']);
            }
            // La fecha de reserva introducida coincide con una reserva cancelada anteriormente
            else if (valida == 3) {
                div               = document.getElementById("ValidaFechaAnulacion");
                div.style.display = "";
                jQuery("#ValidaFechaAnulacion").html(js_traducciones['anular_reserva']['ya_ha_cancelado_la_reserva']);
            }
            // Fecha válida
            else if (valida == 1) {
                FormAnulacionReserva.attr('action', AnmularReservaAction);
                FormAnulacionReserva.submit();
            }
        });
        return false;
    });
    // VUELVE AL PASO DE INTRODUCIR EL LOCALIZADOR
    jQuery("#VolverLocalizador").click(function() {
        var localizador = jQuery('#Localizador').val();
        jQuery.ajax({
            type : 'POST',
            url  : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/mis_php_web/modulos/anular/anular_reserva.php',
            data : {
                "localizadorVolver": localizador
            },
            cache : false
        }).done(function(response) {
            div               = document.getElementById("IntroducirFechaAnulacion");
            div.style.display = "none";
            div               = document.getElementById("IntroducirLocalizador");
            div.style.display = "";
        });
    });
});