jQuery(function() {
    jQuery('#IntroducirLocalizador').on('focus', '#FechasCalendarioReserva', function() {
        
        var instalacion = jQuery('#Instalacion').val(),
            servicio    = jQuery('#Servicios').val();
        
        jQuery.ajax({
            type     : 'POST',
            url      : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/fechas_ocupadas.php',
            dataType : 'json',
            async    : false,
            data     : {
                "actividad"   : '',
                "instalacion" : instalacion,
                "servicio"    : servicio
            },
            success: function(fechas_ocupadas) {
                dias                                = fechas_ocupadas[0];
                fechas_bloquear                     = fechas_ocupadas;
                var calendary_options_complementary = {
                    beforeShowDay: DiasBloqueadosReserva
                };
                jQuery("#FechasCalendarioReserva").datepicker(jQuery.extend(calendario_reservas_opciones, calendary_options_complementary));
            }
        });
    });
});
// Variables globales para usar en las funciones pasadas al datepicker
var dias;
var fechas_bloquear;
/***********************************************************************
 * Función que bloquea días ocupados, fechas inferiores a la actual, 
 * la actual y la del días siguiente 
 **********************************************************************/
function DiasBloqueadosReserva(date) {
    // Si no hay datos seleccionados bloqueo todo el calendario
    if (fechas_bloquear.length == 0) {
        return [false, "dia_nodisponible"];
    } else {
        // Año
        var anio = date.getFullYear();
        // Mes
        if ((date.getMonth() + 1) < 10) {
            var mes = 0 + '' + (date.getMonth() + 1);
        } else {
            var mes = date.getMonth() + 1;
        }
        // Día
        if ((date.getDate()) < 10) {
            var dia = 0 + '' + date.getDate();
        } else {
            var dia = date.getDate();
        }
        // BLOQUEO FECHAS OCUPADAS SI LAS HAY
        if (fechas_bloquear.length > 1) {
            for (i = 1; i < fechas_bloquear.length; i++) {
                //if(jQuery.inArray(anio + '-' + mes + '-' + dia, fechas_bloquear) != -1) 
                if ((anio + '-' + mes + '-' + dia) == fechas_bloquear[i]) {
                    return [false, "dia_nodisponible"];
                }
            }
        }
        // BLOQUEO FECHAS SUPERIORES A LOS DÍAS DEL SERVICIO SELECCIONADO
        fecha_maxima = new Date();
        tiempo       = fecha_maxima.getTime();
        milisegundos = parseInt(dias * 24 * 60 * 60 * 1000);
        total        = fecha_maxima.setTime(tiempo + milisegundos);
        if (date > fecha_maxima) {
            return [false, "dia_nodisponible"];
        }
        return [true, "dia_disponible"];
    }
}