jQuery(function() {
    // DESCARGA DE FACTURA
    jQuery("#DescargarFactura").click(function() {
        var localizador = jQuery("#Localizador").val();
        // Comprobar si el localizador introducido es válido
        jQuery.ajax({
            type  : "POST",
            url   : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/mis_php_web/ajax/factura/validar_factura.php",
            data  : {
                localizador: localizador
            },
            cache : false
        }).done(function(valido) {
            // Localizador no válido
            if (valido == 0) {
                div               = document.getElementById("ValidaLocalizadorCompra");
                div.style.display = "";
                jQuery("#ValidaLocalizadorCompra").html(js_traducciones["factura"]["introduzca_localizador_valido"]);
            }
            // El localizador ha sido cancelado
            else if (valido == 2) {
                div               = document.getElementById("ValidaLocalizadorCompra");
                div.style.display = "";
                jQuery("#ValidaLocalizadorCompra").html(js_traducciones["factura"]["compra_cancelada"]);
            } else {
                jQuery("#DescargaFactura").html(valido);
                jQuery("#DescargaFactura").show();
                jQuery("#DescargarFactura").hide();
            }
        });
        return false;
    });

    // SOLICITAR FACTURA
    var FormSolicitarFactura   = jQuery("#FormSolicitarFactura"),
        SolicitarFacturaAction = FormSolicitarFactura.attr("action");
    
    FormSolicitarFactura.removeAttr("action");
    
    jQuery("#SolicitarFactura").click(function() {
        var localizador = jQuery("#Localizador").val();
        jQuery.ajax({
            type  : "POST",
            url   : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/mis_php_web/ajax/factura/validar_solicitud_factura.php",
            data  : {
                localizador: localizador
            },
            cache : false
        }).done(function(valido) {
            // Puede solicitar factura
            if (valido == 1) {
                jQuery("#ValidaLocalizadorCompra").hide();
                FormSolicitarFactura.attr("action", SolicitarFacturaAction);
                FormSolicitarFactura.submit();
            }
            // No puede solicitar factura: no ha pasado la fecha y hora de visita
            else if (valido == 0) {
                jQuery("#ValidaLocalizadorCompra").show();
                jQuery("#ValidaLocalizadorCompra").html(js_traducciones["factura"]["no_ha_pasado_fecha"]);
            }
            // No tiene reservas asociadas
            else if (valido == 3) {
                jQuery("#ValidaLocalizadorCompra").show();
                jQuery("#ValidaLocalizadorCompra").html(js_traducciones["factura"]["no_tiene_reservas_realizadas"]);
            }
            // Localizador no válido
            else if (valido == 2) {
                jQuery("#ValidaLocalizadorCompra").show();
                jQuery("#ValidaLocalizadorCompra").html(js_traducciones["factura"]["introduzca_localizador_valido"]);
            }
        });
        return false;
    });
});