jQuery(function() {

	/************************** REIMPRIMIR *******************************/
	//Valido si dependiendo de los datos localizados existe una compra o reserva
	//Si los campos introduccidos son validos, devolveremos los datos necesarios para reaprobechar
	var FormImprimir    = jQuery('#ImprimirCompraReserva'),
		data;

    FormImprimir.removeAttr('action');
    
    FormImprimir.find('input[type="submit"]').off('click'); //Para asegurarse que unicamente habra un evento
    FormImprimir.find('input[type="submit"]').on('click', function() {        
        var telefono        = FormImprimir.find('#Telefono').val(),
            fecha 	        = FormImprimir.find('#Fecha').val(),
            localizador     = FormImprimir.find('input[name="localizador"]:checked').val(),
            sala_horario_id = FormImprimir.find('input[name="localizador"]:checked').attr('data-sala-horario-id');
        
        jQuery.ajax({
            url      : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/validacion_imprimir.php',
            data     : { 	
            	telefono        : telefono,
				fecha           : fecha,
				localizador     : localizador,
                sala_horario_id : sala_horario_id
			},
			dataType : 'json',
            type     : 'POST',
            cache    : false
        }).done(function(json) {            
        	if ( json[0] ) {
                
           		if ( json[1] ) {

                    if(location.pathname == '/tusvisitas/'){
                       FormImprimir.attr('action', '/imprimir_compra'); 
                    }else{
                       FormImprimir.attr('action', '/en/print_purchase');
                    }                   

        			FormImprimir.find('.radios').remove();
        			FormImprimir.append(_parseInputHidden(json[2][0]));
                    jQuery("#BotonImprimir").hide();
        			FormImprimir.submit();
    			}

    			if ( !json[1] ) {
    				FormImprimir.find('.radios').remove();
					FormImprimir.find('.boton').before(_parseInputRadio(json[2]));
    			}
        	}
        	else {                
        		jQuery('div[id*="Validacion"]').html('').hide();
        		if ( json[1] ) {
    				if(typeof json['error'] !== undefined && json['error'] == 3){
    					jQuery('#ValidacionDatosIncorrectos').html(js_traducciones['imprimir']['DatosIncorrectos']).show();
    				}
    				else{
                        if (jQuery.type(json[1]) !== "string"){
                            jQuery.each(json[1], function(i, v) {
                                jQuery('#ValidacionDatosIncorrectos').html(js_traducciones['imprimir'][i]).show();
                            });
                        }else{   
                            jQuery('#ValidacionDatosIncorrectos').html(js_traducciones['imprimir'][json[1]]).show();
                        }
    				}
        		}
        	}
        });

        return false;
    });
});

function _parseInputHidden(data) {
	var dom = '';

	jQuery.each(data, function(i, v) {
		dom += '<input type="hidden" name="' + i + '" value="' + v + '"/>';
	});

	return dom;
}

function _parseInputRadio(data) {
	var dom = '<div class="radios">', info;

	jQuery.each(data, function(i, v) {
		info = '<strong>'+ v.localizador + '</strong> - ' + v.instalacion_nombre + ', ' + v.actividad_nombre + ', <span>' + v.fecha_inicio + ' ' + v.hora_inicio + '</span>';
		dom += '<div><input type="radio" name="localizador" value="' + v.localizador + '" data-sala-horario-id="' + v.fecha + '"/> ' + info + '</div>';
	});

	dom += '</div>';

	return dom;
}