<?php

//Clase para traducción
class lang
{

    private $lang        = null;
    private $con         = null;
    private $session     = null;
    private $module_type = 'mis_php_web';

    //Constructor
    public function __construct()
    {
        $this->con  = new SPDO(BDENGINEMISPHP, BDHOSTMISPHP, BDDATABASEMISPHP, BDUSERMISPHP, BDPASSMISPHP);
        $this->lang = 'es_ES';
    }

    /**
     *
     * @param (string) $past_lang en formato es_ES
     * @return boolean Devuelve true si el idioma $past_lang difiere del idioma establecido en la URL,
     *                 false si son el mismo
     */
    public function urlLangHasChanged($past_lang)
    {
        if (!isset($past_lang) || $past_lang == '') {
            return false;
        }

        $_SERVER['REQUEST_URI_PATH'] = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $segments                    = explode('/', $_SERVER['REQUEST_URI_PATH']);
        $lang                        = $segments[SEGMENT_URL_LANG];

        switch ($lang) {
            case 'visitas':
                $lang = 'es_ES';
                break;
            case 'enoexperiencia':
                $lang = 'es_ES';
                break;
            case 'visits':
                $lang = 'en_GB';
                break;
            case 'enoexperience':
                $lang = 'en_GB';
                break;
            case 'yourvisits':
                $lang = 'en_GB';
                break;
            case 'visites':
                $lang = 'fr_FR';
                break;
            case 'enoexperience-fr':
                $lang = 'fr_FR';
                break;
            case 'vos-visites':
                $lang = 'fr_FR';
                break;
            default:
                $lang = 'es_ES';
                break;
        }

        return $lang != $past_lang;

    }

    /**
     *
     * @return Ambigous <string, unknown> Devuelve el idioma obtenidod de URL en formato es_ES
     */
    public function getURLLang()
    {
        $_SERVER['REQUEST_URI_PATH'] = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $segments                    = explode('/', $_SERVER['REQUEST_URI_PATH']);
        $lang                        = $segments[SEGMENT_URL_LANG];

        switch ($lang) {
            case 'en':
                $lang = 'en_GB';
                break;
            case 'visitas':
                $lang = 'es_ES';
                break;
            case 'enoexperiencia':
                $lang = 'es_ES';
                break;
            case 'visits':
                $lang = 'en_GB';
                break;
            case 'enoexperience':
                $lang = 'en_GB';
                break;
            case 'yourvisits':
                $lang = 'en_GB';
                break;
            case 'print_purchase':
                $lang = 'en_GB';
                break;
            case 'fr':
                $lang = 'fr_FR';
                break;
            case 'visites':
                $lang = 'fr_FR';
                break;
            case 'enoexperience-fr':
                $lang = 'fr_FR';
                break;
            case 'vos-visites':
                $lang = 'fr_FR';
                break;
            case 'fr/imprimer_lachat':
                $lang = 'fr_FR';
                break;
            default:
                $lang = 'es_ES';
                break;
        }

        return $lang;
    }

    public function getBrowserLanguage()
    {
        return substr($_SERVER["HTTP_ACCEPT_LANGUAGE"], 0, 2) . '_' . substr($_SERVER["HTTP_ACCEPT_LANGUAGE"], 3, 2);
    }

    //Función que obtiene el idioma del Navegador
    public function getLangNavegador()
    {

        $session_lang = $this->getSessionLang();
        $lang_nav     = '';
        if (!isset($session_lang) || (isset($session_lang) && $this->urlLangHasChanged($session_lang))) {
            $lang_nav = $this->getURLLang();
        } else {
            $lang_nav = $session_lang;
        }

        switch ($lang_nav) {
            case ($lang_nav == 'es' || $lang_nav == 'es_ES'):
                $lang_nav = 'es_ES';
                break;
            case ($lang_nav == 'en' || $lang_nav == 'en_GB'):
                $lang_nav = 'en_GB';
                break;
            case ($lang_nav == 'fr' || $lang_nav == 'fr_FR'):
                $lang_nav = 'fr_FR';
                break;
            case ($lang_nav == 'zh'):
                $lang_nav = 'en_GB';
                break;
            default:
                $lang_nav = 'es_ES';
                break;
        }

        //Compruebo si el idioma está: si no está traducido se pone uno por defecto
        $sql_idiomas = "SELECT *
                        FROM idiomas
                        WHERE iso_code like '" . $lang_nav . "'";

        $result_idiomas = $this->con->query($sql_idiomas);

        if ($result_idiomas->rowCount() == 0) {
            $lang_nav = 'es_ES';
        }
        $this->lang = $lang_nav;
        return $lang_nav;

    }

    //Función que me devuelve el id del idioma dado el iso_code
    public function getIdLang($iso_code)
    {
        //Obtengo iso code
        $sql_idiomas = "SELECT *
                        FROM idiomas
                        WHERE iso_code like '" . $iso_code . "'";

        $result_idiomas = $this->con->query($sql_idiomas);
        $idioma         = $result_idiomas->fetch();

        return $idioma['id'];

    }

    //Función que me devuelve el iso_code dado el id de idioma
    public function getIsoLang($idioma_id)
    {
        //Obtengo id idioma
        $sql_idiomas = "SELECT *
                        FROM idiomas
                        WHERE id = " . $idioma_id . "";

        $result_idiomas = $this->con->query($sql_idiomas);
        $idioma         = $result_idiomas->fetch();

        return $idioma['iso_code'];

    }

    //Función para traducir cadenas
    public function getString($str)
    {

        $this->lang = $this->getIdLang($_SESSION["lang"]);

        $sql = "SELECT DISTINCT(texto_lang)
                FROM i18_lang
                WHERE idioma = '" . $this->lang . "'
                AND texto_original = '" . $str . "'";

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();

            return $row['texto_lang'];
        }

        return $str;
    }

    //Función para traducir todos los campos de un servicio
    public function getStringsProduct($product_id)
    {

        $this->lang = $this->getIdLang($_SESSION["lang"]);

        //Obtengo traducciones
        $sql = "SELECT *
                FROM products_lang
                WHERE idioma = '" . $this->lang . "'
                AND servicio_id = " . $product_id;

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();

            $textos['nombre']            = $row['nombre'];
            $textos['descripcion']       = $row['descripcion'];
            $textos['descripcion_breve'] = $row['descripcion_breve'];

        } else {
            //Sino las hay, muestro las del servicio
            $sql = "SELECT *
                    FROM servicios
                    WHERE id = " . $product_id;

            $result = $this->con->query($sql);
            $row    = $result->fetch();

            $textos['nombre']               = $row['nombre'];
            $textos['descripcion']          = $row['descripcion'];
            $textos['descripcion_breve']    = $row['descripcion_breve'];
            $textos['condiciones_servicio'] = $row['condiciones_servicio'];
            $textos['condiciones_extra']    = $row['condiciones_extra'];


        }

        return $textos;
    }

    //Función que devuelve los archivos de un servicio según idioma
    public function getArchivesProduct($product_id)
    {

        $this->lang = $this->getIdLang($_SESSION["lang"]);
        $archivos   = '';

        //Obtengo archivos del idioma
        $sql_archivos = "SELECT *
                         FROM servicio_archivos
                         WHERE servicio_id = " . $product_id . "
                         AND idioma_id = " . $this->lang;

        $result_archivos = $this->con->query($sql_archivos);

        if ($result_archivos->rowCount() > 0) {

            foreach ($result_archivos->fetchAll() as $row_archivo) {

                $archivo = array(
                    'nombre'  => $row_archivo['nombre'],
                    'archivo' => $row_archivo['archivo'],
                );

                $archivos[] = $archivo;
            }
        }

        return $archivos;
    }

    public function setSessionLang($lang)
    {
        $_SESSION["lang"] = $lang;
    }

    public function getSessionLang()
    {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        return isset($_SESSION["lang"]) ? $_SESSION["lang"] : null;
    }

    public function getFormActionTranslation($action_name, $idioma = null)
    {
        if ($idioma == null) {
            $this->lang = $this->getIdLang($this->getURLLang());
        } else {
            $this->lang = $this->getIdLang($this->getSessionLang());
        }

        $sql = "SELECT DISTINCT(translation)
                FROM front_accion_formulario f
                JOIN front_accion_formulario_idioma i on i.id_front_accion_formulario = f.id_front_accion_formulario
                WHERE id_language = '" . $this->lang . "'
                AND BINARY f.name = '" . $action_name . "'
                AND module_type like '" . $this->module_type . "'
                LIMIT 1";

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();
            return $row['translation'];
        } else {
            return null;
        }

    }

    public function getLangPref()
    {
        return substr($this->getURLLang(), 0, 2);
    }
}
