<?php

/************** Includes **********************************/
require_once '../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

// Compruebo que haya introducido al menos el localizador
if ($_POST['localizador'] != '') {

    $_POST['localizador'] = strtoupper(trim($_POST['localizador']));

    // Compruebo que el localizador introducido es válido o si le quedan
    // todavía reservas por hacer
    $sql_localizador = "SELECT *
                        FROM localizadores
                        WHERE localizador like '" . $_POST['localizador'] . "'
                        AND estado = 'pagado'
                        AND anulacion = 0";

    $result_localizador = $conexion->query($sql_localizador);

    if ($result_localizador->rowCount() > 0) {
        $row_localizador = $result_localizador->fetch(PDO::FETCH_ASSOC);

        // Compruebo que el pago no sea en instalación
        $sql_localizador_instalacion = "SELECT *
                                        FROM localizadores
                                        WHERE localizador like '" . $_POST['localizador'] . "'
                                        AND estado = 'pagado'
                                        AND anulacion = 0
                                        AND pago_instalacion = 1";

        $result_localizador_instalacion = $conexion->query($sql_localizador_instalacion);

        if ($result_localizador_instalacion->rowCount() > 0) {
            $pago_instalacion = true;
            $invalido         = true;
        } else {
            $pago_instalacion = false;
            $invalido         = false;
        }
    } else {
        $pago_instalacion = false;
        $invalido         = true;
    }

    // Compruebo si ha introducido la fecha
    if ($_POST['fecha'] == '') {
        $fecha = 0;
    } else {

        // Compruebo que la fecha introducida es válida
        $fecha_intr = cambiaf_a_mysql($_POST['fecha']);

        // Compruebo si hay una reserva
        $sql_reservas = "SELECT sh.fecha, r.fecha_reserva, sh.hora_inicio, s.s_instalacion
                         FROM reservas r JOIN sala_horarios sh ON r.sala_horario_id = sh.id
                         JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                         JOIN servicios s ON ss.servicio_id = s.id
                         AND localizador like '" . $_POST['localizador'] . "'
                         ORDER BY r.id ASC";

        $result_reserva = $conexion->query($sql_reservas);

        // ES RESERVA
        if ($result_reserva->rowCount() > 0) {

            $fecha = 0;
            foreach ($result_reserva->fetchAll() as $row_reserva) {

                if (date('Y-m-d', strtotime($row_reserva['fecha'])) == $fecha_intr) {
                    $fecha = 1;

                    $hora_actual          = date('Y-m-d H:i:s');
                    $fecha_reserva_valida = $row_reserva['fecha'] . ' ' . $row_reserva['hora_inicio'];
                    $hora_reserva_valida  = date('Y-m-d H:i:s', strtotime($fecha_reserva_valida . " -24 hours"));

                    // Puede anular reserva
                    if (strtotime($hora_actual) <= strtotime($hora_reserva_valida)) {
                        $anular_reserva = 1;

                        // anular_compra a 1 porque estamos con una
                        // fecha de reserva
                        $anular_compra = 1;
                    } else {
                        $anular_reserva = 0;
                        $anular_compra  = 0;
                    }

                }
            }
        } else // no es válida
        {
            $fecha = 0;
        }

    }
}

// Localizador no válido y no ha introducido la fecha
if ($fecha == 0 && $invalido) {
    echo json_encode(2);
}
// Localizador válido pero no ha introducio la fecha
elseif ($fecha == 0 && $invalido == false) {
    echo json_encode(3);
}
// Localizador no válido pero ha introducio la fecha
elseif ($fecha == 1 && $invalido) {
    // Localizador y fecha válidos, pero es un localizador de pago en
    // instalación que no se puede anular
    if ($invalido == true && $pago_instalacion == true) {
        echo json_encode(10);
    } else {
        echo json_encode(4);
    }
}
//Localizador y fecha válidos pero no puede anular reserva
elseif ($fecha == 1 && $invalido == false && $anular_reserva == 0) {
    echo json_encode(6);
}
//válidos
elseif ($fecha == 1 && $invalido == false) {
    echo json_encode(1);

} else {
    echo json_encode(11);
}
