<?php
require_once '../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

$cupon        = $_POST['cupon'];
$servicio     = $_POST['servicio'];
$fecha_visita = $_POST['fecha_visita'];
$localizador  = $_POST['localizador'];

//Convertimos la fecha a una de mysql
$fecha_visita = preg_replace('#(\d{2})/(\d{2})/(\d{4})#', '$3-$2-$1', $fecha_visita);

//Primero comprovamos que es correcto el el cupón
$sql_cupon = "SELECT b.*
              FROM bonos b
              WHERE b.codigo = ?
                    AND b.activo = 1
                    AND b.desde_fecha <= ?
                    AND b.hasta_fecha >= ?
                    AND b.usos_restantes > 0";

$result_cupon = $conexion->prepare($sql_cupon);
$result_cupon->execute(array($cupon, $fecha_visita, $fecha_visita));

if ($result_cupon->rowCount() > 0) {

    $cupon_resultado = $result_cupon->fetch();

    if ($cupon_resultado['servicio_id'] == $servicio || $cupon_servicio['servicio_id'] == '') {

        // Ahora comprobamos que el localizador no tiene ya un bono asociado para que no se pasen de listos
        $sql_localizador = "SELECT l.localizador, l.total, l.bono
                            FROM localizadores l
                            WHERE l.localizador = ?";

        $result_localizador = $conexion->prepare($sql_localizador);
        $result_localizador->execute(array($localizador));

        if ($result_localizador->rowCount() > 0) {
            $localizador_completo = $result_localizador->fetch();

            if ($localizador_completo['bono'] != '') {
                echo 1;
            } else {
                // Le metemos el bono al localizador y cambiamos el total que hay que pagar por supuesto

                $total_actual = $localizador_completo['total'];

                // 2021-09-14: a partir de ahora los cupones pueden afectar sólo a las tarifas o a todo el carrito

                if ($cupon_resultado['afecta_extras'] == 0) {
                    // Buscamos el total de las tarifas
                    $sql_localizador_tarifas    = "SELECT * from localizador_tarifas where localizador = ?";
                    $result_localizador_tarifas = $conexion->prepare($sql_localizador_tarifas);
                    $result_localizador_tarifas->execute(array($localizador));

                    if ($result_localizador_tarifas->rowCount() > 0) {
                        $localizador_tarifas = $result_localizador_tarifas->fetchAll();

                        $total_tarifas = 0;

                        foreach ($localizador_tarifas as $loc_tarifa) {
                            $total_tarifas += $loc_tarifa['plazas_adulto'] * $loc_tarifa['precio_tarifa'];
                        }
                    } else {
                        $total_tarifas = $total_actual;
                    }
                } else {
                    $total_tarifas = $total_actual;
                }

                if ($cupon_resultado['porcentual'] == 1) {
                    $total_nuevo = $total_actual - $total_tarifas * $cupon_resultado['cantidad'] / 100;
                } else {
                    $total_nuevo = $total_actual - $cupon_resultado['cantidad'];
                }

                if ($total_nuevo < 0) {
                    $total_nuevo = 0;
                }
                $sql_update_localizador    = "UPDATE localizadores set bono = ?, total = ?, total_real= ? WHERE localizador = ?";
                $result_update_localizador = $conexion->prepare($sql_update_localizador);
                $result_update_localizador->execute(array($cupon, $total_nuevo, $total_nuevo, $localizador));

                // Modificamos el bono con un uso menos
                $sql_update_bono    = "UPDATE bonos set usos_restantes = usos_restantes -1 WHERE codigo = ?";
                $result_update_bono = $conexion->prepare($sql_update_bono);
                $result_update_bono->execute(array($cupon));
                $cupon_resultado['total_tarifas'] = $total_tarifas;
                echo json_encode($cupon_resultado);

            }
        } else {
            echo 0;
        }

    } else {
        echo 0;
    }
} else {
    echo 0;
}
