<?php

date_default_timezone_set('Europe/Madrid');

/************** Includes **********************************/
require_once '../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

// Array de fechas ocupadas y fechas sin horarios
$fechas_ocupadas = array();
$num             = 1;

// Compruebo días a comprobar en el servicio
$sql_dias_maximo = "SELECT antelacion_reserva, actividad_id, antelacion_minima_reserva
					FROM servicios
					WHERE id = " . $_POST['servicio'];

$result_dias_maximo = $conexion->query($sql_dias_maximo);

if ($result_dias_maximo->rowCount() > 0) {
    $row_dias = $result_dias_maximo->fetch();

    $dias         = $row_dias['antelacion_reserva'];
    $fecha_maxima = date("Y-m-d", strtotime(date("Y-m-d") . " +" . $dias . " day"));

    // Días a mostrar en el calendario
    $fechas_ocupadas[0] = $dias;

    // Actividad
    $actividad = $_POST['actividad'];
    if ($actividad == '') {
        $actividad = $row_dias['actividad_id'];
    }

    // Comprueba si la fecha pasada tiene horas libres o todas ocupadas
    $sql_fecha_ocupada = "SELECT sh.fecha, SUM( sh.plazas_libres ) as plazas_ocupadas
						  FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
						  JOIN servicios s ON ss.servicio_id = s.id
						  AND ss.servicio_id = " . $_POST['servicio'] . "
						  AND s.actividad_id = " . $actividad . "
						  AND s.instalacion_id = " . $_POST['instalacion'] . "
						  AND fecha >= '" . date('Y-m-d') . "'
						  AND fecha <= '" . $fecha_maxima . "'
						  GROUP BY sh.fecha";

    $result_fecha_ocupada = $conexion->query($sql_fecha_ocupada);

    if ($result_fecha_ocupada->rowCount() > 0) {
        foreach ($result_fecha_ocupada->fetchAll() as $row_fecha) {

            if ($row_fecha['plazas_ocupadas'] <= 0) {
                $fechas_ocupadas[$num] = $row_fecha['fecha'];

                $num++;
            }
        }
    }

    // Compruebo que de hoy hasta los próximos días que podría
    // reservar hay horarios en todas las fechas
    $dia = date("Y-m-d");

    // Recorro todos los días del calendario para comprobar si tienen
    // horario
    while ($dia <= $fecha_maxima) {
        $dia        = date("Y-m-d", strtotime($dia . " +1 day"));
        $i          = strtotime($dia);
        $dia_semana = jddayofweek(cal_to_jd(CAL_GREGORIAN, date("m", $i), date("d", $i), date("Y", $i)), 0);

        // Compruebo que el día tiene horarios y puede reservar
        $sql_esta = "SELECT sh.*
					 FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
					 JOIN servicios s ON ss.servicio_id = s.id
					 AND ss.servicio_id = " . $_POST['servicio'] . "
					 AND s.actividad_id = " . $actividad . "
					 AND s.instalacion_id = " . $_POST['instalacion'] . "
					 AND fecha = '" . $dia . "'
					 GROUP BY sh.fecha";

        $result_esta = $conexion->query($sql_esta);

        if ($result_esta->rowCount() == 0) {
            $fechas_ocupadas[$num] = $dia;

            $num++;
        } else {
            // Compruebo horarios del día para ver si se tienen que
            // bloquear o no en función de la antelación mínima
            $sql_horario = "SELECT sh.*
							FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
							JOIN servicios s ON ss.servicio_id = s.id
							AND ss.servicio_id = " . $_POST['servicio'] . "
							AND s.actividad_id = " . $actividad . "
							AND s.instalacion_id = " . $_POST['instalacion'] . "
							AND fecha = '" . $dia . "'";

            $result_horario = $conexion->query($sql_horario);

            foreach ($result_horario->fetchAll() as $row_horario) {
                // Compruebo horas de antelación mínimas para poder reservar
                $horas_antelacion_minima = $row_dias['antelacion_minima_reserva'];
                $fecha_hora_actual       = date('Y-m-d H:i:s');

                // Fecha y hora hasta la cual puedo reservar
                // Fecha y hora que muestro -horas de antelacion mínima
                $fecha_hora_reserva        = $row_horario['fecha'] . ' ' . $row_horario['hora_inicio'];
                $fecha_hora_minima_reserva = date("Y-m-d H:i:s", strtotime($fecha_hora_reserva . " -$horas_antelacion_minima hour"));

                // Compruebo si la fecha hora actual superan a la fecha y hora
                // hasta las cuales puedo reservar
                if ($fecha_hora_actual > $fecha_hora_minima_reserva) {
                    $bloquear_dia = 1;
                } else {
                    $bloquear_dia = 0;
                }

            }

            // Sólo se bloqueará el día si todos los horarios dan
            // como resultado bloquear día
            if ($bloquear_dia == 1) {
                $fechas_ocupadas[$num] = $dia;
                $num++;
            }
        }
    }
} else {
    $fechas_ocupadas = '';
}

echo json_encode($fechas_ocupadas);
