<?php
/************** Includes **********************************/
require_once '../../config.php';
require_once '../../principal_compra_reserva_ajax.php';
require DIRLIBCOMP . 'Redsys.class.php';
require DIRLIBCOMP . 'apiRedsys.php';
require_once DIRLIBCOMP . 'SPDO.php';
require DIRLIBCOMP . 'autoload.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

// Creamos el localizador
// Recogemos los campos que nos envían
$total_compra   = 0;
$nombre         = $_POST['nombre'];
$apellidos      = $_POST['apellidos'];
$telefono       = !empty($_POST['telefono']) ? $_POST['telefono'] : '941112233';
$email          = $_POST['email'];
$unidades       = $_POST['unidades'];
$mesa           = $_POST['mesa'];
$productos      = $_POST['productos'];
$servicio       = $_POST['servicio'];
$servicio_id    = $_POST['servicio'];
$instalacion    = $_POST['instalacion'];
$localizador    = "P-" . generarLocalizador(6);
$fecha_hoy      = date('Y-m-d H:i:s');
$fecha_creacion = date("Y-m-d");
$ip_usuario     = $_SERVER['REMOTE_ADDR'];
$cupon_gastro   = !empty($_POST['cupon_gastro']) ? $_POST['cupon_gastro'] : '';
$cupon_aplicado = !empty($_POST['cupon_aplicado']) ? $_POST['cupon_aplicado'] : '';
$newsletter     = !empty($_POST['newsletter']) ? $_POST['newsletter'] : '';

$productos_array = explode(",", $productos);

foreach ($productos_array as $producto) {
    //Obtenemos el precio de la tarifa desde la base de datos
    $sql_precio = "SELECT  sp.precio
                   FROM productos p
                   JOIN servicios_productos sp on p.id = sp.producto_id
                   WHERE p.id = " . $producto . "
                   AND sp.servicio_id =" . $servicio_id;

    $result_precio = $conexion->query($sql_precio);
    if ($result_precio->rowCount() > 0) {
        $row_precio = $result_precio->fetch();

        $total_compra += $row_precio['precio'];
    } else {
        //Si no existe el producto no continuamos

    }
}
$total_compra = round($total_compra, 2);

if ($cupon_aplicado == 1) {
    $cupon_gastro = $cupon_gastro;

    $sql_cupon = "SELECT b.*
                  FROM bonos b
                  WHERE b.codigo = '" . $cupon_gastro . "'";

    $result_cupon = $conexion->query($sql_cupon);
    if ($result_cupon->rowCount() > 0) {
        $row_cupon = $result_cupon->fetch();

        if($row_cupon['porcentual'] == 1){
            $descuento = $total_compra*$row_cupon['cantidad']/100;
        }else{
            $descuento = $row_cupon['cantidad'];
        }

        $total_compra = $total_compra - $descuento;
    }

} else {
    $cupon_gastro = '';
}
setcookie('m_i_nombre', $nombre, time() + 14400, "/"); // 86400 = 1 day
setcookie('m_i_apellidos', $apellidos, time() + 14400, "/"); // 86400 = 1 day
setcookie('m_i_telefono', $telefono, time() + 14400, "/"); // 86400 = 1 day
setcookie('m_i_email', $email, time() + 14400, "/"); // 86400 = 1 day
setcookie('m_i_asistentes', $unidades, time() + 14400, "/"); // 86400 = 1 day

// Primeramente comprobamos que los productos siguen disponibles en stock si no le decimos al cliente que nada
$disponibles = comprobar_disponibilidad_productos($productos, $conexion);
if (!$disponibles) {
    $respuesta = array('', 'Alguno de los productos ya no están disponibles', 'no-productos');
    echo json_encode($respuesta);
    return;
}

$sql_insert_localizador = "INSERT INTO localizadores(localizador, fecha_creacion,  ip, total, nombre, apellido, email, dni, telefono, unidades, plazas_adulto, plazas_infantil, servicio_id, instalacion_id, servicio_pases, pases_totales, fecha_uso, impreso_en_taquilla, estado, fecha_compra, fecha_solicitud, fecha_respuesta, recibir_correo, web, tipo_pago, idioma, idioma_navegador, unidades_reales, total_real, bono)
                           VALUES (:localizador, :fecha_creacion, :ip, :total, :nombre, :apellido, :email, :dni, :telefono, :unidades, :plazas_adulto, :plazas_infantil, :servicio_id, :instalacion_id, :servicio_pases, :pases_totales, :fecha_uso, :impreso_en_taquilla, :estado, :fecha_compra, :fecha_solicitud, :fecha_respuesta, :recibir_correo, :web, :tipo_pago, :idioma, :idioma_navegador, :unidades_reales, :total_real, :bono)";

$result_localizador = $conexion->prepare($sql_insert_localizador);
$exito_loc          = $result_localizador->execute(array(
    ':localizador'         => $localizador,
    ':fecha_creacion'      => $fecha_creacion,
    ':ip'                  => $ip_usuario,
    ':total'               => $total_compra,
    ':nombre'              => $nombre,
    ':apellido'            => $apellidos,
    ':email'               => $email,
    ':dni'                 => '',
    ':telefono'            => $telefono,
    ':unidades'            => $unidades,
    ':plazas_adulto'       => 1,
    ':plazas_infantil'     => 0,
    ':servicio_id'         => $servicio,
    ':instalacion_id'      => $instalacion,
    ':servicio_pases'      => 1,
    ':pases_totales'       => 1,
    ':fecha_uso'           => $fecha_hoy,
    ':impreso_en_taquilla' => 0,
    ':estado'              => 'nuevo',
    ':fecha_compra'        => $fecha_hoy,
    ':fecha_solicitud'     => $fecha_hoy,
    ':fecha_respuesta'     => $fecha_hoy,
    ':recibir_correo'      => 1,
    ':web'                 => 1,
    ':tipo_pago'           => $_POST['forma_pago'],
    ':idioma'              => 1,
    ':idioma_navegador'    => 1,
    ':unidades_reales'     => $unidades,
    ':total_real'          => $total_compra,
    ':bono'                => $cupon_gastro,
));

// Introducimos los productos como extras
if ($exito_loc) {

    // Buscamos el id de la mesa para guardarla apartir del número y del servicio siempre que no sea la mesa 0
    if ($mesa != 0) {
        $sql_get_mesa    = "SELECT id FROM mesas WHERE servicio_id = $servicio and numero = $mesa";
        $result_get_mesa = $conexion->query($sql_get_mesa);

        if ($result_get_mesa != null && $result_get_mesa->rowCount() > 0) {
            $mesas   = $result_get_mesa->fetchAll();
            $mesa_id = $mesas[0]['id'];
        } else {
            $mesa_id = 0;
        }
    } else {
        $mesa_id = 0;
    }

    // Introducimos la mesa del localizador
    $sql_mesa    = "INSERT INTO localizador_mesas (localizador, mesa) values ('" . $localizador . "', $mesa_id)";
    $result_mesa = $conexion->query($sql_mesa);

    // Introducimos el campo newsletter del localizador
    $sql_campo    = "INSERT INTO localizador_campos (localizador, campo_id, value) values ('" . $localizador . "', 11, $newsletter)";
    $result_campo = $conexion->query($sql_campo);

    // Buscamos los productos que nos han pasado
    $sql_productos = "SELECT p.*, sp.precio as precio_gastrobar
                      FROM productos p
                      JOIN servicios_productos sp on sp.producto_id = p.id
                      WHERE p.id IN( " . $productos . ") AND sp.servicio_id = $servicio_id";

    $result_productos = $conexion->query($sql_productos);

    $productos_explode = explode(",", str_replace(' ', '', $productos));
    $cuenta_productos  = array_count_values($productos_explode);

    $descripcion_productos = 'Localizador: ' . $localizador . ', Mesa: ' . $mesa . ', ';
    if ($result_productos != null && $result_productos->rowCount() > 0) {
        foreach ($result_productos->fetchAll() as $row_producto) {
            $cantidad               = $cuenta_productos[$row_producto['id']];
            $producto_id            = $row_producto['id'];
            $precio                 = $cantidad * $row_producto['precio_gastrobar'];
            $sql_insert_producto    = "INSERT INTO localizador_productos (localizador, producto_id, unidades, total) values ('" . $localizador . "', $producto_id, $cantidad, $precio)";
            $result_insert_producto = $conexion->query($sql_insert_producto);
            $exito_productos        = $result_productos->rowCount();
            $descripcion_productos .= $cantidad . " x " . $row_producto['nombre'] . ", ";
            $exito_descuenta        = descuenta_producto($row_producto['id'], $cantidad, $conexion);
        }
    }

}
// Generamos los datos del redsys
// Inserto en Redsys

if ($exito_productos) {

    // Buscamos la forma de pago
    $sql_forma_pago    = "SELECT pago FROM tipos_pagos WHERE id = " . $_POST['forma_pago'];
    $result_forma_pago = $conexion->query($sql_forma_pago);
    if ($result_forma_pago != null && $result_forma_pago->rowCount() > 0) {
        $forma_pago = $result_forma_pago->fetch();
    }

    $protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
    $domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];
    $url_ok     = 'gastro-bar/?compra_finalizada';
    $url_nok    = 'gastro-bar/?compra_no_finalizada';

    if (strpos(strtoupper($forma_pago['pago']), 'BIZUM') !== false || strpos(strtoupper($forma_pago['pago']), 'TARJETA') !== false || strpos(strtoupper($forma_pago['pago']), 'APPLE PAY') !== false || strpos(strtoupper($forma_pago['pago']), 'GOOGLE PAY') !== false) {

        $merchant_identifier = "REQUIRED";
        if (isset($_COOKIE['m_i']) && !empty($_COOKIE['m_i'])) {
            $merchant_identifier = $_COOKIE['m_i'];
        }

        $oper_bueno = 1;

        while ($oper_bueno > 0) {
            $numero_operacion        = rand(2000000000, 9999999999);
            $numero_operacion_paypal = 20 . $numero_operacion;

            $sql_numero_op = "SELECT Ds_Order
                              FROM Redsys
                              WHERE Ds_Order = ?";

            $result_numero_op = $conexion->prepare($sql_numero_op);
            $result           = $result_numero_op->execute(array($numero_operacion));

            if ($result_numero_op->rowCount() == 0) {
                $oper_bueno = 0;
            }
        }

        $numero_operacion = $_SESSION['numero_operacion'] = $numero_operacion_paypal;
        $miObj            = new RedsysAPI;
        $Redsys           = new Redsys(array(
            'Server'                   => RedsysServer,
            'Key'                      => RedsysKey,
            'Ds_Merchant_MerchantCode' => RedsysMerchantCode,
            'Ds_Merchant_Terminal'     => RedsysTerminal,
            'Ds_Merchant_UrlOK'        => $domainLink . '/' . $url_ok, //Complete URL when process is OK
            'Ds_Merchant_UrlKO'        => $domainLink . '/' . $url_nok, //Complete URL when process FAILs
            'Ds_Merchant_MerchantURL'  => RedsysMerchantURL, // Direccion al IPN de Redsys
            'Ds_Merchant_Identifier'   => $merchant_identifier,
        ));

        $str_precio    = number_format((float)$total_compra, 2, '.', ''); 
        $total_compra2 = (int )str_replace('.', '', $str_precio);

        $miObj->setParameter("DS_MERCHANT_AMOUNT", $total_compra2);
        $miObj->setParameter("DS_MERCHANT_ORDER", substr($numero_operacion, 2, 12));
        $miObj->setParameter("DS_MERCHANT_MERCHANTCODE", RedsysMerchantCode);
        $miObj->setParameter("DS_MERCHANT_CURRENCY", 978);
        $miObj->setParameter("DS_MERCHANT_TRANSACTIONTYPE", 0);
        $miObj->setParameter("DS_MERCHANT_TERMINAL", RedsysTerminal);
        $miObj->setParameter("DS_MERCHANT_MERCHANTURL", RedsysMerchantURL);
        $miObj->setParameter("DS_MERCHANT_URLOK", $domainLink . '/' . $url_ok);
        $miObj->setParameter("DS_MERCHANT_URLKO", $domainLink . '/' . $url_nok);
        //$miObj->setParameter("DS_MERCHANT_IDENTIFIER", $merchant_identifier);
        $miObj->setParameter("Ds_Merchant_ProductDescription", $descripcion_productos);

        if (strpos(strtoupper($forma_pago['pago']), 'BIZUM') !== false) {
            $miObj->setParameter("Ds_MERCHANT_PAYMETHODS", "z");
        }

        if (strpos(strtoupper($forma_pago['pago']), 'GOOGLE PAY') !== false || strpos(strtoupper($forma_pago['pago']), 'APPLE PAY') !== false) {
            $miObj->setParameter("Ds_MERCHANT_PAYMETHODS", 'xpay');
        }else{
            if ($total_compra <= 50) {
                // Quitar el 3Dsecure
                $miObj->setParameter("DS_MERCHANT_DIRECTPAYMENT", true);
                $miObj->setParameter("DS_MERCHANT_EXCEP_SCA", "LWV");
            }
        }

        $params    = $miObj->createMerchantParameters();
        $signature = $miObj->createMerchantSignature(RedsysKey);

        $sql_tpv    = "INSERT INTO Redsys (localizador, Ds_Order, Ds_MerchantData, Ds_Amount, sala_horario_id) VALUES (?, ?, ?, ?, ?)";
        $result_tpv = $conexion->prepare($sql_tpv);

        $exito_tpv = $result_tpv->execute(array(
            $localizador,
            substr($numero_operacion, 2, 12),
            $numero_operacion,
            $total_compra * 100, //Por 100 ya que se envia multiplicado por este factor
            0,
        ));

        actualizar_operacion($numero_operacion, $localizador, $conexion);

        $respuesta = array($params, $signature, 'tarjeta');
        echo json_encode($respuesta);
    } else if (strpos(strtoupper($forma_pago['pago']), 'PAYPAL') !== false) {

        // Paypal Class
        require DIRLIBCOMP . 'PaypalVisitas.class.php';

        $Paypal = new PaypalVisitas(array(
            'Server'        => PaypalServer,
            'Business'      => PaypalFacilitator,
            'Return'        => $domainLink . '/' . $url_ok, //Complete URL when process is OK
            'Cancel_return' => $domainLink . '/' . $url_nok, //Complete URL when process FAILs
            'no_shipping'   => 1, //Evita que paypal pregunte por dirección de entrega
            'Notify_url'    => PaypalNotifyURL, //Complete URL to process payment
        ));

        // Muestro información de las tarifas seleccionadas
        $sql_tarifa_carrito = "SELECT lp.*, p.nombre, p.imagen, p.abreviatura,sp.precio
                               FROM localizador_productos lp 
                               JOIN productos p ON lp.producto_id = p.id
                               JOIN servicios_productos sp on sp.producto_id = p.id
                               WHERE lp.localizador = '" . $localizador . "' AND sp.servicio_id = $servicio_id";

        $result_tarifa_carrito = $conexion->query($sql_tarifa_carrito);

        $articulos_carrito = array();
        $precio_carrito    = 0;
        if ($result_tarifa_carrito->rowCount() > 0) {

            $k = 0;
            while ($row_tarifa = $result_tarifa_carrito->fetch(PDO::FETCH_ASSOC)) {
                $nombre_tarifa = $row_tarifa['nombre'];

                if ($row_tarifa['precio'] != 0) {
                    $precio_tarifacarrito        =  $row_tarifa['unidades']  * $row_tarifa['precio'];
                    $precio_tarifacarrito_format = number_format($precio_tarifacarrito, 2);
                }

                $articulos_carrito[] = array(
                    'item_name' => $language->getString($nombre_tarifa),
                    'quantity'  => $row_tarifa['unidades'],
                    'amount'    => $row_tarifa['total'],
                );
                $precio_carrito += intval($row_tarifa['unidades']) * floatval($row_tarifa['total']);

                $k++;
            }
        }
        if ($precio_carrito != $total_compra) {
            if ($total_compra == 0) {
                foreach ($articulos_carrito as &$articulo) {
                    $articulo['discount_amount'] = $articulo['quantity'] * $articulo['amount'];
                }
            } else {
                $precio_a_descontar = $precio_carrito - $total_compra;
                foreach ($articulos_carrito as &$articulo) {
                    $max_discount = $articulo['quantity'] * $articulo['amount'];
                    if ($max_discount >= $precio_a_descontar) {
                        $articulo['discount_amount'] = $precio_a_descontar;
                        $precio_a_descontar          = 0;
                    } else {
                        $articulo['discount_amount'] = $max_discount;
                        $precio_a_descontar -= $max_discount;
                    }
                }
            }
        }

        $oper_bueno = 1;

        while ($oper_bueno > 0) {
            $numero_operacion        = rand(2000000000, 9999999999);
            $numero_operacion_paypal = 20 . $numero_operacion;

            $sql_numero_op = "SELECT Invoice
                              FROM Paypal
                              WHERE Invoice = ?";

            $result_numero_op = $conexion->prepare($sql_numero_op);
            $result           = $result_numero_op->execute(array($numero_operacion));

            if ($result_numero_op->rowCount() == 0) {
                $oper_bueno = 0;
            }
        }

        $paypal_button = $Paypal->button(
            _('CONFIRMAR'),
            array(
                'Invoice' => $numero_operacion_paypal,
                'class'   => 'confirmar_compra btn-right btn-outline-black',
                'Amount'  => round(floatval($total_compra), 2, PHP_ROUND_HALF_DOWN),
                'Upload'  => 1,
            ),
            $articulos_carrito
        );

        // Inserto en Paypal
        $sql_paypal    = "INSERT INTO Paypal (localizador, invoice, mc_gross, sala_horario_id)
                          VALUES (:localizador, :Num_operacion, :Importe, :sala_horario_id)";
        $result_paypal = $conexion->prepare($sql_paypal);
        $exito_paypal  = $result_paypal->execute(array(
            ':localizador'     => $localizador,
            ':Num_operacion'   => $numero_operacion_paypal,
            ':Importe'         => $total_compra,
            ':sala_horario_id' => 0,
        ));

        actualizar_operacion($numero_operacion_paypal, $localizador, $conexion);

        $respuesta = array('', $paypal_button, 'paypal');
        echo json_encode($respuesta);

    } else if (strpos(strtoupper($forma_pago['pago']), 'BODEGA') !== true) {

        // Cambio estados localizador
        // Actualizo localizador
        $sql_update_localizadores    = "UPDATE localizadores SET estado = ?, pago_instalacion = ?, impreso_en_taquilla = ? WHERE localizador = ?";
        $result_update_localizadores = $conexion->prepare($sql_update_localizadores);
        $exito_loc                   = $result_update_localizadores->execute(array('pagado', 1, 1, $localizador));

        $sql_loc_extras = "SELECT lp.*, p.nombre, p.imagen, p.abreviatura, sp.precio as precio_gastrobar
                           FROM localizador_productos lp
                           JOIN productos p ON lp.producto_id = p.id
                           JOIN servicios_productos sp on p.id = sp.productos_id
                           WHERE lp.localizador = ? AND sp.servicio_id = ?";

        $result_loc_extras = $conexion->prepare($sql_loc_extras);
        $result_loc_extras->execute(array($localizador, $servicio_id));

        $extras_seleccionados = array();
        while ($row_loc_extra = $result_loc_extras->fetch()) {

            $nombre_extra = $language->getString($row_loc_extra['nombre'], true);
            if ($row_loc_extra['precio_gastro_bar'] == 0) {
                $precio_extra_mostrar = $language->getString('Gratuito', true);
            } else {
                $precio_extra_mostrar = sprintf('%0.2f', $row_loc_extra['precio_gastro_bar']) . ' €';
            }

            $extras_seleccionados[] = array(
                'abreviatura' => $row_loc_extra['abreviatura'],
                'imagen'      => $row_loc_extra['imagen'],
                'nombre'      => $language->getString($nombre_extra, true),
                'cantidad'    => $row_loc_extra['unidades'],
                'precio'      => $precio_extra_mostrar,
            );
        }

        $total = $total_compra;

        // Traducciones
        $product_lang = $language->getStringsProduct($servicio_id);

        // Servicio comprado
        $sql_compra = "SELECT s.nombre as nombreS, s.pistas, s.tipo_pago, i.nombre as nombreI, a.nombre as nombreA, s.instalacion_id, s.miniatura
                       FROM servicios s JOIN instalaciones i ON s.instalacion_id = i.id
                       JOIN actividades a ON s.actividad_id = a.id
                       AND s.id = " . $servicio_id;

        $result_compra = $conexion->query($sql_compra);

        if ($result_compra->rowCount() > 0) {
            $row_compra = $result_compra->fetch();

            // Servicio comprado
            $servicio_id          = $servicio;
            $servicio             = $product_lang['nombre'];
            $condiciones_servicio = $product_lang['condiciones_servicio'];
            $instalacion_id       = $row_compra['instalacion_id'];
        }

        require_once DIRMODULOSCOMP . 'compra/recibircorreo_compra.php';

        $url_respuesta = '?compra_finalizada';

        $respuesta = array('', '/' . $url_ok, 'bodega');
        echo json_encode($respuesta);
    }
}

function actualizar_operacion($numero_operacion, $localizador, $conexion)
{
    // Actualizamos el localizador con el id de pedido
    $sql_update_id_pedido    = "UPDATE localizadores SET id_pedido = ? WHERE localizador = ?";
    $result_update_id_pedido = $conexion->prepare($sql_update_id_pedido);
    $exito_update_pedido     = $result_update_id_pedido->execute(array(
        $numero_operacion,
        $localizador,
    ));
}

function comprobar_disponibilidad_productos($productos, $conexion)
{

    $productos_explode = explode(",", str_replace(' ', '', $productos));
    $cuenta_productos  = array_count_values($productos_explode);

    foreach ($cuenta_productos as $producto => $cantidad) {

        $sql_producto    = "SELECT * FROM productos WHERE id = $producto AND cantidad_disponible >= $cantidad";
        $result_producto = $conexion->query($sql_producto);
        if ($result_producto->rowCount() == 0) {
            return false;
        }
    }

    return true;
}

function descuenta_producto($producto, $cantidad, $conexion)
{
    $update_producto = "UPDATE productos set cantidad_disponible = cantidad_disponible - $cantidad WHERE id = $producto";
    $resultado       = $conexion->query($update_producto);

    return $resultado;
}
