<?php
/************** Includes **********************************/
require_once '../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

$clave         = '';
$merchantID    = $_POST['merchantID'];
$acquirerBIN   = $_POST['acquirerBIN'];
$terminalID    = $_POST['terminalID'];
$num_operacion = $_POST['num_operacion'];
$tipoMoneda    = $_POST['tipoMoneda'];
$exponente     = $_POST['exponente'];
$cifrado       = $_POST['cifrado'];
$URL_OK        = $_POST['URL_OK'];
$URL_NOK       = $_POST['URL_NOK'];
$localizador   = $_POST['localizador'];


//Control de informacion de transaccion
if ($num_operacion == ""){    
    $respuesta = "";
    echo json_encode($respuesta);
    die;
}

$precio = 0;

//Obtenemos el precio del localizador desde la bbdd filtrando por el id_pedido pasado en Base64
$sql_localizador = "SELECT l.total 
			        FROM localizadores l
                    JOIN CecaTpv c on l.localizador = c.localizador AND l.id_pedido = c.Num_Operacion
			        WHERE l.localizador = :localizador  
                    AND l.id_pedido = :id_pedido";

$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador,
    ':id_pedido' => $num_operacion,
));

if ($result_localizador->rowCount() > 0) {
    $row_localidor = $result_localizador->fetch(PDO::FETCH_ASSOC);
    $precio        = $row_localidor['total'];
}

if ($precio == 0){
    $respuesta = "";
    echo json_encode($respuesta);
    die;
}

// Modificamos en BD el Importe de la tabla CecaTpv
$sql_update_ceca    = "UPDATE CecaTpv set importe = ? WHERE localizador = ?";
$result_update_ceca = $conexion->prepare($sql_update_ceca);
$result_update_ceca->execute(array($precio*100, $localizador));

$respuesta = hash('sha256',
    $clave . $merchantID . $acquirerBIN . $terminalID .
    $num_operacion . $precio*100 . $tipoMoneda . $exponente .
    $cifrado . $URL_OK . $URL_NOK
);


echo json_encode($respuesta);
