<?php
/************** Includes **********************************/
require_once '../../config.php';
require DIRLIBCOMP . 'Redsys.class.php';
require DIRLIBCOMP . 'apiRedsys.php';
require_once DIRLIBCOMP . 'SPDO.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

$protocol   = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

$miObj  = new RedsysAPI;

$localizador = $_POST['localizador'];
$precio      = 0;
$merchant    = $_POST['merchant'];


$redsys_desc = json_decode(base64_decode($merchant));

function convertirPrecioRedsys($number) {

    $str_precio = number_format((float)$number, 2, '.', '');

    return (int )str_replace('.', '', $str_precio);
   
}

//Obtenemos el precio del localizador desde la bbdd filtrando por el id_pedido pasado en Base64
$sql_localizador = "SELECT l.total, l.id_pedido, l.instalacion_id, l.idioma, tp.pago 
                    FROM localizadores l
                    JOIN tipos_pagos tp ON tp.id = l.tipo_pago
                    JOIN Redsys r ON l.localizador = r.localizador 
                    AND l.id_pedido= r.Ds_MerchantData
                    WHERE l.localizador = :localizador
                    AND substring(l.id_pedido, 3, char_length(id_pedido)) = :id_pedido "; 
               
$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador,
    ':id_pedido' => $redsys_desc->Ds_Merchant_Order
));

if ($merchant == ""){    
    $respuesta = array("", "");
    echo json_encode($respuesta);
    die;
}
               
if ($result_localizador->rowCount() > 0) {
    $row_localidor = $result_localizador->fetch(PDO::FETCH_ASSOC);
    $precio_float  = $row_localidor['total'];
    $precio        = convertirPrecioRedsys($precio_float);
    $instalacion   = $row_localidor['instalacion_id'];
    $tipo_pago     = $row_localidor['pago'];
    $idioma        = $row_localidor['idioma'];    
}

if ($precio == 0){
    $respuesta = array("", "");
    echo json_encode($respuesta);
    die;
}


// Modificamos en BD el Importe de la tabla Redsys
$sql_update_redsys    = "UPDATE Redsys set Ds_Amount = ? WHERE localizador = ?";
$result_update_redsys = $conexion->prepare($sql_update_redsys);
$result_update_redsys->execute(array($precio, $localizador));

if ($idioma == 2) {
    $url_ok  = 'en/enoexperience/?compra_finalizada';
    $url_nok = 'en/enoexperience/?compra_no_finalizada';
} else {
    $url_ok  = 'enoexperiencia/?compra_finalizada';
    $url_nok = 'enoexperiencia/?compra_no_finalizada';
}

// Vemos si tenemos la instalación y buscamos su configuración de redsys
$sql_redsys_conf = "SELECT *
                    FROM instalaciones i
                    JOIN redsys_configuraciones rc ON i.redsys_conf_id = rc.id
                    WHERE i.id = $instalacion
                    LIMIT 1";
$result_redsys_conf = $conexion->query($sql_redsys_conf);

if (!is_bool($result_redsys_conf) && $result_redsys_conf->rowCount() > 0) {
    $row_redsys           = $result_redsys_conf->fetch();
    $redsys_server        = $row_redsys['RedsysServer'];
    $redsys_key           = $row_redsys['Secret_Key'];
    $redsys_merchant_code = $row_redsys['Ds_Merchant_MerchantCode'];
    $redsys_terminal      = $row_redsys['Ds_Merchant_Terminal'];

    $miObj = new RedsysAPI;

    $Redsys = new Redsys(array(
        'Server'                   => $redsys_server,
        'Key'                      => $redsys_key,
        'Ds_Merchant_MerchantCode' => $redsys_merchant_code,
        'Ds_Merchant_Terminal'     => $redsys_terminal,
        'Ds_Merchant_UrlOK'        => $domainLink . '/' . $url_ok, //Complete URL when process is OK
        'Ds_Merchant_UrlKO'        => $domainLink . '/' . $url_nok, //Complete URL when process FAILs
        'Ds_Merchant_MerchantURL'  => RedsysMerchantURL, // Direccion al IPN de Redsys
    ));

    if (strtoupper($tipo_pago) == 'BIZUM') {
        $miObj->setParameter("Ds_MERCHANT_PAYMETHODS", "z");
    }
    
    $miObj->setParameter("DS_MERCHANT_AMOUNT", $precio);
    $miObj->setParameter("DS_MERCHANT_ORDER", substr($row_localidor['id_pedido'], 2, 12) );
    $miObj->setParameter("DS_MERCHANT_MERCHANTCODE", $redsys_merchant_code);
    $miObj->setParameter("DS_MERCHANT_CURRENCY", 978);
    $miObj->setParameter("DS_MERCHANT_TRANSACTIONTYPE", 0);
    $miObj->setParameter("DS_MERCHANT_TERMINAL", $redsys_terminal);
    $miObj->setParameter("DS_MERCHANT_MERCHANTURL", RedsysMerchantURL);
    $miObj->setParameter("DS_MERCHANT_URLOK", $domainLink . '/' . $url_ok);
    $miObj->setParameter("DS_MERCHANT_URLKO", $domainLink . '/' . $url_nok);

    $params    = $miObj->createMerchantParameters();
    $signature = $miObj->createMerchantSignature(RedsysKey);

    $respuesta = array($params, $signature,$precio);
    echo json_encode($respuesta);
}

?>
