<?php

/************** Includes **********************************/
require_once '../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

//Compruebo si hay plazas seleccionadas en el horario marcado

$sql_plazas = "SELECT plazas_libres
               FROM sala_horarios
               WHERE id = :id_hora ";

$result_plazas = $conexion->prepare($sql_plazas);
$result_plazas->execute(array(':id_hora' => $_POST['hora']));

if ($result_plazas->rowCount() > 0) {
    $row_plazas = $result_plazas->fetch(PDO::FETCH_ASSOC);

    // Compruebo si el servicio es de la carrera San Silvestre
    $sql_servicio = "SELECT nombre, pistas
                     FROM servicios
                     WHERE id = :id_servicio ";

    $result_servicio = $conexion->prepare($sql_servicio);
    $result_servicio->execute(array(':id_servicio' => $_POST['servicio']));

    if ($result_servicio->rowCount() > 0) {
        $row_servicio = $result_servicio->fetch();
    }

    if ($row_plazas['plazas_libres'] >= $_POST['usuarios']) {
        echo json_encode(1);
    } else {
        // Compruebo si el horario es de un servicio de pistas
        $sql_horario_seleccionado = "SELECT fecha, hora_inicio, hora_fin
                                     FROM sala_horarios
                                     WHERE id = :id_hora ";

        $result_horario_seleccionado = $conexion->prepare($sql_horario_seleccionado);
        $result_horario_seleccionado->execute(array(':id_hora' => $_POST['hora']));

        if ($result_horario_seleccionado->rowCount() > 0) {
            $row_horario_seleccionado = $result_horario_seleccionado->fetch();

            // Busco el id correcto con la fecha, hora y pista seleccionada
            $sql_id_correcto = "SELECT sh.id, sh.plazas_libres
                                FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                                JOIN servicios s ON ss.servicio_id = s.id
                                AND sh.fecha = :fecha
                                AND sh.hora_inicio = :hora_inicio
                                AND sh.hora_fin = :hora_fin
                                AND s.id = :id ";

            $result_id_correcto = $conexion->prepare($sql_id_correcto);
            $result_id_correcto->execute(array(
                ':fecha'       => $row_horario_seleccionado['fecha'],
                ':hora_inicio' => $row_horario_seleccionado['hora_inicio'],
                ':hora_fin'    => $row_horario_seleccionado['hora_fin'],
                ':id'          => $_POST['servicio'],
            ));

            if ($result_id_correcto->rowCount() > 0) {
                $row_id_correcto = $result_id_correcto->fetch();

                if ($row_id_correcto['plazas_libres'] >= 1 && $row_servicio['pistas'] == 1) {
                    echo json_encode(1);
                } else {
                    echo json_encode(0);
                }
            } else {
                echo json_encode(0);
            }

        } else {
            echo json_encode(0);
        }
    }
} else {
    echo json_encode(0);
}
