<?php
ini_set('display_errors', 1);

/**************    Include cabecera  ***********************************/
require_once '../../principal_compra_reserva_ajax.php';

require_once '../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRMODULOSCOMP . 'reembolso_funcion.php';
require_once DIRMODULOSCOMP . 'reembolso_paypal_funcion.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

// Establecemos en función del lenguaje seleccionado el js con los textos
$sesion_lang      = $language->getSessionLang();
$lang             = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
$_SESSION['lang'] = $lang;

// PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'extras/extra_api.php';

function guidv4($data = null)
{
    // Generate 16 bytes (128 bits) of random data or use the data passed into the function.
    $data = $data ?? random_bytes(16);
    assert(strlen($data) == 16);

    // Set version to 0100
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
    // Set bits 6-7 to 10
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80);

    // Output the 36 character UUID.
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}


// Recogemos las variables POST
$localizador             = $_POST['localizador'];
$data_extras             = $_POST['data_extras'];
$listado_extras_eliminar = $_POST['listado_extras_eliminar'];

$resultado_total_reembolso = 1;
$acumulador_devolucion     = 0;
$uuid_v4                   = guidv4();
$idioma_visita_id          = 1;
//Obtenemos la fecha de la reserva
$sql_reservas = "SELECT sh.fecha, sh.hora_inicio, r.idioma_id
                 FROM reservas r JOIN sala_horarios sh ON r.sala_horario_id = sh.id
                 JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id   
                 AND localizador = :localizador                         
                 ORDER BY r.id ASC";

$result_reserva = $conexion->prepare($sql_reservas);
$result_reserva->execute(array(
    ':localizador' => $_POST['localizador']
));


if ($result_reserva->rowCount() > 0) {
    $row_reserva = $result_reserva->fetch(PDO::FETCH_ASSOC);

    // Fecha y hora hasta la cual puedo modificar la reserva
    $fecha_hora_reserva = $row_reserva['fecha'] . ' ' . $row_reserva['hora_inicio'];
    $idioma_visita_id   = $row_reserva['idioma_id'] ;
}


//Guardamos los movimientos de la devolucion
foreach ($listado_extras_eliminar as $key => $extra_eliminar) {
    
    $sql_precio = "SELECT le.*, l.id_pedido, l.tipo_pago, le.precio, e.antelacion_maxima_cancelacion
                   FROM localizador_extras_servicio le      
                   INNER JOIN localizadores l on le.localizador_extra = l.localizador and l.estado='pagado'           
                   INNER JOIN extras_servicios e on le.extra_id = e.id
                   WHERE le.localizador = :localizador
                   AND le.id = :id ";
    
    $result_precio = $conexion->prepare($sql_precio);
    $result_precio->execute(array(':localizador' => $localizador, ':id' => $extra_eliminar['id']));
    
    $extras_agrupados_pedido = array();
    if ($result_precio->rowCount() > 0) {
        $row_precio = $result_precio->fetch();
        
        //Nos aseguramos que la cantidad sea negativa
        $unidades_original   = abs($row_precio['unidades']) ;
        $localizador         = $row_precio['localizador'];
        $localizador_extra   = $row_precio['localizador_extra'];
        $tarifa_id           = $row_precio['tarifa_id'];
        $unidades            = abs($extra_eliminar['cantidad_extra']);
        $extra_id            = $row_precio['extra_id'];
        $id_pedido           = $row_precio['id_pedido'];
        $precio              = $row_precio['precio'];      
        $tipo_pago           = $row_precio['tipo_pago'];
        //Nos aseguramos que el total sea negativo        
        $total               = abs($unidades * $precio) ;

        //Comprobamos que la fecha maxima de cancelacion 
        $hay_limite_horas = 1;
                       
        if ( $row_precio['antelacion_maxima_cancelacion'] == 0 ){
            $hay_limite_horas = 1;
        }else {
            $now = date("Y-m-d H:i:s");               
       
            $fecha        = $fecha_hora_reserva;
            $minimo_horas = date('Y-m-d H:i:s', strtotime($fecha . " -"  . $row_precio['antelacion_maxima_cancelacion'] ." hours"));
          
            if ($now > $minimo_horas) {       
                $hay_limite_horas = 0;               
            }
        }

        //Nos aseguramos de que haya suficientes unidades disponibles 
        if( $unidades_original >= $unidades && $hay_limite_horas == 1){

            $sql_local_extra = " INSERT INTO localizador_extras_servicio_devolucion (
                localizador,
                localizador_extra,
                tarifa_id,
                unidades,
                unidades_anterior,
                extra_id,
                id_pedido,
                precio,
                tipo_pago,
                total,
                uuid,
                id_registro,
                fecha_modificacion
                )
            VALUES (
                :localizador,
                :localizador_extra,
                :tarifa_id,
                :unidades,
                :unidades_anterior,
                :extra_id,
                :id_pedido,
                :precio,
                :tipo_pago,
                :total,
                :uuid,
                :id_registro,
                :fecha_modificacion
                )";

            $array_devolucion = array(
            ':localizador'         => $localizador,
            ':localizador_extra'   => $localizador_extra,
            ':tarifa_id'           => $tarifa_id,
            ':unidades_anterior'   => $unidades_original,
            ':unidades'            => $unidades,
            ':extra_id'            => $extra_id,
            ':id_pedido'           => $id_pedido,
            ':precio'              => $precio,
            ':total'               => $total,
            ':tipo_pago'           => $tipo_pago,
            ':uuid'                => $uuid_v4,
            ':id_registro'         => $extra_eliminar['id'],
            ':fecha_modificacion'  => date("Y-m-d H:i:s"),
            );

            $result_local_extra = $conexion->prepare($sql_local_extra);
            $exito_local_extra  = $result_local_extra->execute($array_devolucion);
        }else{
            $resultado_total_reembolso = 3;
        }

    }

}

//Si de alguna linea no tenemos cantidades interumpimos el proceso
if($resultado_total_reembolso !=1 ){
    exit();
}

// Extras seleccionad
$precio_total   = 0;
$total_ant      = 0;
$sql_loc_extras = "SELECT sum(le.unidades) as unidades, sum(le.total) as total, e.nombre, u.nombre as nombre_tarifa, et.tipo_clave, el.nombre as nombre_extra
                   FROM localizador_extras_servicio le JOIN extras_servicios e ON le.extra_id = e.id                 
                   LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
                   LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
                   INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
                   LEFT JOIN extras_servicios_lang el ON el.extra_id = e.id AND el.idioma = ?
                   WHERE le.localizador = ?
                   AND le.estado='pagado'
                   AND le.unidades > 0                    
                   GROUP BY le.tarifa_id, e.nombre, u.nombre, et.tipo_clave,el.nombre
                   ORDER BY e.orden, le.tarifa_id";

$result_loc_extras = $conexion->prepare($sql_loc_extras);
$result_loc_extras->execute(array( $idioma_visita_id , $localizador));

$extras_seleccionados_ant = array();
while ($row_loc_extra = $result_loc_extras->fetch()) {

    $nombre_extra = $language->getString($row_loc_extra['nombre'], true);
    if($idioma_visita_id != 1 && isset($row_loc_extra['nombre_extra'])){
        $nombre_extra = $row_loc_extra['nombre_extra'];
    }  
    $nombre_tarifa = $language->getString($row_loc_extra['nombre_tarifa'], true);
    
    if ($nombre_tarifa == '' ){
        $nombre_extra = $nombre_extra;
    }else{
        $nombre_extra = $nombre_extra . " | " . $nombre_tarifa ;
    }

    $extras_seleccionados_ant[] = array(
        'nombre'        => $nombre_extra,
        'nombre_tarifa' => $nombre_tarifa,
        'cantidad'      => $row_loc_extra['unidades'],
        'precio'        => number_format($row_loc_extra['total'], 2) . " €");

        $total_ant    += $row_loc_extra['total'];    

}

//Recorremos las devoluciones agrupadas por pedido
$sql_tarifas_extras = "SELECT tipo_pago, id_pedido, localizador_extra, sum(total) as total
                       FROM localizador_extras_servicio_devolucion                      
                       WHERE localizador = :localizador
                       AND uuid = :uuid
                       GROUP BY tipo_pago, id_pedido , localizador_extra";

$result_tarifas_extras = $conexion->prepare($sql_tarifas_extras);
$result_tarifas_extras->execute(array(
    ':localizador' => $localizador,
    ':uuid'        => $uuid_v4
));

if ($result_tarifas_extras->rowCount() > 0) {

    foreach ($result_tarifas_extras->fetchAll() as $row_devolucion) {

        $tipo_pago                = $row_devolucion['tipo_pago'];
        $id_pedido                = $row_devolucion['id_pedido'];
        $total                    = $row_devolucion['total'];
        $localizador_extra        = $row_devolucion['localizador_extra'];
        $resultado_devolucion     = 0;
        $hay_devolucion_economica = 0;
        
        if(in_array($tipo_pago , array(2, 38, 102, 40, 41))){
            $hay_devolucion_economica = 1;
            
            $refund_amount = abs(intval(round(floatval($total), 2, PHP_ROUND_HALF_DOWN) * 100));
            $es_una_baja   = 0;
            
            $resultado_devolucion = devolucion_redsys($conexion , $localizador_extra, $refund_amount, "Devolución Extra " . $localizador_extra );
            $sentencia            = "LOCALIZADOR - refund " . $localizador_extra. " - " . $refund_amount. " Respuesta ". $resultado_devolucion ;
            Insertar_Sentencia($sentencia, 'anulacion');
            
        }
        
        if(in_array($tipo_pago , array(6))){
            $hay_devolucion_economica = 1;
            $resultado_devolucion     = devolucion_paypal($conexion , $localizador_extra, $total , "Devolución Extra " . $localizador_extra );

            $sentencia = "LOCALIZADOR - refund PAYPAL " . $localizador_extra. " - " . $refund_amount. " Respuesta ". $resultado_devolucion ;
            Insertar_Sentencia($sentencia, 'anulacion');
        }

        if(in_array($tipo_pago , array(1))){
            $resultado_devolucion = 1;
        }

        if ($resultado_devolucion == 1){  
            
            $acumulador_devolucion += $total;
            
            $sql_local_extra = "UPDATE localizador_extras_servicio_devolucion
                                SET devolucion_ok = 1             
                                WHERE localizador = :localizador    
                                AND localizador_extra = :localizador_extra
                                AND id_pedido     = :id_pedido
                                AND tipo_pago     = :tipo_pago 
                                AND uuid          = :uuid  ";

            $result_local_extra = $conexion->prepare($sql_local_extra);
            $exito_local_extra = $result_local_extra->execute(array(
                ':localizador'       => $localizador,
                ':localizador_extra' => $localizador_extra,
                ':id_pedido'         => $id_pedido,
                ':tipo_pago'         => $tipo_pago,   
                ':uuid'              => $uuid_v4,   
            ));
                        
        }else{
            $resultado_total_reembolso = 0;
        }

    }
}

//Recorremos las devoluciones ok y descontamos unidades de las lineas
$sql_precio = "SELECT ld.id_registro, ld.localizador_extra, ld.extra_id, ld.tarifa_id,
               le.unidades as unidades_original, ld.unidades,le.precio,
               e.tipo_stock,
               r.sala_horario_id
               FROM localizador_extras_servicio_devolucion ld      
               INNER JOIN localizador_extras_servicio le on le.id = ld.id_registro 
               and le.localizador = ld.localizador
               and le.localizador_extra = ld.localizador_extra
               and le.extra_id = ld.extra_id
               and le.tarifa_id = ld.tarifa_id              
               INNER JOIN extras_servicios e on le.extra_id = e.id
               INNER JOIN reservas r on le.localizador = r.localizador
               WHERE ld.localizador = :localizador
               AND ld.uuid = :uuid 
               AND ld.devolucion_ok = 1 ";

$result_precio = $conexion->prepare($sql_precio);
$result_precio->execute(array(':localizador' => $localizador, ':uuid' => $uuid_v4));

if ($result_precio->rowCount() > 0) {

    foreach ($result_precio->fetchAll() as $row_precio) {
      
        //Nos aseguramos que la cantidad sea negativa
        $unidades_descontadas = abs( $row_precio['unidades']) ;       
        $localizador_extra    = $row_precio['localizador_extra'];
        $tarifa_id            = $row_precio['tarifa_id'];
        $unidades_original    = abs( $row_precio['unidades_original']);
        $unidades             = $unidades_original - abs($unidades_descontadas);
        $extra_id             = $row_precio['extra_id'];  
        $id_registro          = $row_precio['id_registro'];
        $precio               = $row_precio['precio'];
        $tipo_stock           = $row_precio['tipo_stock'];
        $sala_horario_id_lin  = $row_precio['sala_horario_id'];
        //Nos aseguramos que el total sea negativo        
        $total                = abs($unidades * $precio) ;
                       
        $sql_local_extra = "UPDATE localizador_extras_servicio
                            SET unidades = :unidades,
                                total = :total                  
                            WHERE localizador     = :localizador
                            AND localizador_extra = :localizador_extra
                            AND extra_id          = :extra_id
                            AND tarifa_id         = :tarifa_id
                            AND id                = :id";
        
        $result_local_extra = $conexion->prepare($sql_local_extra);
        $exito_local_extra  = $result_local_extra->execute(array(
            ':localizador'       => $localizador,
            ':localizador_extra' => $localizador_extra,
            ':tarifa_id'         => $tarifa_id,
            ':extra_id'          => $extra_id,
            ':unidades'          => $unidades,             
            ':total'             => $total,
            ':id'                => $id_registro,
        ));
        
        $sentencia = "LOCALIZADOR - refund bbdd linea " . $localizador_extra. " id_Registro " . $id_registro . "- Descuento unidades" . $unidades . " Respuesta ". $exito_local_extra ;
        Insertar_Sentencia($sentencia, 'anulacion');

        //Realizamos una devolucion de stock si procede
        if ($tipo_stock == 1){
            $sql_stock_extra_update = "UPDATE extras_servicios
                                       SET cantidad_stock = cantidad_stock + :unidades                                  
                                       WHERE id = :extra_id";
            
            $result_stock       = $conexion->prepare($sql_stock_extra_update);
            $exito_result_stock = $result_stock->execute(array(           
                ':extra_id'          => $extra_id,
                ':unidades'          => $unidades_descontadas,             
            ));

            $sentencia = "LOCALIZADOR - devolucion stock tipo 1 bbdd linea " . $localizador_extra. " extra_id " . $extra_id . "- Descuento unidades" . $unidades . " Respuesta ". $exito_result_stock ;
            Insertar_Sentencia($sentencia, 'anulacion');

        }
        if ($tipo_stock == 2){
            $sql_stock_extra_update = "UPDATE extras_servicios_sala_horarios as e 
                                       INNER JOIN sala_horarios as s_fecha on e.sala_horario_id = s_fecha.id 
                                       INNER JOIN sala_horarios as s_padre on s_padre.fecha = s_fecha.fecha 
                                       SET e.cantidad_stock = e.cantidad_stock + :unidades 
                                       WHERE s_padre.id = :sala_horario_id_lin 
                                       AND e.extra_id = :extra_id " ;
            
            $result_stock       = $conexion->prepare($sql_stock_extra_update);
            $exito_result_stock = $result_stock->execute(array(           
                ':extra_id'            => $extra_id,
                ':unidades'            => $unidades_descontadas,             
                ':sala_horario_id_lin' => $sala_horario_id_lin,             
            ));

            $sentencia        = "LOCALIZADOR - devolucion stock tipo 2 bbdd linea " . $localizador_extra. " extra_id " . $extra_id . "- Descuento unidades" . $unidades . " Respuesta ". $exito_result_stock ;
            Insertar_Sentencia($sentencia, 'anulacion');

        }
        if ($tipo_stock == 3){
            $sql_stock_extra_update = "UPDATE extras_servicios_sala_horarios as e          
                                       SET e.cantidad_stock = e.cantidad_stock + :unidades 
                                       WHERE e.sala_horario_id  = :sala_horario_id_lin 
                                       AND e.extra_id = :extra_id " ;
            
            $result_stock = $conexion->prepare($sql_stock_extra_update);
            $exito_result_stock  = $result_stock->execute(array(           
                ':extra_id'            => $extra_id,
                ':unidades'            => $unidades_descontadas,             
                ':sala_horario_id_lin' => $sala_horario_id_lin,             
            ));

            $sentencia = "LOCALIZADOR - devolucion stock tipo 2 bbdd linea " . $localizador_extra. " extra_id " . $extra_id . "- Descuento unidades" . $unidades . " Respuesta ". $exito_result_stock ;
            Insertar_Sentencia($sentencia, 'anulacion');

        }

    }
}
//Recorremos las devoluciones ok y descontamos las cantidades de los localizadores
$sql_precio = "SELECT ld.localizador_extra, sum(ld.total) as total
               FROM localizador_extras_servicio_devolucion ld      
               INNER JOIN localizador_extras_servicio le on le.id = ld.id_registro 
               AND le.localizador = ld.localizador
               AND le.localizador_extra = ld.localizador_extra
               AND le.extra_id = ld.extra_id
               AND le.tarifa_id = ld.tarifa_id              
               WHERE ld.localizador = :localizador
               AND ld.uuid = :uuid 
               AND ld.devolucion_ok = 1 
               GROUP BY ld.localizador_extra";

$result_precio = $conexion->prepare($sql_precio);
$result_precio->execute(array(':localizador' => $localizador, ':uuid' => $uuid_v4));

if ($result_precio->rowCount() > 0) {

    foreach ($result_precio->fetchAll() as $row_precio) {
      
        //Nos aseguramos que la cantidad sea negativa       
        $localizador_extra   = $row_precio['localizador_extra'];
        $total               = $row_precio['total'];
                           
        $sql_local_extra = "UPDATE localizadores
                            SET total = total - :total,
                                total_real = total_real - :total                  
                            WHERE localizador = :localizador_extra
                            AND estado ='pagado'";
        
        $result_local_extra = $conexion->prepare($sql_local_extra);
        $exito_local_extra  = $result_local_extra->execute(array(    
            ':localizador_extra' => $localizador_extra,          
            ':total'             => $total    
        ));

        $sentencia        = "LOCALIZADOR - refund bbdd localizador " . $localizador_extra. " - Descuento " . $total . " Respuesta ". $exito_local_extra ;
        Insertar_Sentencia($sentencia, 'anulacion');

    }
}

//Si todas las devoluciones son ok
if ($resultado_total_reembolso == 1 && $acumulador_devolucion > 0){
    
    $texto_reembolso_01 = _('Su solicitud de reembolso ha sido procesada con éxito y hemos emitido un reembolso a su tarjeta.');
    $texto_reembolso_02 = _('Por favor, tenga en cuenta que, según su banco o entidad financiera, el tiempo que tardará en aparecer el reembolso en su cuenta puede variar, normalmente será automático, pero podría tardar varios días hábiles.');
    $texto_reembolso_03 = _('Si tiene alguna pregunta, no dude en ponerse en contacto con nuestro equipo de atención al cliente a través de');
    $texto_reembolso_04 = ' <a href="mailto:' . MAILFROM . '" target="_blank" class="contacto_formulario">' . MAILFROM . '</a> ';
    $texto_reembolso_05 = _(' o directamente desde este formulario de contacto ');
    $texto_reembolso_06 = ' (<a href="/contacto-visitas" class="contacto_formulario">' . $domainLink . '/contacto-visitas</a>) .';

    $texto_reembolso = _($texto_reembolso_01 . '<br>' . $texto_reembolso_02 . '<br>' . $texto_reembolso_03 . $texto_reembolso_04 . $texto_reembolso_05 . $texto_reembolso_06);

    $format_cantidad_a_devolver = number_format($acumulador_devolucion, 2) . " €";

    // Informacion necesaria para el correo
    // Obtenemos la informacion que necesita el correo
    $descuento_coste           = 0;
    $descuento_coste_realizado = 0;

    // Extras seleccionad
    $sql_loc_extras = " SELECT sum(le.unidades) as unidades, sum(le.total) as total, 
                        e.nombre, 
                        u.nombre as nombre_tarifa, 
                        et.tipo_clave,
                        el.nombre as nombre_extra
                        FROM localizador_extras_servicio le 
                        JOIN extras_servicios e ON le.extra_id = e.id                                               
                        LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
                        LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
                        INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
                        LEFT JOIN extras_servicios_lang el ON el.extra_id = e.id  AND el.idioma = ?
                        WHERE le.localizador = ?
                        AND le.estado = 'pagado'
                        AND le.unidades > 0                       
                        GROUP BY le.tarifa_id, e.nombre, u.nombre, et.tipo_clave,el.nombre
                        ORDER BY e.orden, le.tarifa_id";

    $result_loc_extras = $conexion->prepare($sql_loc_extras);
    $result_loc_extras->execute(array($idioma_visita_id,$localizador));

    $extras_seleccionados = array();
    while ($row_loc_extra = $result_loc_extras->fetch()) {

        $nombre_extra = $language->getString($row_loc_extra['nombre'], true);
        if($idioma_visita_id != 1 && isset($row_loc_extra['nombre_extra'])){
            $nombre_extra = $row_loc_extra['nombre_extra'];
        }  
        $nombre_tarifa = $language->getString($row_loc_extra['nombre_tarifa'], true);
        
        if ($nombre_tarifa == '' ){
            $nombre_extra = $nombre_extra;
        }else{
            $nombre_extra = $nombre_extra . " | " . $nombre_tarifa ;
        }

    
        $extras_seleccionados[] = array(
            'nombre'        => $nombre_extra,
            'nombre_tarifa' => $nombre_tarifa,
            'cantidad'      => $row_loc_extra['unidades'],
            'precio'        => number_format($row_loc_extra['total'], 2) . " €");
        
        $precio_total += $row_loc_extra['total'];

    }    
    
    // PHP con los textos estáticos de la plantilla
    require_once DIRLANGUAGESTRINGS . 'extras/extra_api.php';

    //Carga de plantilla
    ob_start();
    include DIRLANGUAGETEMPLATES . "extras/api/datos_reserva.ctp";
    $contenido_html = ob_get_clean();

    $sentencia        = "LOCALIZADOR - refund localizador " . $localizador_extra. " Inicio envio correo: " . date("Y-m-d H:i:s") ;
    Insertar_Sentencia($sentencia, 'anulacion');

    // //Enviamos un correo con la modificacion
    $sentencia        = "LOCALIZADOR - refund localizador " . $localizador_extra. " Fin envio correo: " . date("Y-m-d H:i:s") ;
    Insertar_Sentencia($sentencia, 'anulacion');

    echo json_encode(array(
        'contenido_html'             => $contenido_html,
        'localizador_extra'          => $localizador_extra,
        'extras_seleccionados'       => $extras_seleccionados,
        'extras_seleccionados_ant'   => $extras_seleccionados_ant,
        'uuid'                       => $uuid_v4,
        'format_cantidad_a_devolver' => $format_cantidad_a_devolver,
        'total_ant'                  => number_format($total_ant, 2) . " €",
        'precio_total'               => number_format($precio_total, 2) . " €"
    ));
    die;
}

?>