<?php
ini_set('display_errors', 1);

/**************    Include cabecera  ***********************************/
require_once '../../principal_compra_reserva_ajax.php';

require_once '../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRMODULOSCOMP . 'reembolso_funcion.php';
require_once DIRMODULOSCOMP . 'reembolso_paypal_funcion.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

// Establecemos en función del lenguaje seleccionado el js con los textos
$sesion_lang = $language->getSessionLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');
$_SESSION['lang'] = $lang;


// Recogemos las variables POST
$localizador                = $_POST['localizador'];
$respuesta_json             = $_POST['respuesta_json'];
$extras_seleccionados       = $respuesta_json['extras_seleccionados'];
$extras_seleccionados_ant   = $respuesta_json['extras_seleccionados_ant'];
$uuid                       = $respuesta_json['uuid'];
$format_cantidad_a_devolver = $respuesta_json['format_cantidad_a_devolver'];
$total_ant                  = $respuesta_json['total_ant'];
$precio_total               = $respuesta_json['precio_total'];
$localizador_extra          = $respuesta_json['localizador_extra'];


$sql_uuid = "SELECT uuid
             FROM localizador_extras_servicio_devolucion
             WHERE uuid = :uuid
             AND envio_correo_ok = 0";

$result_reserva = $conexion->prepare($sql_uuid);
$result_reserva->execute(array(
    ':uuid' => $uuid
));

if ($result_reserva->rowCount() > 0) {

    //Obtenemos el total antes de actualizarlo
    $sql_total = "SELECT l.* ,
                  i.nombre, i.google_maps, i.descripcion as instalacion_descripcion, i.enlace_prepago,
                  r.sala_horario_id,
                  sh.fecha, sh.hora_inicio, sh.hora_fin,
                  s.condiciones_extra
                  FROM localizadores l
                  JOIN instalaciones i on l.instalacion_id = i.id
                  JOIN reservas r on l.localizador = r.localizador
                  JOIN sala_horarios sh ON r.sala_horario_id = sh.id
                  JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                  JOIN servicios s ON ss.servicio_id = s.id
                  WHERE l.localizador = :localizador
                  AND l.regalo = 0
                  AND l.anulacion = 0
                  AND l.estado = 'pagado'";

    $result_total = $conexion->prepare($sql_total);
    $result_total->execute(array(':localizador' => $localizador));

    if ($result_total->rowCount() > 0) {
        $row_total = $result_total->fetch(PDO::FETCH_ASSOC);

        // Pago seleccionado
        $sql_tipo_pago = "SELECT *
                          FROM tipos_pagos
                          WHERE id = " . $row_total['tipo_pago'];

        $result_tipo_pago = $conexion->query($sql_tipo_pago);
        $row_tipo_pago    = $result_tipo_pago->fetch();
        $tipo_pago        = $row_tipo_pago['pago'];

    } 

    $instalacion             = $row_total['nombre'];
    $instalacion_mapa        = $row_total['google_maps'];
    $instalacion_pregago     = $row_total['enlace_prepago'];
    $instalacion_descripcion = $row_total['instalacion_descripcion'];
    $plazas_total            = $row_total['unidades'];
    $sala_horario_id         = $row_total['sala_horario_id'];
    $condiciones_extra       = $row_total['condiciones_extra'];
    $fechaId                 = $sala_horario_id;

    $fecha_reserva = cambiaf_a_normal($row_total['fecha']);

    $accion = _("modificado");


    $hay_extras_horario = 1;
    $hash_encryp        = encriptar("l=" . $localizador . "&requestpay=1&fecha=". $fecha_reserva );    

    // Enviamos un correo con la modificacion
    require CARPETAPROYECTO . '/modules/visitas/reservas/modulos/extras/correo_modificacion.php';

    $sql_update_localizador_tarifas = "UPDATE localizador_extras_servicio_devolucion
                                       SET envio_correo_ok = 1
                                       WHERE uuid = :uuid";

    $result_update_localizador_tarifas = $conexion->prepare($sql_update_localizador_tarifas);
    $result_update_localizador_tarifas->execute(array(':uuid' => $uuid));

    echo json_encode(1);
}else{
    echo json_encode(0);
}
?>