<?php

date_default_timezone_set('Europe/Madrid');

/************** Includes **********************************/
require_once dirname(__DIR__) . '/principal_compra_reserva_ajax.php';

// Establecemos en función del lenguaje seleccionado el js con los textos
$sesion_lang = $language->getSessionLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

if (isset($_POST['actividad'])) //Al seleccionar una actividad
{
    // COMPROBACIÓN SI ES URL DE INSTALACIÓN
    require_once DIRMODULOSCOMP . 'compra/url_instalaciones.php';

    // Url de instalación
    if ($es_instalacion) {
        $instalacion = "AND i.id = " . $row_instalacion['instalacion_id'];
    }
    // No es url de instalación
    else {
        $instalacion = '';
    }

    // Primera instalación de la lista de instalaciones correspondientes a la
    // actividad seleccionada
    // Instalaciones correspondientes a la actividad seleccionada
    // Que tengan fechas disponibles para reservar en los próximos 7 días
    $fecha_max_reserva = date("Y-m-d", strtotime(date("Y-m-d") . " +6 day"));
    $fecha_actual      = date("Y-m-d");

    $sql_instalaciones = "SELECT i.id, i.nombre, a.nombre as nombreA, s.horas_valle, s.pistas
                          FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                          JOIN servicios s  ON ss.servicio_id = s.id
                          JOIN instalaciones i ON s.instalacion_id = i.id
                          JOIN actividades a ON s.actividad_id = a.id
                          AND actividad_id = " . $_POST['actividad'] . "
                          AND fecha >= '" . $fecha_actual . "'
                          AND fecha <= '" . $fecha_max_reserva . "'
                          AND s.activo = 1
                          AND i.activo = 1 " .
                          $instalacion . "
                          GROUP BY i.nombre
                          ORDER BY i.nombre ASC";
    echo $sql_instalaciones;

    $result_instalaciones = $conexion->query($sql_instalaciones);

    // Compruebo que hay resultados inicialmente
    if ($result_instalaciones->rowCount() > 0) {
        $row_instalacion    = $result_instalaciones->fetch(PDO::FETCH_ASSOC);
        $instalacion        = $row_instalacion['id'];
        $nombre_instalacion = strtoupper($row_instalacion['nombre']);

        // Servicios de esa instalación, sólo me quedo con el primero para mostrar fechas
        $sql_servicios = "SELECT id, nombre
                          FROM servicios
                          WHERE actividad_id = " . $_POST['actividad'] . "
                          AND instalacion_id = " . $instalacion . "
                          AND sala_id <> 0
                          AND activo = 1
                          ORDER BY pases ASC";

        $result_servicios = $conexion->query($sql_servicios);
        $row_servicio     = $result_servicios->fetch(PDO::FETCH_ASSOC);
        $servicio         = $row_servicio['id'];

        // Obtengo días de antelación a la reserva del servicio
        $dias_antelacion   = diasAntelacionReserva($servicio);
        $dias_antelacion  -= 1;
        $fecha_max_reserva = date("Y-m-d", strtotime(date("Y-m-d") . " +$dias_antelacion day"));
        $fecha_actual      = date("Y-m-d");

        $sql_fechas_servicio = "SELECT sala_horario_id
                                FROM sala_horario_servicios ss JOIN sala_horarios sh ON ss.sala_horario_id = sh.id
                                AND servicio_id = " . $servicio . "
                                AND fecha >= '" . $fecha_actual . "'
                                AND fecha <= '" . $fecha_max_reserva . "'
                                AND plazas_libres > 0
                                ORDER BY sala_horario_id ASC";

        $result_fechas_servicio = $conexion->query($sql_fechas_servicio);

        if ($result_fechas_servicio->rowCount() > 0) //Si hay fechas y horarios para el servicio
        {
            $row_fecha      = $result_fechas_servicio->fetch(PDO::FETCH_ASSOC);
            $fecha_servicio = $row_fecha['sala_horario_id'];

            // Obtengo primera fecha del servicio seleccionado inicialmente
            $sql_fechas = "SELECT fecha
                           FROM sala_horarios
                           WHERE id = " . $fecha_servicio;

            $result_fechas     = $conexion->query($sql_fechas);
            $row_fecha_marcada = $result_fechas->fetch(PDO::FETCH_ASSOC);
            $fecha_marcada     = $row_fecha_marcada['fecha'];

            // Obtengo todos los horarios de la fecha seleccionada con plazas libres
            // Horas pasadas del día de hoy no las muestro
            if ($fecha_marcada == date("Y-m-d")) {
                $hora_actual     = date("H:i:s");
                $horas_nopasadas = "AND hora_inicio > '" . $hora_actual . "'";
            }

            $sql_horas = "SELECT sh.id, hora_inicio, hora_fin, s.s_instalacion
                          FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                          JOIN servicios s ON ss.servicio_id = s.id
                          AND ss.servicio_id = " . $servicio . "
                          AND fecha = '" . $fecha_marcada . "'
                          AND plazas_libres > 0 " . $horas_nopasadas;

            $result_horarios = $conexion->query($sql_horas);

            if ($result_horarios->rowCount() > 0) {
                echo '<option value="0">' . _('Seleccione hora') . '</option>';

                foreach ($result_horarios->fetchAll() as $row_hora) {
                    $horainicio  = strtotime($row_hora['hora_inicio']);
                    $hora_inicio = date("H:i", $horainicio);
                    $horafin     = strtotime($row_hora['hora_fin']);
                    $hora_fin    = date("H:i", $horafin);

                    echo '<option value="' . $row_hora['id'] . '">' . $hora_inicio . ' - ' . $hora_fin . '</span></option>';

                }
            } else {
                echo '<option value="0">' . _('Seleccione hora') . '</option>';
            }
        } else // No hay fechas y horarios para el servicio
        {
            echo '<option value="0">' . _('Seleccione hora') . '</option>';
        }
    } else {
        echo '<option value="">' . _('No hay horarios disponibles para este servicio') . '</option>';
    }
} elseif (isset($_POST['instalacion'])) //Obtengo las horas de la primera fecha de la instalación y actividad seleccionada, del primer servicio de la lista
{
    // Al cambiar la selección de la instalación

    // Servicios de la instalación seleccionada, sólo me quedo con el primero para mostrar fechas
    $sql_servicios = "SELECT id, nombre
                      FROM servicios
                      WHERE actividad_id = " . $_POST['actividadSeleccionada'] . "
                      AND instalacion_id = " . $_POST['instalacion'] . "
                      AND sala_id <> 0
                      AND activo = 1
                      ORDER BY pases ASC";

    $result_servicios = $conexion->query($sql_servicios);

    if ($result_servicios->rowCount() > 0) {
        $row_servicio = $result_servicios->fetch(PDO::FETCH_ASSOC);
        $servicio     = $row_servicio['id'];

        // Obtengo días de antelación a la reserva del servicio
        $dias_antelacion   = diasAntelacionReserva($servicio);
        $dias_antelacion  -= 1;
        $fecha_max_reserva = date("Y-m-d", strtotime(date("Y-m-d") . " +$dias_antelacion day"));
        $fecha_actual      = date("Y-m-d");

        $sql_fechas_servicio = "SELECT sala_horario_id
                                FROM sala_horario_servicios ss JOIN sala_horarios sh ON ss.sala_horario_id = sh.id
                                AND servicio_id = " . $servicio . "
                                AND fecha >= '" . $fecha_actual . "'
                                AND fecha <= '" . $fecha_max_reserva . "'
                                AND plazas_libres > 0
                                ORDER BY sala_horario_id ASC";

        $result_fechas_servicio = $conexion->query($sql_fechas_servicio);

        if ($result_fechas_servicio->rowCount() > 0) // Si hay fechas y horarios para el servicio
        {
            $row_fecha      = $result_fechas_servicio->fetch(PDO::FETCH_ASSOC);
            $fecha_servicio = $row_fecha['sala_horario_id'];

            // Obtengo primera fecha del primer servicio de la lista
            $sql_fechas = "SELECT fecha
                           FROM sala_horarios
                           WHERE id = " . $fecha_servicio;

            $result_fechas     = $conexion->query($sql_fechas);
            $row_fecha_marcada = $result_fechas->fetch(PDO::FETCH_ASSOC);
            $fecha_marcada     = $row_fecha_marcada['fecha'];

            // Obtengo todos los horarios de la fecha seleccionada con plazas libres
            // Horas pasadas del día de hoy no las muestro
            if ($fecha_marcada == date("Y-m-d")) {
                $hora_actual     = date("H:i:s");
                $horas_nopasadas = "AND hora_inicio > '" . $hora_actual . "'";
            }

            $sql_horas = "SELECT sh.id, sh.hora_inicio, sh.hora_fin, s.s_instalacion
                          FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                          JOIN servicios s ON ss.servicio_id = s.id
                          AND ss.servicio_id = " . $servicio . "
                          AND sh.fecha = '" . $fecha_marcada . "'
                          AND sh.plazas_libres > 0 " . $horas_nopasadas;

            $result_horarios = $conexion->query($sql_horas);

            if ($result_horarios->rowCount() > 0) {
                echo '<option value="0">' . _('Seleccione hora') . '</span></option>';

                foreach ($result_horarios->fetchAll() as $row_hora) {
                    $horainicio  = strtotime($row_hora['hora_inicio']);
                    $hora_inicio = date("H:i", $horainicio);
                    $horafin     = strtotime($row_hora['hora_fin']);
                    $hora_fin    = date("H:i", $horafin);

                    echo '<option value="' . $row_hora['id'] . '">' . $hora_inicio . ' - ' . $hora_fin . '</span></option>';
                }
            } else {
                echo '<option value="0">' . _('Seleccione hora') . '</span></option>';
            }

        } else // No hay fechas y horarios para el servicio
        {
            echo '<option value="">' . _('No hay horarios disponibles para este servicio') . '</option>';
        }
    } else {
        echo '<option value="">' . _('Seleccione hora') . '</option>';
    }
} elseif (isset($_POST['servicio'])) // Obtengo horas de la primera fecha del servicio, instalación y actividad seleccionadas
{
    // Al cambiar la selección del servicio

    // Compruebo si el servicio es de la actividad seleccionada o pertenece a otra
    // Caso bonos de frontón
    $sql_actividad_servicio = "SELECT *
                               FROM servicios
                               WHERE actividad_id = " . $_POST['actividadSeleccionada'] . "
                               AND id = " . $_POST['servicio'];

    $result_actividad_servicio = $conexion->query($sql_actividad_servicio);

    if ($result_actividad_servicio->rowCount() == 0) {
        // Obtengo días de antelación a la reserva del primer servicio de la
        // actividad seleccionada, para que tenga la misma casuística
        // de reserva que los servicios de la actividad
        $sql_actividad_servicio = "SELECT *
                                   FROM servicios
                                   WHERE actividad_id = " . $_POST['actividadSeleccionada'];

        $result_servicio = $conexion->query($sql_actividad_servicio);
        $row_servicio    = $result_servicio->fetch();

        $dias_antelacion   = diasAntelacionReserva($row_servicio['id']);
        $dias_antelacion  -= 1;
        $fecha_max_reserva = date("Y-m-d", strtotime(date("Y-m-d") . " +$dias_antelacion day"));
        $fecha_actual      = date("Y-m-d");

        $sql_fechas_servicio = "SELECT ss.sala_horario_id
                                FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                                JOIN servicios_otras_instalaciones so ON ss.servicio_id = so.servicio_id
                                JOIN salas sa ON sh.sala_id = sa.id
                                AND sh.fecha >= '" . $fecha_actual . "'
                                AND sh.fecha <= '" . $fecha_max_reserva . "'
                                AND ss.servicio_id = " . $_POST['servicio'] . "
                                AND so.actividad_id = " . $_POST['actividadSeleccionada'] . "
                                AND so.servicio_id = " . $_POST['servicio'] . "
                                AND sa.instalacion_id = " . $_POST['instalacionServicio'] . "
                                AND sh.plazas_libres > 0
                                ORDER BY sh.fecha ASC";

    } else {
        // Obtengo días de antelación a la reserva del servicio
        $dias_antelacion   = diasAntelacionReserva($_POST['servicio']);
        $dias_antelacion  -= 1;
        $fecha_max_reserva = date("Y-m-d", strtotime(date("Y-m-d") . " +$dias_antelacion day"));
        $fecha_actual      = date("Y-m-d");

        $sql_fechas_servicio = "SELECT sala_horario_id
                                FROM sala_horario_servicios ss JOIN sala_horarios sh ON ss.sala_horario_id = sh.id
                                AND servicio_id = " . $_POST['servicio'] . "
                                AND fecha >= '" . $fecha_actual . "'
                                AND fecha <= '" . $fecha_max_reserva . "'
                                AND plazas_libres > 0
                                ORDER BY sala_horario_id ASC";
    }

    $result_fechas_servicio = $conexion->query($sql_fechas_servicio);

    if ($result_fechas_servicio->rowCount() > 0) // Si hay fechas y horarios para el servicio
    {
        $row_fecha      = $result_fechas_servicio->fetch(PDO::FETCH_ASSOC);
        $fecha_servicio = $row_fecha['sala_horario_id'];

        // Obtengo primera fecha del servicio seleccionado
        $sql_fechas = "SELECT fecha
                       FROM sala_horarios
                       WHERE id = " . $fecha_servicio;

        $result_fechas     = $conexion->query($sql_fechas);
        $row_fecha_marcada = $result_fechas->fetch(PDO::FETCH_ASSOC);
        $fecha_marcada     = $row_fecha_marcada['fecha'];

        // Obtengo todos los horarios de la primera fecha de la lista con plazas libres
        // Horas pasadas del día de hoy no las muestro
        if ($fecha_marcada == date("Y-m-d")) {
            $hora_actual     = date("H:i:s");
            $horas_nopasadas = "AND hora_inicio > '" . $hora_actual . "'";
        }

        // Compruebo de nuevo si el servicio es de la actividad para obtener los horarios
        if ($result_actividad_servicio->rowCount() == 0) {
            $sql_horas = "SELECT sh.id, sh.hora_inicio, sh.hora_fin, s.s_instalacion
                          FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                          JOIN servicios_otras_instalaciones so ON ss.servicio_id = so.servicio_id
                          JOIN salas sa ON sh.sala_id = sa.id
                          JOIN servicios s ON so.servicio_id = s.id
                          AND sh.fecha = '" . $fecha_marcada . "'
                          AND ss.servicio_id = " . $_POST['servicio'] . "
                          AND so.actividad_id = " . $_POST['actividadSeleccionada'] . "
                          AND so.servicio_id = " . $_POST['servicio'] . "
                          AND sa.instalacion_id = " . $_POST['instalacionServicio'] . "
                          AND sh.plazas_libres > 0 " . $horas_nopasadas;
        } else {
            $sql_horas = "SELECT sh.id, sh.hora_inicio, sh.hora_fin, s.s_instalacion
                          FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                          JOIN servicios s ON ss.servicio_id = s.id
                          AND ss.servicio_id = " . $_POST['servicio'] . "
                          AND s.actividad_id = " . $_POST['actividadSeleccionada'] . "
                          AND sh.fecha = '" . $fecha_marcada . "'
                          AND sh.plazas_libres > 0 " . $horas_nopasadas;
        }

        $result_horarios = $conexion->query($sql_horas);

        if ($result_horarios->rowCount() > 0) {
            echo '<option value="0">' . _('Seleccione hora') . '</span></option>';

            foreach ($result_horarios->fetchAll() as $row_hora) {
                $horainicio  = strtotime($row_hora['hora_inicio']);
                $hora_inicio = date("H:i", $horainicio);
                $horafin     = strtotime($row_hora['hora_fin']);
                $hora_fin    = date("H:i", $horafin);

                echo '<option value="' . $row_hora['id'] . '">' . $hora_inicio . ' - ' . $hora_fin . '</span></option>';

            }
        } else {
            echo '<option value="0">' . _('Seleccione hora') . '</span></option>';
        }

    } else //No hay fechas y horarios para el servicio
    {
        echo '<option value="">' . _('No hay horarios disponibles para este servicio') . '</option>';
    }

} elseif (isset($_POST['fecha'])) //Obtengo horas de la fecha seleccionada
{
    // Al seleccionar un fecha

    // Obtengo primero la fecha correspondiente al id de fecha seleccionado
    // ($_POST['fecha']) de la fecha seleccionada y servicio seleccionado
    $sql_fecha = "SELECT fecha
                  FROM sala_horarios
                  WHERE id = " . $_POST['fecha'];

    $result_fecha       = $conexion->query($sql_fecha);
    $row_fecha          = $result_fecha->fetch(PDO::FETCH_ASSOC);
    $fecha_seleccionada = $row_fecha['fecha'];

    // Busco todos los horarios de la fecha y servicio seleccionados con plazas libres
    // Horas pasadas del día de hoy no las muestro
    if ($fecha_seleccionada == date("Y-m-d")) {
        $hora_actual     = date("H:i:s");
        $horas_nopasadas = "AND hora_inicio > '" . $hora_actual . "'";
    }

    // Compruebo si el servicio es de la actividad seleccionada o pertenece a otra
    // Caso bonos de frontón
    $sql_actividad_servicio = "SELECT *
                               FROM servicios
                               WHERE actividad_id = " . $_POST['actividadSeleccionada'] . "
                               AND id = " . $_POST['servicioFecha'];

    $result_actividad_servicio = $conexion->query($sql_actividad_servicio);

    if ($result_actividad_servicio->rowCount() == 0) {
        $sql_horas = "SELECT sh.id, sh.hora_inicio, sh.hora_fin, sh.plazas_libres, s.s_instalacion
                      FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                      JOIN servicios_otras_instalaciones so ON ss.servicio_id = so.servicio_id
                      JOIN salas sa ON sh.sala_id = sa.id
                      JOIN servicios s ON so.servicio_id = s.id
                      AND sh.fecha = '" . $fecha_seleccionada . "'
                      AND ss.servicio_id = " . $_POST['servicioFecha'] . "
                      AND so.actividad_id = " . $_POST['actividadSeleccionada'] . "
                      AND so.servicio_id = " . $_POST['servicioFecha'] . "
                      AND sa.instalacion_id = " . $_POST['instalacionServicio'] . "
                      AND sh.plazas_libres > 0
                      AND sh.plazas_libres > 0 " . $horas_nopasadas;

    } else {
        $sql_horas = "SELECT sh.id, sh.hora_inicio, sh.hora_fin, sh.plazas_libres, s.s_instalacion
                      FROM sala_horarios sh JOIN sala_horario_servicios ss ON ss.sala_horario_id = sh.id
                      JOIN servicios s ON ss.servicio_id = s.id
                      AND ss.servicio_id = " . $_POST['servicioFecha'] . "
                      AND s.actividad_id = " . $_POST['actividadSeleccionada'] . "
                      AND sh.fecha = '" . $fecha_seleccionada . "'
                      AND sh.plazas_libres > 0 " . $horas_nopasadas;
    }

    $result_horas = $conexion->query($sql_horas);

    if ($result_horas->rowCount() > 0) {

        echo '<option value="0">' . _('Seleccione hora') . '</option>';

        foreach ($result_horas->fetchAll() as $row_hora) {

            $horainicio  = strtotime($row_hora['hora_inicio']);
            $hora_inicio = date("H:i", $horainicio);
            $horafin     = strtotime($row_hora['hora_fin']);
            $hora_fin    = date("H:i", $horafin);

            if ($row_hora['id'] == $_POST['horaSelected']) {
                $selected = ' selected="selected"';
            } else {
                $selected = '';
            }

            if ($row_hora['id'] == $_POST['horaSelected']) {
                echo '<option value="' . $row_hora['id'] . '"' . $selected . '>' . $hora_inicio . ' - ' . $hora_fin . '</span></option>';
            } else {
                // Compruebo plazas disponibles para ese horario
                if ($row_hora['plazas_libres'] >= $_POST['usuarios']) {
                    echo '<option value="' . $row_hora['id'] . '"' . $selected . '>' . $hora_inicio . ' - ' . $hora_fin . '</span></option>';
                } else {
                    echo '<option class="hora_nodisponible" value="' . $row_hora['id'] . '" disabled>' . $hora_inicio . ' - ' . $hora_fin . ' Completo</option>';
                }
            }
        }
    } else {
        echo '<option value="">' . _('No hay horarios disponibles para este servicio') . '</option>';
    }
} elseif (isset($_POST['usuarios'])) //Obtengo horas disponibles de la fecha seleccionada
{
    // según el número de usuarios seleccionados

    // Obtengo primero la fecha correspondiente al id de fecha seleccionado
    // ($_POST['fecha_usuarios']) de la fecha seleccionada y servicio seleccionado
    $sql_fecha = "SELECT fecha
                  FROM sala_horarios
                  WHERE id = " . $_POST['fecha_usuarios'];

    $result_fecha       = $conexion->query($sql_fecha);
    $row_fecha          = $result_fecha->fetch(PDO::FETCH_ASSOC);
    $fecha_seleccionada = $row_fecha['fecha'];

    // Busco todos los horarios de la fecha y servicio seleccionados con plazas libres
    // Horas pasadas del día de hoy no las muestro
    if ($fecha_seleccionada == date("Y-m-d")) {
        $hora_actual     = date("H:i:s");
        $horas_nopasadas = "AND sh.hora_inicio > '" . $hora_actual . "'";
    }

    $sql_horas = "SELECT sh.id, sh.hora_inicio, sh.hora_fin, sh.plazas_libres, s.s_instalacion
                  FROM sala_horarios sh JOIN sala_horario_servicios ss ON ss.sala_horario_id = sh.id
                  JOIN servicios s ON ss.servicio_id = s.id
                  AND ss.servicio_id = " . $_POST['servicioFecha'] . "
                  AND sh.fecha = '" . $fecha_seleccionada . "'
                  AND sh.plazas_libres > 0 " . $horas_nopasadas;

    $result_horas = $conexion->query($sql_horas);

    if ($result_horas->rowCount() > 0) {
        foreach ($result_horas->fetchAll() as $row_hora) {
            $horainicio  = strtotime($row_hora['hora_inicio']);
            $hora_inicio = date("H:i", $horainicio);
            $horafin     = strtotime($row_hora['hora_fin']);
            $hora_fin    = date("H:i", $horafin);

            //Compruebo plazas disponibles para ese horario
            if ($row_hora['plazas_libres'] >= $_POST['usuarios']) {
                echo '<option value="' . $row_hora['id'] . '">' . $hora_inicio . ' - ' . $hora_fin . '</option>';
            } else {
                echo '<option class="hora_nodisponible" value="' . $row_hora['id'] . '" disabled>' . $hora_inicio . ' - ' . $hora_fin . ' Completo</option>';
            }
        }
    } else {
        echo '<option value="">' . _('No hay horarios disponibles para este servicio') . '</option>';
    }
}
