<?php

/**************    Include cabecera  ***********************************/
require_once dirname(__DIR__) . '/principal_compra_reserva_ajax.php';

// Establecemos en función del lenguaje seleccionado el js con los textos
$sesion_lang = $language->getSessionLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');


// PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'modificar/modificar_api.php';

// Recogemos las variables POST
$localizador        = $_POST['localizador'];
$arrTarifasOriginal = $_POST['arrTarifasOriginal'];
$sala_nueva         = $_POST['salaHorarioSeleccionada'];
$fechaIdOriginal    = $_POST['fechaIdOriginal'];
$fechaId            = $sala_nueva;
$sala_horario_id    = $fechaIdOriginal;

$valor_consulta              = "";
$valor_id                    = "";
$mensaje                     = "";
$accion                      = _("modificado");
$instalacion_mapa            = "";
$cantidad_descuento_anterior = 0;
$cantidad_descuento          = 0;

function ObtenerPlazasIniciales($conexion, $localizador){
    $total_antes_unidades = 0;

    // Comprobamos la modificacion del cambio de unidades contra la bbdd
    $sql_unidades = "SELECT unidades_iniciales 
                     FROM localizadores_cambios_plazas 
                     WHERE localizador = :localizador
                     AND unidades_iniciales is not null
                     limit 1";

    $result_total_unidades = $conexion->prepare($sql_unidades);
    $result_total_unidades->execute(array(':localizador' => $localizador));

    if ($result_total_unidades->rowCount() > 0) {
        $row_total_unidades   = $result_total_unidades->fetch();
        $total_antes_unidades = $row_total_unidades['unidades_iniciales'];
        
    }else{
        
        //Si no hay registros en localizadores_cambios_plazas, las plazas son las del localizador
        $sql_unidades = "SELECT sum(l.plazas_adulto) as total_plazas_adulto
                         FROM localizador_tarifas l
                         WHERE l.localizador = :localizador ";
    
        $result_total_unidades = $conexion->prepare($sql_unidades);
        $result_total_unidades->execute(array(':localizador' => $localizador));
        
        if ($result_total_unidades->rowCount() > 0) {
            $row_total_unidades   = $result_total_unidades->fetch();
            $total_antes_unidades = $row_total_unidades['total_plazas_adulto'];           
        }    
    }

    return $total_antes_unidades;
}


//Obtenemos el precio del localizador desde la bbdd filtrando por el id_pedido pasado en Base64
$sql_total = "SELECT l.* , i.nombre, i.google_maps, i.descripcion as instalacion_descripcion, i.enlace_prepago
              FROM localizadores l
              JOIN instalaciones i on l.instalacion_id = i.id
              WHERE l.localizador = :localizador
              AND l.regalo = 0
              AND l.anulacion = 0
              AND l.estado = 'pagado'";

$result_localizador = $conexion->prepare($sql_total);
$result_localizador->execute(array(
    ':localizador' => $localizador,
));

if ($result_localizador->rowCount() > 0) {
    $row_localidor           = $result_localizador->fetch(PDO::FETCH_ASSOC);
    $precio_total            = $row_localidor['total'];
    $instalacion             = $row_localidor['nombre'];
    $instalacion_mapa        = $row_localidor['google_maps'];
    $instalacion_pregago     = $row_localidor['enlace_prepago'];
    $instalacion_descripcion = $row_localidor['instalacion_descripcion'];
    $total_ant               = $precio_total;

    // Pago seleccionado
    $sql_tipo_pago = "SELECT *
                      FROM tipos_pagos
                      WHERE id = " . $row_localidor['tipo_pago'];

    $result_tipo_pago = $conexion->query($sql_tipo_pago);
    $row_tipo_pago    = $result_tipo_pago->fetch();
    $tipo_pago        = $row_tipo_pago['pago'];

} else {
    echo json_encode(array(0, "No se ha podido modificar la reserva."));
    die;
}

//Comprobamos que exista una reserva
$sql_localizador = "SELECT sala_horario_id,unidades,idioma_id
                    FROM reservas r
                    WHERE r.localizador = :localizador ";

$result_reserva = $conexion->prepare($sql_localizador);
$result_reserva->execute(array(':localizador' => $localizador));

//Si no hay reserva del localizador no continuamos
if ($result_reserva->rowCount() <= 0) {
    echo json_encode(array(0, $sala_nueva, $sala_bbdd));
    die;
}

$row_sala_horario_id  = $result_reserva->fetch();
$sala_bbdd            = $row_sala_horario_id['sala_horario_id'];
$unidades             = $row_sala_horario_id['unidades'];
$idioma_visita_id     = $row_sala_horario_id['idioma_id'];
$plazas_total         = $unidades;
$total_antes_unidades = $unidades;
//Comprobamos que la nueva sala horario exista
$sql_sala = "SELECT fecha 
             FROM sala_horarios
             WHERE id = :sala_nueva
             AND plazas_libres >= :unidades ";

$result_sala = $conexion->prepare($sql_sala);
$result_sala->execute(array(
    ':sala_nueva' => $sala_nueva,
    ':unidades'   => $unidades,
));

//Si no hay reserva del localizador no continuamos
if ($result_sala->rowCount() <= 0) {
    echo json_encode(array(0, "No se ha podido modificar la reserva."));
    die;
}
if (intval($sala_bbdd) == 0) {
    echo json_encode(array(0, "No se ha podido modificar la reserva."));
    die;
}
$row_sala = $result_sala->fetch();
$fecha    = $row_sala['fecha'];

//Obtenemos la fecha de la antigua para guardarla en la bbdd
$sql_sala_anterior = "SELECT fecha 
                      FROM sala_horarios
                      WHERE id = :sala_anterior ";

$result_sala_anterior = $conexion->prepare($sql_sala_anterior);
$result_sala_anterior->execute(array(
    ':sala_anterior' => $fechaIdOriginal,
));
if ($result_sala_anterior->rowCount() > 0) {
    $row_sala_anterior   = $result_sala_anterior->fetch();
    $fecha_sala_anterior = $row_sala_anterior['fecha'];
}

// Extras seleccionad
$sql_loc_extras = "SELECT le.*, e.nombre, e.tipo_stock
                   FROM localizador_extras_servicio le JOIN extras_servicios e ON le.extra_id = e.id                   
                   WHERE le.localizador = ? ";

$result_loc_extras = $conexion->prepare($sql_loc_extras);
$result_loc_extras->execute(array($localizador));


while ($row_loc_extra = $result_loc_extras->fetch()) {
    //Si el extra tiene el tipo de stock hay que mover el stock al nuevo horario
    if($row_loc_extra['tipo_stock'] == 2){

        //Quitamos el stock de la sala nueva
        $sql_stock_extra_update = "UPDATE extras_servicios_sala_horarios as e 
                                   INNER JOIN sala_horarios as s_fecha on e.sala_horario_id = s_fecha.id 
                                   INNER JOIN sala_horarios as s_padre on s_padre.fecha = s_fecha.fecha 
                                   SET e.cantidad_stock = e.cantidad_stock - :unidades 
                                   WHERE s_padre.id = :sala_horario_id_lin 
                                   AND e.extra_id = :extra_id " ;
        
        $result_stock = $conexion->prepare($sql_stock_extra_update);
        $exito_result_stock  = $result_stock->execute(array(           
            ':extra_id'            => $row_loc_extra['extra_id'],
            ':unidades'            => $row_loc_extra['unidades'],             
            ':sala_horario_id_lin' => $sala_nueva,             
        ));

        //Aumentamos el stock de la sala nueva
        $sql_stock_extra_update = "UPDATE extras_servicios_sala_horarios as e 
                                   INNER JOIN sala_horarios as s_fecha on e.sala_horario_id = s_fecha.id 
                                   INNER JOIN sala_horarios as s_padre on s_padre.fecha = s_fecha.fecha 
                                   SET e.cantidad_stock = e.cantidad_stock + :unidades 
                                   WHERE s_padre.id = :sala_horario_id_lin 
                                   AND e.extra_id = :extra_id " ;
        
        $result_stock = $conexion->prepare($sql_stock_extra_update);
        $exito_result_stock  = $result_stock->execute(array(           
            ':extra_id'            => $row_loc_extra['extra_id'],
            ':unidades'            => $row_loc_extra['unidades'],             
            ':sala_horario_id_lin' => $fechaIdOriginal,             
        ));
    }

}
$extras_seleccionados_ant = array();
//Recorremos los extras pagados y sumamos el total
$sql_loc_extras = " SELECT sum(le.unidades) as unidades, sum(le.total) as total,
                     le.localizador_extra, 
                     e.id, e.nombre, e.condiciones_extra, 
                     u.nombre as nombre_tarifa, 
                     et.tipo_clave,
                     el.nombre as nombre_extra
                    FROM localizador_extras_servicio le JOIN extras_servicios e ON le.extra_id = e.id    
                    LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
                    LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
                    INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
                    LEFT JOIN extras_servicios_lang el ON el.extra_id = e.id AND el.idioma = :idioma                                 
                    WHERE le.localizador = :localizador
                    AND le.estado = 'pagado' 
                    AND le.unidades > 0                  
                    GROUP BY le.tarifa_id, e.id, e.nombre, u.nombre, et.tipo_clave,el.nombre
                    ORDER BY e.orden, le.tarifa_id 
                    ";
  
$result_tarifas_extras = $conexion->prepare($sql_loc_extras);
$result_tarifas_extras->execute(array(
    ':localizador' => $localizador,     
    ':idioma'      => $idioma_visita_id ,     
));

if ($result_tarifas_extras->rowCount() > 0) {
    foreach ($result_tarifas_extras->fetchAll() as $row_loc_extra) {
      
        $nombre_extra = $language->getString($row_loc_extra['nombre'], true);
        if($idioma_visita_id != 1 && isset($row_loc_extra['nombre_extra'])){
            $nombre_extra = $row_loc_extra['nombre_extra'];
        }  
        $nombre_tarifa = $language->getString($row_loc_extra['nombre_tarifa'], true);
        
        if ($nombre_tarifa == '' ){
            $nombre_extra = $nombre_extra;
        }else{
            $nombre_extra = $nombre_extra . " | " . $nombre_tarifa ;
        }

        $extras_seleccionados_ant[] = array(
            'nombre'   => $nombre_extra,
            'cantidad' => $row_loc_extra['unidades'],
            'precio'   => number_format($row_loc_extra['total'], 2) . " €");     
    }
}
$extras_seleccionados = $extras_seleccionados_ant;

// Guardamos el sala_horario_id
if ($sala_nueva == $sala_bbdd) {
    echo json_encode(array(0, "No se ha podido modificar la reserva."));
    die;
}

// Devolvemos todas las plazas anteriores al horario anterior
$sql_update_horario    = "UPDATE sala_horarios SET plazas_libres = plazas_libres + ? WHERE id = ?";
$result_update_horario = $conexion->prepare($sql_update_horario);
$result_update_horario->execute(array($unidades, $fechaIdOriginal));

$sql_update_horario    = "UPDATE sala_horarios SET plazas_libres = plazas_libres - ? WHERE id = ?";
$result_update_horario = $conexion->prepare($sql_update_horario);
$result_update_horario->execute(array($unidades, $sala_nueva));

// Modificamos el sala_horario_id en reservas y en localizador_tarifas, junto con el numero de plazas
$sql_update_reserva    = "UPDATE reservas SET sala_horario_id = ? WHERE localizador = ?";
$result_update_reserva = $conexion->prepare($sql_update_reserva);
$result_update_reserva->execute(array($sala_nueva, $localizador));

$sql_update_localizador_tarifas    = "UPDATE localizador_tarifas SET sala_horario_id = ? WHERE localizador = ?";
$result_update_localizador_tarifas = $conexion->prepare($sql_update_localizador_tarifas);
$result_update_localizador_tarifas->execute(array($sala_nueva, $localizador));

// Modificamos el sala_horario_id en reservas y en localizador_tarifas, junto con el numero de plazas
$sql_localizador       = "UPDATE localizadores SET fecha_uso = ? WHERE localizador = ?";
$result_update_reserva = $conexion->prepare($sql_localizador);
$result_update_reserva->execute(array($fecha, $localizador));

// Modificamos el timestamp del localizador
$mensaje_bbdd       = 'Fecha modificada por el cliente';
$fecha_modificacion = date('Y-m-d H:i:s');

$sql_localizador_fecha  = "UPDATE localizadores SET timestamp = ? WHERE localizador = ?";
$result_update_reserva  = $conexion->prepare($sql_localizador_fecha);
$result_update_reserva->execute(array( $fecha_modificacion, $localizador ));

$sql_formuario = "INSERT INTO localizadores_cambios_fechas (localizador, fecha_modificacion, fecha_nueva, fecha_anterior, sala_nueva, sala_anterior, mensaje)
                  VALUES(:localizador, :fecha_modificacion, :fecha_nueva, :fecha_anterior, :sala_nueva, :sala_anterior, :mensaje)";

$result_formulario = $conexion->prepare($sql_formuario);
$exito_formulario  = $result_formulario->execute(array(
    ':localizador'        => $localizador,
    ':fecha_modificacion' => $fecha_modificacion,
    ':fecha_nueva'        => $fecha,
    ':fecha_anterior'     => $fecha_sala_anterior,
    ':sala_nueva'         => $sala_nueva,
    ':sala_anterior'      => $fechaIdOriginal,
    ':mensaje'            => $mensaje_bbdd,
));

//Obtenemos la informacion que necesita el correo
$arrTarifasNombre    = array();
$arrTarifasPrecio    = array();
$arrTarifasPrecioAnt = array();
$arrTarifasUnidades  = array();
$arrTarifasId        = array();
$arrTarifas          = array();

$sql_precio = "SELECT lt.*, ug.nombre, t.precio, t.usuarios_grupo_id, ug.usuarios_descuenta
               FROM localizador_tarifas lt
               JOIN tarifas t ON lt.tarifa_id = t.id
               JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
               WHERE localizador = :localizador ";

$result_precio = $conexion->prepare($sql_precio);
$result_precio->execute(array(':localizador' => $localizador));
if ($result_precio->rowCount() > 0) {

    while ($row_precio = $result_precio->fetch()) {
        $arrTarifasId[]        = $row_precio['tarifa_id'];
        $arrTarifasNombre[]    = $row_precio['nombre'];
        $arrTarifasPrecio[]    = number_format($row_precio['precio_tarifa'] * $row_precio['plazas_adulto'], 2) . " €";
        $arrTarifasPrecioAnt[] = number_format($row_precio['precio_tarifa'] * $row_precio['plazas_adulto'], 2) . " €";
        $arrTarifasUnidades[]  = $row_precio['plazas_adulto'];
        $arrTarifas[]          = $row_precio['plazas_adulto'];
    }

}

$RESULTMODIFICAR      = _('Su reserva ha sido modificada con exito');
$INFOENVIADAPORCORREO = _('Hemos enviado toda la información a su correo electrónico');

// OBTENGO INFORMACIÓN DE LA RESERVA
$sql_info_reserva = "SELECT sh.fecha, sh.hora_inicio, sh.hora_fin, s.nombre as nombreS, s.s_instalacion, s.pistas, s.horas_valle, a.nombre as nombreA, a.id as idA, i.nombre as nombreI, s.id, s.sala_id, i.id as instalacion_id
                     FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                     JOIN servicios s ON ss.servicio_id = s.id
                     JOIN actividades a ON s.actividad_id = a.id
                     JOIN salas sa ON sh.sala_id = sa.id
                     JOIN instalaciones i ON sa.instalacion_id = i.id
                     AND sh.id = :sala_horario_id ";

$result_info_reserva = $conexion->prepare($sql_info_reserva);
$result_info_reserva->execute(array(
    ':sala_horario_id' => $sala_nueva,
));

// Caso por ejemplo de balneario que un mismo horario tiene asociados varios servicios
$result_info_servicio = $conexion->prepare($sql_info_reserva);
$result_info_servicio->execute(array(
    ':sala_horario_id' => $sala_nueva,
));

if ($result_info_reserva->rowCount() > 0) {
    $row_info_reserva = $result_info_reserva->fetch(PDO::FETCH_ASSOC);

    // Nombre del servicio
    $servicio_igualcompra = true;
    $servicio_encontrado  = false;

    foreach ($result_info_servicio->fetchAll() as $row_info_servicio) {

        // Hago la comprobación si el servicio no tiene sala nula
        if ($row_info_servicio['sala_id'] != null) {

            // Si el servicio comprado es igual al reservado
            // Busco el servicio del listado de sala_horarios, ya que en balneario por ejemplo
            // a un mismo horario hay asociado varios servicios
            if (($row_info_servicio['id'] == $row_info_servicio['id']) && ($servicio_igualcompra == true)) {
                $servicio_reserva     = $row_info_servicio['nombreS'];
                $servicio_id_reserva  = $row_info_servicio['id'];
                $nombre_actividad     = $row_info_servicio['nombreA'];
                $actividad_id         = $row_info_servicio['idA'];
                $instalacion_id       = $row_info_servicio['instalacion_id'];
                $servicio_igualcompra = false;
                $servicio_encontrado  = true;
            } else {
                if ($servicio_encontrado == false) {
                    $servicio_reserva     = $row_info_reserva['nombreS'];
                    $servicio_id_reserva  = $row_info_reserva['id'];
                    $nombre_actividad     = $row_info_reserva['nombreA'];
                    $actividad_id         = $row_info_reserva['idA'];
                    $instalacion_id       = $row_info_servicio['instalacion_id'];
                    $servicio_igualcompra = true;
                    $servicio_encontrado  = true;

                }
            }
        } else {
            $servicio_id_reserva = $row_info_reserva['id'];
        }
    }

    // Traducción datos servicio
    $product_lang = $language->getStringsProduct($servicio_id_reserva);

    // TEXTOS SECCIÓN (GENERALES Y DE SERVICIO)
    $section_message = 'modificar_paso_1';
    $servicio_texto  = $servicio_id_reserva;
    // require_once DIRMODULOSCOMP . 'otros/show_messages.php';

    $fechadia = cambiaf_a_normal($row_info_reserva['fecha']);

    // INSTALACIÓN
    $sql_instalacion = "SELECT *
                        FROM instalaciones
                        WHERE id = " . $instalacion_id;

    $result_instalacion = $conexion->query($sql_instalacion);

    if ($result_instalacion->rowCount() > 0) {
        $row_instalacion = $result_instalacion->fetch(PDO::FETCH_ASSOC);
    }

    $hora_inicio = strtotime($row_info_reserva['hora_inicio']);
    $hora_inicio = date("H:i", $hora_inicio);
    $hora_fin    = strtotime($row_info_reserva['hora_fin']);
    $hora_fin    = date("H:i", $hora_fin);   

}

// Muestro tarifas
$sql_tarifas = "SELECT lt.*, t.precio, ug.nombre, t.id, t.pago_grupo, ug.especial, ug.id as IdG, ug.orden
                FROM tarifas t JOIN localizadores l ON l.servicio_id = t.servicio_id
                JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                JOIN localizador_tarifas lt ON l.localizador = lt.localizador and lt.tarifa_id = t.id
                AND l.localizador = '" . $localizador . "'
                AND ug.activo = 1
                AND ug.mostrar_precio = 1
                AND t.seleccionable = 1";

$result_tarifas_usuarios = $conexion->query($sql_tarifas);

$tarifas_usuarios = $result_tarifas_usuarios->fetchAll();

foreach ($tarifas_usuarios as $key => $row) {
    $aux[$key] = $row['orden'];
}

array_multisort($aux, SORT_ASC, $tarifas_usuarios);

$k            = 0;
$precio_total = 0;
foreach ($tarifas_usuarios as $row_tarifa_usuario) {
    // Precio de la tarifa seleccionada
    if ($row_tarifa_usuario['pago_grupo'] == 0) {
        $precio = $row_tarifa_usuario['precio'] * $row_tarifa_usuario['plazas_adulto'];
    } else {
        $precio = $row_tarifa_usuario['precio'];
    }
    $precio_total += $precio;
    $precio        = sprintf('%0.2f', $precio);

    // Grupo de usuarios de la tarifa
    $grupo_usuarios = $row_tarifa_usuario['IdG'];
    $k++;
}

//Comprobamos si el localizador tiene un bono asociado para realizar un recalculo del precio
//Primero comprovamos que es correcto el el cupón
$sql_cupon = "SELECT b.porcentual,b.cantidad,b.codigo
              FROM bonos b
              JOIN localizadores l on l.bono = b.codigo
              WHERE l.localizador = :localizador ";

$result_cupon = $conexion->prepare($sql_cupon);
$result_cupon->execute(array(
    ':localizador' => $localizador,
));

// 2021-09-14: a partir de ahora los cupones pueden afectar sólo a las tarifas o a todo el carrito
if ($result_cupon->rowCount() > 0) {
    $row_cupon = $result_cupon->fetch(PDO::FETCH_ASSOC);
    if ($row_cupon['porcentual'] == 1) {
        $cantidad_descuento          = $precio_total * $row_cupon['cantidad'] / 100;
        $precio_total                = $precio_total - $cantidad_descuento;
        $texto_precio                = number_format($row_cupon['cantidad'], 2) . " %";
        $cantidad_descuento_anterior = $row_cupon['cantidad'];
    } else {
        $unidades_ini_loc            = ObtenerPlazasIniciales($conexion, $localizador); 
        $cantidad_descuento_anterior = number_format(($row_cupon['cantidad']/$unidades_ini_loc) * $plazas_total,2);
        $cantidad_descuento          = $cantidad_descuento_anterior;
        $precio_total                = $precio_total - $cantidad_descuento;
        $texto_precio                = number_format($cantidad_descuento, 2)  . " €";

    }
    $nombre_bono = $row_cupon['codigo'];

    if ($precio_total < 0) {
        $precio_total = 0;
    }

}
//Obtenemos el precio del localizador desde la bbdd filtrando por el id_pedido pasado en Base64
$sql_localizador = "SELECT l.total
                    FROM localizadores l
                    WHERE l.localizador = :localizador ";

$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador,
));

if ($result_localizador->rowCount() > 0) {
    $row_localidor = $result_localizador->fetch(PDO::FETCH_ASSOC);
    $precio_total  = $row_localidor['total'];
}

$sql_localizador = "SELECT sum(le.total) as total
                    FROM localizador_extras_servicio le
                    WHERE le.localizador = :localizador 
                    AND le.localizador_extra <> le.localizador 
                    AND le.estado ='pagado' ";

$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador,
));

if ($result_localizador->rowCount() > 0) {
    $row_localidor       = $result_localizador->fetch(PDO::FETCH_ASSOC);
    $precio_total_extras = $row_localidor['total'];
    $precio_total       += $precio_total_extras;
    $total_ant          += $precio_total_extras;
}

if ($precio_total != 0) {
    $precio_format = number_format($precio_total, 2);
}

$precio_total      = number_format($precio_total, 2) . " €";
$total_ant         = number_format($total_ant, 2) . " €";
$tReservaReembolso = 0;

//Carga de plantilla
require_once DIRLANGUAGETEMPLATES . "modificar/api/datos_reserva.ctp";

//Enviamos un correo con la modificacion
require CARPETAPROYECTO . '/modules/visitas/reservas/modulos/modificar/correo_modificacion.php';
