<?php

/**************    Include cabecera  ***********************************/
require_once dirname(__DIR__) . '/principal_compra_reserva_ajax.php';

// Establecemos en función del lenguaje seleccionado el js con los textos
$sesion_lang = $language->getSessionLang();
$lang        = (isset($sesion_lang) ? $sesion_lang : 'es_ES');

// PHP con los textos estáticos de la plantilla
require_once DIRLANGUAGESTRINGS . 'modificar/modificar_api.php';

// Recogemos las variables POST
$localizador        = $_POST['localizador'];
$arrTarifas         = $_POST['arrTarifasNuevo'];
$arrTarifasOriginal = $_POST['arrTarifasOriginal'];
$arrTarifasId       = $_POST['arrTarifasId'];
$fechaId            = $_POST['fechaId'];
$fechaIdOriginal    = $_POST['fechaIdOriginal'];

$unidades       = 0;
$unidades_antes = 0;

$valor_consulta     = "";
$valor_id           = "";
$mensaje            = "";
$accion             = _("modificado");
$instalacion_mapa   = "";
$fecha_modificacion = date('Y-m-d H:i:s');
$lista_extras       = [];
$newServiceTableId  = null;

foreach ($arrTarifas as $key => $value) {
    $unidades += $value;
    $unidades_antes += $arrTarifasOriginal[$key];
}

// Volvemos a comprobar que la reserva es sólo para disminuír plazas por si se saltan la comprobación del javascript
if (empty($_POST['pago_instalacion'])) {
    foreach ($arrTarifas as $key => $value) {
        if ($value > $arrTarifasOriginal[$key]) {
            echo json_encode(array(0, $mensaje));
            die;
        }
    }
}

//Comprobamos la modificacion del cambio de unidades contra la bbdd
$sql_unidades = "SELECT sum(l.plazas_adulto) as total_plazas_adulto
                 FROM localizador_tarifas l
                 WHERE l.localizador = :localizador ";

$result_total_unidades = $conexion->prepare($sql_unidades);
$result_total_unidades->execute(array(':localizador' => $localizador));

if ($result_total_unidades->rowCount() > 0) {
    $row_total_unidades = $result_total_unidades->fetch();
}
$total_antes_unidades = $row_total_unidades['total_plazas_adulto'];

if ($unidades >= $total_antes_unidades) {
    // Añadido bloqueo de cambio de fecha
    $mensaje = "";
    echo json_encode(array(0, $mensaje));
    die;
}

if ($fechaId != $fechaIdOriginal) {
    // Añadido bloqueo de cambio de fecha
    echo json_encode(array(0, $mensaje));
    die;
}

//------
if (isServiceTypeTable($conexion, $localizador)) {
    $newServiceTableId = getAvailableTable($conexion, $localizador, $unidades);
    if (is_null($newServiceTableId)) {
        // Añadido bloqueo de cambio de fecha
        echo json_encode(array(0, $mensaje));
        die;
    }
}

function isServiceTypeTable($conn, $locatorCode)
{
    // Compruebo si el servicio al que pertenece el localizador es de Tipo Mesa
    $stmt = "SELECT es_tipo_mesa FROM servicios s JOIN localizadores l ON s.id = l.servicio_id WHERE l.localizador = :localizador";
    $serviceResult = $conn->prepare($stmt);
    $serviceResult->execute(array(':localizador' => $locatorCode));
    if ($serviceResult->rowCount() > 0) {
        $serviceRow = $serviceResult->fetch();
        return ((bool)$serviceRow['es_tipo_mesa']);
    }
    return false;
}

// Funcion para conseguir mesa disponible con el nuevo numero de personas de la reserva
// @return:
//      - el mismo servicio_mesa_id que ya tenia la reserva
//      - o un nuevo servicio_mesa_id
//      - o "null" en caso de haber mesa disponible
function getAvailableTable($conn, $locatorCode, $pax)
{
    $salaHorarioId = null;
    $stmt = "SELECT l.servicio_mesa_id, r.sala_horario_id FROM localizadores l JOIN reservas r ON l.localizador=r.localizador WHERE l.localizador = :localizador";
    $result = $conn->prepare($stmt);
    $result->execute(array(':localizador' => $locatorCode));
    if ($result->rowCount() > 0) {
        $reserveRow = $result->fetch();
        $salaHorarioId = $reserveRow['sala_horario_id'];
        $currentServicioMesaId = $reserveRow['servicio_mesa_id'];

        try {
            $curl = curl_init();

            // Check if initialization had gone wrong*    
            if ($curl === false) {
                throw new Exception('CURl - failed to initialize');
            }

            curl_setopt($curl, CURLOPT_URL, DIRECCIONGESTOR . "ApiVisitasV2/availableTable");
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
            ));
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode([
                "locator"         => $locatorCode,
                "sala_horario_id" => $salaHorarioId,
                "pax"             => $pax,
            ]));

            $response = curl_exec($curl);

            // Check the return value of curl_exec(), too
            if ($response === false) {
                throw new Exception(curl_error($curl), curl_errno($curl));
            }

            // Check HTTP return code, too; might be something else than 200
            // $httpReturnCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            // var_dump($httpReturnCode);

            curl_close($curl);

            $data = json_decode($response, true);

            // Filtrar el array
            $existsCurrentServicioMesaId = false;
            foreach ($data as $item) {
                if ($item['id'] === $currentServicioMesaId) {
                    $existsCurrentServicioMesaId = true;
                    break; // Salir del bucle una vez encontrado
                }
            }

            return ($existsCurrentServicioMesaId) ? $currentServicioMesaId : $data[0]['id'];
        } catch (Exception $e) {

            // echo json_encode($e->getMessage());
            return null;
        } finally {
            // Close curl handle unless it failed to initialize
            if (is_resource($curl)) {
                curl_close($curl);
            }
        }
    }

    return null;
}
//--------

function CalcularPreciosDescuentos($conexion, $data_info, $total_antes_unidades)
{

    $precio_total                = 0;
    $precio_total_mas_extras     = 0;
    $cantidad_descuento          = 0;
    $cantidad_descuento_anterior = 0;

    //Comprobamos que la modificacion no exceda el precio del localizador
    foreach ($data_info['arrTarifas'] as $key => $value) {
        if ($value != "") {

            $sql_precio = "SELECT lt.*, ug.nombre, t.precio, t.usuarios_grupo_id, ug.usuarios_descuenta
                           FROM localizador_tarifas lt
                           JOIN tarifas t ON lt.tarifa_id = t.id
                           JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                           WHERE lt.localizador = :localizador
                           AND t.id = :tarifa_id ";

            $result_precio = $conexion->prepare($sql_precio);
            $result_precio->execute(array(':localizador' => $data_info['localizador'], ':tarifa_id' => $data_info['arrTarifasId'][$key]));

            if ($result_precio->rowCount() > 0) {
                $row_precio = $result_precio->fetch();
            }
            //Acumulamos el precio total de la reservas con las nuevas plaza$row_precio['precio_tarifa']
            if ($data_info['hay_cupon'] == false) {
                $precio_total += $row_precio['precio_tarifa'] * $value; //multiplicamos el precio x el numero de plazas introducido
            }

            if ($data_info['hay_cupon_porcentaje'] == true) {
                $precio_total += ($row_precio['precio_tarifa'] * $value) * ((100 - $data_info['porcentaje']) / 100);
                $cantidad_descuento += ($row_precio['precio_tarifa'] * $value) * ($data_info['porcentaje'] / 100);

                // multiplicamos el precio x el numero de plazas introducido teniendo en cuenta el % del descuento
            }
            if ($data_info['hay_cupon_cantidad'] == true) {
                //Calculamos un descuento equitativo con las unidades que se estan descontando
                $descuento_proporcional = ($data_info['cantidad_descuento_fija'] / $data_info['unidades_ini_loc']) * $value;
                $precio_total += ($row_precio['precio_tarifa'] * $value) - ($descuento_proporcional);
                $cantidad_descuento += $descuento_proporcional;
            }
        }
    }

    $precio_total_mas_extras = $precio_total;

    //Recorremos los extras pagados y sumamos el total
    $sql_loc_extras = " SELECT sum(le.unidades) as unidades, sum(le.total) as total, le.localizador_extra, e.nombre, u.nombre as nombre_tarifa, et.tipo_clave
                        FROM localizador_extras_servicio le JOIN extras_servicios e ON le.extra_id = e.id 
                        INNER JOIN localizadores l on le.localizador_extra = l.localizador and l.estado='pagado'                        
                        LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
                        LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
                        INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
                        WHERE le.localizador = :localizador
                        AND le.unidades > 0
                        GROUP BY le.tarifa_id, le.localizador_extra, e.nombre, u.nombre, et.tipo_clave
                        ORDER BY e.orden, le.tarifa_id
                        ";

    $result_tarifas_extras = $conexion->prepare($sql_loc_extras);
    $result_tarifas_extras->execute(array(
        ':localizador' => $data_info['localizador'],
    ));

    if ($result_tarifas_extras->rowCount() > 0) {
        foreach ($result_tarifas_extras->fetchAll() as $row_tarifa_extras) {
            $precio_total_mas_extras += $row_tarifa_extras['total'];
            if ($row_tarifa_extras['localizador_extra'] == $data_info['localizador']) {
                $precio_total += $row_tarifa_extras['total'];
            }
        }
    }

    if ($precio_total > $data_info['precio_total_bbdd']) {
        $mensaje = "Error al generar la devolución.";
        echo json_encode(array(0, $mensaje, $precio_total, $data_info['precio_total_bbdd']));
        die;
    }
    if ($precio_total < 0) {
        $mensaje = "Error al generar la devolución.";
        echo json_encode(array(0, $mensaje, $precio_total, $data_info['precio_total_bbdd']));
        die;
    }

    if ($data_info['hay_cupon_cantidad'] == true) {
        $cantidad_descuento_anterior = ($data_info['cantidad_descuento_fija'] / $data_info['unidades_ini_loc']) * $total_antes_unidades;
    }
    if ($data_info['hay_cupon_porcentaje'] == true) {
        $cantidad_descuento_anterior = $data_info['porcentaje'];
    }

    return array(
        'precio_total'                => $precio_total,
        'precio_total_mas_extras'     => number_format($precio_total_mas_extras, 2),
        'cantidad_descuento'          => number_format($cantidad_descuento, 2),
        'cantidad_descuento_anterior' => number_format($cantidad_descuento_anterior, 2),
    );
}

function ObtenerPlazasIniciales($conexion, $localizador)
{
    $total_antes_unidades = 0;

    //Comprobamos la modificacion del cambio de unidades contra la bbdd
    $sql_unidades = "SELECT unidades_iniciales
                     FROM localizadores_cambios_plazas
                     WHERE localizador = :localizador
                     AND unidades_iniciales is not null
                     limit 1";

    $result_total_unidades = $conexion->prepare($sql_unidades);
    $result_total_unidades->execute(array(':localizador' => $localizador));

    if ($result_total_unidades->rowCount() > 0) {
        $row_total_unidades   = $result_total_unidades->fetch();
        $total_antes_unidades = $row_total_unidades['unidades_iniciales'];
    } else {

        //Si no hay registros en localizadores_cambios_plazas, las plazas son las del localizador
        $sql_unidades = "SELECT sum(l.plazas_adulto) as total_plazas_adulto
                         FROM localizador_tarifas l
                         WHERE l.localizador = :localizador ";

        $result_total_unidades = $conexion->prepare($sql_unidades);
        $result_total_unidades->execute(array(':localizador' => $localizador));

        if ($result_total_unidades->rowCount() > 0) {
            $row_total_unidades   = $result_total_unidades->fetch();
            $total_antes_unidades = $row_total_unidades['total_plazas_adulto'];
        }
    }

    return $total_antes_unidades;
}

function guidv4($data = null)
{
    // Generate 16 bytes (128 bits) of random data or use the data passed into the function.
    $data = $data ?? random_bytes(16);
    assert(strlen($data) == 16);

    // Set version to 0100
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
    // Set bits 6-7 to 10
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80);

    // Output the 36 character UUID.
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

// Si pasa la comprobación:
//  - Modificamos las unidades, plazas adulto, plazas infantil del localizador
//  - Modificamos las unidades de la reserva
//  - Liberamos las plazas del horario

if (!empty($fechaIdOriginal)) {

    $uuid_v4 = guidv4();

    //Comprobamos si el localizador tiene un bono asociado para realizar un recalculo del precio
    //Primero comprovamos que es correcto el el cupón
    $sql_cupon = "SELECT b.porcentual,b.cantidad
                  FROM bonos b
                  JOIN localizadores l on l.bono = b.codigo
                  WHERE l.localizador = :localizador ";

    $result_cupon = $conexion->prepare($sql_cupon);
    $result_cupon->execute(array(
        ':localizador' => $localizador,
    ));

    $hay_cupon               = false;
    $hay_cupon_porcentaje    = false;
    $hay_cupon_cantidad      = false;
    $porcentaje              = 0;
    $cantidad_descuento_fija = 0;
    $unidades_ini_loc        = 0;

    // 2021-09-14: a partir de ahora los cupones pueden afectar sólo a las tarifas o a todo el carrito
    if ($result_cupon->rowCount() > 0) {
        $row_cupon = $result_cupon->fetch(PDO::FETCH_ASSOC);
        $hay_cupon = true;
        if ($row_cupon['porcentual'] == 1) {
            $porcentaje           = $row_cupon['cantidad'];
            $hay_cupon_porcentaje = true;
        } else {
            $hay_cupon_cantidad      = true;
            $cantidad_descuento_fija = $row_cupon['cantidad'];

            $unidades_ini_loc = ObtenerPlazasIniciales($conexion, $localizador);
        }
    }

    //Obtenemos el total antes de actualizarlo
    $sql_total = "SELECT l.* , i.nombre, i.google_maps, i.descripcion as instalacion_descripcion, i.enlace_prepago
                  FROM localizadores l
                  JOIN instalaciones i on l.instalacion_id = i.id
                  WHERE l.localizador = :localizador
                  AND l.regalo = 0
                  AND l.anulacion = 0
                  AND l.estado = 'pagado'";

    $result_cupon = $conexion->prepare($sql_total);
    $result_cupon->execute(array(
        ':localizador' => $localizador,
    ));

    if ($result_cupon->rowCount() > 0) {
        $row_total = $result_cupon->fetch(PDO::FETCH_ASSOC);
        $total_ant = $row_total['total'];
        $idioma_visita_id = $row_total['idioma'];
    } else {
        $mensaje = "No existe el localizador";
        echo json_encode(array(0, $mensaje));
        die;
    }

    //guardamos el sala_horario_id
    $sala_horario_id = $fechaIdOriginal;
    $diferencia      = (int) $total_antes_unidades - $unidades; // Siempre será positivo puesto que las reservas sólo deja disminuír

    if ($fechaId != $fechaIdOriginal) {
        // Añadido bloqueo de cambio de fecha
        echo json_encode(array(0, $mensaje));
        die;
    } else {
        $sql_update_horario    = "UPDATE sala_horarios SET plazas_libres = plazas_libres + ? WHERE id = ?";
        $result_update_horario = $conexion->prepare($sql_update_horario);
        $result_update_horario->execute(array($diferencia, $sala_horario_id));
    }

    $plazas_total        = 0;
    $precio_total        = 0;
    $precio_devover      = 0;
    $arrTarifasNombre    = array();
    $arrTarifasPrecio    = array();
    $arrTarifasPrecioAnt = array();
    $arrTarifasUnidades  = array();

    $data_info['arrTarifas']              = $arrTarifas;
    $data_info['arrTarifasId']            = $arrTarifasId;
    $data_info['localizador']             = $localizador;
    $data_info['hay_cupon']               = $hay_cupon;
    $data_info['hay_cupon_cantidad']      = $hay_cupon_cantidad;
    $data_info['hay_cupon_porcentaje']    = $hay_cupon_porcentaje;
    $data_info['cantidad_descuento_fija'] = $cantidad_descuento_fija;
    $data_info['porcentaje']              = $porcentaje;
    $data_info['precio_total_bbdd']       = $total_ant;
    $data_info['unidades_ini_loc']        = $unidades_ini_loc;

    $data_info_precios           = CalcularPreciosDescuentos($conexion, $data_info, $total_antes_unidades);
    $precio_total                = $data_info_precios['precio_total'];
    $precio_total_mas_extras     = $data_info_precios['precio_total_mas_extras'];
    $cantidad_descuento          = $data_info_precios['cantidad_descuento'];
    $cantidad_descuento_anterior = $data_info_precios['cantidad_descuento_anterior'];

    foreach ($arrTarifas as $key => $value) {
        if ($value != "") {
            $original   = 1;
            $sql_precio = "SELECT lt.*, ug.nombre, t.precio, t.usuarios_grupo_id, ug.usuarios_descuenta
                           FROM localizador_tarifas lt
                           JOIN tarifas t ON lt.tarifa_id = t.id
                           JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                           WHERE lt.localizador = :localizador
                           AND t.id = :tarifa_id ";

            $result_precio = $conexion->prepare($sql_precio);
            $result_precio->execute(array(':localizador' => $localizador, ':tarifa_id' => $arrTarifasId[$key]));

            if ($result_precio->rowCount() > 0) {
                $row_precio = $result_precio->fetch();
            }

            //Comprobamos si esta tarifa tiene una modificacion
            $sql_tarifa_det = "SELECT lt.*
                               FROM localizadores_cambios_plazas_det lt
                               JOIN tarifas t ON lt.tarifa_id = t.id
                               WHERE lt.localizador = :localizador
                               AND t.id = :tarifa_id ";

            $result_tarifa_det = $conexion->prepare($sql_tarifa_det);
            $result_tarifa_det->execute(array(':localizador' => $localizador, ':tarifa_id' => $arrTarifasId[$key]));

            if ($result_tarifa_det->rowCount() > 0) {
                $original = 0;
            }

            if ($row_precio['usuarios_descuenta'] == 1) {
                $plazas_total += $value;
            }

            $sql_update_plazas    = "UPDATE localizador_tarifas SET plazas_adulto = ? WHERE tarifa_id = ? and localizador= ?";
            $result_update_plazas = $conexion->prepare($sql_update_plazas);
            $result_update_plazas->execute(array($value, $arrTarifasId[$key], $localizador));
            $valor_consulta = $value;
            $valor_id       = $arrTarifasId[$key];

            $arrTarifasNombre[]    = $row_precio['nombre'];
            $arrTarifasPrecioAnt[] = number_format($row_precio['precio_tarifa'] * $row_precio['plazas_adulto'], 2) . " €";
            $arrTarifasPrecio[]    = number_format($row_precio['precio_tarifa'] * $value, 2) . " €";
            $arrTarifasUnidades[]  = $row_precio['plazas_adulto'];

            //Guardamos un log de las modificaciones de las tarifas
            if ($row_precio['plazas_adulto'] > $value) {

                $sql_log_cambios_tarifas = "INSERT INTO localizadores_cambios_plazas_det
                (
                    localizador,
                    fecha_modificacion,
                    tarifa_id,
                    servicio_id,
                    sala_horario_id,
                    plazas_adulto,
                    plazas_adulto_anterior,
                    precio_tarifa,
                    uuid,
                    original,
                    backoffice
                    )
                VALUES(
                    :localizador,
                    :fecha_modificacion,
                    :tarifa_id,
                    :servicio_id,
                    :sala_horario_id,
                    :plazas_adulto,
                    :plazas_adulto_anterior,
                    :precio_tarifa,
                    :uuid,
                    :original,
                    :backoffice
                    )";

                $result_formulario = $conexion->prepare($sql_log_cambios_tarifas);
                $exito_formulario  = $result_formulario->execute(array(
                    ':localizador'            => $localizador,
                    ':fecha_modificacion'     => $fecha_modificacion,
                    ':tarifa_id'              => $row_precio['tarifa_id'],
                    ':servicio_id'            => $row_precio['servicio_id'],
                    ':sala_horario_id'        => $row_precio['sala_horario_id'],
                    ':plazas_adulto'          => ($value - $row_precio['plazas_adulto']) * -1,
                    ':plazas_adulto_anterior' => $row_precio['plazas_adulto'],
                    ':precio_tarifa'          => $row_precio['precio_tarifa'],
                    ':uuid'                   => $uuid_v4,
                    ':original'               => $original,
                    ':backoffice'             => 0,
                ));
            }
        }
    }

    //Comprobamos si el localizador tiene un bono asociado para realizar un recalculo del precio
    //Primero comprovamos que es correcto el el cupón
    $sql_cupon = "SELECT b.porcentual,b.cantidad
                  FROM bonos b
                  JOIN localizadores l on l.bono = b.codigo
                  WHERE l.localizador = :localizador ";

    $result_cupon = $conexion->prepare($sql_cupon);
    $result_cupon->execute(array(
        ':localizador' => $localizador,
    ));

    //Obtenemos el total antes de actualizarlo
    $sql_total = "SELECT l.* , i.nombre, i.google_maps, i.descripcion as instalacion_descripcion, i.enlace_prepago
                  FROM localizadores l
                  JOIN instalaciones i on l.instalacion_id = i.id
                  WHERE l.localizador = :localizador
                  AND l.regalo = 0
                  AND l.anulacion = 0
                  AND l.estado = 'pagado'";

    $result_total = $conexion->prepare($sql_total);
    $result_total->execute(array(':localizador' => $localizador));

    if ($result_total->rowCount() > 0) {
        $row_total = $result_total->fetch(PDO::FETCH_ASSOC);

        // Pago seleccionado
        $sql_tipo_pago = "SELECT *
                          FROM tipos_pagos
                          WHERE id = " . $row_total['tipo_pago'];

        $result_tipo_pago = $conexion->query($sql_tipo_pago);
        $row_tipo_pago    = $result_tipo_pago->fetch();
        $tipo_pago        = $row_tipo_pago['pago'];
    } else {
        $mensaje = "No se puede editar este localizador";
        echo json_encode(array(0, $mensaje));
        die;
    }
    $total_ant               = $row_total['total'];
    $instalacion             = $row_total['nombre'];
    $instalacion_mapa        = $row_total['google_maps'];
    $instalacion_pregago     = $row_total['enlace_prepago'];
    $instalacion_descripcion = $row_total['instalacion_descripcion'];

    $sql_update_localizador    = "UPDATE localizadores SET unidades = ?, unidades_reales = ?, plazas_adulto =? WHERE localizador = ?";
    $result_update_localizador = $conexion->prepare($sql_update_localizador);
    $result_update_localizador->execute(array($plazas_total, $plazas_total, $plazas_total, $localizador));

    $sql_update_reserva    = "UPDATE reservas SET unidades = ? WHERE localizador = ?";
    $result_update_reserva = $conexion->prepare($sql_update_reserva);
    $result_update_reserva->execute(array($plazas_total, $localizador));

    $sql_update_localizador    = "UPDATE localizadores SET total = ? WHERE localizador = ?";
    $result_update_localizador = $conexion->prepare($sql_update_localizador);
    $result_update_localizador->execute(array($precio_total, $localizador));

    //Obtenemos la forma de pago del localizador
    $sql_forma_pago = "SELECT tp.pago
                       FROM tipos_pagos tp
                       JOIN localizadores l ON l.tipo_pago = tp.id
                       AND  l.localizador = :localizador ";

    $result_forma_pago = $conexion->prepare($sql_forma_pago);
    $result_forma_pago->execute(array(':localizador' => $localizador));

    if ($result_forma_pago->rowCount() > 0) {
        $row_forma_pago = $result_forma_pago->fetch();
    }

    if ($_POST['pago_instalacion'] == 1) {
        $mensaje = "Su reserva ha sido modificada. Esta modificación no genera devolución.";
    } else {

        $mensaje_bbdd               = 'Plazas modificadas por el cliente';

        $cantidad_a_devolver        = $total_ant - $precio_total;

        // Compruebo si el servicio al que pertenece el localizador es de Tipo Mesa
        if (isServiceTypeTable($conexion, $localizador)) {
            $stmt = "SELECT cargo_por_persona, cargo_por_porcentaje_total, l.total, l.total_adelantado_mesa FROM servicios s JOIN localizadores l ON s.id = l.servicio_id WHERE l.localizador = :localizador";
            $serviceResult = $conexion->prepare($stmt);
            $serviceResult->execute(array(':localizador' => $data_info['localizador']));
            if ($serviceResult->rowCount() > 0) {
                $serviceRow = $serviceResult->fetch();

                $newPax = array_sum($data_info['arrTarifas']);

                if (!is_null($serviceRow['cargo_por_persona'])) {
                    $cantidad_a_devolver = ($serviceRow['cargo_por_persona'] * $unidades) - ($serviceRow['cargo_por_persona'] * $newPax);
                }

                if (!is_null($serviceRow['cargo_por_porcentaje_total'])) {
                    $cantidad_a_devolver = $serviceRow['total_adelantado_mesa'] - ($precio_total * ($serviceRow['cargo_por_porcentaje_total'] / 100));
                }
            }

            $sql_update_localizador    = "UPDATE localizadores SET servicio_mesa_id = ?, total_adelantado_mesa = ? WHERE localizador = ?";
            $result_update_localizador = $conexion->prepare($sql_update_localizador);
            $result_update_localizador->execute(array($newServiceTableId, ($precio_total * ($serviceRow['cargo_por_porcentaje_total'] / 100)), $localizador));
        }
        //----------------------------------------------------------------

        $format_cantidad_a_devolver = number_format($cantidad_a_devolver, 2) . " €";

        $sql_formuario = "INSERT INTO localizadores_cambios_plazas (localizador, fecha_modificacion, diferencia,total_anterior,total_nuevo ,mensaje, unidades_iniciales)
                          VALUES(:localizador, :fecha_modificacion, :diferencia, :total_anterior,:total_nuevo,:mensaje,:unidades_iniciales)";

        $result_formulario = $conexion->prepare($sql_formuario);
        $exito_formulario  = $result_formulario->execute(array(
            ':localizador'        => $localizador,
            ':fecha_modificacion' => $fecha_modificacion,
            ':diferencia'         => $cantidad_a_devolver,
            ':total_nuevo'        => $precio_total,
            ':total_anterior'     => $total_ant,
            ':unidades_iniciales' => $unidades_ini_loc,
            ':mensaje'            => $mensaje_bbdd,
        ));
        if (strpos(strtoupper($tipo_pago), 'PAYPAL') === false) {
            $refund_amount = intval(round(floatval($cantidad_a_devolver), 2, PHP_ROUND_HALF_DOWN) * 100);
            $es_una_baja   = 0;
            require_once DIRMODULOSCOMP . 'reembolso.php';
        } else {
            $refund_amount = $cantidad_a_devolver;
            require_once DIRMODULOSCOMP . 'reembolso_paypal.php';
        }

        $title_reembolsada     = _('Reembolso');
        $info_reembolsada      = _('Información sobre el reembolso de su compra');
        $total_reembolsado     = _('Total reembolsado: ');
        $RESULTMODIFICAR       = _('Su reserva ha sido modificada con exito');
        $INFOENVIADAPORCORREO  = _('Hemos enviado toda la información a su correo electrónico');
        $TITLEREEMBOLSADO      = $title_reembolsada;
        $INFOREEMBOLSADO       = $info_reembolsada;
        $TEXTOTOTALREEMBOLSADO = $total_reembolsado;
        $TOTALREEMBOLSADO      = $format_cantidad_a_devolver;
        $TEXTOREEMBOLSADO      = $texto_reembolso;

        // OBTENGO INFORMACIÓN DE LA RESERVA
        $sql_info_reserva = "SELECT sh.fecha, sh.hora_inicio, sh.hora_fin, s.nombre as nombreS, s.s_instalacion, s.pistas, s.horas_valle, a.nombre as nombreA, a.id as idA, i.nombre as nombreI, s.id, s.sala_id, i.id as instalacion_id
                             FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
                             JOIN servicios s ON ss.servicio_id = s.id
                             JOIN actividades a ON s.actividad_id = a.id
                             JOIN salas sa ON sh.sala_id = sa.id
                             JOIN instalaciones i ON sa.instalacion_id = i.id
                             AND sh.id = :sala_horario_id ";

        $result_info_reserva = $conexion->prepare($sql_info_reserva);
        $result_info_reserva->execute(array(
            ':sala_horario_id' => $sala_horario_id,
        ));
        // Caso por ejemplo de balneario que un mismo horario tiene asociados varios servicios
        $result_info_servicio = $conexion->prepare($sql_info_reserva);
        $result_info_servicio->execute(array(
            ':sala_horario_id' => $sala_horario_id,
        ));

        if ($result_info_reserva->rowCount() > 0) {
            $row_info_reserva = $result_info_reserva->fetch(PDO::FETCH_ASSOC);

            // Nombre del servicio
            $servicio_igualcompra = true;
            $servicio_encontrado  = false;

            foreach ($result_info_servicio->fetchAll() as $row_info_servicio) {

                // Hago la comprobación si el servicio no tiene sala nula
                if ($row_info_servicio['sala_id'] != null) {

                    // Si el servicio comprado es igual al reservado
                    // Busco el servicio del listado de sala_horarios, ya que en balneario por ejemplo
                    // a un mismo horario hay asociado varios servicios
                    if (($row_info_servicio['id'] == $row_info_servicio['id']) && ($servicio_igualcompra == true)) {

                        $servicio_reserva     = $row_info_servicio['nombreS'];
                        $servicio_id_reserva  = $row_info_servicio['id'];
                        $nombre_actividad     = $row_info_servicio['nombreA'];
                        $actividad_id         = $row_info_servicio['idA'];
                        $instalacion_id       = $row_info_servicio['instalacion_id'];
                        $servicio_igualcompra = false;
                        $servicio_encontrado  = true;
                    } else {
                        if ($servicio_encontrado == false) {
                            $servicio_reserva     = $row_info_reserva['nombreS'];
                            $servicio_id_reserva  = $row_info_reserva['id'];
                            $nombre_actividad     = $row_info_reserva['nombreA'];
                            $actividad_id         = $row_info_reserva['idA'];
                            $instalacion_id       = $row_info_servicio['instalacion_id'];
                            $servicio_igualcompra = true;
                            $servicio_encontrado  = true;
                        }
                    }
                } else {
                    $servicio_id_reserva = $row_info_reserva['id'];
                }
            }

            // Traducción datos servicio
            $product_lang = $language->getStringsProduct($servicio_id_reserva);

            // TEXTOS SECCIÓN (GENERALES Y DE SERVICIO)
            $section_message = 'modificar_paso_1';
            $servicio_texto  = $servicio_id_reserva;
            // require_once DIRMODULOSCOMP . 'otros/show_messages.php';

            $fechadia = cambiaf_a_normal($row_info_reserva['fecha']);

            // INSTALACIÓN
            $sql_instalacion = "SELECT *
                                FROM instalaciones
                                WHERE id = " . $instalacion_id;

            $result_instalacion = $conexion->query($sql_instalacion);

            if ($result_instalacion->rowCount() > 0) {
                $row_instalacion = $result_instalacion->fetch(PDO::FETCH_ASSOC);
            }

            $hora_inicio = strtotime($row_info_reserva['hora_inicio']);
            $hora_inicio = date("H:i", $hora_inicio);
            $hora_fin    = strtotime($row_info_reserva['hora_fin']);
            $hora_fin    = date("H:i", $hora_fin);
        }

        // Muestro tarifas
        $sql_tarifas = "SELECT lt.*, t.precio, ug.nombre, t.id, t.pago_grupo, ug.especial, ug.id as IdG, ug.orden
                        FROM tarifas t JOIN localizadores l ON l.servicio_id = t.servicio_id
                        JOIN usuarios_grupos ug ON t.usuarios_grupo_id = ug.id
                        JOIN localizador_tarifas lt ON l.localizador = lt.localizador and lt.tarifa_id = t.id
                        AND l.localizador = '" . $localizador . "'
                        AND ug.activo = 1
                        AND ug.mostrar_precio = 1
                        AND t.seleccionable = 1
                        AND lt.plazas_adulto > 0";

        $result_tarifas_usuarios = $conexion->query($sql_tarifas);

        $tarifas_usuarios = $result_tarifas_usuarios->fetchAll();

        foreach ($tarifas_usuarios as $key => $row) {
            $aux[$key] = $row['orden'];
        }

        array_multisort($aux, SORT_ASC, $tarifas_usuarios);

        $k = 0;
        // $precio_total = 0;
        foreach ($tarifas_usuarios as $row_tarifa_usuario) {

            // Precio de la tarifa seleccionada
            if ($row_tarifa_usuario['pago_grupo'] == 0) {
                $precio = $row_tarifa_usuario['precio'] * $row_tarifa_usuario['plazas_adulto'];
            } else {
                $precio = $row_tarifa_usuario['precio'];
            }
            // $precio_total += $precio;
            $precio = sprintf('%0.2f', $precio);

            // Grupo de usuarios de la tarifa
            $grupo_usuarios = $row_tarifa_usuario['IdG'];

            $k++;
        }

        // Comprobamos si el localizador tiene un bono asociado para realizar un recalculo del precio
        // Primero comprovamos que es correcto el el cupón
        $sql_cupon = "SELECT b.porcentual,b.cantidad, b.codigo
                      FROM bonos b
                      JOIN localizadores l on l.bono = b.codigo
                      WHERE l.localizador = :localizador ";

        $result_cupon = $conexion->prepare($sql_cupon);
        $result_cupon->execute(array(
            ':localizador' => $localizador,
        ));

        // 2021-09-14: a partir de ahora los cupones pueden afectar sólo a las tarifas o a todo el carrito
        if ($result_cupon->rowCount() > 0) {
            $row_cupon = $result_cupon->fetch(PDO::FETCH_ASSOC);
            if ($row_cupon['porcentual'] == 1) {
                $texto_precio = number_format($row_cupon['cantidad'], 2) . " %";
            } else {
                $texto_precio = number_format($row_cupon['cantidad'], 2) . " €";
            }
            $nombre_bono = $row_cupon['codigo'];
        }

        if ($precio_total != 0) {
            $precio_format = number_format($precio_total, 2);
        }
    }
}
// echo json_encode(array(1, $mensaje, $valor_consulta, $valor_id, $precio_total, $diferencia, $unidades_antes, $unidades, $total_antes_unidades));

$extras_seleccionados_ant = array();
//Recorremos los extras pagados y sumamos el total
$sql_loc_extras = " SELECT sum(le.unidades) as unidades, sum(le.total) as total,
                    le.localizador_extra, 
                    e.id, e.nombre, e.condiciones_extra, 
                    u.nombre as nombre_tarifa, 
                    et.tipo_clave,
                    el.nombre as nombre_extra
                    FROM localizador_extras_servicio le JOIN extras_servicios e ON le.extra_id = e.id    
                    LEFT JOIN tarifas_extras t ON le.tarifa_id = t.id 
                    LEFT JOIN usuarios_grupos u ON t.usuarios_grupo_id = u.id
                    INNER JOIN extras_servicios_tipos et ON et.id = e.tipo_id
                    LEFT JOIN extras_servicios_lang el ON el.extra_id = e.id AND el.idioma = :idioma                                
                    WHERE le.localizador = :localizador
                    and le.estado='pagado' 
                    AND le.unidades > 0               
                    GROUP BY le.tarifa_id, e.id, e.nombre, u.nombre, et.tipo_clave,el.nombre
                    ORDER BY e.orden, le.tarifa_id 
                    ";

$result_tarifas_extras = $conexion->prepare($sql_loc_extras);
$result_tarifas_extras->execute(array(
    ':localizador' => $localizador,
    ':idioma'      => $idioma_visita_id,
));

if ($result_tarifas_extras->rowCount() > 0) {
    foreach ($result_tarifas_extras->fetchAll() as $row_loc_extra) {

        $nombre_extra = $language->getString($row_loc_extra['nombre'], true);
        if ($idioma_visita_id != 1 && isset($row_loc_extra['nombre_extra'])) {
            $nombre_extra = $row_loc_extra['nombre_extra'];
        }
        $nombre_tarifa = $language->getString($row_loc_extra['nombre_tarifa'], true);

        if ($nombre_tarifa == '') {
            $nombre_extra = $nombre_extra;
        } else {
            $nombre_extra = $nombre_extra . " | " . $nombre_tarifa;
        }

        $extras_seleccionados_ant[] = array(
            'nombre'   => $nombre_extra,
            'cantidad' => $row_loc_extra['unidades'],
            'precio'   => number_format($row_loc_extra['total'], 2) . " €"
        );
    }
}
$extras_seleccionados = $extras_seleccionados_ant;

$sql_localizador = " SELECT sum(le.total) as total
                    FROM localizador_extras_servicio le
                    WHERE le.localizador = :localizador 
                    AND le.localizador_extra <> le.localizador 
                    AND le.estado ='pagado' ";

$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador,
));

if ($result_localizador->rowCount() > 0) {
    $row_localidor = $result_localizador->fetch(PDO::FETCH_ASSOC);
    $precio_total_extras  = $row_localidor['total'];
    $precio_total += $precio_total_extras;
    $total_ant += $precio_total_extras;
}


$precio_total = number_format($precio_total, 2) . " €";
$total_ant    = number_format($total_ant, 2) . " €";

//Carga de plantilla
require_once DIRLANGUAGETEMPLATES . "modificar/api/datos_reserva.ctp";

require CARPETAPROYECTO . '/modules/visitas/reservas/modulos/modificar/correo_modificacion.php';
