<?php

/************** Includes **********************************/
require_once '../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIB . 'clases/lang.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'clases/messages.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);


// Recogemos las variables POST
$localizador = $_POST['localizador'];
$fechaId     = $_POST['fechaId'];
$plazas      = $_POST['plazas'];
$newsletter  = !empty($_POST['newsletter']) ? $_POST['newsletter'] : '';
$campos      =  !empty($_POST['campos']) ? $_POST['campos'] : array();

//Obtenemos el total antes de actualizarlo
$sql_localizador = " SELECT l.* , i.nombre, i.google_maps, i.descripcion as instalacion_descripcion, i.enlace_prepago
                FROM localizadores l
                JOIN instalaciones i on l.instalacion_id = i.id
                WHERE l.localizador = :localizador
                
    ";

$result_total = $conexion->prepare($sql_localizador);
$result_total->execute(array(':localizador' => $localizador));

if ($result_total->rowCount() > 0) {
    $row_total = $result_total->fetch(PDO::FETCH_ASSOC);

    $instalacion             = $row_total['nombre'];
    $instalacion_mapa        = $row_total['google_maps'];
    $instalacion_enlace      = $row_total['enlace_prepago'];
    $instalacion_desc = $row_total['instalacion_descripcion'];
}

//Obtenemos el precio del localizador desde la bbdd filtrando por el id_pedido pasado en Base64
$sql_localizador = " SELECT r.sala_horario_id
    FROM reservas r
    WHERE r.localizador = :localizador
    AND r.sala_horario_id <> 0
     "; 
               
$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador
));

if ($result_localizador->rowCount() > 0) {
    echo json_encode(2);die;
}


// Volvemos a comprobar que la reserva es sólo para disminuír plazas por si se saltan la comprobación del javascript
if (empty($_POST['pago_instalacion'])) {
    foreach ($arrTarifas as $key => $value) {
        if ($value > $arrTarifasOriginal[$key]) {
            echo json_encode(0);die;
        }
    }
}

// Guardamos la respuesta a lo de la newsletter
$sql_insert_newsletter    = "INSERT INTO localizador_campos(localizador, campo_id, value) values (?, 11, ?)";
$result_insert_newsletter = $conexion->prepare($sql_insert_newsletter);
$result_insert_newsletter->execute(array($localizador, $newsletter));

//guardamos el sala_horario_id
$sql_update_horario    = "UPDATE sala_horarios SET plazas_libres = plazas_libres - ? WHERE id = ?";
$result_update_horario = $conexion->prepare($sql_update_horario);
$result_update_horario->execute(array($plazas, $fechaId));

//modificamos el sala_horario_id en reservas y en localizador_tarifas, junto con el numero de plazas
$sql_update_reserva    = "UPDATE reservas SET sala_horario_id = ? WHERE localizador = ?";
$result_update_reserva = $conexion->prepare($sql_update_reserva);
$result_update_reserva->execute(array($fechaId, $localizador));

$sql_update_localizador_tarifas    = "UPDATE localizador_tarifas SET sala_horario_id = ? WHERE localizador = ?";
$result_update_localizador_tarifas = $conexion->prepare($sql_update_localizador_tarifas);
$result_update_localizador_tarifas->execute(array($fechaId, $localizador));


foreach($campos as $index => $campo){
    if(!empty($campo)){
        $sql_insert_campo    = "INSERT INTO  localizador_campos(localizador, campo_id, value) values (?, ?, ?)";
        $result_insert_campo = $conexion->prepare($sql_insert_campo);
        $result_insert_campo->execute(array($localizador, $index, $campo));
    }
}

echo json_encode(1);

require CARPETAPROYECTO . '/modules/visitas/reservas/modulos/regalar/correo_regalar.php';
