<?php

/************** Includes **********************************/
require_once '../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIB . 'clases/lang.php';
require_once DIRLIBCOMP . 'funciones.php';
require_once DIRLIBCOMP . 'clases/messages.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);


// Recogemos las variables POST
$localizador     = $_POST['localizador'];
$fechaId         = $_POST['fechaId'];
$fechaIdOriginal = $_POST['fechaIdOriginal'];
$plazas          = $_POST['plazas'];


//Obtenemos el total antes de actualizarlo
$sql_localizador = " SELECT l.* , i.nombre, i.google_maps, i.descripcion as instalacion_descripcion, i.enlace_prepago
                FROM localizadores l
                JOIN instalaciones i on l.instalacion_id = i.id
                WHERE l.localizador = :localizador
                
    ";

$result_total = $conexion->prepare($sql_localizador);
$result_total->execute(array(':localizador' => $localizador));

if ($result_total->rowCount() > 0) {
    $row_total = $result_total->fetch(PDO::FETCH_ASSOC);
    $unidades                = $row_total['unidades'];

    $instalacion             = $row_total['nombre'];
    $instalacion_mapa        = $row_total['google_maps'];
    $instalacion_enlace      = $row_total['enlace_prepago'];
    $instalacion_descripcion = $row_total['instalacion_descripcion'];
    $instalacion_prepago     = $row_total['enlace_prepago'];

}

//Obtenemos el precio del localizador desde la bbdd filtrando por el id_pedido pasado en Base64
$sql_localizador = " SELECT r.sala_horario_id
    FROM reservas r
    WHERE r.localizador = :localizador
    AND r.sala_horario_id = 0
     "; 
               
$result_localizador = $conexion->prepare($sql_localizador);
$result_localizador->execute(array(
    ':localizador' => $localizador
));

if ($result_localizador->rowCount() > 0) {
    echo json_encode(2);die;
}


// Volvemos a comprobar que la reserva es sólo para disminuír plazas por si se saltan la comprobación del javascript
if (empty($_POST['pago_instalacion'])) {
    foreach ($arrTarifas as $key => $value) {
        if ($value > $arrTarifasOriginal[$key]) {
            echo json_encode(0);die;
        }
    }
}

//Obtenemos el total antes de actualizarlo
$sql_sala = " SELECT fecha
        FROM sala_horarios 
        WHERE id = :sala_horario_id
        AND plazas_libres >= :unidades
        AND bloqueado = 0    
    ";

$result_sala = $conexion->prepare($sql_sala);
$result_sala->execute(array(
    ':sala_horario_id' => $fechaId,
    ':unidades' =>  $unidades ));

if ($result_sala->rowCount() > 0) {
    $row_total = $result_sala->fetch(PDO::FETCH_ASSOC);
    $fecha     = $row_total['fecha'];

}else{
    echo json_encode(0);die;
}

//Obtenemos el total antes de actualizarlo
$sql_sala = " SELECT fecha, hora_inicio
        FROM sala_horarios 
        WHERE id = :sala_horario_id
    ";

$result_sala = $conexion->prepare($sql_sala);
$result_sala->execute(array(
    ':sala_horario_id' => $fechaIdOriginal,
    ));

if ($result_sala->rowCount() > 0) {
    $row_total = $result_sala->fetch(PDO::FETCH_ASSOC);
    $fecha_reserva_ant = date("d/m/Y", strtotime($row_total['fecha']));
    $horario_ant       = date("H:i", strtotime($row_total['hora_inicio']));
}



//    - devolvemos todas las plazas anteriores al horario anterior
$sql_update_horario    = "UPDATE sala_horarios SET plazas_libres = plazas_libres + ? WHERE id = ?";
$result_update_horario = $conexion->prepare($sql_update_horario);
$result_update_horario->execute(array($unidades, $fechaIdOriginal));

$sql_update_horario    = "UPDATE sala_horarios SET plazas_libres = plazas_libres - ? WHERE id = ?";
$result_update_horario = $conexion->prepare($sql_update_horario);
$result_update_horario->execute(array($unidades, $fechaId));

//modificamos el sala_horario_id en reservas y en localizador_tarifas, junto con el numero de plazas
$sql_update_reserva    = "UPDATE reservas SET sala_horario_id = ? WHERE localizador = ?";
$result_update_reserva = $conexion->prepare($sql_update_reserva);
$result_update_reserva->execute(array($fechaId, $localizador));

$sql_update_localizador_tarifas    = "UPDATE localizador_tarifas SET sala_horario_id = ? WHERE localizador = ?";
$result_update_localizador_tarifas = $conexion->prepare($sql_update_localizador_tarifas);
$result_update_localizador_tarifas->execute(array($fechaId, $localizador));

//modificamos el sala_horario_id en reservas y en localizador_tarifas, junto con el numero de plazas
$sql_localizador       = "UPDATE localizadores SET fecha_uso = ? WHERE localizador = ?";
$result_update_reserva = $conexion->prepare($sql_localizador);
$result_update_reserva->execute(array($fecha, $localizador));

$mensaje_bbdd       = 'Fecha regalo modificada por el cliente ';
$fecha_modificacion = date('Y-m-d H:i:s');

$sql_formuario = "INSERT INTO localizadores_cambios_fechas
                    (localizador, fecha_modificacion, fecha_nueva, fecha_anterior, sala_nueva, sala_anterior, mensaje)
                    VALUES(:localizador, :fecha_modificacion, :fecha_nueva, :fecha_anterior, :sala_nueva, :sala_anterior, :mensaje)";
$result_formulario = $conexion->prepare($sql_formuario);
$exito_formulario  = $result_formulario->execute(array(
    ':localizador'        => $localizador,
    ':fecha_modificacion' => $fecha_modificacion,
    ':fecha_nueva'        => $fecha,
    ':fecha_anterior'     => $fecha_reserva_ant,
    ':sala_nueva'         => $fechaId,
    ':sala_anterior'      => $fechaIdOriginal,
    ':mensaje'            => $mensaje_bbdd,
));


echo json_encode(1);

require CARPETAPROYECTO . '/modules/visitas/reservas/modulos/regalar/correo_modificacion_fecha.php';
