<?php

/************** Includes **********************************/
require_once '../../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

$servicio        = htmlentities($_POST['servicio']);
$localizador     = $_POST['localizador'];
$cantidad_extras = 0;

if ($servicio != null && $servicio != '') {

    // EXTRAS COMPROBAMOS SI EL LOCALIZADOR TIENE EXTRAS
    // Compruebo si hay plazas disponibles en el horario seleccionado
    $sql_plazas = "SELECT count(*) as num_extras 
                   FROM localizador_extras_servicio le        
                   WHERE le.localizador = :localizador                     
                   AND le.estado = 'pagado'";

    $result_plazas = $conexion->prepare($sql_plazas);
    $result_plazas->execute(array(':localizador' => $localizador));

    if ($result_plazas->rowCount() > 0) {
        $row_plazas_ini = $result_plazas->fetch(PDO::FETCH_ASSOC);
        $cantidad_extras =$row_plazas_ini['num_extras'];
    }

    $sql_servicio    = "SELECT antelacion_reserva, antelacion_minima_reserva FROM servicios WHERE id = " . $servicio;
    $result_servicio = $conexion->query($sql_servicio);
    $datos_servicio  = $result_servicio->fetch();

    //Compruebo si hay plazas disponibles en el horario seleccionado
    $sql_horarios = "SELECT sh.*
					 FROM sala_horarios sh
					 JOIN sala_horario_servicios shs ON sh.id = shs.sala_horario_id
					 WHERE shs.servicio_id = " . $servicio . "
					 AND sh.plazas_libres > 0 AND sh.bloqueado = 0
					 AND sh.fecha >= '" . date('Y-m-d', strtotime(date('Y-m-d') . ' +' . $datos_servicio['antelacion_minima_reserva'] . ' hours')) . "'
					 AND sh.fecha <= '" . (date('Y-m-d', strtotime(date('Y-m-d') . ' +' . $datos_servicio['antelacion_reserva'] . ' days'))) . "'
					 ORDER BY sh.fecha";

    $result_horarios = $conexion->query($sql_horarios);

    $horarios_ok = array();
    if ($result_horarios->rowCount() > 0) {
        foreach ($result_horarios->fetchAll() as $row_horarios) {  
            $horarios_ok[] = $row_horarios['fecha'];
        }
    }

    echo json_encode($horarios_ok);
}