<?php

date_default_timezone_set('Europe/Madrid');

/************** Includes **********************************/
require_once '../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

/*******************************************************************
 * TRADUCCIONES
 *******************************************************************/
require_once DIRLIBCOMP . 'lang.php';
$language         = new lang();
$_SESSION["lang"] = $language->getLangNavegador();

if (isset($_POST['actividad'])) //Al seleccionar una actividad
{
    // COMPROBACIÓN SI ES URL DE INSTALACIÓN
    require_once DIRMODULOSCOMP . 'compra/url_instalaciones.php';

    // Url de instalación
    if ($es_instalacion) {
        $instalacion = "AND i.id = " . $row_instalacion['instalacion_id'];
    }
    // No es url de instalación
    else {
        $instalacion = '';
    }

    // Vemos sólo servicios de la instalación seleccionada inicialmente
    // Instalaciones correspondientes a la actividad seleccionada
    // Que tengan fechas disponibles para reservar en los próximos 7 días
    $fecha_max_reserva = date("Y-m-d", strtotime(date("Y-m-d") . " +6 day"));
    $fecha_actual      = date("Y-m-d");

    $sql_instalaciones = "SELECT i.id, i.nombre, a.nombre as nombreA, s.horas_valle, s.pistas
						  FROM sala_horarios sh JOIN sala_horario_servicios ss ON sh.id = ss.sala_horario_id
						  JOIN servicios s  ON ss.servicio_id = s.id
						  JOIN instalaciones i ON s.instalacion_id = i.id
						  JOIN actividades a ON s.actividad_id = a.id
						  JOIN salas sa ON sh.sala_id = sa.id
						  AND actividad_id = " . $_POST['actividad'] . "
						  AND fecha >= '" . $fecha_actual . "'
						  AND fecha <= '" . $fecha_max_reserva . "'
						  AND s.activo = 1
						  AND sa.publicado = 1
						  AND i.activo = 1 " .
        				  $instalacion . "
						  GROUP BY i.nombre
						  ORDER BY i.nombre ASC";

    $result_instalaciones = $conexion->query($sql_instalaciones);

    // Compruebo que hay resultados inicialmente
    if ($result_instalaciones->rowCount() > 0) {
        // Obtengo sólo los datos de la primera instalación seleccionada en el select
        // por si hay más de una para la actividad seleccionada
        $row_instalacion = $result_instalaciones->fetch(PDO::FETCH_ASSOC);
        $instalacion     = $row_instalacion['id'];

        // Servicios correspondientes a la actividad seleccionada (e instalación por defecto si hay más de una)
        $sql_servicios = "SELECT s.id, s.nombre, a.nombre as nombreA, s.horas_valle, s.pistas, sa.nombre as nombreSa
						  FROM servicios s JOIN actividades a ON s.actividad_id = a.id
						  JOIN salas sa ON s.sala_id = sa.id
						  AND s.actividad_id = " . $_POST['actividad'] . "
						  AND s.instalacion_id = " . $instalacion . "
						  AND s.sala_id <> 0
						  AND sa.padre_id IS NULL
						  AND s.activo = 1
						  ORDER BY s.pases ASC";

        $result_servicios = $conexion->query($sql_servicios);
        $result_actividad = $conexion->query($sql_servicios);

        if ($result_servicios->rowCount() > 0) {
            // Muestro primero un texto
            $row_actividad = $result_actividad->fetch();

            echo '<option value="0">Seleccione una visita</option>';

            foreach ($result_servicios->fetchAll() as $row_servicios) {

                // Traducción datos servicio
                $product_lang = $language->getStringsProduct($row_servicios['id']);

                echo '<option value="' . $row_servicios['id'] . '">' . $product_lang['nombre'] . '</option>';
            }

            // Compruebo si hay más servicios relacionados con la instalación
            $sql_mas_servicios = "SELECT s.id, s.nombre
								  FROM servicios_otras_instalaciones so JOIN servicios s ON so.servicio_id = s.id
								  AND so.instalacion_id = " . $instalacion . "
								  AND so.actividad_id = " . $_POST['actividad'];

            $result_mas_servicios = $conexion->query($sql_mas_servicios);

            if ($result_mas_servicios->rowCount() > 0) {
                foreach ($result_mas_servicios->fetchAll() as $row_mas_servicios) {

                    // Traducción datos servicio
                    $product_lang = $language->getStringsProduct($row_mas_servicios['id']);

                    echo '<option value="' . $row_mas_servicios['id'] . '">' . $product_lang['nombre'] . '</option>';
                }
            }
        } else {
            echo '<option value="">No hay visitas disponibles</option>';
        }
    } else {
        echo '<option value="">No hay servicios visitas disponibles</option>';
    }

} elseif (isset($_POST['instalacion'])) //Obtengo los servicios de la instalación y actividad seleccionada
{
    // Al cambiar la selección de la instalación

    // Vemos sólo los servicios de la instalación seleccionada
    $sql_servicios = "SELECT s.id, s.nombre, sa.nombre as nombreSa
					  FROM servicios s JOIN actividades a ON s.actividad_id = a.id
					  JOIN salas sa ON s.sala_id = sa.id
					  AND s.instalacion_id = " . $_POST['instalacion'] . "
					  AND s.actividad_id = " . $_POST['actividadSeleccionada'] . "
					  AND s.sala_id <> 0
					  AND sa.padre_id IS NULL
					  AND s.activo = 1
					  ORDER BY s.pases asc";

    $result_servicios = $conexion->query($sql_servicios);

    if ($result_servicios->rowCount() > 0) {

        echo '<option value="0">Seleccione una visita</option>';

        foreach ($result_servicios->fetchAll() as $row_servicios) {

            // Traducción datos servicio
            $product_lang = $language->getStringsProduct($row_servicios['id']);

            echo '<option value="' . $row_servicios['id'] . '">' . $product_lang['nombre'] . '</option>';
        }

        // Compruebo si hay más servicios relacionados con la instalación
        $sql_mas_servicios = "SELECT s.id, s.nombre
							  FROM servicios_otras_instalaciones so JOIN servicios s ON so.servicio_id = s.id
							  AND so.instalacion_id = " . $_POST['instalacion'] . "
							  AND so.actividad_id = " . $_POST['actividadSeleccionada'];

        $result_mas_servicios = $conexion->query($sql_mas_servicios);

        if ($result_mas_servicios->rowCount() > 0) {
            foreach ($result_mas_servicios->fetchAll() as $row_mas_servicios) {
                // Traducción datos servicio
                $product_lang = $language->getStringsProduct($row_mas_servicios['id']);

                echo '<option value="' . $row_mas_servicios['id'] . '">' . $product_lang['nombre'] . '</option>';
            }
        }
    } else {
        echo '<option value="">Seleccione una actividad</option>';
    }
}