<?php
ini_set('display_errors', 0);
date_default_timezone_set('Europe/Madrid');

/**
 * Includes
 */
require_once '../config.php';
require_once DIRLIBCOMP . 'SPDO.php';
require_once DIRLIBCOMP . 'funciones.php';
$conexion = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);

$sql_and_localizador   = "";
$sql_and_salahorarioid = "";

/**
 * Validacion principal,
 * Si no hay valor en uno de los dos, enviar un flash de vuelta
 */
if (!strlen(trim($_POST['telefono'])) || !strlen(trim($_POST['fecha']))) {

    $mensaje = array();
    if (!strlen(trim($_POST['telefono']))) {
        $mensaje = array_merge($mensaje, array("ValidacionTelefono" => "Introduzca su teléfono."));
    }

    if (!strlen(trim($_POST['fecha']))) {
        $mensaje = array_merge($mensaje, array("ValidacionFecha" => "Introduzca fecha de Compra o Reserva."));
    }

    echo json_encode(array(0, $mensaje));

    die();
}

if (isset($_POST['localizador'])) {
    $sql_and_localizador = "AND localizador.localizador = '" . $_POST['localizador'] . "'";
}

if (isset($_POST['sala_horario_id'])) {
    $sql_and_salahorarioid = "AND sala_horario.id = '" . $_POST['sala_horario_id'] . "'";
}

$sql_localizador = "SELECT * FROM localizadores localizador
                    JOIN reservas reserva ON localizador.localizador = reserva.localizador
                    JOIN sala_horarios sala_horario ON reserva.sala_horario_id = sala_horario.id
                    AND localizador.telefono = '" . trim($_POST['telefono']) . "'
                    AND (localizador.fecha_creacion = '" . cambiaf_a_mysql(trim($_POST['fecha'])) . "' OR sala_horario.fecha = '" . cambiaf_a_mysql(trim($_POST['fecha'])) . "' ) AND localizador.estado = 'pagado' " . $sql_and_localizador . ' ' . $sql_and_salahorarioid;

$result_localizador = $conexion->query($sql_localizador);

$resultado = array();
if ($result_localizador->rowCount() === 1 || ($result_localizador->rowCount() > 1 && isset($_POST['localizador']) && isset($_POST['sala_horario_id']))) {
    $cuant = 1;
} else {
    $cuant = 0;
}

if ($result_localizador->rowCount() > 0) {
    while ($localizador = $result_localizador->fetch()) {
        $sql_reserva = "SELECT distinct localizador.*, localizador.nombre as localizador_nombre, reserva.*, servicio.*, sala_horario_servicios.*, sala_horario_servicios.*,
                        instalacion.nombre as instalacion_nombre, actividades.nombre as actividad_nombre, sala_horarios.hora_inicio, sala_horarios.id as sala_horario_id_original, localizador.telefono as telefono_localizador
                        FROM localizadores localizador
                        JOIN reservas reserva ON localizador.localizador = reserva.localizador
                        JOIN servicios servicio ON servicio.id = localizador.servicio_id
                        JOIN instalaciones instalacion ON servicio.instalacion_id = instalacion.id
                        JOIN sala_horario_servicios ON localizador.servicio_id = sala_horario_servicios.servicio_id
                        JOIN actividades  ON actividades.id = servicio.actividad_id
                        JOIN sala_horarios ON reserva.sala_horario_id = sala_horarios.id
                        AND localizador.localizador = '" . $localizador['localizador'] . "' AND sala_horarios.id = " . $localizador['sala_horario_id'];

        $resultadosloc = $conexion->query($sql_reserva);

        // Cuando existe resultado es que es una reserva
        if ($resultadosloc->rowCount() > 0) {
            $reserva = $resultadosloc->fetch();

            $resultado[] = array(
                'plazas'                => $reserva['unidades'],
                'plazas_valle'          => $reserva['unidades'],
                'localizador'           => $reserva['localizador'],
                'email'                 => $reserva['email'],
                'nombre'                => $reserva['localizador_nombre'],
                'apellidos'             => $reserva['apellido'],
                'telefono'              => !empty($reserva['telefono']) ? $reserva['telefono'] : $reserva['telefono_localizador'],
                'servicio'              => $reserva['servicio_id'],
                'servicio_nombre'       => $reserva['nombre'],
                'fecha'                 => $reserva['sala_horario_id_original'],
                'hora'                  => $reserva['sala_horario_id_original'],
                'instalacion'           => $reserva['instalacion_id'],
                'instalacion_nombre'    => $reserva['instalacion_nombre'],
                'actividad_nombre'      => $reserva['actividad_nombre'],
                'hora_inicio'           => substr($reserva['hora_inicio'], 0, strlen($reserva['hora_inicio']) - 3),
                'fecha_inicio'          => date("d/m/y", strtotime($reserva['fecha_reserva'])),
                'actividadSeleccionada' => $reserva['actividad_id'],
                'pago_instalacion'      => $reserva['pago_instalacion'],
            );
        }

        // Si no existe esque es una compra y no una reserva
        else {
            $sql_reserva = "SELECT distinct localizador.*, localizador.nombre as localizador_nombre, servicio.*, sala_horario_servicios.*, instalacion.nombre as instalacion_nombre,
                            actividades.nombre as actividad_nombre ,sala_horarios.hora_inicio, sala_horarios.id as sala_horario_id_original
                            FROM localizadores localizador
                            JOIN servicios servicio ON servicio.id = localizador.servicio_id
                            JOIN instalaciones instalacion ON servicio.instalacion_id = instalacion.id
                            JOIN sala_horario_servicios on localizador.servicio_id = sala_horario_servicios.servicio_id
                            JOIN actividades ON actividades.id = servicio.actividad_id
                            JOIN sala_horarios ON reserva.sala_horario_id = sala_horarios.id
                            AND localizador.localizador = '" . $localizador['localizador'] . "'";

            $resultadosloc = $conexion->query($sql_reserva);

            $reserva = $resultadosloc->fetch();

            $resultado[] = array(
                'plazas'                => $reserva['unidades'],
                'plazas_valle'          => $reserva['unidades'],
                'localizador'           => $reserva['localizador'],
                'email'                 => $reserva['email'],
                'nombre'                => $reserva['localizador_nombre'],
                'apellidos'             => $reserva['apellido'],
                'telefono'              => !empty($reserva['telefono']) ? $reserva['telefono'] : $reserva['telefono_localizador'],
                'servicio'              => $reserva['servicio_id'],
                'servicio_nombre'       => $reserva['nombre'],
                'fecha'                 => $reserva['sala_horario_id_original'],
                'hora'                  => $reserva['sala_horario_id_original'],
                'instalacion'           => $reserva['instalacion_id'],
                'instalacion_nombre'    => $reserva['instalacion_nombre'],
                'actividad_nombre'      => $reserva['actividad_nombre'],
                'hora_inicio'           => "",
                'fecha_inicio'          => date("d/m/y", strtotime($reserva['fecha_compra'])),
                'actividadSeleccionada' => $reserva['actividad_id'],
                'pago_instalacion'      => $reserva['pago_instalacion'],
            );
        }
    }

    echo json_encode(array(1, $cuant, $resultado));
} else {
    echo json_encode(array(0, "DatosIncorrectos"));
}
