<?php
ini_set('error_reporting', 0 );
ini_set("log_errors", 1);
ini_set("error_log", "logs/error.log");
/*ini_set('display_errors', 0);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
require_once __DIR__ . '/../../../environment.php';

date_default_timezone_set('Europe/Madrid');

require __DIR__ . '/lib/autoload.php';
use Dotenv\Dotenv;
$dotenv = Dotenv::create(__DIR__ .'/../../..');
$dotenv->load();

$protocol   = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
$domainLink = $protocol . '://' . $_SERVER['HTTP_HOST'];

define('URLANALYTICS', $domainLink . "/wp-content/analytics.php");

// Datos de la BBDD local
define('BDENGINE',   $_ENV['BDENGINE']);
define('BDHOST',     $_ENV['BDHOST']);
define('BDDATABASE', $_ENV['BDDATABASE']);
define('BDUSER',     $_ENV['BDUSER']);
define('BDPASS',     $_ENV['BDPASS']);

define('CARPETAPROYECTO',   $_ENV['CARPETAPROYECTO']);
define('DIRECCIONPROYECTO', $domainLink . '/wp-content/plugins/visitas');
define('DIRECCIONGESTOR',   $_ENV['DIRECCIONGESTOR']);
define('DIRWEBROOT',        $_ENV['DIRWEBROOT']);

define('MAILHOST',     $_ENV['MAILHOST']);
define('MAILSMTPAUTH', strtolower($_ENV['MAILSMTPAUTH']) === "true");
define('MAILUSER',     $_ENV['MAILUSER']);
define('MAILPASS',     $_ENV['MAILPASS']);
define('MAILFROM',     $_ENV['MAILFROM']);
define('MAILPORT',     $_ENV['MAILPORT']);
define('URLAPISMTPTOKEN',  $_ENV['URLAPISMTPTOKEN']);
define('PASSAPISMTPTOKEN', $_ENV['PASSAPISMTPTOKEN']);
define('URLAPISMTPDATA',   $_ENV['URLAPISMTPDATA']);

// Redsys - desarrollo
define('RedsysServer',               $_ENV['REDSYSSERVER']);
define('RedsysKey',                  $_ENV['REDSYSKEY']);
define('RedsysMerchantCode',         $_ENV['REDSYSMERCHANTCODE']);
define('RedsysTerminal',             $_ENV['REDSYSTERMINAL']);
define('RedsysMerchantURL',          DIRECCIONPROYECTO . '/modules/visitas/reservas/modulos/compra/Redsys.ipn.php');
define('RedsysEnviromentProduction',  strtolower($_ENV['REDSYSENVIROMENTPRODUCTION']) === "true");


if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    /* special ajax here */} else {
    if (!isset($sin_root)) {
        echo "<script type=\"text/javascript\">var ROOT = '" . DIRECCIONPROYECTO . "';</script>";
        echo "<script type=\"text/javascript\">var ROOTGESTOR = '" . DIRECCIONGESTOR . "';</script>";
    } else {
        if (!$sin_root) {
            echo "<script type=\"text/javascript\">var ROOT = '" . DIRECCIONPROYECTO . "';</script>";
            echo "<script type=\"text/javascript\">var ROOTGESTOR = '" . DIRECCIONGESTOR . "';</script>";
        }
    }
}

// Directorios de la aplicación
define('DIRMODULOS', 'modulos/');
define('DIRMODULOSCOMP', CARPETAPROYECTO . '/modules/visitas/reservas/modulos/');
define('DIRLIB', CARPETAPROYECTO . '/modules/visitas/reservas/lib/');
define('DIRLIBCLASS', CARPETAPROYECTO . '/modules/visitas/reservas/lib/clases/');
define('DIRLIBCOMP', CARPETAPROYECTO . '/modules/visitas/reservas/lib/');
define('DIRCLASS', CARPETAPROYECTO . '/modules/visitas/reservas/lib/clases/');
define('DIRTPL', CARPETAPROYECTO . '/modules/visitas/reservas/templates');
define('DIRJS', 'js/');
define('DIRJSCOMP', DIRECCIONPROYECTO . '/modules/visitas/reservas/js/');
define('DIRCSSCOMP', DIRECCIONPROYECTO . '/modules/visitas/reservas/css/');
define('DIRLOG', CARPETAPROYECTO . '/modules/visitas/reservas/logs/');
define('DIRAJAX', CARPETAPROYECTO . '/modules/visitas/reservas/ajax/');
define('DIRLANGUAGESTRINGS', CARPETAPROYECTO . '/modules/visitas/reservas/php_strings/');
define('DIRLANGUAGETEMPLATES', CARPETAPROYECTO . '/modules/visitas/reservas/templates/');
define('DIRARCHIVOSSERVICIOS', CARPETAPROYECTO . '/servicios_archivos/');
define('ENALCEARCHIVOSSERVICIOS', DIRECCIONPROYECTO . '/servicios_archivos/');
define('ENALCEIMAGENSERVICIOS', $domainLink . '/wp-content/plugins/visitas/img/servicios/');
define('ENLACEIMAGEN', $domainLink . '/wp-content/plugins/visitas/img/');

define('DOMINIO', DIRECCIONPROYECTO . '/modules/visitas/reservas/');
define('DOMINIOPRINCIPAL', DIRECCIONPROYECTO . '/modules/visitas/reservas/');
define('DOM', DIRECCIONPROYECTO . '/');
define('DOMRESERVAS', DIRECCIONGESTOR);

// Paypal
define('PaypalServer',       $_ENV['PAYPALSERVER'] );
define('PaypalFacilitator',  $_ENV['PAYPALFACILITATOR'] );
define('PaypalNotifyURL',    DIRECCIONPROYECTO . '/modules/visitas/reservas/modulos/compra/Paypal.ipn.php');
define('PaypalClientId',     $_ENV['PAYPALCLIENTID'] ); 
define('PaypalClientSecret', $_ENV['PAYPALCLIENTSECRET']); 
define('PaypalMode',         $_ENV['PAYPALMODE']); 

// URL de retorno
define('URL_OK', 'enoexperiencia/?compra_finalizada');
define('URL_NOK', 'enoexperiencia/?compra_no_finalizada');

//  Establece el segmento de la url que contiene el idioma, varía de producción a desarrollo
define('SEGMENT_URL_LANG', $_ENV['SEGMENT_URL_LANG']);

define('MAIL_TO_NOTIFY_DEBUG', $_ENV['MAIL_TO_NOTIFY_DEBUG']);
define('MAIL_TO_NOTIFY',       $_ENV['MAIL_TO_NOTIFY']);

// Las peticiones se realizan contra el backoffice
define('BACKOFFICE_API',  $_ENV['BACKOFFICE_API']);

if(!DEFINED('ANALITICS_REGISTRO_COMPRA')){
    define('ANALITICS_REGISTRO_COMPRA', $_ENV['ANALITICS_REGISTRO_COMPRA']);
}
if(!DEFINED('ANALITICS_CODIGO')){
    define('ANALITICS_CODIGO',          $_ENV['ANALITICS_CODIGO']);
}
if(!DEFINED('ANALITICS_CLAVE')){
    define('ANALITICS_CLAVE',           $_ENV['ANALITICS_CLAVE']);
}
define('PASSBOOK_P12_FILE',             CARPETAPROYECTO . '/modules/visitas/reservas/files/' . $_ENV['PASSBOOK_FILE']);
define('PASSBOOK_P12_PASSWORD',         $_ENV['PASSBOOK_P12_PASSWORD']);
define('PASSBOOK_WWDR_FILE',            CARPETAPROYECTO . '/modules/visitas/reservas/files/WWDR.pem');
define('PASSBOOK_PASS_TYPE_IDENTIFIER', $_ENV['PASSBOOK_PASS']);
define('PASSBOOK_TEAM_IDENTIFIER',      $_ENV['PASSBOOK_TEAM_IDENTIFIER']);
define('PASSBOOK_ORGANIZATION_NAME',    $_ENV['PASSBOOK_ORGANIZATION_NAME']);
define('PASSBOOK_OUTPUT_PATH_BASE',     CARPETAPROYECTO . '/modules/visitas/reservas/files/passbook/');
define('PASSBOOK_ICON_FILE',            CARPETAPROYECTO . '/modules/visitas/reservas/images/' . $_ENV['PASSBOOK_ICON_FILE']);
define('PASSBOOK_BACKGROUND_FILE',      CARPETAPROYECTO . '/modules/visitas/reservas/images/'. $_ENV['PASSBOOK_BACKGROUND_FILE']);

define('NOMBREINSTALACION',         $_ENV['NOMBREINSTALACION']); 
define('CLAVEENCRIPTAR'   ,         $_ENV['CLAVEENCRIPTAR']); 

define('URL_FRONT_PRINCIPAL',$_ENV['URL_FRONT_PRINCIPAL']); 