

function cargaCarritoComun(tarifas){
     								
    var tarifas_html = "";
    tarifas.map(tarifa => {
        tarifas_html += "<tr>";
        tarifas_html += "<td> <label>" + tarifa['nombre_tarifa'] + "</label></td>";
        tarifas_html += "<td><input type='text' class='num_usuarios' name='plazas_adulto' data-grupo='" + tarifa['id_grupo_usuario'] + "' value='" + tarifa['num_tarifa_carrito'] + "' readonly></td>";
        tarifas_html += "<td class='casi-last'>" + tarifa['precio'] + "</td>";
        tarifas_html += "<td class='delete-mejora'></td>";
        tarifas_html += "</tr>";
    });

    return tarifas_html;
}

function cargarCamposExtrasComun(campos_servicio){
    var campos_servicio_html = "";

    for(var i = 0; i < campos_servicio.length; i++){

        if (campos_servicio[i]['campo_type'] =='text'){
            campos_servicio_html += `
            <div class="linea_datos">						
                <input 
                placeholder="${campos_servicio[i]['campo_nombre']} ${(campos_servicio[i]['es_oblicatorio'] == "1") ? `*` :``}" 
                type="${campos_servicio[i]['campo_type']}" 
                name="campos_extra[${campos_servicio[i]['campo_id']}]" 
                class="form-control input_datopersonal campo_extra" 
                id="${campos_servicio[i]['campo_id']}"
                data-id="${campos_servicio[i]['campo_id']}"
                data-obligatorio="${(campos_servicio[i]['es_oblicatorio'] == "1") ? `*` :``}"
                > 
            </div>
                `;
        }else if(campos_servicio[i]['campo_type'] =='textarea'){
            campos_servicio_html +=`
                <div class="linea_datos">								
                    <textarea 
                        placeholder="${campos_servicio[i]['campo_nombre']} ${(campos_servicio[i]['es_oblicatorio'] == "1") ? `*` :``}" 
                        name="campos_extra[${campos_servicio[i]['campo_id']}]" 
                        class="input_datopersonal campo_extra form-control" 
                        id="${campos_servicio[i]['campo_id']}" 
                        data-id="${campos_servicio[i]['campo_id']}" 
                        data-obligatorio="${(campos_servicio[i]['es_oblicatorio'] == "1") ? `*` :``}"
                        maxlength="255"></textarea>
                    <span class="caracteres_textarea"><span class="max_caracteres">0</span>/255</span>
                </div>
            `;

        }else if(campos_servicio[i]['campo_type'] =='select'){
            campos_servicio_html +=`
                <div class="linea_datos">
                    <select 
                        name="campos_extra[${campos_servicio[i]['campo_id']}]" 
                         class="input_datopersonal campo_extra valid" 
                        id="${campos_servicio[i]['campo_id']}"
                        data-id="${campos_servicio[i]['campo_id']}"
                        data-nombre-campo="${campos_servicio[i]['campo_nombre']} ${(campos_servicio[i]['es_oblicatorio'] == "1") ? `*` :``}"                   
                        >
                        ${campos_servicio[i]['opciones'].map(opcion => 	{

                            if (campos_servicio[i]['campo_id']=='113' && (opcion.opcion =='España' || opcion.opcion =='Spain')  ) {
                               return `<option value="${opcion.opcion}" selected> ${opcion.opcion} </option>`	
                            }else{
                                return `<option value="${opcion.opcion}"> ${opcion.opcion} </option>`	

                            }						
                        }
                            
                        )}							
                    </select>
                </div>
            `;
        }
    }
    return campos_servicio_html;

}

function cargarCamposExtrasComunStr(info_campos_extras){
    var campos_servicio_html = "";

    for(var i = 0; i < info_campos_extras.length; i++){
        if(info_campos_extras[i].LocalizadorCampo.value !=''){
            if (info_campos_extras[i].Campo.type =='textarea'){
                campos_servicio_html +="<div class='datos-visitas textarea-full'>";							
            }else{
                campos_servicio_html +="<div class='datos-visitas'>";							
            }
            campos_servicio_html +="<p>" + info_campos_extras[i].Campo.nombre + "</p>";
            campos_servicio_html +="<p><strong>" + info_campos_extras[i].LocalizadorCampo.value +"</strong></p>";
            campos_servicio_html +="</div>";
        }
    }
    return campos_servicio_html;
}

function cargarCamposExtrasCheckComun(campos_servicio_chk) {
    
    var campos_servicio_chk_html = "";
    campos_servicio_chk.forEach(chk => {				
        campos_servicio_chk_html +=`
            <input type="checkbox" name="campos_extra_check[${chk.id}]" data-id="${chk.id}" id="condiciones_compra2${chk.id}">
            <label for="condiciones_compra2${chk.id}">
                <span></span>
                <p>${chk.descripcion} ${chk.nombre}</p>							
            </label>
    `;
    });
    return campos_servicio_chk_html;
}
function cargarCamposExtrasCheckComunAnterior(campos_servicio_chk) {
    
    var campos_servicio_chk_html = "";
    campos_servicio_chk.forEach(function (chk) {
      campos_servicio_chk_html += "<label>";
      campos_servicio_chk_html += "<input type='" + chk.type +"' name='campos_extra_check[" +chk.id+ "]' data-id='"  + chk.id +"' >" + chk.nombre +"  <br/> " + chk.descripcion;
      campos_servicio_chk_html += "</label>";
    });
    return campos_servicio_chk_html;
}

function cargaExtrasComun(campos_extras){
    var campos_extras_html ='';
    if(campos_extras.length > 0){        

        campos_extras.map(extra => {
        
            var extra_precio_html  = '';
            var caja_unidades_html = '';

            if(extra.Extras.por_unidad == "1" ){
                // $cantidad = '';
                // $html = '';
                extra.info_tarifas.map( usuarios_grupos =>{
                    var precio='';

                    if ( usuarios_grupos.ExtrasUsuariosGrupos.precio =="0"){
                        precio = extras['texto_extra_gratuito'];
                    }else{
                        precio=`${usuarios_grupos.ExtrasUsuariosGrupos.precio} €`;
                    }
                    extra_precio_html += `
                        <div class='usuario_grupo_precio'
                            data-1='${usuarios_grupos.UsuariosGrupos.id}' 
                            data-2='${usuarios_grupos.ExtrasUsuariosGrupos.precio}'>
                                ${usuarios_grupos.UsuariosGrupos.nombre} - ${precio}
                        </div>`;
                });

            } else{

                if(extra.Extras.por_unidad == "0" && extra.Extras.precio != "0"){
                    extra_precio_html = `<div class='usuario_grupo_precio' data-1='' data-2='${extra.Extras.precio}'>${extra.Extras.precio} €</div>`;
                }

                if (extra.Extras.cantidad_maxima > 1 ){
                    caja_unidades_html = `<input type="number" 
                        name="cantidad_maxima" 
                        max="${extra.Extras.cantidad_maxima}" 
                        min="1" placeholder=""
                        />`;
                }
            }

            
            
            campos_extras_html += `
            <li class="card-visita"  data-id="${extra.Extras.id}">
                <div class="content-extra">

                    <input type="hidden" value="237" />
                    
                    <div class="mejora-enviar">
                        <button class="enviar_extra" 
                            data-id="${extra.Extras.id}" 
                            data-name="${extra.Extras.nombre}"
                            data-price="${extra_precio_html}"
                            data-grupo="${extra.Extras.por_unidad}"
                            onclick="cargarExtras(this)">
                            <i class="fa fa-plus"></i>
                        </button>
                    </div>

                    <div class="textos-card-extras">
                        <div class="mejora-texto-titulo">
                            <strong>${extra.Extras.nombre}</strong>
                        </div>
                        <div class="mejora-texto mejora-descripcion">${extra.Extras.descripcion}</div>
                    </div>
                    
                    <div class="mejora-precio">	
                            ${caja_unidades_html}					
                            <input type="hidden" value="1" />
                            <div class="cont-mejora-precio">${extra_precio_html}</div>

                    </div>             

                </div>
            </li>
            `;
        });
    }
    return campos_extras_html;
}

function cargaFormasPagoComun(tipos_pagos){
    var tipo_pagos_html='';

    for(var i = 0; i < tipos_pagos.length; i++){
        tipo_pagos_html += '<div class="card-visita radio pago ' + tipos_pagos[i]['nombre_css'] + '">';
        tipo_pagos_html += '<label>';
        tipo_pagos_html += '<input type="radio" name="pago" value="' + tipos_pagos[i]['id'] + '" >' + tipos_pagos[i]['pago_tipo'];
        tipo_pagos_html += '</label>';
        tipo_pagos_html += '</div>';
    }

    return tipo_pagos_html;
}

function cargarResumenLocalizadorComun(localizador,hay_extras){

    var tipo = jQuery('#tipoModificacion').val();

    if(tipo == 'fechas'){
        jQuery('#DivEdicionFechas').show();
    }else{
        jQuery('#DivEdicionPlazas').show();
    }

    var url =  ROOTGESTOR  + "ApiTusVisitasV2/modificar";

    if (hay_extras == 1){
        url = ROOTGESTOR  + "ApiExtrasV2/modificar";
    }

    var lang = jQuery('#lang').val();

    jQuery.ajax({
        type     : "POST",
        url      : url,     		
        data     : JSON.stringify({    
          localizador : localizador,
          lang        : lang
        }),
        success: function (response) {
          var data = JSON.parse(response);

          contenido_carrito = jQuery('#carrito').html();
             
          jQuery('#TotalPrecio').text(data.precio_total_str);
          jQuery('#TotalCarrito').val(data.precio_total_str);
          jQuery('#StrLocalizador').html(localizador);
          jQuery('#StrServicio').html(data.info_compra.servicio_nombre);
          jQuery('#StrInstalacion').html(data.info_compra.instalacion_nombre);
          jQuery('#StrFecha').html(data.fecha);
          jQuery('#fecha').html(data.fecha);
          jQuery('#StrHora').html(data.hora);
          try {        
            jQuery('#TxtHoraFechaAnterior').val(data.hora);
          } catch (error) {
          }  
          jQuery('#StrFormaPago').html(data.pago);
          jQuery('#StrNombre').html(data.nombre);
          jQuery('#StrApellido').html(data.apellido);
          jQuery('#StrTelefono').html(data.telefono);
          jQuery('#StrEmail').html(data.email);      
          jQuery('#servicioSeleccionado').val(data.info_compra.servicio_id);
          jQuery('#TipoVisita').val(data.info_compra.servicio_id);
          jQuery('#ServicioId').val(data.info_compra.servicio_id);
          jQuery('#Adultos').val(data.unidades);
          jQuery('#Plazas').val(data.unidades);
          jQuery('#FechaAnterior').val(data.horario);
          jQuery('#Idioma').val(data.info_compra.idioma_info.Idioma.id);
          jQuery('#instalacion').val(data.instalacion);
          jQuery('#BodegaId').val(data.instalacion);
          jQuery('#pago_instalacion').val(data.pago_instalacion);
          jQuery('#DivCondicionesExtras').html(data.info_compra.condiciones_extra);
          try {
                jQuery('#StrFormaPago').html(data.pago);     
            
          } catch (error) {
            
          }
     
        var tarifas_html       = '';
        var tarifas_input_html = '';
        var TarifasId          = '';
        var TarifasValue       = '';

        for(var i = 0; i < data.tarifas.length; i++){
    
            if(i == data.tarifas.length - 1){
                TarifasId    += data.tarifas[i].Tarifa.id;
                TarifasValue += data.tarifas[i].LocalizadorTarifa.plazas_adulto;
            }else{
                TarifasId    += data.tarifas[i].Tarifa.id + ',';
                TarifasValue += data.tarifas[i].LocalizadorTarifa.plazas_adulto + ',';
            }
            tarifas_input_html += '<div class="adultos">';
            tarifas_input_html += '<h4>' + data.tarifas[i].UsuariosGrupo.nombre +' (' + data.tarifas[i].Tarifa.precio +' €)</h4>	';
            tarifas_input_html += '<input type="text" max="' + data.tarifas[i].LocalizadorTarifa.plazas_adulto +'" id="txtTarifa' + data.tarifas[i].Tarifa.id +'" name="tarifas[]" placeholder="-" class="input-card usuarios_grupos form-control-tarifas" data-id="' + data.tarifas[i].Tarifa.id +'" data-original="' + data.tarifas[i].LocalizadorTarifa.plazas_adulto +'"  value="' + data.tarifas[i].LocalizadorTarifa.plazas_adulto +'"  >';
            tarifas_input_html += '</div>';

        }

        jQuery('#DivTarifasCambio').html(tarifas_input_html);
        
        data.tarifas.map( tarifa =>{            
            tarifas_html +=`
                <tr>
                    <td>
                        <label>${tarifa.UsuariosGrupo.nombre}</label>
                    </td>
                    <td>
                        <span class="num_usuarios">${tarifa.LocalizadorTarifa.plazas_adulto}</span>
                    </td>
                    <td class="casi-last">${parseFloat(tarifa.LocalizadorTarifa.precio_tarifa_total).toFixed(2)} €</td>
                </tr>`;
        });
        jQuery("#carrito .totales").before(tarifas_html);
        var total_extras = 0;
    
        try {
            var extras_html ='';

            if(data.extras_agrupados.length > 0 ){
                jQuery('#hay_extras').val(1);
                
                extras_html = `
                <tr style="height:30px">
                    <td>
                        &nbsp;
                    </td>
                    <td>
                        &nbsp;
                    </td>
                    <td>
                        &nbsp;
                    </td>
                </tr>
 
                <tr>
                    <th>
                        <h5> EXTRAS  </h5>
                    </th>
                    <th>
                        
                    </th>
                    <th>
                    
                    </th>
                </tr>`;

            }

            data.extras_agrupados.map( extra =>{
                extras_html +=`
                    <tr class="extra-mejora-tabla">
                        <td>
                            <label>${extra.nombre_extra}</label>
                        </td>
                        <td>
                            <span class="num_usuarios">${extra.cantidad_extra}</span>
                        </td>
                        <td>${parseFloat(extra.total).toFixed(2)}  €</td>
                    </tr>
                `;
                total_extras += 1;
            });
            jQuery("#carrito .totales").before(extras_html);


        } catch (error) {
            
        }

        try {
            if (data.bono != ''){
                var texto_cupon = jQuery('#LblCupon').val();
                var cupon_html  = '<tr class="tr-descuento extra-mejora-tabla">';
                    cupon_html += '<td>' + texto_cupon +' (' + data.bono + ': -' + data.bono_cantidad +') </td>';
                    cupon_html += '<td><span class="num_usuarios">1</span></td>';
                    cupon_html += '<td class="casi-last"> <strike>' + parseFloat(data.bono_cantidad_descontada).toFixed(2) +' €</strike></td>';
                    cupon_html += '</tr>';
                jQuery("#carrito .totales").before(cupon_html);
            }

                     
        } catch (error) {
            
        }
                   
        jQuery('#TarifasId').val(TarifasId);
        jQuery('#TarifasValue').val(TarifasValue);
        jQuery("#BtnVolverTusVisitas").attr("href","/"+data.info_compra.formulario_volver);
        
        var campos_servicio_html = "";
        var campos_servicio      = jQuery.makeArray(data.info_campos_extras);    
        campos_servicio_html     = cargarCamposExtrasComunStr(campos_servicio);
        if(data.regalo == "1"){     
            jQuery("#DivColFecha").hide();
            jQuery("#DivColHora").hide();
            jQuery('#DivContenidoExtrasRegalo').html(campos_servicio_html);
            jQuery('#DivTusDatosModificacionRegalo').show();
            try {
                carga_controles_fecha();
            } catch (error) {
                
            }
        }else{
            if(hay_extras == 0){
                jQuery('#DivTusDatosModificacionRegalo').hide();
                jQuery('#DivContenidoExtras').after(campos_servicio_html);
                try {
                    carga_controles_fecha();
                } catch (error) {
                    
                }
            }
        }

        if(hay_extras == 1){
            // Si no hay extras vamos directamene a añadir extras
            if (total_extras == 0){         
                // Seteamos la accion alta
                jQuery('input:radio[name="accion"]').filter('[value="add"]').attr('checked', true);
                accion = 'add';
                seleccion_operacion();
            }else{
                jQuery('#DivTipoEdicionExtras').show();
            }
        }else{
            // Debido a que Paypal tarda en dar la respuesta 
            // tenemos que obtener los extras sin el estado pagado
            if (data.forma_pago ==6 && total_extras == 0){               
                resultado_extras_compra_ok(localizador);
            }
        }
 
        },			
        beforeSend: function () {
            // jQuery(".loader").show();
        }
        });
    

}

function QuitarPreseleccionCombo(){
     
    jQuery('select[name^="campos_extra"]').each(function () {
        try {
            campo_id     = jQuery(this).attr("id");
            
            if(campo_id == 114 || campo_id == 115 || campo_id == 17){            
                nombre_campo = jQuery('#' + campo_id).attr("data-nombre-campo");
  
                jQuery('#' + campo_id).prepend(jQuery('<option>', { 
                    value    : "NoSelect",
                    text     : nombre_campo,
                    required : "required",
                    disabled : "disabled",         
                }));
                jQuery('#' + campo_id +' option[value=NoSelect]').attr('selected', 'selected');
                    
            }else if(campo_id == 113){
                try {
                    var $el = jQuery('#' + campo_id).find('option[value="España"]');
                    jQuery('#' + campo_id).find('option[value="España"]').remove();
                    jQuery('#' + campo_id).find('option:eq(0)').before($el);                      
                } catch (error) {
                    
                }
   
            }
 
        } catch (error) {
          
        }      
    });
}

function cargaExtrasServiciosComun(campos_extras,accion){
    var campos_extras_html ='';
    if(campos_extras.length == 0){
        jQuery('#DivTusExtras').hide();
    }else{
        jQuery('#DivTusExtras').show();
        campos_extras.map(extra => {

            if (accion =='add'){
                campos_extras_html += cargaExtraServiciosComun(extra);
            }else{       
                campos_extras_html += cargaExtraServiciosEliminarComun(extra);
            }    
           
        });
    }
    return campos_extras_html;
}

function cargaExtraServiciosComun(extra){


    var campos_extras_html = '';
    var contenido_pop_up   = '';
    var tipo               = extra.ExtrasServiciosTipos.tipo_clave;
    var agrupados_tarifa   = extra.ExtrasServiciosTipos.agrupados_tarifa;
    var precio_unico       = extra.ExtrasServiciosTipos.precio_unico;
    

    campos_extras_html += `
        <div class="bloque_extra">       
            <div class="detalle-extras">        
                <div class="imagen-extra-detalle">
                    <img src="/wp-content/plugins/visitas/img/extras/${extra.Extras.miniatura}" />
                </div> 
            </div>
            <h3 class="title-card-filtro">${extra.Extras.nombre}</h3>
            <div class="breve_descripcion">
                ${extra.Extras.descripcion_breve}  
            </div>
            <div class="content-card-filtro" id="DivTarifasCambioExtras">
        `;

    //Extras precios y unidades por tarifas 
    if (agrupados_tarifa == '1'){

        extra.info_tarifas.map( tarifa =>{     
            var plazas     = 0;  
            var precio_str = '';
            var precio_val = precio_unico == "0" ? tarifa.TarifasExtras.precio : extra.Extras.precio ;

            if ( precio_val =="0"){
                precio_str = extras['texto_extra_gratuito'];
            }else{
                precio_str =`${precio_val} €`;
            }
                                  
            campos_extras_html += `<div class="adultos" id="DivExtraLinea_${extra.Extras.id}_${tarifa.TarifasExtras.id}">
            <h4> ${tarifa.UsuariosGrupos.nombre} (${precio_str}) </h4> 
                <input type="text" 
                    max="${tarifa.LocalizadorTarifa.plazas_adulto}"
                    id="txtTarifa_${extra.Extras.id}_${tarifa.TarifasExtras.id}"
                    name="tarifas[]" 
                    placeholder="-" 
                    class="input-card usuarios_grupos form-control-tarifas" 
                    data-id="${tarifa.TarifasExtras.id}"
                    data-original="${plazas}"
                    value="${plazas}"  >
            </div>`;
  
        });
    
    }

    //Extra solo una unidad por visita. Precio fijo
    if (agrupados_tarifa == "0"){
        var plazas = 0;  
        if ( extra.Extras.precio =="0"){
            precio_str = extras['texto_extra_gratuito'];
        }else{
            precio_str =`${extra.Extras.precio} €`;
        }

        campos_extras_html += `<div class="adultos">
        <h4> ${extra.Extras.nombre} (${precio_str}) </h4> 
            <input type="text" 
                id="txtTarifa_${extra.Extras.id}_${extra.Extras.id}"
                name="tarifas[]" 
                placeholder="-" 
                class="input-card usuarios_grupos form-control-tarifas" 
                data-id="${extra.Extras.id}"
                data-original="${plazas}"
                value="${plazas}"  >
        </div>`;
    }
    campos_extras_html += '</div>';


    campos_extras_html += ` 
        <a class="boton_info" href="#DivExtraPopup${extra.Extras.id}">
            <div class="imagen-tooltip-detalle">             
                <button class="info_extra">+ info </button>
            </div> 
        </a>  
        `;

    campos_extras_html += '</div>';

    var texto_condiciones ='Condiciones';
    try {    
        texto_condiciones = extra.condiciones_extra_str ;
    } catch (error) {
        
    }

    //Movemos el contenido del popup al inicio de body para salvar el zindex global
    contenido_pop_up += `
        <div id="DivExtraPopup${extra.Extras.id}" class="overlay">
            <div class="popup">
            <a class="close" href="#">&times;</a>
            <br>
            <br>
                <img src="/wp-content/plugins/visitas/img/extras/${extra.Extras.miniatura}" />
                <h2 id="dialog_title" class="h2">${extra.Extras.nombre}</h2>
    
                <p id="dialog_description">
                    ${extra.Extras.descripcion}  
                </p>

                <p id="dialog_condiciones">
                    <span class="condiciones">${texto_condiciones}</span>
                    ${extra.Extras.condiciones_extra} 
                </p>
                <div class="flex flex-space-between">
                    <a  href="#">Cerrar información</a>    
                </div>
            </div>
        </div>
        `;
    jQuery('body').prepend(contenido_pop_up);         
   
    return campos_extras_html;
}
function cargaExtraServiciosEliminarComun(extra){


    var campos_extras_html = '';
    var contenido_pop_up   = '';
    var tipo               = extra.ExtrasServiciosTipos.tipo_clave;
    var agrupados_tarifa   = extra.ExtrasServiciosTipos.agrupados_tarifa;
    var precio_unico       = extra.ExtrasServiciosTipos.precio_unico;

    campos_extras_html += `
        <div class="bloque_extra">   
            <div class="detalle-extras">        
                <div class="imagen-extra-detalle">
                    <img src="/wp-content/plugins/visitas/img/extras/${extra.Extras.miniatura}" />
                </div>    
            </div>
            <h3 class="title-card-filtro">${extra.Extras.nombre}</h3>
            <div class="breve_descripcion">
                ${extra.Extras.descripcion_breve}  
            </div>
            <div class="content-card-filtro" id="DivTarifasCambioExtras">
        `;

    //Extras precios y unidades por tarifas 
    if (agrupados_tarifa == '1'){

        var localizador_extra_actual = '';
        extra.info_tarifas.map( tarifa =>{     
            var cabecera_pedido = '';
            if(tarifa.LocalizadorTarifa.plazas_adulto >0){
                var precio_str = '';
                var precio_val = ( precio_unico == "0" ) ? tarifa.TarifasExtras.precio : extra.Extras.precio ;
    
                if ( precio_val =="0"){
                    precio_str = extras['texto_extra_gratuito'];
                }else{
                    precio_str =`${precio_val} €`;
                }
                if (localizador_extra_actual != tarifa.LocalizadorTarifa.localizador_extra){           
                    cabecera_pedido = '';
                }else{
                    cabecera_pedido = '';
                }
                
                campos_extras_html += `<div class="adultos" id="DivtxtTarifa${tarifa.LocalizadorTarifa.id}">
                    ${cabecera_pedido}                
                <h4> ${tarifa.UsuariosGrupos.nombre}  (${precio_str}) </h4> 
                    <input type="text" 
                    max="${tarifa.LocalizadorTarifa.plazas_adulto}"
                    id="txtTarifa_${extra.Extras.id}_${tarifa.LocalizadorTarifa.id}"
                    name="tarifas[]" 
                    placeholder="-" 
                    class="input-card usuarios_grupos form-control-tarifas" 
                    data-id="${tarifa.LocalizadorTarifa.id}"
                    data-original="${tarifa.LocalizadorTarifa.plazas_adulto}"
                    value="${tarifa.LocalizadorTarifa.plazas_adulto}"  >
                    </div>`;

                localizador_extra_actual = tarifa.LocalizadorTarifa.localizador_extra;
            }
  
        });
    
    }

    //Extra solo una unidad por visita. Precio fijo
    if (agrupados_tarifa == '0'){
        if ( extra.Extras.precio =="0"){
            precio_str = extras['texto_extra_gratuito'];
        }else{
            precio_str =`${extra.Extras.precio} €`;
        }

        campos_extras_html += `<div class="adultos">
        <h4> ${extra.Extras.nombre} (${precio_str}) </h4> 
            <input type="text"               
                id="txtTarifa_${extra.Extras.id}_${extra.info_tarifas[0].LocalizadorTarifa.id}"
                name="tarifas[]" 
                placeholder="-" 
                class="input-card usuarios_grupos form-control-tarifas" 
                data-id="${extra.info_tarifas[0].LocalizadorTarifa.id}"
                data-original="1"
                value="${extra.info_tarifas[0].LocalizadorTarifa.plazas_adulto}"  >
        </div>`;
    }

    campos_extras_html += '</div>';
    campos_extras_html += ` 
    <a class="boton_info" href="#DivExtraPopup${extra.Extras.id}">
        <div class="imagen-tooltip-detalle"> 
            <button class="info_extra">+ info </button>
        </div> 
    </a>  
    `;

    campos_extras_html   += '</div>';
    var texto_condiciones ='Condiciones';
    try {    
        texto_condiciones = (extra.condiciones_extra_str ? undefined : extra.condiciones_extra_str );
    } catch (error) {
        
    }
        
    //Movemos el contenido del popup al inicio de body para salvar el zindex global
    contenido_pop_up += `
    <div id="DivExtraPopup${extra.Extras.id}" class="overlay">
        <div class="popup">
        <a class="close" href="#">&times;</a>
        <br>
        <br>
            <img src="/wp-content/plugins/visitas/img/extras/${extra.Extras.miniatura}" />
            <h2 id="dialog_title" class="h2">${extra.Extras.nombre}</h2>
  
            <p id="dialog_description">
                ${extra.Extras.descripcion}  
            </p>
            <p id="dialog_condiciones">
                <span class="condiciones">${texto_condiciones}</span>
                ${extra.Extras.condiciones_extra} 
            </p>
            <div class="flex flex-space-between">
                <a  href="#">Cerrar información</a>    
            </div>
        </div>
    </div>
    `;
    jQuery('body').prepend(contenido_pop_up);          
   
    return campos_extras_html;
}

function cargaExtrasCarritoComun(extras){
     								
    var extras_html = "";
    extras.map(extra => {
        extras_html += "<tr>";
        extras_html += "<td> <label>" + extra['nombre_tarifa'] + "</label></td>";
        extras_html += "<td><input type='text' class='num_usuarios' name='plazas_adulto' data-grupo='" + extra['id_grupo_usuario'] + "' value='" + extra['num_tarifa_carrito'] + "' readonly></td>";
        extras_html += "<td class='casi-last'>" + extra['precio'] + "</td>";
        extras_html += "<td class='delete-mejora'></td>";
        extras_html += "</tr>";
    });

    return extras_html;
}
function resultado_extras_eliminacion(localizador,agrupados){

    var url = ROOTGESTOR  + "ApiExtrasV2/get_localizador_extras_resumen";
    if(agrupados == 1){
        url = ROOTGESTOR  + "ApiExtrasV2/get_localizador_extras_resumen_padre";

        jQuery('#StrServicioConfirmar').html(info_data_servicio.servicio_nombre);
        jQuery('#StrFechaPlazas').html(info_data_servicio.fecha);
        jQuery('#StrHoraPlazas').html(info_data_servicio.hora);

        jQuery("#TrFormaPagoConfirmar").hide();
    }
  
    jQuery.ajax({
        type     : "POST",
        url      : url,  
        async    : false,   		
        data     : JSON.stringify({    
            localizador
        }),
        success: function (response) {
    
            var data = JSON.parse(response);
                              
            var tarifas_html = '';
        
            var total_plazas = 0;         
            data.extras_agrupados.map( tarifa =>{            
                total_plazas += parseInt(tarifa.num_tarifa_carrito);
                tarifas_html +=`
                    <tr>
                        <td>
                            <label>${tarifa.nombre_extra}</label>
                        </td>
                        <td>
                            <span class="num_usuarios">${tarifa.cantidad_extra}</span>
                        </td>
                        <td class="casi-last">${tarifa.total_str} </td>
                    </tr>`;

            });
            jQuery("#carritoConfirmar .totales").before(tarifas_html);
            jQuery('#TotalPrecioConfirmar').text(data.precio_extras_total_str); 
                  
 
        },			
        beforeSend: function () {
            // jQuery(".loader").show();
        }
        });
    

}
function resultado_extras_compra_ok(localizador){

    var url = ROOTGESTOR  + "ApiExtrasV2/get_localizador_extras_resumen";

  
    jQuery.ajax({
        type     : "POST",
        url      : url,  
        async    : false,   		
        data     : JSON.stringify({    
            localizador
        }),
        success: function (response) {
    
            var data = JSON.parse(response);
                              
            var tarifas_html = '';

            tarifas_html = `
                <tr style="height:30px">
                    <td>
                        &nbsp;
                    </td>
                    <td>
                        &nbsp;
                    </td>
                    <td>
                        &nbsp;
                    </td>
                </tr>
 
                <tr>
                    <th>
                        <h5> EXTRAS  </h5>
                    </th>
                    <th>
                        
                    </th>
                    <th>
                    
                    </th>
                </tr>`;

        
            var total_plazas = 0;         
            data.extras_agrupados.map( tarifa =>{            
                total_plazas += parseInt(tarifa.num_tarifa_carrito);
                tarifas_html +=`
                    <tr>
                        <td>
                            <label>${tarifa.nombre_extra}</label>
                        </td>
                        <td>
                            <span class="num_usuarios">${tarifa.cantidad_extra}</span>
                        </td>
                        <td class="casi-last">${tarifa.total_str} </td>
                    </tr>`;

            });
            jQuery("#carrito .totales").before(tarifas_html);
                        
 
        },			
        beforeSend: function () {
            // jQuery(".loader").show();
        }
        });
    

}

function creacion_touch_spin_extras(endpoint,localizador,plazas_adulto,campos_extras){
 
        // Recorremos todas las lineas de los extras
        // para crear los touchSpin
        campos_extras.forEach(extra_item => {
            if(extra_item.ExtrasServiciosTipos.agrupados_tarifa =='1'){
                extra_item.info_tarifas.forEach(extra => {    
                    creacion_touch_spin_extras_linea(extra_item,extra.TarifasExtras.id,endpoint,localizador,plazas_adulto,);
                });
            }
            if(extra_item.ExtrasServiciosTipos.agrupados_tarifa =='0'){
                creacion_touch_spin_extras_linea(extra_item,extra_item.Extras.id,endpoint,localizador,plazas_adulto,);
            }     
        
        });
        jQuery("#DivExtrasContenido").show();
   
}

function creacion_touch_spin_extras_linea(extra_item, id_tarifa , endpoint, localizador, plazas_adulto,){   
    var id_linea         = extra_item.Extras.id + "_" + id_tarifa;
    var cantidad_maxima  = 99;
    var cantidad_minima  = 0;                     
    var tipo             = extra_item.ExtrasServiciosTipos.tipo_clave;
    var agrupados_tarifa = extra_item.ExtrasServiciosTipos.agrupados_tarifa;
    var cantidad_maxima  = extra_item.ExtrasServiciosTipos.cantidad_maxima;
    
    if (agrupados_tarifa == '1' || cantidad_maxima == '0'){
        // La cantidad maxima es el total de unidades - los extras ya comprados 
        cantidad_maxima = parseInt(plazas_adulto) - parseInt(extra_item.total_extras);  
    }
      

    //Alta de touchspin
    jQuery("#txtTarifa_"+ id_linea).TouchSpin({
        buttonup_txt   : '<svg version="1.1" id="Alta_Capa_up_' + id_linea +'" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"><rect x="14.5" y="29.5" class="st0" width="31" height="1"/><rect x="29.5" y="14.5" class="st0" width="1" height="31"/> </svg>',
        buttondown_txt : '<svg version="1.1" id="Alta_Capa_down_' + id_linea +'" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"><rect x="14.5" y="29.5" class="st0" width="31" height="1"/></svg>',
        min            : cantidad_minima,
        max            : cantidad_maxima,
        mousewheel     : false,
    });

    //Reduccion de unidades
    jQuery("#txtTarifa_" + id_linea).on("touchspin.on.stopdownspin", function() {
        jQuery("#Alta_Capa_up_" + id_linea).parent().prop('disabled', false);                            
        jQuery("#Alta_Capa_up_" + id_linea).parent().attr('style', 'display:inline');
        if( jQuery("#txtTarifa_" + id_linea).val() == 0){
            jQuery("#Alta_Capa_down_" + id_linea).parent().attr('style', 'visibility:hidden'); 
        }

        //Comprobamos con la api si el extra tiene las unidades superadas
        if( agrupados_tarifa == '1'){

            var total_extra = 0;
            //Buscamos las otras lineas del extra para ocultarlas siempre que la cantidad sea 0
            campos_extras.forEach(extra_busqueda => {
                extra_busqueda.info_tarifas.forEach(extra_bus => {  

                    if( extra_bus.TarifasExtras.extra_id == extra_item.Extras.id){                                            
                        total_extra += parseInt(jQuery("#txtTarifa_" + extra_bus.TarifasExtras.extra_id + "_" + extra_bus.TarifasExtras.id).val());
                    }
                });
            });               

            //Comprobamos contra la API si es posible añadir más extras
            var res = chk_unidades_extra(endpoint,localizador,extra_item.Extras.id, total_extra);

            if (res.permitir_mas == 1){
                
                //Buscamos las otras lineas del extra para ocultarlas siempre que la cantidad sea 0
                campos_extras.forEach(extra_busqueda => {
                    extra_busqueda.info_tarifas.forEach(extra_bus => {  

                        if( extra_bus.TarifasExtras.extra_id == extra_item.Extras.id){
                            var id_linea_extra = extra_bus.TarifasExtras.extra_id +"_"+ extra_bus.TarifasExtras.id;
                            var cant_linea     = parseInt(jQuery("#txtTarifa_"+ id_linea_extra).val());
                           
                            if( extra_bus.TarifasExtras.id != id_tarifa){                                                                                      
                                jQuery("#Alta_Capa_up_" + id_linea_extra).parent().attr('style', 'display:inline');
                                jQuery("#Alta_Capa_up_" + id_linea_extra).parent().prop('disabled', false);

                                // TODO: Obtener el numero de extras disponibles
                                jQuery("#txtTarifa_" + id_linea_extra).trigger("touchspin.updatesettings", {
                                    max: cant_linea + res.unidades_disponibles
                                });                                           
                            }  

                        }
                    });
                });
            }
        }                   
    });

    // Aumento de unidades
    jQuery("#txtTarifa_" + id_linea).on("touchspin.on.stopupspin", function() {                        
        if(cantidad_maxima == jQuery("#txtTarifa_"+ id_linea).val()){                        
            jQuery("#Alta_Capa_up_" + id_linea ).parent().prop('disabled', true);
            jQuery("#Alta_Capa_up_" + id_linea ).parent().attr('style', 'visibility:hidden');
        }

        // Comprobamos con la api si el extra tiene las unidades superadas
        if( agrupados_tarifa == '1'){

            var total_extra = 0;
            // Obtenemos el total de unidades seleccionadas de ese extra                            
            campos_extras.forEach(extra_busqueda => {
                extra_busqueda.info_tarifas.forEach(extra_bus => {  
                    if( extra_bus.TarifasExtras.extra_id == extra_item.Extras.id){                                            
                        total_extra += parseInt(jQuery("#txtTarifa_" + extra_bus.TarifasExtras.extra_id + "_" + extra_bus.TarifasExtras.id).val());
                    }
                });
            });               

            var res = chk_unidades_extra(endpoint,localizador,extra_item.Extras.id, total_extra);

            if (res.permitir_mas == 0){
                jQuery("#Alta_Capa_up_" + id_linea ).parent().attr('style', 'visibility:hidden');
                jQuery("#Alta_Capa_up_" + id_linea ).parent().prop('disabled', true);

                // Buscamos las otras lineas del extra para ocultarlas siempre que la cantidad sea 0
                // Si no es 0 impedimos sumar mas unidades
                campos_extras.forEach(extra_busqueda => {
                    extra_busqueda.info_tarifas.forEach(extra_bus => {  

                        if( extra_bus.TarifasExtras.extra_id == extra_item.Extras.id){
                            var id_linea_extra =  extra_bus.TarifasExtras.extra_id +"_"+ extra_bus.TarifasExtras.id;
                            var cant_linea     = parseInt(jQuery("#txtTarifa_"+ id_linea_extra).val());

                            jQuery("#txtTarifa_" + id_linea_extra).trigger("touchspin.updatesettings", {
                                max: cant_linea
                            });

                            if( extra_bus.TarifasExtras.id != id_tarifa ){                                                    
                                jQuery("#Alta_Capa_up_" + id_linea_extra).parent().attr('style', 'visibility:hidden');
                                jQuery("#Alta_Capa_up_" + id_linea_extra).parent().prop('disabled', true);
                                
                            }                                              
                          
                        }
                    });
                });

            }else{
                var total_extra = 0;
                //Obtenemos el total de unidades seleccionadas de ese extra                            
                campos_extras.forEach(extra_busqueda => {
                    extra_busqueda.info_tarifas.forEach(extra_bus => {  

                        if( extra_bus.TarifasExtras.extra_id == extra_item.Extras.id){                                            
                            total_extra += parseInt(jQuery("#txtTarifa_"+ extra_bus.TarifasExtras.extra_id +"_"+ extra_bus.TarifasExtras.id).val());
                        }
                    });
                });               

                
                // Buscamos las otras lineas del extra para ocultarlas siempre que la cantidad sea 0
                // Si no es 0 impedimos sumar mas unidades
                campos_extras.forEach(extra_busqueda => {
                    extra_busqueda.info_tarifas.forEach(extra_bus => {  

                        if( extra_bus.TarifasExtras.extra_id == extra_item.Extras.id){
                            var id_linea_extra = extra_bus.TarifasExtras.extra_id + "_" + extra_bus.TarifasExtras.id;
                            var cant_linea     = parseInt(jQuery("#txtTarifa_" + id_linea_extra).val());
                   
                            if (parseInt(plazas_adulto) - parseInt(total_extra) > 0){
                                jQuery("#txtTarifa_" + id_linea_extra).trigger("touchspin.updatesettings", {
                                    max: (parseInt(plazas_adulto) - parseInt(total_extra) ) + cant_linea
                                });
                            }
                        }
                    });
                });                                    
            }
        }
        //Permitimos reducir unidades
        jQuery("#Alta_Capa_down_" + id_linea ).parent().attr('style', 'display:inline'); 
    });
    //Por defecto impedimos bajar unidades en la alta
    jQuery("#Alta_Capa_down_" + id_linea).parent().attr('style', 'visibility:hidden'); 
}
function chk_unidades_extra(endpoint,localizador, extra_id, cantidad){
    var data;    

    jQuery.ajax({
        type     : "POST",
        url      : ROOTGESTOR  + endpoint + "/chk_unidades_extra",  
        async    : false,   		
        data     : JSON.stringify({    
            localizador,
            extra_id,
            cantidad
        }),
        success: function (response) {
            data = JSON.parse(response); 
        
        },			
        beforeSend: function () {
            // jQuery(".loader").show();
        }
    });

    return data;    
}

function mostrar_detalle_extra( extra_id){
    const alertDialog = document.querySelector('#DivExtraTooltip' + extra_id);
    
    alertDialog.show();

}
const closeDialog = (e,extra_id) => {
    e.preventDefault();
    var dialog = document.querySelector('#DivExtraTooltip' + extra_id);
    dialog.close();
    dialog.removeEventListener("keydown", trapFocus);
};

function obtener_posibles_extras(localizador){

    var data_extras = [];
    jQuery.ajax({
        type     : "POST",
        url      : ROOTGESTOR  + "ApiExtrasV2/get_extras_adicionales_add",  
        async    : false,   		
        data     : JSON.stringify({    
            localizador,
            data_extras
        }),
        success: function (response) {
            var data = JSON.parse(response);

            data_extras = jQuery.makeArray(data['extras']);

        },			
        beforeSend: function () {
            // jQuery(".loader").show();
        }
    });

    return data_extras;    
}

function cargaCompraOKExtraServicios(extra){


    var campos_extras_html = '';
    var contenido_pop_up   = '';
    var tipo               = extra.ExtrasServiciosTipos.tipo_clave;
    var agrupados_tarifa   = extra.ExtrasServiciosTipos.agrupados_tarifa;
    var precio_unico       = extra.ExtrasServiciosTipos.precio_unico;
    

    campos_extras_html += `
    <div class="bloque_extra" id="DivDatosExtrasServicioMejora-extras">       
        <div class="detalle-extras">        
            <div class="imagen-extra-detalle">
                <img src="/wp-content/plugins/visitas/img/extras/${extra.Extras.miniatura}" />
            </div> 
        </div>
        <h3 class="title-card-filtro">${extra.Extras.nombre}</h3>
        <div class="breve_descripcion">
            ${extra.Extras.descripcion_breve}  
        </div>

    `;


    campos_extras_html += ` 
    <a class="boton_info" id="DivExtrasEnlace">
        <div class="imagen-tooltip-detalle" >             
            <button class="info_extra">+ info </button>
        </div> 
    </a>  
    `;

    campos_extras_html += '</div>';

    var texto_condiciones ='Condiciones';
    try {    
        texto_condiciones = extra.condiciones_extra_str ;
    } catch (error) {
        
    }    
   
    return campos_extras_html;
}

