var campos_extras        = [];
var carritoConfirmarHtml = '';
jQuery(function() {
  url_down = '../wp-content/plugins/visitas/img/down.svg';
  url_up   = '../wp-content/plugins/visitas/img/up.svg';
  if(LANG == 'en') {
      url_down = '../../wp-content/plugins/visitas/img/down.svg';
      url_up   = '../../wp-content/plugins/visitas/img/up.svg';
  }
  
  jQuery(".adultos input").TouchSpin({       
      buttondown_txt : '<img src="' + url_down + '">',
      buttonup_txt   : '<img src="' + url_up + '">'
  });


  /****************** PROCESO COMPRA *********************************/

  /*******************************************************************
   * Comprobación de datos del formulario de compra
   *******************************************************************/
  if (jQuery("#FormCompraEvento").length) {
    // Obtengo campos que son obligatorios
    var servicio_id = jQuery("#LocalizadorServicio").val();
    jQuery
      .ajax({
        type     : "POST",
        dataType : "json",
        url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/campos_obligatorios.php",
        data     : {
          servicio_id: servicio_id
        }
      })
      .done(function(data) {
        // Recorremos el array de campos extras
        for (i = 0; i < data.length; i++) {
          // Obtenemos los valores necesarios
          campo_id = data[i][0];
          es_array = data[i][1];
          // Si es array (como los inpus de cuenta corriente) hay que añadir el par de
          // corchetes. En cualquier caso seleccionamos el input con el nombre
          // indicado y le añadimos la regla de requerido
          input_name = "";
          if (es_array == 1) {
            input_name = "input[name='campos_extra[" + campo_id + "][]']";
          } else {
            input_name = "input[name='campos_extra[" + campo_id + "]']";
          }

          jQuery(input_name).rules("add", {
            required: true,
            messages: {
              required: "El campo es obligatorio"
            }
          });
        }
      });
    messages_es = {
      nombre                    : "El campo nombre es obligatorio.",
      apellidos                 : "El campo apellidos es obligatorio.",
      telefono                  : "El campo teléfono es obligatorio. Introdúzcalo en un formato válido. Ej. 941454050, 666555444",
      email                     : "El campo email es obligatorio. Introdúzcalo en un formato válido. Ej. ejemplo@pruebajig.es",
      dni                       : "El campo dni es obligatorio. Introdúzcalo en un formato válido. Ej. 16123456A",
      condiciones_compra        : "Por favor, acepte las condiciones de compra.",
      pago                      : "Por favor, seleccione un método de pago.",
      plazas_adulto             : "Por favor, seleccione número de plazas",
      tarifausuario             : "Seleccione tarifa",
      cantidad_maxima           : "Por favor, introduzca un valor mayor o igual a {0}.",
      'campos_extra_check[104]' : "Por favor, acepte las politicas de privacidad.",
    };
    messages_en = {
      nombre                    : "First name is required field.",
      apellidos                 : "Last name is required field.",
      telefono                  : "Telephone is required field. Type in a valid format. Ej. 941454050, 666555444",
      email                     : "Email is required field. Type in a valid format. Ej. ejemplo@pruebajig.es",
      dni                       : "DNI is required field. Type in a valid format. Ej. 16123456A",
      condiciones_compra        : "Please, accept purchase conditions.",
      pago                      : "Please, select a payment method.",
      plazas_adulto             : "Please, select number of vacancies",
      tarifausuario             : "Please, select a price",
      cantidad_maxima           : "Please enter a value greater than or equal to {0}.",
      'campos_extra_check[104]' : "Please, accept the privacy policies.",
    };
    messages = "";
    switch (lang_js) {
      case "es_ES":
        messages = messages_es;
        break;
      case "en_GB":
        messages = messages_en;
        break;
      default:
        messages = messages_en;
        break;
    }
    jQuery("#FormCompraEvento").validate({
      rules: {
        nombre: {
          required  : true,
          minlength : 2
        },
        apellidos: {
          required  : true,
          minlength : 2
        },
        telefono: {
          required  : true,
          minlength : 9,
          number    : true
        },
        email: {
          required  : true,
          minlength : 6,
          email     : true
        },
        dni: {
          required  : true,
          minlength : 9,
          maxlength : 9
        },
        condiciones_compra: {
          required: true
        },
        pago: {
          required: true
        },
        plazas_adulto: {
          min: 1
        },
        tarifausuario: {
          required  : true,
          minlength : 1
        },
        cantidad_maxima: {
           min: 1
        },
        'campos_extra_check[104]': {
          required: true
        },
      },
      messages: messages,
      // Algunos inputs se componen de varios campos. Estos hay que definirlos aqui ya que por defecto
      // el error se pondría en el primero de esos campos (apellido 1, primer grupo de dígitos de la cuenta
      // corriente...)
      errorPlacement: function(error, element) {
        if (element.attr("name") == "pago") {          
          jQuery( "#FormasPago" ).append(error);
        } else if (element.attr("name") == "condiciones_compra") {
          jQuery( "#FormasPago" ).append(error);
          error.insertAfter(".recibir_correo");
        } else {
          error.insertAfter(element);
        }
      },
      submitHandler: function(form) {
        // Compruebo plazas por si viene de la web
        var hora     = jQuery("#LocalizadorSalaHorario").val();
        var usuarios = jQuery("#LocalizadorUnidades").val();
        var servicio = jQuery("#LocalizadorServicio").val();
        var web      = 1;
        if (hora != 0 && hora != "") {
          jQuery
            .ajax({
              type     : "POST",
              url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/validar_plazas_proceso.php",
              dataType : "json",
              data     : {
                hora     : hora,
                usuarios : usuarios,
                servicio : servicio,
                web      : web,
               },
              cache: false
            })
            .done(function(json) {
              if (json == 0) {
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "";
                jQuery("#ValidarPlazas").html("Lo sentimos, no quedan plazas disponibles.");
              } else {
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "none";
                // Tarifa validada o no hace falta
                if (validada == true) {  
                  jQuery(form)[0].submit();  
                                     
                } else {
                  div               = document.getElementById("ValidarPlazas");
                  div.style.display = "";
                  jQuery("#ValidarPlazas").html("Por favor, introduzca su email y contraseña correctas o seleccione otra tarifa.");
                }
              }
            });
          return false;
        } else {
          // Tarifa validada o no hace falta
          if (validada == true) {            
            validations.localizadorValidation(jQuery(form), true);
          } else {
            div               = document.getElementById("ValidarPlazas");
            div.style.display = "";
            jQuery("#ValidarPlazas").html("Por favor, introduzca su email y contraseña válidos o seleccione otra tarifa.");
          }
        }
      }
    });
  }

  /************************PROCESO DE RESERVA ****************************/
  // Compruebo que no han pasado más de 10 minutos desde que ha realizado la
  // reserva hasta que confirma (en cuyo caso el cron la elimina). Le muestro aviso
  var FormReserva = jQuery("#ConfirmarReserva"),
    ReservaAction = FormReserva.attr("action");
  FormReserva.removeAttr("action");
  jQuery("#ValidarTiempoReserva").click(function() {
    // Localizador
    var localizador = jQuery("#Localizador").val();
    // Horario
    var hora = jQuery("#Hora").val();
    // Comprobar tiempo que lleva haciendo la reserva
    jQuery
      .ajax({
        type     : "POST",
        url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/tiempo_reserva.php",
        dataType : "json",
        data     : {
          localizador : localizador,
          hora        : hora
        },
        cache    : false
      })
      .done(function(json) {
          FormReserva.attr("action", ReservaAction);
          FormReserva.submit();
      });
    return false;
  });

});


function carga_compra_evento(paso_compra){

  jQuery('#DivSteps').html(`<div></div> <div class="color-step"></div>`);

  let extras                   = [];
  let campos_extra             = [];
  let recibir_correo           = 0;
  let descuenta_plazas_primero = 1;

  try {
    var sala_horario_id = jQuery('#sala_horario_id').val();
    var servicio_mesa_id = jQuery('#servicio_mesa_id').val();
    var actividad       = jQuery('#actividad').val();
    var servicio        = jQuery('#servicio').val();
    var instalacion     = jQuery('#instalacion').val();
    var web             = jQuery('#web').val();
    var tarifas         = jQuery('#tarifas').val();
    var plazas          = jQuery('#plazas').val();
    var idioma          = jQuery('#idioma').val();
    var ip              = jQuery('#ip').val();
    var idioma_nav      = jQuery('#idioma_nav').val(); 	
    var forma_pago      = jQuery('#forma_pago').val();	
    var nombre      	  = jQuery('#nombre').val();	
    var email      		  = jQuery('#email').val();	
    var telefono        = jQuery('#telefono').val();	
    var apellidos       = jQuery('#apellidos').val();	
    descuenta_plazas_primero = jQuery('#descuenta_plazas_primero').val();	
    
  } catch (error) {
    
  }
  var texto_comprar ='Confirmar';

  try {
    texto_comprar =comprar['confirmar'];
  } catch (error) {
    
  }

  try {
    var arrayTarifas = tarifas.split(":");
    var tarifas      = [];
    var lista        = [];

    arrayTarifas.forEach((tarifa) =>{
      var dataTarifa = tarifa.split(",");
      if (dataTarifa[2].trim() > 0){
        tarifas.push(dataTarifa[0].trim());
        lista.push(dataTarifa[2].trim());
      }
    });
 
  } catch (error) {
    
  }

  try {
    jQuery('input[name^="campos_extra"]').each(function() {   	
   
      try {
        valor = jQuery(this).val();
      } catch (error) {
        
      }

      campos_extra.push({
        "id"    : jQuery(this).attr('data-id'),
        "valor" : valor
      });
    });
    

  } catch (error) {
    console.log({error});
  }
  try {
    
    //Extras
    jQuery('input[name^="extra"]').each(function() {   	
     valor = 0;
     try {
       valor = jQuery(this).val();
     } catch (error) {
       
     }
     if(jQuery(this).attr('data-id')){
        extras.push({
          "propiedad" : jQuery(this).attr('data-propiedad') ,
          "id"        : jQuery(this).attr('data-id') ,
          "valor"     : valor
        });
     }
   });
  } catch (error) {
    
  }

  var data_continuar_compra = {					    
    actividad,
    apellidos,
    campos_extra,
    descuenta_plazas_primero,
    email,
    extra 	 	       : extras,
    forma_pago,
    idioma,
    idioma_navegador : idioma_nav,
    instalacion,
    ip,
    lista            : lista.toString(),
    nombre,
    plazas,
    recibir_correo,
    evento			     : 1 ,		 
    sala_horario_id,
    servicio_mesa_id,
    servicio,
    tarifas          : tarifas.toString(),
    telefono,
    texto_comprar,
    web          
};


  jQuery.ajax({
    type     : "POST",
    url      : ROOTGESTOR  + "ApiCompraV2/comprar_confirmar",     		
    data     : JSON.stringify(data_continuar_compra),
    success: function (response) {
      let data        = JSON.parse(response);
      let localizador = data.localizador;
      let extras      = [];
      jQuery('#localizador').val(localizador);
      jQuery('#TxtPagoIntalacionLocalizador').val(data['localizador']);

      var tarifas_resp = data['tarifas'];										
      var tarifas_html = "";
      tarifas_resp.map(tarifa => {
        tarifas_html += "<tr>";
        tarifas_html += "<td> <label>" + tarifa['nombre_tarifa'] + "</label></td>";
        tarifas_html += "<td><input type='text' class='num_usuarios' name='plazas_adulto' data-grupo='" + tarifa['id_grupo_usuario'] + "' value='" + tarifa['num_tarifa_carrito'] + "' readonly></td>";
        tarifas_html += "<td class='casi-last'>" + tarifa['precio'] + "</td>";
        tarifas_html += "<td class='delete-mejora'></td>";
        tarifas_html += "</tr>";
      });

      jQuery("#carrito .totales").before(tarifas_html);
      jQuery("#carritoConfirmar .totales").before(tarifas_html);
      carritoConfirmarHtml = jQuery("#carritoConfirmar").html();
     
      jQuery('#LblCarritoConfirmarFormaPago').html(data['info_forma_pago']['pago']);	

      jQuery('#fecha_visita').html(data['fecha']);
      jQuery('#fecha_hora').html(data['hora_inicio']);

      jQuery('#SpnTituloServicio').html(`${data['servicio_nombre']} - ${data['instalacion_nombre']} `);
      jQuery('#StrNombreInstalacion').html(data['instalacion_nombre'] );
      jQuery('#StrNombreServicio').html(data['servicio_nombre'] );
      jQuery('#StrIdiomaServicio').html(data.idioma_info.Idioma.idioma );
      jQuery('#StrFecha').html(data['fecha'] );
      jQuery('#StrHora').html(data['hora_inicio'] );

      
      jQuery('#LblNombre').html(nombre);
      jQuery('#LblApellidos').html(apellidos);
      jQuery('#LblTelefono').html(telefono);
      jQuery('#LblEmail').html(email);
      try {
        jQuery('#id_pedido').val(data.info_pago.numero_operacion);
      } catch (error) {
        
      }

      jQuery('#TotalPrecio').text(data['precio_total_str']);
      jQuery('#TotalPrecioConfirmar').text(data['precio_total_str']);

      try {
        data.extras_agrupados.forEach( (extra_item) => {
    
          jQuery('#trTotalCarritoConfirmar').before(`<tr id="TrCarritoConfirmarExtra" class="extra-mejora-tabla">
            <td>${extra_item.nombre_extra}</td>
            <td><input type="text" value="${extra_item.cantidad_extra}" readonly></td>
            <td class="casi-last">${parseFloat(extra_item.total).toFixed(2)} €</td>
            </tr>`);
        });
  
      } catch (error) {
        
      }

      contenidoExtras ='';
      data.info_campos_extras.forEach(campos => {
        if(campos.LocalizadorCampo.value !=''){
          contenidoExtras += `
          <div class="datos-visitas" data-extras="DivPersonalExtra${campos.Campo.id}">
            <p>${campos.Campo.nombre}</p>
            <p><strong> ${campos.LocalizadorCampo.value}</strong></p>
          </div>					
          `;
        }
      });
      
      jQuery('#DivContenedorCamposExtras').after(contenidoExtras);
      jQuery('#DivCondiciones').html(data.condiciones_servicio);
      
      if (data.hay_cupon == 0){					
        jQuery('#cupones').hide();
        jQuery('#paso_3_all_confirmar .datos-reserva').attr('style', 'width: 100% !important');
      }else{
        jQuery('#cupones').show();
        jQuery('#cupones').attr('style', 'visibility: visible !important');
        jQuery('#cupon').attr('placeholder',cupones_textos["texto_3"]);
        jQuery('#validar_cupon').val(cupones_textos["texto_5"]);
      }
      
      if((forma_pago == 2 || forma_pago == 104 || forma_pago == 38 || forma_pago == 40 || forma_pago == 41) && data.validaciones_compra){										
        sesion_pago_api(data.info_pago);				

        jQuery('#DivPagoRedsys').html(data.info_pago.boton);
        jQuery('#DivPagoPaypal').html('');
        jQuery('#DivPagoInstalacion').html('');
        
        EstablecerValidaciones();
      }
      
      if(forma_pago == 6 || forma_pago == 37 && data.validaciones_compra){
        sesion_pago_api(data.info_pago);				
        jQuery('#DivPagoPaypal').html(data.info_pago.boton);
        jQuery('#DivPagoRedsys').html('');
        jQuery('#DivPagoInstalacion').html('');
        jQuery('#Redsys').hide();

        EstablecerValidaciones();
      }

      jQuery('#tiempo_pago').val(data.tiempo_pago); 
      
      if (data.info_forma_pago.pago_lugar == '1'){
        jQuery('#modulo_reservas').show();
        jQuery('#DivPago').hide();
        jQuery('#DivPagoInstalacion').show();
      }else{
        jQuery('#DivPago').show();
        jQuery('#DivPagoInstalacion').html('');
        jQuery('#DivPagoInstalacion').hide();
      }    

      if(data.prepago == 0){
        jQuery("#DivAvisoPrepago").hide();
      }

      try {
        if (data.extras_servicio.length > 0){
          jQuery('#paso_3_all').hide();

          campos_extras = jQuery.makeArray(data['extras_servicio']);	
          if(campos_extras.length == 0 ){
            jQuery("#hay_extras").val(0);
          }else{
            var condiciones_extra = 'Condiciones de los extras';
            try {
              condiciones_extra = data['condiciones_extra'];
            } catch (error) {
              
            }
            jQuery("#hay_extras").val(1);
        
            const plazas_acumulados = data.tarifas.reduce(
            (accumulator, currentValue) => accumulator + parseInt(currentValue.num_tarifa_carrito),
              0,
            );

            campos_extras.forEach(item => {
              item['condiciones_extra_str'] = condiciones_extra;
            });
                        
            cargarExtrasAdicionalesAdd(data['localizador'],plazas_acumulados,campos_extras);
          }

          jQuery('#paso_extras_compra').show();
          jQuery('#DivAltaEliminarExtras').show();

        }else{
          jQuery('#paso_3_all').show();
          jQuery('#paso_extras_compra').hide();
          jQuery('#DivAltaEliminarExtras').hide();
        }
      } catch (ex) {
        
      }

    },			
    beforeSend: function () {
        // jQuery(".loader").show();
    }
    });


}

function cargar_compra_prepago(paso_compra){

  let extras                   = [];
  let campos_extra             = [];
  let recibir_correo           = 0;
  let descuenta_plazas_primero = 0;

  try {
    var sala_horario_id = jQuery('#sala_horario_id').val();
    var actividad       = jQuery('#actividad').val();
    var servicio        = jQuery('#servicio').val();
    var instalacion     = jQuery('#instalacion').val();
    var web             = jQuery('#web').val();
    var tarifas         = jQuery('#tarifas').val();
    var lista           = jQuery('#lista').val();
    var plazas          = jQuery('#plazas').val();
    var idioma          = jQuery('#idioma').val();
    var ip              = jQuery('#ip').val();
    var idioma_nav      = jQuery('#idioma_nav').val(); 	
    var forma_pago      = jQuery('#forma_pago').val();	
    var nombre      	  = jQuery('#nombre').val();	
    var email      		  = jQuery('#email').val();	
    var telefono        = jQuery('#telefono').val();	
    var apellidos       = jQuery('#apellidos').val();	
    var localizador     = jQuery('#localizador').val();	


    
  } catch (error) {
    
  }
  var texto_comprar ='Pagar';

  try {
    texto_comprar =comprar['prepago'];
  } catch (error) {
    
  }

  try {
    jQuery('input[name^="campos_extra"]').each(function() {   	
   
      try {
        valor = jQuery(this).val();
      } catch (error) {
        
      }

      campos_extra.push({
        "id"    : jQuery(this).attr('data-id'),
        "valor" : valor
      });
    });
    

  } catch (error) {
    console.log({error});
  }

  jQuery.ajax({
    type     : "POST",
    url      : ROOTGESTOR  + "ApiCompraV2/prepago",     		
    data     : JSON.stringify({    
      localizador      : localizador,
      sala_horario_id  : sala_horario_id,
      actividad        : actividad,
      servicio         : servicio,
      instalacion      : instalacion,
      web              : web,	  
      tarifas          : tarifas,
      plazas           : plazas,
      lista            : lista,
      idioma           : idioma,
      ip               : ip,
      idioma_navegador : idioma_nav,
      descuenta_plazas_primero,
      forma_pago,
      texto_comprar
    }),
    success: function (response) {
      let data        = JSON.parse(response);
      let localizador = data.localizador;
      let extras      = [];
      jQuery('#localizador').val(localizador);

      // Extras
      jQuery('input[name^="extra"]').each(function() {   	
        valor = 0;
        try {
          valor = jQuery(this).val();
        } catch (error) {
          
        }
        if(jQuery(this).attr('data-id')){
          extras.push({
            "propiedad" : jQuery(this).attr('data-propiedad') ,
            "id"        : jQuery(this).attr('data-id') ,
            "valor"     : valor
          });
        }
      });

      try {       
        jQuery('#id_pedido').val(data.info_pago.numero_operacion);     
      } catch (error) {
   
      }

      var tarifas_resp = data['tarifas'];										
      var tarifas_html = "";
      tarifas_resp.map(tarifa => {
        tarifas_html += "<tr>";
        tarifas_html += "<td> <label>" + tarifa['nombre_tarifa'] + "</label></td>";
        tarifas_html += "<td><input type='text' class='num_usuarios' name='plazas_adulto' data-grupo='" + tarifa['id_grupo_usuario'] + "' value='" + tarifa['num_tarifa_carrito'] + "' readonly></td>";
        tarifas_html += "<td class='casi-last'>" + tarifa['precio'] + "</td>";
        tarifas_html += "<td class='delete-mejora'></td>";
        tarifas_html += "</tr>";
      });

      jQuery("#carrito .totales").before(tarifas_html);
      jQuery("#carritoConfirmar .totales").before(tarifas_html);
      carritoConfirmarHtml = jQuery("#carritoConfirmar").html();
        
      jQuery('#fecha_visita').html(data['fecha']);
      jQuery('#fecha_hora').html(data['hora_inicio']);

      jQuery('#SpnTituloServicio').html(`${data['servicio_nombre']} - ${data['instalacion_nombre']} `);
      jQuery('#StrNombreInstalacion').html(data['instalacion_nombre'] );
      jQuery('#StrNombreServicio').html(data['servicio_nombre'] );
      jQuery('#StrIdiomaServicio').html(data.idioma_info.Idioma.idioma );
      jQuery('#StrFecha').html(data['fecha'] );
      jQuery('#StrHora').html(data['hora_inicio'] );

      jQuery('#LblCarritoConfirmarFormaPago').html(data['info_forma_pago']['pago']);	
      jQuery('#LblNombre').html(nombre);
      jQuery('#LblApellidos').html(apellidos);
      jQuery('#LblTelefono').html(telefono);
      jQuery('#LblEmail').html(email);
      jQuery('#TotalPrecio').text(data['precio_total_str']);
      jQuery('#TotalPrecioConfirmar').text(data['precio_total_str']);

      try {
        data.extras_agrupados.forEach( (extra_item) => {
          
          jQuery('#trTotalCarritoConfirmar').before(`<tr id="TrCarritoConfirmarExtra" class="extra-mejora-tabla">
            <td>${extra_item.nombre_extra}</td>
            <td><input type="text" value="${extra_item.cantidad_extra}" readonly></td>
            <td class="casi-last">${parseFloat(extra_item.total).toFixed(2)} €</td>
            </tr>`);
        });
  
      } catch (error) {
        
      }


      contenidoExtras ='';
      data.info_campos_extras.forEach(campos => {
        if(campos.LocalizadorCampo.value != ''){
          contenidoExtras += `
          <div class="datos-visitas ${ (campos.Campo.type =='textarea') ? 'textarea-full' : '' } ">
            <p>${campos.Campo.nombre}</p>
            <p><strong id="LblTelefono">${campos.LocalizadorCampo.value}</strong></p>       
          </div>
          `;
        }
      });
      
      jQuery('#DivContenedorCamposExtras').after(contenidoExtras);
      jQuery('#DivCondiciones').html(data.condiciones_servicio);
      
      if (data.hay_cupon == 0){					
        jQuery('#cupones').hide();
        jQuery('#paso_3_all_confirmar .datos-reserva').attr('style', 'width: 100% !important');
      }else{
        jQuery('#cupones').show();
        jQuery('#cupones').attr('style', 'visibility: visible !important');
        jQuery('#cupon').attr('placeholder',cupones_textos["texto_3"]);
        jQuery('#validar_cupon').val(cupones_textos["texto_5"]);
      }
      
      if(forma_pago == 38){										
        sesion_pago_api(data.info_pago);				
        jQuery('#DivPagoRedsys').html(data.info_pago.boton);
        jQuery('#DivPagoPaypal').html('');
        jQuery('#DivPagoInstalacion').html('');
        
        EstablecerValidaciones();
      }
      
      if(forma_pago == 37 ){
        sesion_pago_api(data.info_pago);				
        jQuery('#DivPagoPaypal').html(data.info_pago.boton);
        jQuery('#DivPagoRedsys').html('');
        jQuery('#DivPagoInstalacion').html('');
        jQuery('#Redsys').hide();

        EstablecerValidaciones();
      }

      jQuery('#tiempo_pago').val(data.tiempo_pago); 
      jQuery("#DivAvisoPrepago").hide();
      
      try {
        if (data.extras_servicio.length > 0){
          jQuery('#paso_3_all').show();
          jQuery('#paso_extras_compra').hide();
          jQuery('#DivAltaEliminarExtras').hide();
        }else{
          jQuery('#paso_3_all').show();
          jQuery('#paso_extras_compra').hide();
          jQuery('#DivAltaEliminarExtras').hide();
        }
      } catch (ex) {
        
      }

    },			
    beforeSend: function () {
        // jQuery(".loader").show();
    }
    });

}

function sesion_pago_api(info_pago){
  jQuery.ajax({
      type  : 'POST',
      url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/sesion_pago_api.php',
      async : false,
      data  : {
          "numero_operacion" : info_pago.numero_operacion
      },
      success: function(response) {
          respuesta = jQuery.parseJSON(response);
      }
  });
}

function cargarExtrasAdicionalesAdd(localizador,plazas_adulto, campos_extras){

  var campos_extras_html = "";
	
	campos_extras_html = cargaExtrasServiciosComun(campos_extras,'add');
					
	jQuery("#DivExtrasContenido").html(campos_extras_html);	

	creacion_touch_spin_extras('ApiCompraV2',localizador,plazas_adulto,campos_extras);

	cantidad = campos_extras.length;

}

function confirmar_extras_siguiente(){
   
  var data_extras             = [];
  var texto_comprar           = 'Confirmar';
  var localizador             = jQuery('#localizador').val();
  var bloqueo_unidades_minima = 0;
  var err_texto_unidad_minima = '';
  try {
    texto_comprar =comprar['confirmar'];
  } catch (error) {
    
  }

  campos_extras.forEach(extra => {
   	var total_extra = 0;
    if (extra.ExtrasServiciosTipos.agrupados_tarifa =='1'){
      extra.info_tarifas.forEach(tarifa => { 
        cantidad =  jQuery("#txtTarifa_" + extra.Extras.id + "_" + tarifa.TarifasExtras.id).val(); 
        if(typeof cantidad !== "undefined"){     
          total_extra +=  parseInt(cantidad); 
          data_extras.push({
            "extra_id"  : extra.Extras.id,
            "tarifa_id" : tarifa.TarifasExtras.id,
            "cantidad"  : cantidad,
          });
        }
      });
    }
    if (extra.ExtrasServiciosTipos.agrupados_tarifa =='0'){
      cantidad =  jQuery("#txtTarifa_" + extra.Extras.id + "_" + extra.Extras.id ).val(); 
      if(typeof cantidad !== "undefined"){   
        total_extra +=  parseInt(cantidad); 
        data_extras.push({
          "extra_id"  : extra.Extras.id,
          "tarifa_id" : extra.Extras.id,
          "cantidad"  : cantidad,
        });	
      }		
    }
   
    if(parseInt(total_extra) > 0 && parseInt(total_extra) < parseInt(extra.ExtrasServiciosTipos.cantidad_minima)){
      bloqueo_unidades_minima = 1;                      
      err_texto_unidad_minima = 'La cantidad mínima del extra ' + extra.Extras.nombre + ' es ' + extra.ExtrasServiciosTipos.cantidad_minima ;                               
    }
  });
  if(bloqueo_unidades_minima == 1){
    var errormsn = err_texto_unidad_minima;	 
    
    jQuery("#ValidarModificar").html('<label class="error"> ' + errormsn + ' </label>');
    jQuery('#ValidarModificar').fadeIn( "slow" );	

    return 0;
  }else{
    jQuery("#ValidarModificar").html('');
  }


  jQuery.ajax({
    type     : "POST",
    url      : ROOTGESTOR  + "ApiCompraV2/comprar_confirmar_paso_extras",     		
    data     : JSON.stringify({    
      texto_comprar,     
      localizador,
      data_extras
    }),
    success: function (response) {
        
        var data = JSON.parse(response);

        var mensaje_loc_pasarela ='Localizador en estado pasarela';
        try {
          if(validar_compra["localizador_en_pasarela"] !== undefined){
            mensaje_loc_pasarela = validar_compra["localizador_en_pasarela"];
          }
        } catch (error) {
        
        }
        try {
          jQuery('#id_pedido').val(data.info_pago.numero_operacion);   
        } catch (error) {         
          jQuery("#ValidarModificar").html('<label class="error"> ' + mensaje_loc_pasarela +' </label>');
          jQuery('#ValidarModificar').fadeIn( "slow" );	
      
          return 0;
        }

        jQuery('#paso_3_all').show(); 
        jQuery('#paso_extras_compra').hide();
        jQuery('#BtnExtrasPasoAtrasEvento').show();
        jQuery('#BtnVolverEvento').hide();
            
        var tarifas_html = '';
        var forma_pago   = data.info_forma_pago.id; 
       
        try {
					jQuery("#carritoConfirmar").html(carritoConfirmarHtml);					
				} catch (error) {
					
				}
        
        try {
          if (data.extras_servicio_alta.length > 0 ){
            jQuery('#DivCondicionesExtras').html(data.condiciones_extra);
            jQuery('#DivBloqueCondicionesExtras').show();

            tarifas_html = `
            <tr style="height:30px">
              <td>
                &nbsp;
              </td>
              <td>
                &nbsp;
              </td>
              <td>
                &nbsp;
              </td>
            </tr>

            <tr>
              <th>
                <h5> EXTRAS  </h5>
              </th>
              <th>
                
              </th>
              <th>
              
              </th>
            </tr>`;
          }else{					
            jQuery('#DivBloqueCondicionesExtras').hide();
          }
        } catch (error) {
          
        }

        data.extras_servicio_alta.map( tarifa =>{           
          tarifas_html +=`
            <tr>
              <td>
                <label>${tarifa.nombre_extra}</label>
              </td>
              <td>
                <span class="num_usuarios">${tarifa.cantidad_extra}</span>
              </td>
              <td class="casi-last">${tarifa.total_str} </td>
            </tr>`;

        });
        jQuery("#carritoConfirmar .totales").before(tarifas_html);

        jQuery('#TotalPrecio').text(data['precio_total_str']);
        jQuery('#TotalPrecioConfirmar').text(data['precio_total_str']);

        if((forma_pago == 2 || forma_pago == 104 || forma_pago == 38)){			
						
          sesion_pago_api(data.info_pago);				
          jQuery('#DivPagoRedsys').html(data.info_pago.boton);
          jQuery('#DivPagoPaypal').html('');
          DivPagoInstalacionHtml = jQuery('#DivPagoInstalacion').html();
          jQuery('#DivPagoInstalacion').html('');
          
          EstablecerValidaciones();
        }
        
        if(forma_pago == 6 || forma_pago == 37){
          sesion_pago_api(data.info_pago);				
          jQuery('#DivPagoPaypal').html(data.info_pago.boton);
          jQuery('#DivPagoRedsys').html('');
          DivPagoInstalacionHtml = jQuery('#DivPagoInstalacion').html();
          jQuery('#DivPagoInstalacion').html('');
          jQuery('#Redsys').hide();

          EstablecerValidaciones();
        }

        if (data.info_forma_pago.pago_lugar == 1){
          jQuery('#modulo_reservas').show();
          jQuery('#DivPago').hide();
          if(DivPagoInstalacionHtml !=''){
            jQuery('#DivPagoInstalacion').html(DivPagoInstalacionHtml);
          }
          jQuery('#DivPagoInstalacion').show(); 
        }else{
          jQuery('#DivPago').show();
          jQuery('#DivPagoInstalacion').html('');
          jQuery('#DivPagoInstalacion').hide(); 
        }

        jQuery('#tiempo_pago').val(data.tiempo_pago); 
        
        if(data.prepago == 0){
          jQuery("#DivAvisoPrepago").hide();
        }		
    },			
    beforeSend: function () {
        // jQuery(".loader").show();
    }
    });

}

function atras_paso_extras_evento(){
  jQuery('#paso_3_all').hide(); 
  jQuery('#paso_extras_compra').show();
  jQuery('#BtnExtrasPasoAtrasEvento').hide();
  jQuery('#BtnVolverEvento').show();

  window.scrollTo(0,0);
}

var validada = true;