jQuery(function () {
	
	jQuery("#Horas").change(function () {
		comprobar_submit();

		var sala_horario_id = jQuery(this).val();

		jQuery("#hora_imprimir").val(sala_horario_id);
		jQuery("#fecha_imprimir").val(sala_horario_id);
	});

	jQuery("#condiciones_compra").click(function () {
		comprobar_submit();
	});

	jQuery("#BtnCheckHorarioSel").click(function () {
		var fecha = jQuery("#fechaSeleccionada").val();
		var fechaId  = jQuery("#salaHorarioSeleccionada").val();


		if (fechaId != 0) {
			var hora = jQuery("#horaSeleccionada").val();

			jQuery("#DivSiguientePaso01").show();
			jQuery("#DivSiguientePaso02").show();
			jQuery("#DivSiguientePaso03").show();

			jQuery("#DivSiguientePaso00").hide();

			jQuery("#LblFecha").html(fecha);
			jQuery("#LblHora").html(hora);
			jQuery("#LblFechaResultado").html(fecha);
			jQuery("#LblHoraResultado").html(hora);

			jQuery("#ValidarRegalo").html("");
			jQuery("#ValidarCambioReserva").prop("disabled", false);

			jQuery(".card-visita.steps").html('<div></div> <div class="color-step"></div>');

			window.scrollTo(0, 0);
		} else {
			jQuery("#DivSiguientePaso01").hide();
			jQuery("#DivSiguientePaso02").hide();
			jQuery("#DivSiguientePaso03").hide();

			jQuery("#DivSiguientePaso00").show();

			// alert('Selecciona un horario/fecha');

			if (fecha == "") {
				jQuery("#MensajeErrorSeleccionarHorario").html('<label class="error">' + regalos_textos["texto_3"] + "</label>");
			} else {
				jQuery("#MensajeErrorSeleccionarHorario").html('<label class="error">' + regalos_textos["texto_4"] + "</label>");
			}

			jQuery("#MensajeErrorSeleccionarHorario").fadeIn("slow");
		}
	});

	function comprobar_submit() {
		
	}

	/************************** PROCESO MODIFICACIÓN ************************/
	// Valido si hay plazas en el horario seleccionado en el momento de hacer
	// la reserva, por si en ese momento
	// otra persona le ha dado antes y ha quitado plazas que quedaban
	var FormCambioReserva = jQuery("#CambioReserva"),
		CambioReservaAction = FormCambioReserva.attr("action");
	FormCambioReserva.removeAttr("action");
	jQuery("#ValidarCambioReserva").click(function (e) {
		e.preventDefault();
		
		var fecha      = jQuery("#fechaSeleccionada").val();
		var hora       = jQuery("#horaSeleccionada").val();
		var fecha_hora = fecha + " - " + hora;
		
		jQuery("#fecha_escogida").text(fecha_hora);
		
		var localizador      = jQuery("#Localizador").val();
		var pago_instalacion = jQuery("#pago_instalacion").val();
		var fechaId          = jQuery("#salaHorarioSeleccionada").val();
		var plazas           = jQuery("#plazas").val();
		var newsletter       = jQuery("#newsletter").prop("ckecked");
		var campos           = [];
		var valido           = true;
		
		
		jQuery("#ValidarRegalo").html("");
		jQuery(".campo_extra").each(function (index) {
			campos[jQuery(this).attr("id")] = jQuery(this).val();
			try {			
				if (jQuery(this).attr("data-obligatorio").includes("*")) {
					if (jQuery(this).val() == "") {
						var contenido = jQuery("#ValidarPlazas").html();
						contenido     = "Revise los campos obligatorios.  ";
						jQuery("#ValidarRegalo").html('<label class="error">' + contenido + "</label>");
						valido = false;
					}
				}
				
			} catch (error) {
				
			}
		});		
		
		if (fechaId == 0) {
			jQuery("#ValidarRegalo").html(regalos_textos["texto_0"]);
			valido = false;
		}

		if (jQuery("#condiciones_compra").prop("checked") == false) {
			jQuery("#ValidarRegalo").html('<label class="error">' + regalos_textos["texto_1"] + "</label>");
			valido = false;
		}
				
		if (!valido) {
			jQuery("#ValidarRegalo").fadeIn("slow");
		}	

		if (valido) {
			jQuery("#ValidarRegalo").html("");
			jQuery(".loader").show();
			jQuery
				.ajax({
					type     : "POST",
					url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/modificar_regalo.php",
					dataType : "json",
					data     : {
						localizador      : localizador,
						fechaId          : fechaId,
						plazas           : plazas,
						pago_instalacion : pago_instalacion,
						newsletter       : newsletter,
						"campos[]"       : campos,
					},
					cache   : false,
					async   : true,
				})
				.done(function (json) {
					jQuery(".loader").hide();
					// No ha pasado la validación
					if (json == 0) {
						div               = document.getElementById("ValidarPlazas");
						div.style.display = "";
						jQuery("#ValidarPlazas").html(modificar["disminuir"]);
					} else if (json == 2) {
						jQuery("#ValidarRegalo").html('<label class="error">' + regalos_textos["texto_2"] + "</label>");
						jQuery("#ValidarRegalo").fadeIn("slow");
					} else {
						if (!jQuery(".radio_modificar:checked").length) {
							jQuery("#ValidarPlazas").html(modificar["elegir"]);
						} else {
							jQuery(".card-visita.steps").css("display", "none");
							jQuery("#anular-reserva-all").css("display", "none");
							jQuery("#DivMsnRegalarOK").css("display", "block");

							window.scrollTo(0, 0);

							jQuery("#DivPasoVolver").show();
						}
					}
				}
			);
		}
		return false;
	});
});

function cargar_info(localizador){
    
	var lang = jQuery('#lang').val();

	jQuery.ajax({
		type     : "POST",
		url      : ROOTGESTOR  + "ApiTusVisitasV2/regalar",     		
		data     : JSON.stringify({    
		localizador : localizador,
		lang       	: lang
	}),
    success: function (response) {
      var data = JSON.parse(response);
         
      jQuery('#StrLocalizador').html(localizador);
      jQuery('#StrServicio').html(data.info_compra.servicio_nombre);
      jQuery('#StrServicioConfirmar').html(data.info_compra.servicio_nombre);
      jQuery('#StrServicioConfirmarOk').html(data.info_compra.servicio_nombre);
      jQuery('#StrInstalacion').html(data.info_compra.instalacion_nombre);
      jQuery('#StrUnidades').html(data.info_compra.unidades);
      jQuery('#ServicioId').val(data.info_compra.servicio_id);
      jQuery('#TipoVisita').val(data.info_compra.servicio_id);
      jQuery('#Adultos').val(data.unidades);
      jQuery('#StrPlazas').html(data.unidades);
      jQuery('#StrPlazasOk').html(data.unidades);
      jQuery('#plazas').val(data.unidades);
      jQuery('#Idioma').val(data.info_compra.idioma_info.Idioma.id);
      jQuery('#instalacion').val(data.instalacion);
      jQuery('#BodegaId').val(data.instalacion);
	  
	  var tarifasHtml  ='';
	  var TarifasId    ='';
	  var TarifasValue ='';
	  for(var i = 0; i < data.tarifas.length; i++){
		tarifasHtml += '<div class="datos-visitas-resumen">';
		tarifasHtml += '<span class="rotulo">' + data.tarifas[i].UsuariosGrupo.nombre;
		tarifasHtml += '<strong id="StrUnidades">' + data.tarifas[i].LocalizadorTarifa.plazas_adulto +'</strong>';
		tarifasHtml += '</span>';
		tarifasHtml += '</div>';

		if(i == data.tarifas.length - 1){
			TarifasId    += data.tarifas[i].Tarifa.id;
			TarifasValue += data.tarifas[i].LocalizadorTarifa.plazas_adulto;
		}else{
			TarifasId    += data.tarifas[i].Tarifa.id + ',';
			TarifasValue += data.tarifas[i].LocalizadorTarifa.plazas_adulto + ',';
		}
	  }

	  var campos_extras_Html='';
	  for(var i = 0; i < data.info_campos_extras_canjeador.length; i++){
		campos_extras_Html += '<div class="datos-visitas datos-usuario-modificar">';
		campos_extras_Html += '<p class="rotulo">' + data.info_campos_extras_canjeador[i].Campo.nombre +'</p>';
		campos_extras_Html += '<p><strong>' + data.info_campos_extras_canjeador[i].LocalizadorCampo.value +'</strong></p>';
		campos_extras_Html += '</div>';
	  }

	var campos_servicio_html = "";
	var campos_servicio      = jQuery.makeArray(data.info_compra.campos_servicio);

	campos_servicio_html = cargarCamposExtrasComun(campos_servicio);

	  jQuery('#DivCondiciones').html(data.info_compra.condiciones_servicio);


	  jQuery('#TarifasId').val(TarifasId);
	  jQuery('#TarifasValue').val(TarifasValue);
	  jQuery('#TdBodegaNombre').after(tarifasHtml);
	  jQuery('#DivContenidoExtras').html(campos_extras_Html + campos_servicio_html);
	  QuitarPreseleccionCombo();

	  jQuery("#CondicionesGenerales2").attr("href",data.info_compra.formulario_condiciones);
	  jQuery("#BtnVolverTusVisitas").attr("href","/"+data.info_compra.formulario_volver);
	  jQuery("#BtnVolverTusVisitasPaso2").attr("href","/"+data.info_compra.formulario_volver);
   
	  cargarCalendario();
	  jQuery('#ResultadosVisitas').html('');

    },			
    beforeSend: function () {
       
    }
    });

}

function cargarCalendario(){
	var diasQueSeBloquean = [];
    jQuery
        .ajax({
            type     : "POST",
            async    : false,
            dataType : "json",
            url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/reserva_web/disponibilidad_fechas_servicio_modificar.php",
            data     : {
                servicio    : jQuery("#TipoVisita").val(),
                localizador : jQuery("#Localizador").val(),
            },
            cache    : false,
        })
        .done(function (response) {
            diasQueSeBloquean = response;
        });
    // CALENDARIOS
    var calendary_options_complementary = {
        beforeShowDay: DiasBloqueados,
    };
    // CALENDARIOS
    $datediv         = jQuery("#FechaVisita-container");
    var fecha_vienes = jQuery("#fecha_vienes").val();

    if (fecha_vienes != "") {
        var primer_dia = new Date(1000 * fecha_vienes);
        //jQuery("#FechaVisita-selected").html(jQuery.datepicker.formatDate("D, d M yy", primer_dia));
    } else {
        if (diasQueSeBloquean[0] == undefined) {
            var primer_dia = new Date();
        } else {
            var primer_dia = new Date(diasQueSeBloquean[0]);
        }
    }
    // CALENDARIOS
    $datediv.datepicker({
        language        : LANG,
        defaultViewDate : {
            year  : primer_dia.getFullYear(),
            month : primer_dia.getMonth(),
        },
        beforeShowDay: function (d) {
            var year  = d.getFullYear(),
                month = ("0" + (d.getMonth() + 1)).slice(-2),
                day   = ("0" + d.getDate()).slice(-2);
            var formatted = year + "-" + month + "-" + day;
            if (jQuery.inArray(formatted, diasQueSeBloquean) != -1) {
                return true;
            } else {
                return false;
            }
        },
    });

    // Sólo si ha introducido fecha marcamos el día
    if (fecha_vienes != "") {
        jQuery("#FechaVisita-container td").each(function (index, element) {
            if (jQuery(element).text() == primer_dia.getDate()) {
                if (jQuery(element).hasClass("new") || jQuery(element).hasClass("old")) {
                } else {
                    jQuery(element).addClass("active");
                    jQuery("#FechaVisita").val(jQuery.datepicker.formatDate("dd/mm/yy", primer_dia));
                }
            }
        });

        ComprobarDisponibilidad(jQuery('#FechaAnterior').val());
        
    }

    $dateinput    = jQuery("#FechaVisita");
    $dateselected = jQuery("#FechaVisita-selected");
    $datediv.unbind().on("changeDate", function (e) {
        $dateinput.val(e.format("dd/mm/yyyy"));
        comprobarTodos();
    });

	$dateinput    = jQuery("#FechaVisita");
    $dateselected = jQuery("#FechaVisita-selected");
    $datediv.unbind().on("changeDate", function (e) {
        $dateinput.val(e.format("dd/mm/yyyy"));
        comprobarTodos();
    });
    jQuery(".usuarios_grupos, .usuarios_grupos_no_suman, input[type=radio][name=Idioma]")
        .unbind()
        .on("change", function (e) {
            comprobarTodos();
        });
        jQuery("#ValidarDatosDisponibilidad").hide();
        jQuery("#ValidarDatoPersonas").hide();
        jQuery("#VerDisponibilidad")
        .unbind()
        .on("click", function () {
            ComprobarDisponibilidad('');
        });

	
}

/***********************************************************************
 * Función que bloquea días del calendario
 **********************************************************************/
function DiasBloqueados(date) {
    // Bloqueo fechas superiores a 90 días
    fecha_maxima = new Date();
    tiempo       = fecha_maxima.getTime();
    dias         = 180;
    milisegundos = parseInt(dias * 24 * 60 * 60 * 1000);
    total        = fecha_maxima.setTime(tiempo + milisegundos);
    if (date > fecha_maxima) {
        return [false, "dia_nodisponible"];
    }
    return [true, "dia_disponible"];
}

/***********************************************************************
 * Función que pasada una fecha me devuelve el día de la semana que es
 **********************************************************************/
function DiaSemanaFecha(fecha_visita) {
    // Convierto fecha de visita al formato adecuado
    var fFecha = fecha_visita.split("/");
    var fecha  = fFecha[2] + "/" + fFecha[1] + "/" + fFecha[0];
    // Días de la semana
    dia_fecha = new Date(fecha);
    return dias_semana[dia_fecha.getDay()];
}

function comprobarTodos() {
    
    valor_fecha   = jQuery("#FechaVisita").val();
    valor_adultos = jQuery("#Adultos").val();
    valor_idioma  = jQuery("input:radio[name=Idioma]:checked").val();

    if (valor_fecha != "" && valor_adultos != "" && valor_idioma != "" && valor_idioma != undefined && valor_adultos != undefined) {
        jQuery("#VerDisponibilidad").click();        
    }
}

function seleccionarHorario( horario,fecha,hora){
    //Eliminamos las clases seleccionados de todos los horarios
    jQuery("label[id^=LblHorario]").each((index,item)=>{
        var iid = jQuery(item).attr('id');        
        jQuery('#'+ iid).attr('class','');
    })
    //Marcamos el horario seleccionado como activo
    jQuery('#LblHorario' + horario).addClass('hour-selected');
    jQuery('#salaHorarioSeleccionada').val(horario);
    jQuery('#fechaSeleccionada').val(fecha);
    jQuery('#horaSeleccionada').val(hora);

    jQuery('#ValidarModificar').html('');
    jQuery('#ValidarModificar').hide('');

    jQuery('#MensajeErrorSeleccionarHorario').html('');
    jQuery('#MensajeErrorSeleccionarHorario').hide('');
}

function ComprobarDisponibilidad( SalaHorarioSeleccionado){
	var backoffice_api =1;
    //Datos
    var localizador  = jQuery("#Localizador").val();
    var bodega       = jQuery("#BodegaId").val();
    var fecha        = jQuery("#FechaVisita").val();
    var categoria    = jQuery("#TipoVisita").val();
    var idioma       = jQuery("input:radio[name=Idioma]:checked").val();
	var servicio     = jQuery('#ServicioId').val();
    var adultos      = jQuery("#Adultos").val();
    var TarifasId    = jQuery("#TarifasId").val();
    var TarifasValue = jQuery("#TarifasValue").val();

    var lista        = {};     
    var listaValues  = TarifasValue.split(",");
    var listaNombres = TarifasId.split(",").forEach(function (item,index) {
        lista[item]  = listaValues[index];
    });

    if (SalaHorarioSeleccionado ==''){
       jQuery('#salaHorarioSeleccionada').val(0);
    }
	
	// Compruebo disponibilidad
	jQuery.ajax({
	type : "POST",
	url  : ROOTGESTOR  + "ApiVisitasV2/disponibilidad_bodega",              
	data : JSON.stringify({
		bodega   : bodega,
		adultos  : adultos,
		lista    : lista,
		fecha    : fecha,
		servicio : servicio,
		idioma   : idioma,
	}),
	success: function (response) {
	
		var json = jQuery.parseJSON(response);
		
		var contenidoHtml = '<div class="info_servicio">';
		contenidoHtml    += '<div class="radio inputs-horas">';
		if (json.horariosid.length >0){                            
			json.horariostexto.forEach((item,index) => {                      
				if (SalaHorarioSeleccionado == json.horariosid[index] ){
					contenidoHtml += `<label id="LblHorario${json.horariosid[index]}" class="hour-selected">`;
				}else{
					contenidoHtml += `<label id="LblHorario${json.horariosid[index]}">`;
				}
				contenidoHtml += `<input type="radio" name="hora" value="${json.horariosid[index]}" class="HoraSeleccion" onChange="seleccionarHorario(${json.horariosid[index]},'${fecha}','${json.horariostexto[index]}')">`;
				contenidoHtml += `<span class="hora">${item}</span>`;
				contenidoHtml +='</label>';
			});
		}else{
			if (SalaHorarioSeleccionado =='' || SalaHorarioSeleccionado =='0'){				
				contenidoHtml += '<div class="servicio_nombre msg_error">' + jQuery("#MsnNoyHorario").val() + '</div>';
			}else{
				contenidoHtml += `<label id="LblHorario${SalaHorarioSeleccionado}" class="hour-selected">`;
				contenidoHtml += `<input type="radio" name="hora" value="${SalaHorarioSeleccionado}" class="HoraSeleccion">`;
				contenidoHtml += `<span class="hora">${jQuery("#TxtHoraFechaAnterior").val()}</span>`;
				contenidoHtml += '</label>';
			}
		}
		contenidoHtml += '</div>';
		contenidoHtml += '</div>';
		jQuery("#ResultadosVisitas").html(contenidoHtml);
	},
	beforeSend: function () {
	
	}
	});

jQuery("#ValidarDatosDisponibilidad").hide();

}

