jQuery(function() {
    if (jQuery('#ContenidoCargado').length) {
        jQuerycalendario = jQuery('#ContenidoCargado');
        var seccion = 'compra';
    } else {
        jQuerycalendario = jQuery('#opciones_modificacion');
    }

    var instalacion = jQuery('#instalacion').val(),
        servicio    = jQuery('#servicioSeleccionado').val(),
        actividad   = jQuery('#actividadSeleccionada').val();    

    jQuery("#FechasCalendario").datepicker({
        language: LANG,       
        dateFormat: 'dd/mm/yy',        
    });         
});
// Variables globales para usar en las funciones pasadas al datepicker
var dias;
var fechas_bloquear;
/***********************************************************************
 * Función que bloquea días ocupados, fechas inferiores a la actual, 
 *  la actual y la del días siguiente 
 **********************************************************************/
function DiasBloqueados(date) {
    // Si no hay datos seleccionados bloqueo todo el calendario
    if (fechas_bloquear.length == 0) {
        return [false, "dia_nodisponible"];
    } else {
        // Año
        var anio = date.getFullYear();
        // Mes
        if ((date.getMonth() + 1) < 10) {
            var mes = 0 + '' + (date.getMonth() + 1);
        } else {
            var mes = date.getMonth() + 1;
        }
        // Día
        if ((date.getDate()) < 10) {
            var dia = 0 + '' + date.getDate();
        } else {
            var dia = date.getDate();
        }
        // BLOQUEO FECHAS OCUPADAS SI LAS HAY
        if (fechas_bloquear.length > 1) {
            for (i = 1; i < fechas_bloquear.length; i++) {
                if (jQuery.inArray(anio + '-' + mes + '-' + dia, fechas_bloquear) != -1) {
                    return [false, "dia_nodisponible"];
                }
            }
        }
        // FECHAS INFERIORES SE BLOQUEAN
        if (new Date() > date) {
            //return [false, "dia_nodisponible"]; 
        }
        // BLOQUEO FECHAS SUPERIORES A LOS DÍAS DEL SERVICIO SELECCIONADO
        fecha_maxima = new Date();
        tiempo       = fecha_maxima.getTime();
        milisegundos = parseInt(dias * 24 * 60 * 60 * 1000);
        total        = fecha_maxima.setTime(tiempo + milisegundos);
        if (date > fecha_maxima) {
            return [false, "dia_nodisponible"];
        }
        return [true, "dia_disponible"];
    }
}
/***********************************************************************
 * Función que bloquea fechas y fines de semana 
 **********************************************************************/
function noWeekendsOrHolidays(date) {
    // Bloqueo fines de semana
    var noWeekend = jQuery.datepicker.noWeekends(date);
    return noWeekend[0] ? DiasBloqueados(date) : noWeekend;
}