jQuery(function() {
    // CALENDARIOS
    jQuery("#FechaVisita, #FechaSeleccionadaVisita").datepicker({
        closeText       : 'Cerrar',
        prevText        : '<<',
        nextText        : '>>',
        currentText     : 'Hoy',
        monthNames      : ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort : ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        dayNames        : ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        dayNamesShort   : ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
        dayNamesMin     : ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
        weekHeader      : 'Sm',
        dateFormat      : 'dd/mm/yy',
        firstDay        : 1,
        minDate         : 0,
        beforeShowDay   : DiasBloqueados
    });
});

/***********************************************************************
 * Función que bloquea días del calendario
 **********************************************************************/
function DiasBloqueados(date) {
    // Bloqueo fechas superiores a 90 días
    fecha_maxima = new Date();
    tiempo       = fecha_maxima.getTime();
    dias         = 180;
    milisegundos = parseInt(dias * 24 * 60 * 60 * 1000);
    total        = fecha_maxima.setTime(tiempo + milisegundos);
    if (date > fecha_maxima) {
        return [false, "dia_nodisponible"];
    }
    return [true, "dia_disponible"];
}