jQuery(function() {
    jQuery("#FormasPago .radio").click(function () {
        jQuery("#FormasPago .radio").removeClass("selected");
        jQuery(this).addClass("selected");
        jQuery("#continuar_compra").prop("disabled", false);
    });


  /****************** PROCESO COMPRA *********************************/

  /*******************************************************************
   * Comprobación de datos del formulario de compra
   *******************************************************************/
  if (jQuery("#FormCompraEvento").length) {
    // Obtengo campos que son obligatorios
    var servicio_id = jQuery("#LocalizadorServicio").val();
    jQuery
      .ajax({
        type     : "POST",
        dataType : "json",
        url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/campos_obligatorios.php",
        data     : {
          servicio_id: servicio_id
        }
      })
      .done(function(data) {
        // Recorremos el array de campos extras
        for (i = 0; i < data.length; i++) {
          // Obtenemos los valores necesarios
          campo_id = data[i][0];
          es_array = data[i][1];
          // Si es array (como los inpus de cuenta corriente) hay que añadir el par de
          // corchetes. En cualquier caso seleccionamos el input con el nombre
          // indicado y le añadimos la regla de requerido
          input_name = "";
          if (es_array == 1) {
            input_name = "input[name='campos_extra[" + campo_id + "][]']";
          } else {
            input_name = "input[name='campos_extra[" + campo_id + "]']";
          }

          jQuery(input_name).rules("add", {
            required : true,
            messages : {
              required: "El campo es obligatorio"
            }
          });
        }
      });
    messages_es = {
      nombre                    : "El campo nombre es obligatorio.",
      apellidos                 : "El campo apellidos es obligatorio.",
      telefono                  : "El campo teléfono es obligatorio. Introdúzcalo en un formato válido. Ej. 941454050, 666555444",
      email                     : "El campo email es obligatorio. Introdúzcalo en un formato válido. Ej. ejemplo@pruebajig.es",
      dni                       : "El campo dni es obligatorio. Introdúzcalo en un formato válido. Ej. 16123456A",
      condiciones_compra        : "Por favor, acepte las condiciones de compra.",
      pago                      : "Por favor, seleccione un método de pago.",
      plazas_adulto             : "Por favor, seleccione número de plazas",
      tarifausuario             : "Seleccione tarifa",
      cantidad_maxima           : "Por favor, introduzca un valor mayor o igual a {0}.",
      num_Adultos               : "Por favor, introduzca un valor mayor o igual a {0}.",
      'campos_extra_check[104]' : "Por favor, acepte las politicas de privacidad.",
    };
    messages_en = {
      nombre                    : "First name is required field.",
      apellidos                 : "Last name is required field.",
      telefono                  : "Telephone is required field. Type in a valid format. Ej. 941454050, 666555444",
      email                     : "Email is required field. Type in a valid format. Ej. ejemplo@pruebajig.es",
      dni                       : "DNI is required field. Type in a valid format. Ej. 16123456A",
      condiciones_compra        : "Please, accept purchase conditions.",
      pago                      : "Please, select a payment method.",
      plazas_adulto             : "Please, select number of vacancies",
      tarifausuario             : "Please, select a price",
      num_Adultos               : "Please enter a value greater than or equal to {0}.",
      cantidad_maxima           : "Please enter a value greater than or equal to {0}.",
      'campos_extra_check[104]' : "Please, accept the privacy policies.",
    };
    messages = "";
    switch (lang_js) {
      case "es_ES":
        messages = messages_es;
        break;
      case "en_GB":
        messages = messages_en;
        break;
      default:
        messages = messages_en;
        break;
    }
    jQuery("#FormCompraEvento").validate({
      rules: {
        nombre: {
          required  : true,
          minlength : 2
        },
        apellidos: {
          required  : true,
          minlength : 2
        },
        telefono: {
          required  : true,
          minlength : 9,
          number    : true
        },
        email: {
          required  : true,
          minlength : 6,
          email     : true
        },
        dni: {
          required  : true,
          minlength : 9,
          maxlength : 9
        },
        condiciones_compra: {
          required: true
        },
        pago: {
          required: true
        },
        plazas_adulto: {
          min: 1
        },
        tarifausuario: {
          required  : true,
          minlength : 1
        },
        cantidad_maxima: {
           min: 1
        },
        'campos_extra_check[104]': {
          required: true
        },
      },
      messages: messages,
      // Algunos inputs se componen de varios campos. Estos hay que definirlos aqui ya que por defecto
      // el error se pondría en el primero de esos campos (apellido 1, primer grupo de dígitos de la cuenta
      // corriente...)
      errorPlacement: function(error, element) {
        if (element.attr("name") == "pago") {          
          jQuery( "#FormasPago" ).append(error);
        } else if (element.attr("name") == "condiciones_compra") {
          jQuery( "#FormasPago" ).append(error);
          error.insertAfter(".recibir_correo");
        } else if (element.attr("name") == "campos_extra_check[104]") {
          jQuery("#FormasPago").append(error);
          error.insertAfter(".recibir_correo");
        }        
        else {
          error.insertAfter(element);
        }
      },
      submitHandler: function(form) {
        // Compruebo plazas por si viene de la web
        var hora     = jQuery("#LocalizadorSalaHorario").val();
        var usuarios = jQuery("#LocalizadorUnidades").val();
        var servicio = jQuery("#LocalizadorServicio").val();
        var web      = 1;
        if (hora != 0 && hora != "") {
          jQuery
            .ajax({
              type     : "POST",
              url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/validar_plazas_proceso.php",
              dataType : "json",
              data     : {
                hora     : hora,
                usuarios : usuarios,
                servicio : servicio,
                web      : web,
               },
              cache   : false
            })
            .done(function(json) {
              if (json == -1) {
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "";
                jQuery("#ValidarPlazas").html(
                  "Debe seleccionar almenos una plaza."
                );
              }else if (json == 0) {
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "";
                jQuery("#ValidarPlazas").html(
                  "Lo sentimos, no quedan plazas disponibles."
                );
              } else {
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "none";
                // Tarifa validada o no hace falta
                if (validada == true) {    
                  jQuery(form)[0].submit();                                      
                } else {
                  div               = document.getElementById("ValidarPlazas");
                  div.style.display = "";
                  jQuery("#ValidarPlazas").html("Por favor, introduzca su email y contraseña correctas o seleccione otra tarifa.");
                }
              }
            });
          return false;
        } else {
          // Tarifa validada o no hace falta
          if (validada == true) {            
            validations.localizadorValidation(jQuery(form), true);
          } else {
            div               = document.getElementById("ValidarPlazas");
            div.style.display = "";
            jQuery("#ValidarPlazas").html("Por favor, introduzca su email y contraseña válidos o seleccione otra tarifa.");
          }
        }
      }
    });
  }

  /************************PROCESO DE RESERVA ****************************/
  // Compruebo que no han pasado más de 10 minutos desde que ha realizado la
  // reserva hasta que confirma (en cuyo caso el cron la elimina). Le muestro aviso
  var FormReserva = jQuery("#ConfirmarReserva"),
    ReservaAction = FormReserva.attr("action");
  FormReserva.removeAttr("action");
  jQuery("#ValidarTiempoReserva").click(function() {
    // Localizador
    var localizador = jQuery("#Localizador").val();
    // Horario
    var hora = jQuery("#Hora").val();
    // Comprobar tiempo que lleva haciendo la reserva
    jQuery
      .ajax({
        type     : "POST",
        url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/tiempo_reserva.php",
        dataType : "json",
        data     : {
          localizador : localizador,
          hora        : hora
        },
        cache    : false
      })
      .done(function(json) {
          FormReserva.attr("action", ReservaAction);
          FormReserva.submit();
      });
    return false;
  });

});
var validada = true;