jQuery(function() {
   jQuery("#FormasPago .radio").click(function () {
      jQuery("#FormasPago .radio").removeClass("selected");
      jQuery(this).addClass("selected");
      jQuery("#continuar_compra").prop("disabled", false);
  });
  /****************** PROCESO COMPRA *********************************/

  /*******************************************************************
   * Comprobación de datos del formulario de compra
   *******************************************************************/
  if (jQuery("#FormCompraServicio").length) {
    // Obtengo campos que son obligatorios
    var servicio_id = jQuery("#idServicio").val();
    jQuery
      .ajax({
        type     : "POST",
        dataType : "json",
        url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/campos_obligatorios.php",
        data     : {
          servicio_id: servicio_id
        }
      })
      .done(function(data) {
        // Recorremos el array de campos extras
        for (i = 0; i < data.length; i++) {
          // Obtenemos los valores necesarios
          campo_id = data[i][0];
          es_array = data[i][1];
          // Si es array (como los inpus de cuenta corriente) hay que añadir el par de
          // corchetes. En cualquier caso seleccionamos el input con el nombre
          // indicado y le añadimos la regla de requerido
          input_name = "";
          if (es_array == 1) {
            input_name = "input[name='campos_extra[" + campo_id + "][]']";
          } else {
            input_name = "input[name='campos_extra[" + campo_id + "]']";
          }

          jQuery(input_name).rules("add", {
            required : true,
            messages : {
              required: "El campo es obligatorio"
            }
          });
        }
      });
    messages_es = {
      nombre             : "El campo nombre es obligatorio.",
      apellidos          : "El campo apellidos es obligatorio.",
      telefono           : "El campo teléfono es obligatorio. Introdúzcalo en un formato válido.",
      email              : "El campo email es obligatorio. Introdúzcalo en un formato válido. Ej. ejemplo@pruebajig.es",
      dni                : "El campo dni es obligatorio. Introdúzcalo en un formato válido. Ej. 16123456A",
      condiciones_compra : "Por favor, acepte las condiciones de compra.",
      pago               : "Por favor, seleccione un método de pago.",
      plazas_adulto      : "Por favor, seleccione número de plazas",
      tarifausuario      : "Seleccione tarifa"
    };
    messages_en = {
      nombre             : "First name is required field.",
      apellidos          : "Last name is required field.",
      telefono           : "Telephone is required field. Type in a valid format. Ej. 941454050, 666555444",
      email              : "Email is required field. Type in a valid format. Ej. ejemplo@pruebajig.es",
      dni                : "DNI is required field. Type in a valid format. Ej. 16123456A",
      condiciones_compra : "Please, accept purchase conditions.",
      pago               : "Please, select a payment method.",
      plazas_adulto      : "Please, select number of vacancies",
      tarifausuario      : "Please, select a price"
    };
    messages = "";
    switch (lang_js) {
      case "es_ES":
        messages = messages_es;
        break;
      case "en_GB":
        messages = messages_en;
        break;
      default:
        messages = messages_en;
        break;
    }
    jQuery("#FormCompraServicio").validate({
      rules: {
        nombre: {
          required  : true,
          minlength : 2
        },
        apellidos: {
          required  : true,
          minlength : 2
        },
        telefono: {
          required  : true,
          minlength : 9,
        },
        email: {
          required  : true,
          minlength : 6,
          email     : true
        },
        dni: {
          required  : true,
          minlength : 9,
          maxlength : 9
        },
        condiciones_compra: {
          required: true
        },
        pago: {
          required: true
        },
        plazas_adulto: {
          min: 1
        },
        tarifausuario: {
          required  : true,
          minlength : 1
        }
      },
      messages: messages,
      // Algunos inputs se componen de varios campos. Estos hay que definirlos aqui ya que por defecto
      // el error se pondría en el primero de esos campos (apellido 1, primer grupo de dígitos de la cuenta
      // corriente...)
      errorPlacement: function(error, element) {
        if (element.attr("name") == "pago") {          
          jQuery( "#FormasPago" ).append(error);
        } else if (element.attr("name") == "condiciones_compra") {
          jQuery( "#FormasPago" ).append(error);
          error.insertAfter(".recibir_correo");
        } else {
          error.insertAfter(element);
        }
      },
      submitHandler: function(form) {
        // Compruebo si la tarifa es especial y en cuyo caso ha sido
        // validada
        tarifaEspecialValidada();
        // Compruebo plazas por si viene de la web
        var hora        = jQuery("#Hora").val();
        var usuarios    = jQuery("#NumeroUsuarios").val();
        var servicio    = jQuery("#idServicio").val();
        var localizador = jQuery("#Localizador").val();
        var web         = jQuery("#Web").val();
        if (hora != 0 && hora != "") {
          jQuery
            .ajax({
              type     : "POST",
              url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/validar_plazas_proceso.php",
              dataType : "json",
              data     : {
                hora        : hora,
                usuarios    : usuarios,
                servicio    : servicio,
                web         : web,
                localizador : localizador
              },
              cache   : false
            })
            .done(function(json) {
              if (json == 0) {
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "";
                jQuery("#ValidarPlazas").html("Lo sentimos, no quedan plazas disponibles.");
              } else {
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "none";
                // Tarifa validada o no hace falta
                if (validada == true) {                  
                  validations.localizadorValidation(jQuery(form), true);
                } else {
                  div               = document.getElementById("ValidarPlazas");
                  div.style.display = "";
                  jQuery("#ValidarPlazas").html("Por favor, introduzca su email y contraseña correctas o seleccione otra tarifa.");
                }
              }
            });
          return false;
        } else {
          // Tarifa validada o no hace falta
          if (validada == true) {            
            validations.localizadorValidation(jQuery(form), true);
          } else {
            div               = document.getElementById("ValidarPlazas");
            div.style.display = "";
            jQuery("#ValidarPlazas").html("Por favor, introduzca su email y contraseña válidos o seleccione otra tarifa.");
          }
        }
      }
    });
  }
  // Muestro u oculto para introducir correo de recibir por email reserva
  jQuery("#RecibirCorreo").click(function() {
    jQuery("#RecibirCorreoReserva").each(function() {
      displaying = jQuery(this).css("display");
      if (displaying == "none") {
        jQuery(this).css("display", "");
      } else {
        jQuery(this).css("display", "none");
      }
    });
  });
  if (typeof jQuery.fn.fancybox == "function") {
    jQuery("#CondicionesGenerales").fancybox({
      transitionIn  : "elastic",
      transitionOut : "elastic",
      speedIn       : 600,
      speedOut      : 200,
      overlayShow   : false,
      type          : "iframe"
    });
  }
  /************************PROCESO DE RESERVA ****************************/
  // Compruebo que no han pasado más de 10 minutos desde que ha realizado la
  // reserva hasta que confirma (en cuyo caso el cron la elimina). Le muestro aviso
  var FormReserva = jQuery("#ConfirmarReserva"),
    ReservaAction = FormReserva.attr("action");
  FormReserva.removeAttr("action");
  jQuery("#ValidarTiempoReserva").click(function() {
    // Localizador
    var localizador = jQuery("#Localizador").val();
    // Horario
    var hora = jQuery("#Hora").val();
    // Comprobar tiempo que lleva haciendo la reserva  

    jQuery
      .ajax({
        type     : "POST",
        url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/tiempo_reserva.php",
        dataType : "json",
        data     : {
          localizador : localizador,
          hora        : hora
        },
        cache    : false
      })
      .done(function(json) {
        // El tiempo que lleva haciendo la reserva a superado los 10 minutos
        if (json == 1) {
          div               = document.getElementById("session-caducada-msg");
          div.style.display = "";
          jQuery("#session-caducada-msg").html("Lo sentimos, su sesión ha caducado. Realice una nueva reserva.");
          setTimeout(function() {
            window.location = location.host;
          }, 5000);
        } else {
          FormReserva.attr("action", ReservaAction);
          FormReserva.submit();
        }
      });
    return false;
  });

  /************************** PROCESO MODIFICACIÓN ************************/
  // Valido si hay plazas en el horario seleccionado en el momento de hacer
  // la reserva, por si en ese momento
  // otra persona le ha dado antes y ha quitado plazas que quedaban
  var FormCambioReserva   = jQuery("#CambioReserva"),
      CambioReservaAction = FormCambioReserva.attr("action");
  FormCambioReserva.removeAttr("action");  
  jQuery("#ValidarCambioReserva").click(function(e) {
    e.preventDefault();
        
    var localizador      = jQuery("#Localizador").val();
    var pago_instalacion = jQuery('#pago_instalacion').val();

    var arrTarifasNuevo    = new Array();
    var arrTarifasOriginal = new Array();
    var arrTarifasId       = new Array();

    total  = 0;
    valido = true;
    jQuery('input[name^="tarifas"]').each(function() {                 
        if(pago_instalacion==0 && jQuery(this).val() > jQuery(this).attr('data-original') ){                
            jQuery("#ValidarPlazas").html(modificar['disminuir']);
            
            valido = false;
        } else {
            total += jQuery(this).val();
            arrTarifasNuevo.push(jQuery(this).val());
            arrTarifasOriginal.push(jQuery(this).attr('data-original'));
            arrTarifasId.push(jQuery(this).attr('data-id'));                
        }
    })

    if(total == 0 && valido) {
        jQuery("#ValidarPlazas").html("El número de plazas no puede ser \"0\", si lo desea puede ir a \"Cancelar Visitas\"");
        
        valido=false;
    }
    
    var fechaId                 = jQuery('#FechaAnterior').val();
    var fechaIdOriginal         = jQuery('#FechaAnterior').val();
    var salaHorarioSeleccionada = jQuery('#salaHorarioSeleccionada').val();

    if (jQuery("#tipoModificacion").val() =='fechas'){
      fechaId  = jQuery('#salaHorarioSeleccionada').val();
    }

    if(fechaId == 0){
      
      jQuery("#ValidarModificar").html('<label class="error"> Debe seleccionar una hora </label>');
      jQuery('#ValidarModificar').fadeIn( "slow" );
      
      valido = false;
    }
    
    if(valido){     
   
      var url_validacion = 'modificar_plazas.php';

      if (jQuery("#tipoModificacion").val() =='fechas'){
        url_validacion = 'modificar_fechas.php';                
      }
            
      jQuery("#ValidarPlazas").html("");
      jQuery.ajax({
          type     : "POST",
          url      :"//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/" + url_validacion,
          dataType : "json",
          data     : {          
            "localizador"             : localizador,
            "arrTarifasNuevo"         : arrTarifasNuevo,
            "arrTarifasOriginal"      : arrTarifasOriginal,
            "arrTarifasId"            : arrTarifasId,
            "fechaId"                 : fechaId,
            "fechaIdOriginal"         : fechaIdOriginal,
            "pago_instalacion"        : pago_instalacion,
            "salaHorarioSeleccionada" : salaHorarioSeleccionada
          },
          cache: false
        }).done(function(json) {
          // No ha pasado la validación
          if (jQuery("#tipoModificacion").val() =='fechas'){
            if (json[0] == 1) {
              // alert('localizador modificado con exito');
              jQuery('#FechasCalendario').css('border','none');
              jQuery('#FechasCalendario').prop('disabled',true);
              jQuery('#Horas').css('border','none');
              jQuery('#Horas').prop('disabled',true);
              jQuery('input[name^="tarifas"]').each(function() {    
                jQuery(this).css('border','none');      
                jQuery(this).prop('disabled',true);     
              });
              div               = document.getElementById("ValidarPlazas");
              div.style.display = "";
              jQuery("#ValidarPlazas").html(json[1]);
           
              jQuery('#DivContenidoConfirmacion').css('display','none');
              jQuery('#DivResultadoModificacion').css('display','inline');
              jQuery('#ValidarCambioReserva').css('display','none');
              
            }
          }else{
            if (json[0] == 0) {           
              jQuery("#ValidarModificar").html('<label class="error"> ' + modificar["disminuir"] + ' </label>');
              jQuery('#ValidarModificar').fadeIn( "slow" );
            } else {
              if (!jQuery(".radio_modificar:checked").length) {                
                jQuery("#ValidarModificar").html('<label class="error"> ' + modificar["elegir"] + ' </label>');
                jQuery('#ValidarModificar').fadeIn( "slow" );
              } else {
                jQuery('#FechasCalendario').css('border','none');
                jQuery('#FechasCalendario').prop('disabled',true);
                jQuery('#Horas').css('border','none');
                jQuery('#Horas').prop('disabled',true);
                jQuery('input[name^="tarifas"]').each(function() {    
                  jQuery(this).css('border','none');      
                  jQuery(this).prop('disabled',true);     
                });
                div               = document.getElementById("ValidarPlazas");
                div.style.display = "";
                jQuery("#ValidarPlazas").html(json[1]);
             
                jQuery('#DivContenidoConfirmacion').css('display','none');
                jQuery('#DivResultadoModificacion').css('display','inline');
                jQuery('#ValidarCambioReserva').css('display','none');
              }
            }
          }
        });
    }
    return false;
  });

  // Vuelvo de la información de la nueva reserva a seleccionarla de nuevo
  if (jQuery(".radio_modificar:checked").length) {    
      jQuery(".radio_modificar").trigger("click");
  }

  // Compruebo que no han pasado más de 10 minutos desde que ha realizado la
  // modificación de la reserva (en cuyo caso el cron la elimina) hasta que
  // la confirma. Le muestro aviso en este caso
  var FormInfoCambio   = jQuery("#NuevaReservaModificada"),
      InfoCambioAction = FormInfoCambio.attr("action");
  FormInfoCambio.removeAttr("action");
  jQuery("#ValidarTiempoModificada").click(function() {
    // Localizador
    var localizador = jQuery("#Localizador").val();
    // Horario
    var hora = jQuery("#Hora").val();
    // Comprobar tiempo que lleva haciendo la reserva
    jQuery.ajax({
        type     : "POST",
        url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/modificar/tiempo_reservamodificada.php",
        dataType : "json",
        data     : {
          localizador : localizador,
          hora        : hora
        },
        cache    : false
      }).done(function(json) {
        // El tiempo que lleva haciendo la reserva a superado los 10 minutos
        if (json == 1) {
          div               = document.getElementById("session-caducada-msg");
          div.style.display = "";
          jQuery("#session-caducada-msg").html("Lo sentimos, su sesión ha caducado. Realice una nueva reserva.");
          setTimeout(function() {
            window.location = "https://" + location.host;
          }, 5000);
        } else {
          FormInfoCambio.attr("action", InfoCambioAction);
          FormInfoCambio.submit();
        }
      });
    return false;
  });

  /************************** PROCESO ANULACIÓN ************************/
  // Valido que haya seleccionado una reserva para anular
  var FormAnulacionCompraReserva = jQuery("#AnulacionCompraReserva"),
    AnulacionCompraReservaAction = FormAnulacionCompraReserva.attr("action");
  FormAnulacionCompraReserva.removeAttr("action");
  jQuery("#ValidarAnulacion").click(function() {        
    // Tipo de anulación
    var tipo_anulacion = jQuery("#TipoAnulacion").val();
    if (tipo_anulacion != "compra") {
      if (!jQuery(".radio_modificar:checked").length) {
        jQuery("#ValidarAnulacionReserva").html("Por favor, seleccione una reserva para anular.");
      } else {
        div = document.getElementById("ValidarAnulacion");
        FormAnulacionCompraReserva.attr("action", AnulacionCompraReservaAction);        
        FormAnulacionCompraReserva.submit();
      }
      return false;
    }
  });
});
var validada = true;

/**********************************************************************
 * Función que comprueba primero si la tarifa seleccionada es especial, 
	y en tal caso si ha sido validada correctamente
***********************************************************************/
function tarifaEspecialValidada() {
  var tarifa = jQuery("#tarifausuario").val();
  jQuery
    .ajax({
      type     : "POST",
      url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/esTarifa_especial.php",
      dataType : "json",
      data     : {
        tarifa: tarifa
      },
      cache    : false
    })
    .done(function(especial) {
      // Tarifa especial
      if (especial == 1) {
        var especial_validado = jQuery("#EspecialValidado").val();
        // No ha sido validado correctamente
        if (especial_validado == 0) {
          validada = false;
        } else {
          validada = true;
        }
      } else {
        validada = true;
      }
    });
}
