jQuery(function() {
    jQuery("#validar_cupon").click(function(e) {
        e.preventDefault();
        jQuery("#cupon-error").remove();
        var cupon        = jQuery("#cupon").val();
        var servicio     = jQuery("#idServicio").val();
        var fecha_visita = jQuery("#fecha_visita").text() || jQuery("#fecha_visita").val();
        var localizador  = jQuery("#localizador").val();

        if (cupon == "") {
            jQuery("#cupon").parent().before("<label for='cupon' id='cupon-error' class='error'>introduce un valor por favor.</label>");
        } else {
            
            jQuery.ajax({
                type  : 'POST',
                url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/cupones.php',
                async : false,
                data  : {
                    "cupon"        : cupon,
                    "servicio"     : servicio,
                    "fecha_visita" : fecha_visita,
                    "localizador"  : localizador
                },
                success: function(response) {
                    var msg   = "";
                    var clase = "";
                    if (response == 0) {
                        msg   = cupones_textos["texto_0"];
                        clase = "error";
                    } else if (response == 1) {
                        msg   = cupones_textos["texto_1"];
                        clase = "error";
                    } else {
                        msg   = cupones_textos["texto_2"];
                        clase = "success";
                        var cupon_respuesta   = jQuery.parseJSON(response);
                        var descuento_carrito = cupones_textos["texto_3"] + " (" + cupon_respuesta.codigo +": -" + cupon_respuesta.cantidad;
                        if (cupon_respuesta.porcentual == 1) {
                            // Modificamos el precio total que se ve en el carrito
                            TotalPrecio = jQuery(".info_total_carrito").text().substring(0, jQuery(".info_total_carrito").text().length - 1);
                            
                            // 2021-09-14 apartir de ahora los descuentos sólo afectan a las tarifas no a los extras
                            var total = parseFloat(TotalPrecio - (cupon_respuesta.total_tarifas * cupon_respuesta.cantidad) / 100).toFixed(2) + " €";
                            jQuery(".info_total_carrito").text(total);
                            var cantidad_carrito = total_descuento = (cupon_respuesta.total_tarifas * cupon_respuesta.cantidad) / 100;
                            var diferencia       = total;
                            descuento_carrito   += "%)"
                        } else {
                            // Modificamos el precio total que se ve en el carrito
                            TotalPrecio    = jQuery(".info_total_carrito").text().substring(0, jQuery(".info_total_carrito").text().length - 1);
                            var diferencia = TotalPrecio - cupon_respuesta.cantidad
                            if(diferencia < 0){
                                diferencia = 0;
                            }
                            
                            var total = diferencia + " €";
                            jQuery(".info_total_carrito").text(total);
                            var cantidad_carrito = cupon_respuesta.cantidad;
                            if(diferencia == 0){
                                var total_descuento = TotalPrecio - 1;
                            }else{
                                var total_descuento = cupon_respuesta.cantidad;
                            }
                             descuento_carrito += "€)"
                        }

                        // Añadimos en el carrito el cupón
                        var fila = "";
                            fila += "<td>" + descuento_carrito + "</td>";
                            fila += "<td><span class='num_usuarios'>1</span></td>";
                            fila += "<td class='casi-last'> -" + parseFloat(cantidad_carrito).toFixed(2) + " €</td>"; 
                            fila += "";
                        jQuery(".tr-descuento").append(fila); 
                    }

                    var redsys = jQuery('#Redsys').attr("action");
                    var ceca   = jQuery('#CecaTpv').attr("action");
                    var paypal = jQuery('#Paypal').attr("action");

                    if(parseFloat(total) != 0){

                        if(typeof redsys !== "undefined"){
                          var merchant  = jQuery("input[name='Ds_MerchantParameters']").val();
                          var signature = jQuery("input[name='Ds_Signature']").val()
                          
                          regenerar_redsys(merchant, signature, diferencia);
                        }

                        if(typeof ceca !== "undefined"){
                          var merchant = jQuery("input[name='Ds_MerchantParameters']").val();
                          
                          regenerar_ceca(diferencia);
                        }

                        if(typeof paypal !== "undefined"){

                           var paypal_discount = '<input type="hidden" name="discount_amount_cart " value="' + total_descuento + '">';
                           jQuery("#Paypal").append(paypal_discount);
                           regenerar_paypal(diferencia);
                        }
                    }else{

                        cambiar_boton();
                    }
                    
                    jQuery("#cupon").parent().before("<label for='cupon' id='cupon-error' class='" + clase + "'>" + msg + "</label>");
                }
            });
        }
    })
});

function cambiar_boton(){
    // Hay que poner el método de pago como pagado con 0 euros
    var redsys    = jQuery('#Redsys').attr("action");
    var ceca      = jQuery('#CecaTpv').attr("action");
    var paypal    = jQuery('#Paypal').attr("action");
    var tipo_pago = '';

    if(typeof redsys !== "undefined"){
        jQuery('#Redsys').remove();
        tipo_pago = 'redsys';
    }

    if(typeof ceca !== "undefined"){
        jQuery('#Ceca').remove();
        tipo_pago = 'ceca';
    }

    if(typeof paypal !== "undefined"){
        jQuery('#Paypal').remove();
        tipo_pago = 'paypal';
    }

    var localizador = jQuery("#localizador").val();

    jQuery.ajax({
        type  : 'POST',
        url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/actualizar_pago.php',
        async : false,
        data  : {
            "localizador" : localizador,
            "tipo_pago"   : tipo_pago,
        },
        success: function(response) {
           
        }
    });


    // Y conseguir un nuevo botón como si fuera pago en bodega
    var actividad   = jQuery( "input[name='actividadSeleccionada']").val();
    var instalacion = jQuery( "input[name='instalacion']").val();
    var servicio    = jQuery( "input[name='servicio']").val();
    var fecha       = jQuery( "input[name='fecha']").val();
    var hora        = jQuery( "input[name='hora']").val();
    var plazas      = jQuery( "input[name='plazas']").val();
    var nombre      = jQuery( "input[name='nombre']").val();
    var apellidos   = jQuery( "input[name='apellidos']").val();
    var telefono    = jQuery( "input[name='telefono']").val();
    var email       = jQuery( "input[name='email']").val();
    var localizador = jQuery( "input[name='localizador']").val();
    var pago        = jQuery( "input[name='pago_seleccionado']").val();
    var idioma      = jQuery( "input[name='idioma']").val();
    var lista       = jQuery( "input[name='lista']").val();


    var boton =  '<div class="finalizar_compra finalizar_compra_pay">';
        boton += '<form action="?comprar" id="modulo_reservas" name="modulo_reservas" method="post" enctype="multipart/form-data">';
        boton += '<div class="divider-input">';
        boton += '<input type="submit" value="Finalizar" class="confirmar_compra btn-solid-main">';
        boton += '</div>';
        boton += '<input type="hidden" name="pago_instalacion_fin">';
        boton += '<input type="hidden" name="actividad" value="' + actividad + '">';
        boton += '<input type="hidden" name="instalacion" value="' + instalacion+ '">';
        boton += '<input type="hidden" name="servicio" value="' + servicio + '">';
        boton += '<input type="hidden" name="fecha" value="' + fecha + '">';
        boton += '<input type="hidden" name="hora" value="' + hora + '">';
        boton += '<input type="hidden" name="plazas" value="' + plazas + '">';
        boton += '<input type="hidden" name="nombre" value="' + nombre + '">';
        boton += '<input type="hidden" name="apellidos" value="' + apellidos + '">';
        boton += '<input type="hidden" name="telefono" value="' + telefono + '">';
        boton += '<input type="hidden" name="email" value="' + email + '">';
        boton += '<input type="hidden" name="localizador" id="localizador" value="' + localizador + '">';
        boton += '<input type="hidden" name="recibir_correo" value="on">';
        boton += '<input type="hidden" name="tipo_compra" value="">';
        boton += '<input type="hidden" name="pago" value="' + pago + '">';
        boton += '<input type="hidden" id="Idioma" name="idioma" value="' + idioma + '">';
        boton += '<input type="hidden" name="lista" id="Lista" value="' + lista + '">';
        boton += '</form>';
        boton += '</div>';

    jQuery('.finalizar_compra_pay').remove();
    jQuery('#modulo_reservas2').parent().append(boton);
}


function regenerar_paypal(precio) {
    
    var localizador = jQuery("#localizador").val();

    jQuery.ajax({
        type  : 'POST',
        url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/regenerar_paypal.php',
        async : false,
        data  : {
            "localizador" : localizador,
            "precio"      : precio,
        },
        success: function(response) {
           
        }
    });
}

function regenerar_redsys(merchant, signature , precio) {
    
    var localizador = jQuery("#localizador").val();
    var id_pedido   = jQuery("#id_pedido").val();    
  
    jQuery.ajax({
        type  : 'POST',
        url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/regenerar_redsys.php',
        async : false,
        data  : {
            "localizador" : localizador,
            "id_pedido"   : id_pedido,
            "merchant"    : merchant,
            "signature"   : signature,
            "precio"      : precio,
        },
        success: function(response) {
            respuesta = jQuery.parseJSON(response);
            jQuery("input[name='Ds_MerchantParameters']").val(respuesta[0]);
            jQuery("input[name='Ds_Signature']").val(respuesta[1]);
        }
    });
}

function regenerar_ceca(precio) {
    
    var localizador = jQuery("#localizador").val();

    // Conseguimos los parámetros para regenerar la firma
    var merchantID    = jQuery("input[name='MerchantID']").val();
    var acquirerBIN   = jQuery("input[name='AcquirerBIN']").val();
    var terminalID    = jQuery("input[name='TerminalID']").val();
    var num_operacion = jQuery("input[name='Num_operacion']").val();
    var tipoMoneda    = jQuery("input[name='TipoMoneda']").val();
    var exponente     = jQuery("input[name='Exponente']").val();
    var cifrado       = jQuery("input[name='Cifrado']").val();
    var URL_OK        = jQuery("input[name='URL_OK']").val();
    var URL_NOK       = jQuery("input[name='URL_NOK']").val();

    jQuery("input[name='Importe']").val(precio*100);

    jQuery.ajax({
        type  : 'POST',
        url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/regenerar_ceca.php',
        async : false,
        data  : {
            "merchantID"    : merchantID,
            "acquirerBIN"   : acquirerBIN,
            "num_operacion" : num_operacion,
            "terminalID"    : terminalID,
            "precio"        : precio,
            "tipoMoneda"    : tipoMoneda,
            "exponente"     : exponente,
            "cifrado"       : cifrado,
            "URL_OK"        : URL_OK,
            "URL_NOK"       : URL_NOK,
            "localizador"   : localizador 

        },
        success: function(response) {
            respuesta = jQuery.parseJSON(response);
            jQuery("input[name='Firma']").val(respuesta);            
        }
    });
}

function llamarRegenerar( localizador ){
    var merchant  = jQuery("input[name='Ds_MerchantParameters']").val();
    var id_pedido = jQuery("#id_pedido").val(); 
    jQuery.ajax({
        type  : 'POST',
        url   : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/regenerar_redsys.php',
        async : false,
        data  : {
            "localizador" : localizador,
            id_pedido,
            merchant,        
            
        },
        success: function(response) {
            respuesta = jQuery.parseJSON(response);
            jQuery("input[name='Ds_MerchantParameters']").val(respuesta[0]);
            jQuery("input[name='Ds_Signature']").val(respuesta[1]);
        }
    });


}
