var jQuery = jQuery.noConflict();
jQuery(function () {
    jQuery(".idioma_cada input").attr("checked", true);
    var backoffice_api = 1;
    var diasQueSeBloquean = [];
    jQuery.ajax({
        type     : "POST",
        url      : ROOTGESTOR  + "ApiVisitasV2/disponibilidad_fechas_servicio",     	
        async: false,	
        data: JSON.stringify({
            servicio: jQuery("#TipoVisita").val(),
        }),
        success: function (response) {
       
            var data = JSON.parse(response);
            diasQueSeBloquean = data.horarios_ok;  
            
            try {
                if(diasQueSeBloquean.length === 0){
                    jQuery("#fila-contacto").show();
                    jQuery(".confirmacion_servicios").hide();
                    jQuery(".steps").html('&nbsp;');
                }
            } catch (error) {

            }
        },			
        beforeSend: function () {
            // jQuery(".loader").show();
        }
    });
    // CALENDARIOS
    var calendary_options_complementary = {
        beforeShowDay: DiasBloqueados,
    };
    // CALENDARIOS
    $datediv         = jQuery("#FechaVisita-container");
    var fecha_vienes = jQuery("#fecha_vienes").val();
    if (fecha_vienes != "") {
        var parts      = fecha_vienes.split('/');
        var primer_dia = new Date(parts[2], parts[1] - 1, parts[0]); 
    } else {
        if (diasQueSeBloquean[0] == undefined) {
            var primer_dia = new Date();
        } else {
            var primer_dia = new Date(diasQueSeBloquean[0]);
        }
    }
    // CALENDARIOS
    $datediv.datepicker({
        language        : LANG,
        defaultViewDate : {
            year  : primer_dia.getFullYear(),
            month : primer_dia.getMonth(),
        },
        beforeShowDay: function (d) {
            var year      = d.getFullYear(),
                month     = ("0" + (d.getMonth() + 1)).slice(-2),
                day       = ("0" + d.getDate()).slice(-2);
            var formatted = year + "-" + month + "-" + day;
            if (jQuery.inArray(formatted, diasQueSeBloquean) != -1) {
                return true;
            } else {
                return false;
            }
        },
    });

    // Sólo si ha introducido fecha marcamos el día
    if (backoffice_api == 1){
        if (fecha_vienes != "") {
            jQuery("#FechaVisita-container td").each(function (index, element) {
                if (jQuery(element).text() == primer_dia.getDate()) {
                    if (jQuery(element).hasClass("new") || jQuery(element).hasClass("old")) {
                    } else {
                        jQuery(element).addClass("active");
                        jQuery("#FechaVisita").val(jQuery.datepicker.formatDate("dd/mm/yy", primer_dia));
                    }
                }
            });
        }
    }

    $dateinput    = jQuery("#FechaVisita");
    $dateselected = jQuery("#FechaVisita-selected");
    $datediv.unbind().on("changeDate", function (e) {
        $dateinput.val(e.format("dd/mm/yyyy"));
        comprobarTodos();
    });
    jQuery(".usuarios_grupos, .usuarios_grupos_no_suman, input[type=radio][name=Idioma]")
        .unbind()
        .on("change", function (e) {
            comprobarTodos();
        });
    jQuery("#ValidarDatosDisponibilidad").hide();
    jQuery("#ValidarDatoPersonas").hide();
    jQuery("#VerDisponibilidad")
        .unbind()
        .on("click", function () {        

            //Datos
            var bodega       = jQuery("#BodegaId").val();
            var fecha        = jQuery("#FechaVisita").val();
            var categoria    = jQuery("#TipoVisita").val();
            var servicio     = jQuery("#TipoVisita").val();
            var form_comprar = jQuery("#form_comprar").val();
            var lang         = jQuery("#lang").val();
            var idioma       = jQuery("input:radio[name=Idioma]:checked").val();
            var adultos      = 0;
            var lista        = {};
         

            jQuery(".usuarios_grupos").each(function (ug) {
                if (jQuery(this).val() > 0) {
                    adultos                        = adultos + parseInt(jQuery(this).val()) * jQuery(this).data("cuantos");
                    lista[jQuery(this).data("id")] = jQuery(this).val();
                }
            });
            jQuery(".usuarios_grupos_no_suman").each(function (ug) {
                if (jQuery(this).val() > 0) {
                    lista[jQuery(this).data("id")] = jQuery(this).val();
                }
            });
        
            // Falta algún dato
            if ( fecha == "" || idioma == "" || categoria == "") {
                jQuery("#ValidarDatosDisponibilidad").show();
                jQuery("#ValidarDatosDisponibilidad").html(disponibilidades_bodegas["texto_introduzca_datos"]);
                jQuery("#ResultadosVisitas").html('');
                jQuery("#ResultadosVisitas").hide();
            }else if(adultos == "" || isNaN(adultos)){
                jQuery("#ResultadosVisitas").html('');
                jQuery("#ResultadosVisitas").hide();
            }
            // Compruebo que están introducidos todos los datos y son correctos
            else if (adultos < 1) {
                jQuery("#ValidarDatoPersonas").show();
                jQuery("#ValidarDatoPersonas").html(disponibilidades_bodegas["texto_reserva_minima"]);
                jQuery("#ResultadosVisitas").html('');
                jQuery("#ResultadosVisitas").hide();
            } else {
                jQuery("#ValidarDatosDisponibilidad").hide();

                // Compruebo disponibilidad
                jQuery.ajax({
                    type : "POST",
                    url  : ROOTGESTOR  + "ApiVisitasV2/disponibilidad_bodega",              
                    data : JSON.stringify({
                        bodega   : bodega,
                        adultos  : adultos,
                        lista    : lista,
                        fecha    : fecha,
                        servicio : servicio,
                        idioma   : idioma,
                        
                    }),
                    success: function (response) {
                        let data = JSON.parse(response);
                        var url  = '';
                        if (backoffice_api ==1){
                            url= "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/reserva_web/disponibilidad_bodega_api.php";
                        }else{
                            url= "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/reserva_web/disponibilidad_bodega_precompilado.php";
                        }
                        
                        jQuery.ajax({
                            type : "POST",
                            url  : url,
                            data : {
                                bodega              : bodega,
                                adultos             : adultos,
                                lista               : lista,
                                fecha               : fecha,
                                categoria           : categoria,
                                idioma              : idioma,
                                horarios_texto      : data.horariostexto,
                                horarios_id         : data.horariosid,
                                mesas               : data.mesas,
                                estipomesa          : data.estipomesa,
                                relatedServices     : data.relatedTableServices,
                                form_comprar        : form_comprar,
                                formulario_contacto : data.formulario_contacto,
                                lang                : lang,
                                tarifas             : data.tarifas,
                                actividad_id        : data.servicio.Servicio.actividad_id,
                                antelacion_reserva  : data.servicio.Servicio.antelacion_reserva                                     
                            },
                            cache: false,
                            success: function (response) {
                                console.log(response);

                                jQuery("#ResultadosVisitas").html(response);
                                jQuery("#ResultadosVisitas").show();
                                jQuery("#Plazas").val(parseInt(adultos));
                            },
                        });
                    },
                    beforeSend: function () {
                        
                    }
                });
     
            }
        });

    // DATOS DEL HORARIO SELECCIONADO
    jQuery(".HoraSeleccion").on("click", function () {
        var hora        = jQuery(this).val();
        var $contenedor = jQuery(this).closest("form");
        var servicio    = $contenedor.find("#ServicioId").val();
        var idioma      = jQuery("input:radio[name=Idioma]:checked").val();
        var tarifas     = jQuery("#TarifasId").val();
        var lista       = jQuery("#Lista").val();
        $contenedor.find("#FechaId").val(hora);
        $contenedor.find("#HoraId").val(hora);
         $contenedor.find("#IdiomaId").val(idioma);
        // Tarifa y precio total según servicio y plazas de adulto
        jQuery
            .ajax({
                type     : "POST",
                dataType : "json",
                url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/reserva_web/total_precio_tarifa.php",
                data     : {
                    servicio : servicio,
                    tarifas  : tarifas,
                    lista    : lista,
                },
                cache: false,
            })
            .done(function (tarifa) {
                $contenedor.find("#Plazas").val(parseInt(tarifa.num));
                $contenedor.find("#PrecioTotal").val(tarifa.total);
            });
    });
    // QUITO ACCIÓN DE FORMULARIO HASTA QUE ESTÉN SELECCIONADOS TODOS
    // LOS DATOS NECESARIOS
    if (backoffice_api ==1){
        var FormComprar   = jQuery("#FormRealizarVisitaCompra"),
            ComprarAction = FormComprar.attr("action");
    }else{
        var FormComprar   = jQuery("#FormRealizarVisita"),
            ComprarAction = FormComprar.attr("action");
    }
    
    FormComprar.removeAttr("action");
    jQuery("#ValidacionVisita").hide();
    jQuery("#ValidarDatoPersonas").hide();
    jQuery("#ValidarRealizarVisita").click(function () {
        var hora   = jQuery("#HoraId").val();
        var plazas = jQuery("#Plazas").val();

        if (hora == "") {
            jQuery(".SeleccioneHorario").html(disponibilidades_bodegas["texto_seleccione_horario_visita"]);
            jQuery(".SeleccioneHorario").show();
        } else {
            // Compruebo plazas antes de continuar
            jQuery
                .ajax({
                    type : "POST",
                    url  : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/reserva_web/comprobar_plazas_libres.php",
                    data : {
                        plazas : plazas,
                        hora   : hora,
                    },
                    cache: false,
                })
                .done(function (response) {
                    // No hay plazas libres
                    if (response == 0) {
                        jQuery("#ValidacionVisita").show();
                        jQuery("#ValidacionVisita").html(compra_reserva["text_no_hay_plazas"]);
                    }
                    // Hay plazas libres
                    else {
                        if (backoffice_api ==1){
                            var form_comprar = jQuery("#form_comprar").val();
                    
                            FormComprar.attr("action",form_comprar);
                            FormComprar.submit();

                        }else{
                            FormComprar.attr("action", ComprarAction);
                            FormComprar.submit();
                        }
                    }
                });
            return false;
        }
        return false;
    });
    /*
     * PRUEBA.
     * Ocultar teclado de dispositivo móvil si obtiene el foco del input date.
     */
    jQuery("#FechaVisita").focus(function () {
        var isMobile = false; // Comprobar si estamos usando un móvil
        if (
            /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) ||
            /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0, 4))
        ) {
            isMobile = true;
        }
        // Acción
        if (isMobile) {
            jQuery(this).blur();
        }
    });

    url_down = "../wp-content/plugins/visitas/img/down.svg";
    url_up   = "../wp-content/plugins/visitas/img/up.svg";
    if (LANG == "en") {
        url_down = "../../wp-content/plugins/visitas/img/down.svg";
        url_up   = "../../wp-content/plugins/visitas/img/up.svg";
    }

    jQuery(".usuarios_grupos").each(function (ug) {   
        var cantidad_maxima = jQuery("#Tarifa_"+ jQuery(this).data("id")).attr('max');
        jQuery("#Tarifa_" + jQuery(this).data("id") ).TouchSpin({
            buttonup_txt   : '<svg version="1.1" id="Btn_Sumar_' + jQuery(this).data("id") + '" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"><rect x="14.5" y="29.5" class="st0" width="31" height="1"/><rect x="29.5" y="14.5" class="st0" width="1" height="31"/> </svg>',
            buttondown_txt : '<svg version="1.1" id="Btn_Restar_' + jQuery(this).data("id") + '" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"><rect x="14.5" y="29.5" class="st0" width="31" height="1"/></svg>',   
        });
        //Aumento de unidades
        jQuery("#Tarifa_"+ jQuery(this).data("id")).on("touchspin.on.stopupspin", function() {           
            if( parseInt(jQuery("#Tarifa_" + jQuery(this).data("id")).val()) >= parseInt(jQuery("#Tarifa_" + jQuery(this).data("id")).attr('max'))){                        
                jQuery("#Btn_Sumar_" + jQuery(this).data("id") ).parent().prop('disabled', true);
                jQuery("#Btn_Sumar_" + jQuery(this).data("id") ).parent().attr('style', 'visibility:hidden');
            }
        });
       
        //Disminucion de unidades
        jQuery("#Tarifa_" + jQuery(this).data("id")).on("touchspin.on.stopdownspin", function() {    
            if( parseInt(jQuery("#Tarifa_"+ jQuery(this).data("id")).val()) < parseInt(jQuery("#Tarifa_"+ jQuery(this).data("id")).attr('max'))){                        
                jQuery("#Btn_Sumar_" + jQuery(this).data("id") ).parent().prop('disabled', false);
                jQuery("#Btn_Sumar_" + jQuery(this).data("id") ).parent().attr('style', 'display:inline');
            }
        });
        //Cambio de unidades
        jQuery("#Tarifa_"+ jQuery(this).data("id")).on("change", function() {    
            if( parseInt(jQuery("#Tarifa_" + jQuery(this).data("id")).val()) < parseInt(jQuery("#Tarifa_" + jQuery(this).data("id")).attr('max'))){                        
                jQuery("#Btn_Sumar_" + jQuery(this).data("id") ).parent().prop('disabled', false);
                jQuery("#Btn_Sumar_" + jQuery(this).data("id") ).parent().attr('style', 'display:inline');
            }
        });
    });


    // Comprobamos que en esa sala horario ya se ha hecho el mínimo de una reserva de 6 o la nuestra es de 6
    jQuery(".HoraSeleccion").click(function () {
        var personas = 0;
        jQuery(".usuarios_grupos").each(function (ug) {
            if (jQuery(this).val() > 0) {
                personas = personas + parseInt(jQuery(this).val()) * jQuery(this).data("cuantos");
            }
        });

        var checkbox      = jQuery(this);
        var sala_horario  = jQuery(this).val();
        var servicio      = jQuery("#ServicioId").val();
        var minimo_plazas = jQuery("#minimo_plazas").val();

        jQuery(".inputs-horas label").each(function () {
            jQuery(this).removeClass("hour-selected");
        });

        if (personas < minimo_plazas) {
            jQuery
                .ajax({
                    type : "POST",
                    url  : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/reserva_web/comprobar_minimo_reserva.php",
                    data : {
                        personas     : personas,
                        sala_horario : sala_horario,
                        servicio     : servicio,
                    },
                    cache: false,
                })
                .done(function (response) {
                    jQuery(".personas_minimo").remove();
                    if (response == 0) {
                        jQuery("#FechaId").val("");
                        jQuery("#HoraId").val("");
                        jQuery("#PlazasAdulto").val("");
                        jQuery("#PlazasInfantil").val("");
                        jQuery("#IdiomaId").val("");

                        checkbox.prop("checked", false);
                        jQuery(".inputs-horas").after("<div class='personas_minimo'>" + disponibilidades_bodegas["texto_reserva_minima"] + " " + minimo_plazas + " " + disponibilidades_bodegas["texto_personas"] + "</div>");
                    } else {
                        checkbox.parent().addClass("hour-selected");
                        jQuery(".personas_minimo").remove();
                    }
                });
        } else {
            checkbox.parent().addClass("hour-selected");
        }
    });
});

/***********************************************************************
 * Función que bloquea días del calendario
 **********************************************************************/
function DiasBloqueados(date) {
    // Bloqueo fechas superiores a 90 días
    fecha_maxima = new Date();
    tiempo       = fecha_maxima.getTime();
    dias         = 180;
    milisegundos = parseInt(dias * 24 * 60 * 60 * 1000);
    total        = fecha_maxima.setTime(tiempo + milisegundos);
    if (date > fecha_maxima) {
        return [false, "dia_nodisponible"];
    }
    return [true, "dia_disponible"];
}

/***********************************************************************
 * Función que pasada una fecha me devuelve el día de la semana que es
 **********************************************************************/
function DiaSemanaFecha(fecha_visita) {
    // Convierto fecha de visita al formato adecuado
    var fFecha = fecha_visita.split("/");
    var fecha  = fFecha[2] + "/" + fFecha[1] + "/" + fFecha[0];
    // Días de la semana
    dia_fecha = new Date(fecha);
    return dias_semana[dia_fecha.getDay()];
}

function comprobarTodos() {
    valor_fecha   = jQuery("#FechaVisita").val();
    valor_adultos = jQuery("#Adultos").val() || 0;
    valor_idioma  = jQuery("input:radio[name=Idioma]:checked").val();  

    jQuery(".usuarios_grupos").each(function (ug) {
        if (jQuery(this).val() > 0) {
            valor_adultos = valor_adultos + parseInt(jQuery(this).val());
        }
    });

    if (valor_fecha != "" && valor_adultos != "" && valor_idioma != "" && valor_idioma != undefined && valor_adultos != undefined) {
        jQuery("#VerDisponibilidad").click();
    }else if(valor_adultos == undefined){
        jQuery("#VerDisponibilidad").click();
    }
}
function seleccionarHorario( horario){
    // Eliminamos las clases seleccionados de todos los horarios
    jQuery("label[id^=LblHorario]").each((index,item)=>{
        var iid = jQuery(item).attr('id');        
        jQuery('#'+ iid).attr('class','');
    })
    // Marcamos el horario seleccionado como activo
    jQuery('#LblHorario' + horario).addClass('hour-selected');
    jQuery('#salaHorarioSeleccionada').val(horario);

    jQuery('#ValidarModificar').html('');
    jQuery('#ValidarModificar').hide('');

    jQuery('#MensajeErrorSeleccionarHorario').html('');
    jQuery('#MensajeErrorSeleccionarHorario').hide('');
  
    var $contenedor = jQuery(this).closest("form");
    var servicio    = $contenedor.find("#ServicioId").val();
    var idioma      = jQuery("input:radio[name=Idioma]:checked").val();
    var tarifas     = jQuery("#TarifasId").val();
    var lista       = jQuery("#Lista").val();
    $contenedor.find("#FechaId").val(horario);
    $contenedor.find("#HoraId").val(horario);
    $contenedor.find("#IdiomaId").val(idioma);

    // Tarifa y precio total según servicio y plazas de adulto
    jQuery
        .ajax({
            type     : "POST",
            dataType : "json",
            url      : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/reserva_web/total_precio_tarifa.php",
            data     : {
                servicio : servicio,
                tarifas  : tarifas,
                lista    : lista,
            },
            cache: false,
        })
        .done(function (tarifa) {
            $contenedor.find("#Plazas").val(parseInt(tarifa.num));
            $contenedor.find("#PrecioTotal").val(tarifa.total);
        });
}
