/***********************************************************************
 * Función que bloquea días ocupados, fechas inferiores a la actual,
 *  la actual y la del días siguiente
 **********************************************************************/
function DiasBloqueados(date) {
  // Si no hay datos seleccionados bloqueo todo el calendario
  if (fechas_bloquear.length == 0) {
    return [false, "dia_nodisponible"];
  } else {
    // Año
    var anio = date.getFullYear();
    // Mes
    if (date.getMonth() + 1 < 10) {
      var mes = 0 + "" + (date.getMonth() + 1);
    } else {
      var mes = date.getMonth() + 1;
    }
    // Día
    if (date.getDate() < 10) {
      var dia = 0 + "" + date.getDate();
    } else {
      var dia = date.getDate();
    }
    // BLOQUEO FECHAS OCUPADAS SI LAS HAY
    if (fechas_bloquear.length > 1) {
      for (i = 1; i < fechas_bloquear.length; i++) {
        //if(jQuery.inArray(anio + '-' + mes + '-' + dia, fechas_bloquear) != -1)
        if (anio + "-" + mes + "-" + dia == fechas_bloquear[i]) {
          return [false, "dia_nodisponible"];
        }
      }
    }
    // BLOQUEO FECHAS SUPERIORES A LOS DÍAS DEL SERVICIO SELECCIONADO
    fecha_maxima = new Date();
    tiempo       = fecha_maxima.getTime();
    milisegundos = parseInt(dias * 24 * 60 * 60 * 1000);
    total        = fecha_maxima.setTime(tiempo + milisegundos);
    if (date > fecha_maxima) {
      return [false, "dia_nodisponible"];
    }
    return [true, "dia_disponible"];
  }
}
/************************************************************************
 * Función para hacer el cambio de opciones según la fecha seleccionada
 * Cambio de horas y compruebo si en esas horas hay plazas disponibles
 * según las marcadas (por si ha seleccionado primero las plazas y luego
 * las fechas y horarios)
 * *********************************************************************/
function cambioOpcionesFechas(fecha) {
  // Select de fechas oculto
  var jQueryfecha = jQuery("#Fechas");  
  var idFecha     = fecha.value; //Fecha seleccionada  
  var actividad   = jQuery("#actividadSeleccionada").val(); //Actividad seleccionada
  if (jQuery("#Idioma").length) {
    var idioma = jQuery("#Idioma").val();
  } else {
    var idioma = "";
  }

  // Obtengo el id del horario buscando en el select oculto la fecha
  // seleccionada en el calendario
  idFecha = jQueryfecha.find("option:contains(" + fecha.value + ")").val();
  // Marco id del horario de la fecha seleccionada en el select oculto
  // para poder obtenerlo en el primer paso de la compra
  // Valor de fecha para modificación en valle e instalaciones
  jQuery("#fecha_valle").val(idFecha);
  jQuery("#fecha_instalaciones").val(idFecha);
  // Instalación seleccionada
  if (jQuery("#instalacionSeleccionada").val() == null) {
    var instalacion = jQuery("#Instalaciones").val();
  } else {
    var instalacion = jQuery("#instalacionSeleccionada").val();
  }
  // Servicio seleccionado
  if (jQuery("#ServiciosValle").val() == null) {
    if (jQuery("#servicioSeleccionado").val() == null) {
      var servicio = jQuery("#Servicios").val();
    } else {
      var servicio = jQuery("#servicioSeleccionado").val();
    }
  } else {
    var servicio = jQuery("#ServiciosValle").val();
  }
  // Usuarios seleccionados
  if (document.getElementById("spinner")) {
    var usuarios = jQuery("#spinner").val();
  } else {
    if (document.getElementById("spinner_cambioopcion")) {
      var usuarios = jQuery("#spinner_cambioopcion").val();
    } else {
      var usuarios = jQuery("#Plazas").val();
    }
  }
  // Cuando no hay fechas de la seleccionada en el calendario
  if (typeof idFecha == "undefined") {
    jQuery("#Horas").html(
      "<option>" + funciones_textos['texto_1'] + "</option>"
    );
  } else {
    // HORAS
    // Horas de la primera fecha de la lista del servicio seleccionado
    jQuery.ajax({
      type : "POST",
      url  : "//" + location.host + "/wp-content/plugins/visitas/modules/visitas/reservas/ajax/horas.php",
      data : {
        instalacionServicio   : instalacion,
        actividadSeleccionada : actividad,
        servicioFecha         : servicio,
        fecha                 : idFecha,
        usuarios              : usuarios,
        idioma                : idioma,
        horaSelected          : jQuery('#FechaAnterior').val()
      },
      beforeSend: function() {
        jQuery("#Horas").html('<option selected="selected" value="0">' + funciones_textos['texto_0'] + '</option>');
      },
      success: function(response) {
        jQuery("#Horas").html(response);
        jQuery("#HorasValle").html(response);
        jQuery("#HorasInstalaciones").html(response);
        jQuery("#OpcionesMarcadas").html(
          '<input type="hidden" id="actividadSeleccionada" name="actividadSeleccionada" value="' +
            actividad +
            '"><input type="hidden" id="instalacionSeleccionada" value="' +
            instalacion +
            '"><input type="hidden" id="servicioSeleccionado" value="' +
            servicio +
            '"><input type="hidden" id="fechaSeleccionada" name="fechaSeleccionada" value="' +
            idFecha +
            '">'
        );
      }
    });
  }
}

function _parseInputHidden(data) {
  var dom = "";
  jQuery.each(data, function(i, v) {
    dom += '<input type="hidden" name="' + i + '" value="' + v + '"/>';
  });
  return dom;
}

function _parseInputRadio(data) {
  var dom = '<div class="radios">',
    info;
  jQuery.each(data, function(i, v) {
    info =
      v.instalacion_nombre +
      ", " +
      v.actividad_nombre +
      ", " +
      v.fecha_inicio +
      " " +
      v.hora_inicio;
    dom +=
      '<div><input type="radio" name="localizador" value="' +
      v.localizador +
      '" data-sala-horario-id="' +
      v.fecha +
      '"/> ' +
      info +
      "</div>";
  });
  dom += "</div>";
  return dom;
}
