
/******************************************************************************
 * Muestra precio de la tarifa del usuario elegida en el carrito
*******************************************************************************/
function cambioPrecioTarifa(idTarifa, cambio)
{	
	var tarifa        = idTarifa.value;           // Tarifa seleccionada
	var plazas_adulto = jQuery('#PlazasAdulto').val(); // Número usuarios
		
	// Si se cambia el número de usuarios
	if(cambio == 'usuarios'){
		var tarifa = jQuery('#tarifausuario').val();
	}
	
	// Precio de la tarifa seleccionada
	jQuery.ajax({
		type : 'POST',
		url  : '//'+ location.host +'/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/tarifas_usuario.php',
		data : { 
			"tarifa"        : tarifa,
			"plazas_adulto" : plazas_adulto,
			"cambio"        : cambio,
			"login"         : 0
		},
		beforeSend: function () {

		},
		success: function(precio){ 
			
			// No me ha devuelto precio no muestro €
			var euro = ' €';
			if(precio.length == 2){
				var euro = '';
			}
			
			jQuery('#TotalPrecio').html(precio + euro);
			jQuery('#PrecioAdulto').html(precio + euro);
			jQuery("#TotalCarrito").val(precio);

		}
	});
}

/******************************************************************************
 * Actualiza el número de plazas según la selección de usuarios
*******************************************************************************/
function cambioPlazas(plazas){	
	var plazas_totales = parseInt(jQuery('#PlazasAdulto').val()) + parseInt(jQuery('#PlazasInfantil').val());
	jQuery('#NumeroUsuarios').val(plazas_totales);
}


/***********************************************************************
 * Comprueba si la tarifa seleccionada es de personal, en cuyo caso muestra
 * el formulario de logeo de personal para validarlo
 ***********************************************************************/
function tipoTarifa(idTarifa){
	var tarifa = idTarifa.value; //Tarifa seleccionada
	
	// Para pistas servicio comprado
	if(jQuery("#IdServicioCompra").val() != ''){
		var idServicio = jQuery("#IdServicioCompra").val();
	}
	// Instalaciones, el servicio comprado es igual al reservado
	else{
		var idServicio = jQuery("#idServicio").val();
	}	
	
	// Se ha seleccionado tarifa
	if(tarifa.length > 0)
	{
		jQuery.ajax({
			type     : 'POST',
			url      : '//'+ location.host +'/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/tipoTarifa.php',
			dataType : 'json',
			data     : { 
				"tarifa"   : tarifa,
				"servicio" : idServicio
			},
			cache: false
		
		}).done(function(personal) { 
		
			// Si es tarifa especial muestro formulario para valiación
			// de usuario especiales
			if(personal.especial == 1){				
			
				// Muestro formulario de validación
				div               = document.getElementById("ValidacionPersonal");
				div.style.display = "";
				
				jQuery('#ValidarTarifaEspecial').show();
								
				// Dejo valores en vacío
				jQuery("#EspecialValidado").val(0);
				jQuery("#nombre").val('');
				jQuery("#apellidos").val('');
				jQuery("#telefono").val('');
				jQuery("#email").val('');
				jQuery("#UserPersonal").val('');
				jQuery("#PassPersonal").val('');
				jQuery('#MensajeValidacionPersonal').html('');
				
				// Compruebo plantilla a cargar
				jQuery.ajax({
					type : 'POST',
					url  : '//'+ location.host +'/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/plantilla_login_especial.php',
					data : { 
						"tarifa"   : tarifa,
						"servicio" : idServicio
					},
					cache: false
				
				}).done(function(plantilla) { 
					// Muestro formulario de validación
					div               = document.getElementById("ValidacionPersonal");
					div.style.display = "";
					
					jQuery('#ValidacionPersonal').html(plantilla);
				});
										
			}
			else
			{
				// Oculto mensaje de validación
				div               = document.getElementById("MensajeValidacionPersonal");
				div.style.display = "none";
				
				// Oculto formulario de validación
				div               = document.getElementById("ValidacionPersonal");
				div.style.display = "none";
				
				// Oculto input de validación
				jQuery('#ValidarTarifaEspecial').hide();				
			}
		});
	}
}


/**********************************************************************
 * Función que actualiza las formas de pago según el grupo seleccionado
 * Puede tener descuento distinto
 **********************************************************************/
function actualizaFormasPago(tarifa_id){
	
	var tarifa = tarifa_id.value;
	
	// Por si viene de la selección de plazas de adulto
	if(typeof tarifa == 'undefined'){
		tarifa = tarifa_id
	}
	
	var usuarios = jQuery('#NumeroUsuarios').val();
	var servicio = jQuery('#idServicio').val();
		
	// Se ha seleccionado tarifa
	if(tarifa.length > 0){
		// Formas de pago para el servicio y grupo seleccionado
		jQuery.ajax({
			type : 'POST',
			url  : '//'+ location.host +'/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/formas_pago.php',
			data : { 
				"tarifa"   : tarifa,
				"servicio" : servicio,
				"usuarios" : usuarios
			},
			cache: false
		
		}).done(function(formaspago) {			
			jQuery('#FormasPago').html(formaspago);			
		});
	}
}

/***********************************************************************
 * Función que cambia que marca el grupo de tarifa correspondiente según
 * el número de plazas de adulto seleccionadas
 * *********************************************************************/
function cambiaGrupoTarifa(plazas_adulto){
	
	var plazas_adulto = plazas_adulto.value;
	var servicio      = jQuery('#idServicio').val();
	
	jQuery.ajax({
		type : 'POST',
		url  : '//'+ location.host +'/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/marcar_grupo_tarifa.php',
		data : { 
			"usuarios" : plazas_adulto,
			"servicio" : servicio
		},
		cache: false
	
	}).done(function(grupo_tarifa) { 
		
		// Marco grupo de tarifa correspondiente
		jQuery("#tarifausuario").find('option').each( function() {
			if (parseInt(jQuery(this).val()) == parseInt(grupo_tarifa)){
				jQuery(this).attr("selected","selected");
				// Actualizo también formas de pago por si al cambiar el grupo
				// de la tarifa éste tiene distintas formas de pago
				actualizaFormasPago(grupo_tarifa);
			} 
		});	
	});	
}

/***********************************************************************
 * Función que actualiza el número de plazas al mínimo posible 
 * según el grupo de tarifa seleccionada, 
 * sólo para los casos que no sea tarifa especial
 * Si es especial dejo el número que estaba
 ***********************************************************************/
function cambiaPlazasAdulto(tarifa_id)
{
	var tarifa        = tarifa_id.value;
	var plazas_adulto = jQuery('#PlazasAdulto').val();
	
	if(tarifa.length > 0){
		jQuery.ajax({
			type : 'POST',
			url  : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/comprar/minimo_plazas_adulto.php',
			data : { 
				"tarifa"        : tarifa,
				"plazas_adulto" : plazas_adulto
			},
			cache: false
		
		}).done(function(plazas_adulto) { 
			
			// Marco grupo de tarifa correspondiente
			jQuery("#PlazasAdulto").find('option').each( function() {
				if (parseInt(jQuery(this).val()) == parseInt(plazas_adulto)){
					jQuery(this).attr("selected","selected");					
				}	 
			});		
		});
	}	
}

/******************************************************************************
 * Proceso Modificación, al seleccionar la reserva a modificar
 * Obtiene id del servicio de la reserva seleccionada
 * Comprueba que el servicio de la reserva es de horas valle
 * Si el servicio de la reserva es de horas valle oculta las opciones de
 *  modificación generales (opciones_modificacion) para mostrar las del servicio 
 *  de la reserva seleccionada (opciones_modificacion_valle)
*******************************************************************************/
function idServicioReserva(idReserva){	
	var reserva     = idReserva.value;
	var localizador = jQuery("#Localizador").val();

	// Compruebo servicio de la reserva (en horas valle es distinto al del 
	// localizador o las distintas reservas que existan pueden ser de 
	// distintos servicios)
	jQuery.ajax({
		type     : 'POST',
		url      : '//' + location.host + '/wp-content/plugins/visitas/modules/visitas/reservas/ajax/modificar/servreserva_seleccionada.php',
		dataType : 'json',
		data     : {  
			"reserva"     : reserva,
			"localizador" : localizador
		},
		cache    : false
		
	}).done(function(servicio_instalacion) { 	
					
	});
}

/******************************************************************************
 * Proceso Anulación, al seleccionar la reserva a anular
 * Obtiene id del servicio de la reserva seleccionada
 * En servicio de horas valle y pistas podemos tener reservas a anular de 
 *  distintos servicios
*******************************************************************************/
function idServicioAnulacion(idReserva){
	var reserva     = idReserva.value;
	var localizador = jQuery("#Localizador").val();
	
	// Compruebo servicio de la reserva (en horas valle es distinto al del 
	// localizador o las distintas reservas que existan pueden ser de 
	// distintos servicios)
	jQuery.ajax({
		type     : 'POST',
		url      : '//'+ location.host +'/wp-content/plugins/visitas/modules/visitas/reservas/ajax/modificar/servreserva_seleccionada.php',
		dataType : 'json',
		data: {  
			"reserva"     : reserva,
			"localizador" : localizador
		},
		cache    : false
		
	}).done(function(servicio) { 		
		jQuery("#ServicioId").val(servicio.servicio);		
	});
}
