
jQuery(function() {

	if ( jQuery("#FormSolicitudFactura").length ) {
				
		// Antes de hacer el submit del formulario compruebo que todo está
		// rellenado
		var FormSolicitud   = jQuery('#FormSolicitudFactura'),
		    SolicitudAction = FormSolicitud.attr('action');
		FormSolicitud.removeAttr('action');
		
		// Compruebo si faltan por rellenar campos extras
		var servicio_id = jQuery('#ServicioId').val();
		var localizador = jQuery('#Localizador').val();
		
		jQuery.ajax({
			type     : 'POST',
			dataType : 'json',
			url      : '//'+ location.host +'/wp-content/plugins/visitas/modules/visitas/reservas/ajax/factura/campos_extra.php',
			data     :{
				"servicio_id" : servicio_id,
				"localizador" : localizador
			}
		}).done(function(data){ 
			
			// Recorremos el array de campos extras
			for(i = 0; i < data.length; i++){				
				// Obtenemos los valores necesarios
				campo_id   = data[i][0];
				input_name = "input[name='campos_extra["+campo_id+"]']";
				
				jQuery(input_name).rules( "add", {
					  required : true,
					  messages : {
						required: "El campo es obligatorio"
					  }
				}); 	
			}
		});
				
		// Valido que si faltan datos estén todos introducidos
		jQuery("#FormSolicitudFactura").validate({
			rules    : {
				email   : { 
					required  : true, 
					minlength : 2, 
					email     : true}
			},
			messages : {
				email   : "El campo email es obligatorio."
			},
			errorPlacement: function(error, element) {
				if (element.attr("name").contains("[]"))
				{
					error.insertAfter(element.parent());
				}   
				else 
				{
					error.insertAfter(element);
				}
						
			},
			submitHandler: function(FormSolicitud) {
				FormSolicitud.setAttribute('action', SolicitudAction)
				FormSolicitud.submit();
			}
		});						
	}	
});
