async function GooglePay(buttonEl) {
  const paymentRequest = window.payments.paymentRequest(
    // Use global method from sq-payment-flow.js
    window.getPaymentRequest()
  );
  const googlePay = await payments.googlePay(paymentRequest);
  await googlePay.attach(buttonEl);

  async function eventHandler(event) {
    // Clear any existing messages
    window.paymentFlowMessageEl.innerText = '';

    try {
      const result = await googlePay.tokenize();
      if (result.status === 'OK') {
        // Use global method from sq-payment-flow.js
        window.createPayment(result.token);
      } else {
        window.paymentCanceled();
      }
    } catch (e) {
      if (e.message) {
        //window.showError(`Error: ${e.message}`);
        window.showError(`Error: No se ha podido completar el pago con Google Pay`);
      } else {
        window.showError('Se ha producido un error al procesar el pago con Google Pay');
      }
    }
  }

  buttonEl.addEventListener('click', eventHandler);
}
