async function SquarePaymentFlow() {

  // Create card payment object and attach to page
  //CardPay(document.getElementById('card-container'), document.getElementById('card-button'));

  // Create Apple pay instance
  if (fnBrowserDetect() != 'safari' ) {
    const applePayMethod = document.getElementsByClassName('radio pago apple_pay');
    if( applePayMethod !== undefined ){
      applePayMethod[0].remove();
    }
  }else{
    ApplePay(document.getElementById('apple-pay-button'));
  }

  // Create Google pay instance
  GooglePay(document.getElementById('google-pay-button'));

  // Create ACH payment
  //ACHPay(document.getElementById('ach-button'));
}

function fnBrowserDetect(){
                        
  let userAgent = navigator.userAgent;
  let browserName;
  
  if(userAgent.match(/chrome|chromium|crios/i)){
      browserName = "chrome";
  }else if(userAgent.match(/firefox|fxios/i)){
      browserName = "firefox";
  }  else if(userAgent.match(/safari/i)){
      browserName = "safari";
  }else if(userAgent.match(/opr\//i)){
      browserName = "opera";
  } else if(userAgent.match(/edg/i)){
      browserName = "edge";
  }else{
      browserName="No browser detection";
  }
  
  return browserName;
}

window.payments = Square.payments(window.applicationId, window.locationId);

window.paymentFlowMessageEl = document.getElementById('payment-flow-message');

window.showSuccess = function(message) {
  window.paymentFlowMessageEl.classList.add('success');
  window.paymentFlowMessageEl.classList.remove('error');
  window.paymentFlowMessageEl.innerText = message;
}

window.showError = function(message) {
  window.paymentFlowMessageEl.classList.add('error');
  window.paymentFlowMessageEl.classList.remove('success');
  window.paymentFlowMessageEl.innerText = message;
}

// Hardcoded for testing purpose, only used for Apple Pay and Google Pay
window.getPaymentRequest = function() {

  const total = document.querySelector('#total_compra');

  return {
    countryCode: window.country,
    currencyCode: window.currency,
    // lineItems: [
    //   { amount: '1.23', label: 'Cat', pending: false },
    //   { amount: '4.56', label: 'Dog', pending: false },
    // ],
    // requestBillingContact: false,
    // requestShippingContact: true,
    // shippingContact: {
    //   addressLines: ['123 Test St', ''],
    //   city: 'San Francisco',
    //   countryCode: 'US',
    //   email: 'test@test.com',
    //   familyName: 'Last Name',
    //   givenName: 'First Name',
    //   phone: '1111111111',
    //   postalCode: '94109',
    //   state: 'CA',
    // },
    // shippingOptions: [
    //   { amount: '0.00', id: 'FREE', label: 'Free' },
    //   { amount: '9.99', id: 'XP', label: 'Express' },
    // ],

    total: { amount: total.value, label: 'Total', pending: false },
  };
};

SquarePaymentFlow();
