<?php
    /**
     * CecaTpv class. Generic Ceca TPV class
     *
     * @author Imanol Urra
     * @version 1.0
     * @copyright JIG.ES 2013
     */

    class CecaTpv {
        protected $Server        = 'https://pgw.ceca.es/cgi-bin/tpv';
        protected $Clave;
        protected $MerchantID;
        protected $AcquirerBIN;
        protected $TerminalID;

        protected $TipoMoneda    = 978;
        protected $Exponente     = 2;

        protected $Cifrado        = 'SHA2';
        protected $Pago_soportado = 'SSL';

        protected $URL_OK;
        protected $URL_NOK;

        protected $Firma;
        protected $Referencia;
        protected $Importe        = 0;
        protected $Num_operacion  = 0;
        protected $Tipo_operacion = 'C';
        protected $inicioBizum    = 0;
       
        /**
         * Contructor
         * @param settings (Array). Configuracion de TPV 
         *        siendo oblicados a ser enviados Clave de encriptacion, MerchantID, AcquirerBin, TerminalID, URL_OK y URL_NOK
         */
        public function __construct($settings = null) {
            if ( !is_array($settings) )  throw new Exception("Ceca TPV error: bad settings array in __construct method", 1);
            
            foreach ($settings as $key => $value) {
                if ( property_exists($this, $key) && $key !== 'Firma' ) {
                    $this->$key = $value;
                }
            }

            $this->Firma = $this->_firma();
        }

        /**
         * Check: Comprueba si la firma recivida coincide con la enviada.
         * @param options (Array). Las opciones enviadas a la TVP como Importe, Num_operacion y la firma
         * @return (Bool) True or false
         */
        public function check($options = array()) {
            $this->__construct(array_merge(get_object_vars($this), $options));

            return ($options['Firma'] == $this->_FirmaCeca()) ? true : false;
        }

        /**
         * Check: Comprueba si la firma recivida coincide con la enviada.
         * @param title (String). Titulo personalizado del boton.
         * @param options (Array) . Configuracion de la TPV(Opcional), mas el Importe(Obligatorio) y Num_operacion(Obligatorio)
         * @return (String) HTML del formulario para realizar el pago con CecaTpv
         */
        public function button($title = 'Comprar', $options = array()) {
            $this->__construct(array_merge(get_object_vars($this), $options));
            $submitClass = $options['class'] ? $options['class'] : '';
            
            $options = get_object_vars($this);

            $html = $this->_formStart($this->Server);
            unset($options['Clave'], $options['Server'], $options['Referencia'], $options['class']);

            foreach ( $options as $key => $value ) {
                $html .= $this->_hidden($key, $value);
            }

            $html .= $this->_submit($title, $submitClass);
            $html .= $this->_formEnd();

            return $html;
        }

        /**
         * Devuelve el string con el html del elemento de un formulario formado
         */
        private function _formStart($action, $type = 'post') {
            return '<form action="'. $action .'" method="'. $type .'" id="CecaTpv" name="CecaTpv">';
        }

        /**
         * Devuelve el string con el cierre del elemento del formulario
         */
        private function _formEnd() {
            return '</form>';
        }

        /**
         * Devuelve el string con el html de un elemento input hidden
         */
        private function _hidden($name, $value) {
            return '<input type="hidden" name="'. $name .'" value="'. $value .'" />';
        }

        /**
         * Devuelve el string con el boton para enviar el formulario a la pasarela de pago
         */
        private function _submit($title, $class = '') {
            return '<input type="submit" value="'. $title .'" class="btn-right btn-outline-black  '. $class .'"/>';
        }

        /**
         * Devuelve el string con la firma codificada con SHA1 para ser enviada a la TPV
         */
        private function _firma() {
            // return sha1(
            //         $this->Clave . $this->MerchantID . $this->AcquirerBIN . $this->TerminalID .
            //         $this->Num_operacion . $this->Importe . $this->TipoMoneda . $this->Exponente .
            //         $this->Cifrado . $this->URL_OK . $this->URL_NOK
            // );

            return hash('sha256',
                $this->Clave . $this->MerchantID . $this->AcquirerBIN . $this->TerminalID .
                $this->Num_operacion . $this->Importe . $this->TipoMoneda . $this->Exponente .
                $this->Cifrado . $this->URL_OK . $this->URL_NOK
            );
        }
        
        /**
         * Devuelve el string con los datos devueltos  codificada con SHA1 para ser enviada a la TPV
         */
        private function _firmaCeca() {
            //Clave_encriptacion+MerchantID+AcquirerBIN+TerminalID+Num_operacion+Importe+TipoMoneda+Exponente+Referencia
            // return sha1(
            //         $this->Clave . $this->MerchantID . $this->AcquirerBIN . $this->TerminalID .
            //         $this->Num_operacion . $this->Importe . $this->TipoMoneda . $this->Exponente .
            //         $this->Referencia
            // );
            return hash('sha256',
                $this->Clave . $this->MerchantID . $this->AcquirerBIN . $this->TerminalID .
                $this->Num_operacion . $this->Importe . $this->TipoMoneda . $this->Exponente .
                $this->Referencia
            );
        }

        /**
         * UNICAMENTE PARA DEBUG
         * Devuelve la firma generada
         */
        public function firma() {
            return $this->Firma;
        }
    }
?>