<?php

class PaypalVisitas
{

    protected $Server = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
    protected $Cmd    = '_cart';
    protected $Business;
    protected $Item_name;
    protected $Amount;
    protected $Currency_code = "EUR";
    protected $No_shipping   = 1;

    protected $Return;
    protected $Cancel_return;

    protected $Invoice;
    protected $Notify_url;

    protected $Quantity;
    protected $Upload;

    /**
     * Contructor
     * @param settings (Array). Configuración de TPV
     *        siendo oblicados a ser enviados Clave de encriptacion, MerchantID, AcquirerBin, TerminalID, URL_OK y URL_NOK
     */
    public function __construct($settings = null)
    {
        if (!is_array($settings)) {
            throw new Exception("Paypal.Class error: bad settings array in __construct method", 1);
        }

        foreach ($settings as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;

                if ($key == 'Server' && strpos($value, '/cgi-bin/webscr') === false) {
                    $this->$key = $value . '/cgi-bin/webscr';
                }
            }
        }
    }

    /**
     * Check: Comprueba si la firma recibida coincide con la enviada.
     * @param title (String). Título personalizado del botón.
     * @param options (Array) . Configuración de la TPV(Opcional), mas el Importe(Obligatorio) y Num_operacion(Obligatorio)
     * @return (String) HTML del formulario para realizar el pago con CecaTpv
     */

    public function button($title = 'Comprar', $options = array(), $items = array())
    {
        $this->__construct(array_merge(get_object_vars($this), $options));
        $submitClass = $options['class'] ? $options['class'] : '';

        $options = get_object_vars($this);

        foreach ($items as $num => $item) {
            foreach ($item as $key => $value) {
                $options[$key . '_' . ($num + 1)] = $value;
            }
        }

        $html = $this->_formStart($this->Server);
        unset($options['Server'], $options['class']);

        foreach ($options as $key => $value) {
            if ($value != '') {
                $html .= $this->_hidden(strtolower($key), $value);
            }

        }

        $html .= $this->_submit($title, $submitClass);
        $html .= $this->_formEnd();

        return $html;
    }

    // Devuelve el string con el html del elemento de un formulario formado
    private function _formStart($action, $type = 'post')
    {
        return '<form action="' . $action . '" method="' . $type . '" id="Paypal" name="Paypal">';
    }

    // Devuelve el string con el cierre del elemento del formulario
    private function _formEnd()
    {
        return '</form>';
    }

    // Devuelve el string con el html de un elemento input hidden
    private function _hidden($name, $value)
    {
        return '<input type="hidden" name="' . $name . '" value="' . $value . '" />';
    }

    // Devuelve el string con el botón para enviar el formulario a la pasarela de pago
    private function _submit($title, $class = '')
    {
        return '<div class="divider-input"><input type="submit" value="' . $title . '" class="' . $class . '"/></div>';
    }
}
