<?php
/**
 * Redsys class. Generic Redsys TPV class
 *
 * @author Imanol Urra
 * @version 1.0
 * @copyright JIG.ES 2014
 */

class Redsys
{
    protected $Server = 'https://sis-t.sermepa.es:25443/sis/realizarPago';
    protected $Key;
    protected $Ds_Merchant_MerchantCode;
    protected $Ds_Merchant_Terminal;

    protected $Ds_Merchant_Currency         = 978;
    protected $Ds_Merchant_ConsumerLanguage = 1;

    protected $Ds_Merchant_TransactionType = 0;

    protected $Ds_Merchant_UrlOK;
    protected $Ds_Merchant_UrlKO;
    protected $Ds_Merchant_MerchantURL;

    protected $Ds_Merchant_MerchantSignature;
    protected $Ds_Merchant_Response;

    protected $Ds_Merchant_Amount = 0;
    protected $Ds_Merchant_Order  = 0;
    protected $Ds_Merchant_ProductDescription;
    protected $Ds_Merchant_MerchantName;
    protected $Ds_Merchant_SumTotal;
    protected $Ds_Merchant_MerchantData;
    protected $Ds_Merchant_DateFrecuency;
    protected $Ds_Merchant_ChargeExpiryDate;
    protected $Ds_Merchant_AuthorisationCode;
    protected $Ds_Merchant_TransactionDate;

    /**
     * Contructor
     *
     * @param settings (Array). Configuracion de TPV
     *                 siendo oblicados a ser enviados Clave de encriptacion, MerchantID, AcquirerBin, TerminalID, URL_OK y URL_NOK
     *
     * @throws Exception
     */
    public function __construct($settings = null)
    {
        if (!is_array($settings)) {
            throw new Exception("Redsys error: bad settings array in __construct method", 1);
        }

        foreach ($settings as $key => $value) {
            if (property_exists($this, $key) && $key !== 'Firma') {
                $this->$key = $value;
            }
        }

        $this->Ds_Merchant_MerchantSignature = $this->_firma();
    }

    /**
     * Check: Comprueba si la firma recibida coincide con la enviada.
     *
     * @param array $options
     *
     * @throws Exception
     * @internal param $options (Array). Las opciones enviadas a la TVP como Importe, Num_operacion y la firma
     * @return bool (Bool) True or false
     */
    public function check($options = array())
    {
        $this->__construct(array_merge(get_object_vars($this), $options));

        return ($options['Ds_Merchant_MerchantSignature'] == $this->_firmaRedsys()) ? true : false;
    }

    /**
     * Check: Comprueba si la firma recivida coincide con la enviada.
     *
     * @param string $title
     * @param array  $options
     *
     * @throws Exception
     * @internal param $title (String). Titulo personalizado del boton.
     * @internal param $options (Array) . Configuracion de la TPV(Opcional), mas el Importe(Obligatorio) y Num_operacion(Obligatorio)
     * @return string (String) HTML del formulario para realizar el pago con CecaTpv
     */
    public function button($title = 'Comprar', $options = array())
    {
        //Multiplicamos el amount por 100
        if ($options['Ds_Merchant_Amount'] && !empty($options['Ds_Merchant_Amount'])) {
            $options['Ds_Merchant_Amount'] *= 100;
        }

        $this->__construct(array_merge(get_object_vars($this), $options));
        $submitClass = $options['class'] ? $options['class'] : '';

        $options = get_object_vars($this);

        $html = $this->_formStart($this->Server);

        // Borramos datos
        unset($options['Key'], $options['Server'], $options['class']);
        foreach ($options as $key => $value) {
            if (!isset($options[$key])) {
                unset($options[$key]);
            }
        }

        foreach ($options as $key => $value) {
            $html .= $this->_hidden($key, $value);
        }

        $html .= $this->_submit($title, $submitClass);
        $html .= $this->_formEnd();

        return $html;
    }

    /**
     * Devuelve el string con el html del elemento de un formulario formado
     */
    private function _formStart($action, $type = 'post')
    {
        return '<form action="' . $action . '" method="' . $type . '" id="Redsys" name="Redsys">';
    }

    /**
     * Devuelve el string con el cierre del elemento del formulario
     */
    private function _formEnd()
    {
        return '</form>';
    }

    /**
     * Devuelve el string con el html de un elemento input hidden
     */
    private function _hidden($name, $value)
    {
        return '<input type="hidden" name="' . $name . '" value="' . $value . '" />';
    }

    /**
     * Devuelve el string con el boton para enviar el formulario a la pasarela de pago
     */
    private function _submit($title, $class = '')
    {
        return '<input type="submit" value="' . $title . '" class="' . $class . '"/>';
    }

    /**
     * Devuelve el string con la firma codificada con SHA1 para ser enviada a la TPV
     */
    private function _firma()
    {
        // Ds_Merchant_Amount + Ds_Merchant_Order +Ds_Merchant_MerchantCode +
        // DS_Merchant_Currency + Ds_Merchant_SumTotal + Ds_Merchant_TransactionType +
        // Ds_Merchant_MerchantURL + CLAVE SECRETA

        return strtoupper(sha1(
            $this->Ds_Merchant_Amount . $this->Ds_Merchant_Order . $this->Ds_Merchant_MerchantCode .
            $this->Ds_Merchant_Currency . $this->Ds_Merchant_SumTotal . $this->Ds_Merchant_TransactionType .
            $this->Ds_Merchant_MerchantURL . $this->Key
        ));
    }

    /**
     * Devuelve el string con los datos devueltos codificada con SHA1
     */
    private function _firmaRedsys()
    {
        // Ds_ Amount + Ds_ Order + Ds_MerchantCode + Ds_Currency + Ds_Response + CLAVE SECRETA

        return strtoupper(sha1(
            $this->Ds_Merchant_Amount . $this->Ds_Merchant_Order . $this->Ds_Merchant_MerchantCode .
            $this->Ds_Merchant_Currency . $this->Ds_Merchant_Response . $this->Key
        ));
    }

    /**
     * UNICAMENTE PARA DEBUG
     * Devuelve la firma generada
     */
    public function firma()
    {
        return $this->Ds_Merchant_MerchantSignature;
    }
}
