<?php

// Set flag that this is a parent file.
/*define('_JEXEC', 1);
define('DS', DIRECTORY_SEPARATOR);

if (file_exists(dirname(__FILE__) . '/defines.php')) {
include_once dirname(__FILE__) . '/defines.php';
}

if (!defined('_JDEFINES')) {
define( 'JPATH_BASE', realpath(dirname(__FILE__) .'/../../' ) );
require_once JPATH_BASE.'/includes/defines.php';
}

require_once JPATH_BASE.'/includes/framework.php';*/

//Clase para traducción
class lang
{

    private $lang        = null;
    private $con         = null;
    private $session     = null;
    private $module_type = 'reservas';

    //Constructor
    public function __construct()
    {
        $this->con  = new SPDO(BDENGINE, BDHOST, BDDATABASE, BDUSER, BDPASS);
        $this->lang = 'es_ES';

    }

    //Función que obtiene el idioma del Navegador
    public function getLangNavegador()
    {
        $lang_nav = '';
        if (!isset($session_lang) || (isset($session_lang) && $this->urlLangHasChanged($session_lang))) {
            $lang_nav = $this->getURLLang();
        } else {
            $lang_nav = $session_lang;
        }

        switch ($lang_nav) {
            case ($lang_nav == 'es' || $lang_nav == 'es_ES'):
                $lang_nav = 'es_ES';
                break;
            case ($lang_nav == 'en' || $lang_nav == 'en_GB'):
                $lang_nav = 'en_GB';
                break;
            case ($lang_nav == 'fr' || $lang_nav == 'fr_FR'):
                $lang_nav = 'fr_FR';
                break;
            case ($lang_nav == 'zh'):
                $lang_nav = 'en_GB';
                break;
            default:
                $lang_nav = 'es_ES';
                break;
        }

        // Compruebo si el idioma está: si no está traducido se pone uno por defecto
        $sql_idiomas = "SELECT *
                        FROM idiomas
                        WHERE iso_code like '" . $lang_nav . "'";

        $result_idiomas = $this->con->query($sql_idiomas);

        if ($result_idiomas->rowCount() == 0) {
            $lang_nav = 'es_ES';
        }

        $this->lang = $lang_nav;
        $this->setSessionLang($lang_nav);
        return $lang_nav;

    }

    //Función que me devuelve el id del idioma dado el iso_code
    public function getIdLang($iso_code)
    {

        if ($iso_code == 'es_ES.utf8') {
            $iso_code = 'es_ES';
        } else if ($iso_code == 'fr_FR.utf8') {
            $iso_code = 'fr_FR';
        } else if ($iso_code == 'en_GB.utf8') {
            $iso_code = 'en_GB';
        }

        //Obtengo iso code
        $sql_idiomas = "SELECT *
                        FROM idiomas
                        WHERE iso_code like '" . $iso_code . "'";

        $result_idiomas = $this->con->query($sql_idiomas);
        $idioma         = $result_idiomas->fetch();
        return $idioma['id'];

    }

    //Función que me devuelve el iso_code dado el id de idioma
    public function getIsoLang($idioma_id)
    {
        //Obtengo id idioma
        $sql_idiomas = "SELECT *
                        FROM idiomas
                        WHERE id = " . $idioma_id . "";

        $result_idiomas = $this->con->query($sql_idiomas);
        $idioma         = $result_idiomas->fetch();
        return $idioma['iso_code'];

    }

    // Función para traducir cadenas
    public function getString($str, $sesion = false)
    {
        if ($sesion) {
            $this->lang = $this->getIdLang($this->getSessionLang());
        } else {
            $this->lang = $this->getIdLang($this->getURLLang());
        }

        $sql = "SELECT DISTINCT(texto_lang)
                FROM i18_lang
                WHERE idioma = '" . $this->lang . "'
                AND texto_original = '" . $str . "'";

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();

            return $row['texto_lang'];
        }
        return $str;
    }

    // Función para traducir cadenas
    public function getStringLanguage($str, $idioma)
    {
        $sql = "SELECT DISTINCT(texto_lang)
                FROM i18_lang
                WHERE idioma = '" . $idioma . "'
                AND BINARY texto_original = '" . $str . "'";

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();
            return $row['texto_lang'];
        }
        return $str;
    }

    // Función para traducir todos los campos de un servicio
    public function getStringsProduct($product_id)
    {
        $this->lang = $this->getIdLang($this->getSessionLang());

        // Obtengo traducciones
        $sql = "SELECT *
                FROM products_lang
                WHERE idioma = '" . $this->lang . "'
                AND servicio_id = " . $product_id;

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();

            $textos['nombre']               = $row['nombre'];
            $textos['descripcion']          = $row['descripcion'];
            $textos['descripcion_breve']    = $row['descripcion_breve'];
            $textos['condiciones_servicio'] = $row['condiciones_servicio'];
            $textos['nota']                 = $row['nota'];

        } else {
            //Sino las hay, muestro las del servicio
            $sql = "SELECT *
                    FROM servicios
                    WHERE id = " . $product_id;

            $result = $this->con->query($sql);
            $row    = $result->fetch();

            $textos['nombre']               = $row['nombre'];
            $textos['descripcion']          = $row['descripcion'];
            $textos['descripcion_breve']    = $row['descripcion_breve'];
            $textos['condiciones_servicio'] = $row['condiciones_servicio'];
            $textos['condiciones_extra']    = $row['condiciones_extra'];
            $textos['nota']                 = $row['nota'];

        }

        return $textos;
    }

    public function getStringsProductLanguage($product_id, $language_id)
    {
        // Obtengo traducciones
        $sql = "SELECT *
                FROM products_lang
                WHERE idioma = '" . $language_id . "'
                AND servicio_id = " . $product_id;

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();

            $textos['nombre']               = $row['nombre'];
            $textos['descripcion']          = $row['descripcion'];
            $textos['descripcion_breve']    = $row['descripcion_breve'];
            $textos['condiciones_servicio'] = $row['condiciones_servicio'];
            $textos['nota']                 = $row['nota'];

        } else {
            //Sino las hay, muestro las del servicio
            $sql = "SELECT *
                    FROM servicios
                    WHERE id = " . $product_id;

            $result = $this->con->query($sql);
            $row    = $result->fetch();

            $textos['nombre']               = $row['nombre'];
            $textos['descripcion']          = $row['descripcion'];
            $textos['descripcion_breve']    = $row['descripcion_breve'];
            $textos['condiciones_servicio'] = $row['condiciones_servicio'];
            $textos['condiciones_extra']    = $row['condiciones_extra'];
            $textos['nota']                 = $row['nota'];

        }

        return $textos;
    }

    public function getStringsProductLanguage2($product_id, $language_id)
    {
        // Obtengo traducciones
        $sql = "SELECT *
                FROM products_lang
                WHERE idioma = '" . $language_id . "'
                AND servicio_id = " . $product_id;

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();

            $textos['nombre']               = $row['nombre'];
            $textos['descripcion']          = $row['descripcion'];
            $textos['descripcion_breve']    = $row['descripcion_breve'];
            $textos['condiciones_servicio'] = $row['condiciones_servicio'];
            $textos['condiciones_servicio'] = $row['condiciones_servicio'];
            $textos['condiciones_extra']    = $row['condiciones_extra'];
            $textos['nota']                 = $row['nota'];

        } else {

            $textos['nombre']               = '';
            $textos['descripcion']          = '';
            $textos['descripcion_breve']    = '';
            $textos['condiciones_servicio'] = '';
            $textos['nota']                 = '';

        }

        return $textos;
    }

    //Función que devuelve los archivos de un servicio según idioma
    public function getArchivesProduct($product_id)
    {

        $this->lang = $this->getIdLang($this->getSessionLang());
        $this->lang = 1;
        $archivos   = '';

        // Obtengo archivos del idioma
        $sql_archivos = "SELECT *
                         FROM servicio_archivos
                         WHERE servicio_id = " . $product_id . "
                         AND tipo = 'documento'
                         AND idioma_id = " . $this->lang;

        $result_archivos = $this->con->query($sql_archivos);

        if ($result_archivos->rowCount() > 0) {

            foreach ($result_archivos->fetchAll() as $row_archivo) {

                $archivo = array(
                    'nombre'  => $row_archivo['nombre'],
                    'archivo' => $row_archivo['archivo'],
                );

                $archivos[] = $archivo;
            }
        }

        return $archivos;
    }

    public function setSessionLang($lang)
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $_SESSION["visitas_lang"] = $lang;
    }

    public function getSessionLang()
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        return $_SESSION["visitas_lang"];
    }

    //No se usan
    public function urlLangHasChanged($past_lang)
    {
        if (!isset($past_lang) || $past_lang == '') {
            return false;
        }

        $_SERVER['REQUEST_URI_PATH'] = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $segments                    = explode('/', $_SERVER['REQUEST_URI_PATH']);
        $lang                        = $segments[SEGMENT_URL_LANG];

        switch ($lang) {
            case 'visitas':
                $lang = 'es_ES';
                break;
            case 'enoexperiencia':
                $lang = 'es_ES';
                break;
            case 'visits':
                $lang = 'en_GB';
                break;
            case 'enoexperience':
                $lang = 'en_GB';
                break;
            case 'visites':
                $lang = 'fr_FR';
                break;
            case 'enoexperience-fr':
                $lang = 'fr_FR';
                break;
            default:
                $lang = 'es_ES';
                break;
        }

        return $lang != $past_lang;

    }

    public function getURLLang()
    {

        $_SERVER['REQUEST_URI_PATH'] = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $segments                    = explode('/', $_SERVER['REQUEST_URI_PATH']);
        $lang                        = $segments[SEGMENT_URL_LANG];      
        switch ($lang) {
            case 'es':
                $lang = 'es_ES';
                break;
            case 'en':
                $lang = 'en_GB';
                break;
            case 'en/enoexperience':
                $lang = 'en_GB';
                break;
            case 'en/print_purchase':
                $lang = 'en_GB';
                break;
            case 'fr':
                $lang = 'fr_FR';
                break;
            case 'enoexperience':
                $lang = 'fr_FR';
                break;
            case 'fr/imprimer_lachat':
                $lang = 'fr_FR';
                break;
            default:
                $lang = 'es_ES';
                break;
        }

        return $lang;
    }
    public function getURLLangTest()
    {

        $_SERVER['REQUEST_URI_PATH'] = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $segments                    = explode('/', $_SERVER['REQUEST_URI_PATH']);
        $lang                        = $segments[SEGMENT_URL_LANG];

        return $lang;
    }

    public function getFormActionTranslation($action_name, $idioma = null)
    {

        if ($idioma == null) {
            $this->lang = $this->getIdLang($this->getURLLang());
        } else {
            $this->lang = $this->getIdLang($this->getSessionLang());
        }

        $sql = "SELECT DISTINCT(translation)
                FROM front_accion_formulario f
                JOIN front_accion_formulario_idioma i on i.id_front_accion_formulario = f.id_front_accion_formulario
                WHERE id_language = '" . $this->lang . "'
                AND f.name = '" . $action_name . "'
                AND module_type like '" . $this->module_type . "'
                LIMIT 1";

        //echo $sql;
        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();
            return $row['translation'];
        } else {
            return null;
        }

    }

    public function getLangPref()
    {
        return substr($this->getURLLang(), 0, 2);
    }

    // Función para traducir cadenas
    public function getStringProducto($str, $sesion = false)
    {
        if ($sesion) {
            $this->lang = $this->getIdLang($this->getSessionLang());
        } else {
            $this->lang = $this->getIdLang($this->getURLLang());
        }

        $sql = "SELECT DISTINCT(texto)
                FROM productos_lang
                JOIN productos on productos_lang.producto_id = productos.id
                WHERE productos_lang.idioma_id = '" . $this->lang . "'
                AND productos.nombre = '" . $str . "'";

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();
            return $row['texto'];
        }
        return $str;
    }

    // Función para traducir cadenas
    public function getStringCategoria($str, $sesion = false)
    {
        if ($sesion) {
            $this->lang = $this->getIdLang($this->getSessionLang());
        } else {
            $this->lang = $this->getIdLang($this->getURLLang());
        }

        $sql = "SELECT DISTINCT(texto)
                FROM categorias_lang
                JOIN categorias_productos on categorias_lang.categoria_id = categorias_productos.id
                WHERE categorias_lang.idioma_id = '" . $this->lang . "'
                AND categorias_productos.nombre = '" . $str . "'";

        $result = $this->con->query($sql);

        if ($result->rowCount() == 1) {
            $row = $result->fetch();
            return $row['texto'];
        }
        return $str;
    }
}
