<?php

//error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);
//date_default_timezone_set('Europe/Madrid');

//Convierte fecha mysql a normal
function cambiaf_a_normal($fecha)
{
    preg_match("/([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})/", $fecha, $mifecha);
    $lafecha = $mifecha[3] . "/" . $mifecha[2] . "/" . $mifecha[1];
    return $lafecha;
}

//Convierte fecha mysql a normal
function cambiaf_a_mysql($fecha)
{
    preg_match("/([0-9]{1,2})\/([0-9]{1,2})\/([0-9]{2,4})/", $fecha, $mifecha);
    $lafecha = $mifecha[3] . "-" . $mifecha[2] . "-" . $mifecha[1];
    return $lafecha;
}

//Función que genera el LOCALIZADOR
function generarLocalizador($longitud)
{
    $characters  = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $localizador = '';
    for ($i = 0; $i < $longitud; $i++) {
        $localizador .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $localizador;
}

//Función que devuelve los días de antelación a la reserva de un servicio
function diasAntelacionReserva($servicio)
{
    include $_SERVER['DOCUMENT_ROOT'] . '/wp-content/plugins/visitas/modules/visitas/reservas/principal_compra_reserva.php';

    $sql_dias = "SELECT s.antelacion_reserva, s.s_instalacion, s.pistas, i.nombre
                 FROM servicios s JOIN instalaciones i ON s.instalacion_id = i.id
                 AND s.id = " . $servicio;

    $result_dias = $conexion->query($sql_dias);

    if ($result_dias->rowCount() > 0) {
        $row_dias = $result_dias->fetch(PDO::FETCH_ASSOC);
    }

    return ($row_dias['antelacion_reserva']);

}

//Función que comprueba el día de la semana que es
function diaSemana($fecha)
{
    //Compruebo día de la semana en el que estoy
    $i          = strtotime($fecha);
    $dia_semana = jddayofweek(cal_to_jd(CAL_GREGORIAN, date("m", $i), date("d", $i), date("Y", $i)), 0);

    //Lunes
    if ($dia_semana == 1) {
        return 'L';
    }
    //Martes
    elseif ($dia_semana == 2) {
        return 'M';
    }
    //Miércoles
    elseif ($dia_semana == 3) {
        return 'X';
    }
    //Jueves
    elseif ($dia_semana == 4) {
        return 'J';
    }
    //Viernes
    elseif ($dia_semana == 5) {
        return 'V';
    }
    //Sábado
    elseif ($dia_semana == 6) {
        return 'S';
    }
    //Domingo
    elseif ($dia_semana == 0) {
        return 'D';
    }
}

//Función que comprueba el día de la semana que es y lo muestra completo
function diaSemanaCompleto($fecha)
{
    //Compruebo día de la semana en el que estoy
    $i          = strtotime($fecha);
    $dia_semana = jddayofweek(cal_to_jd(CAL_GREGORIAN, date("m", $i), date("d", $i), date("Y", $i)), 0);

    //Lunes
    if ($dia_semana == 1) {
        return 'Lunes';
    }
    //Martes
    elseif ($dia_semana == 2) {
        return 'Martes';
    }
    //Miércoles
    elseif ($dia_semana == 3) {
        return 'Miércoles';
    }
    //Jueves
    elseif ($dia_semana == 4) {
        return 'Jueves';
    }
    //Viernes
    elseif ($dia_semana == 5) {
        return 'Viernes';
    }
    //Sábado
    elseif ($dia_semana == 6) {
        return 'Sábado';
    }
    //Domingo
    elseif ($dia_semana == 0) {
        return 'Domingo';
    }
}

//Función que comprueba si la web está en dispositivo móvil
function is_mobile()
{

    // Get the user agent

    $user_agent = $_SERVER['HTTP_USER_AGENT'];

    // Create an array of known mobile user agents
    // This list is from the 21 October 2010 WURFL File.
    // Most mobile devices send a pretty standard string that can be covered by
    // one of these.  I believe I have found all the agents (as of the date above)
    // that do not and have included them below.  If you use this function, you
    // should periodically check your list against the WURFL file, available at:
    // http://wurfl.sourceforge.net/

    $mobile_agents = array(

        "240x320",
        "acer",
        "acoon",
        "acs-",
        "abacho",
        "ahong",
        "airness",
        "alcatel",
        "amoi",
        "android",
        "anywhereyougo.com",
        "applewebkit/525",
        "applewebkit/532",
        "asus",
        "audio",
        "au-mic",
        "avantogo",
        "becker",
        "benq",
        "bilbo",
        "bird",
        "blackberry",
        "blazer",
        "bleu",
        "cdm-",
        "compal",
        "coolpad",
        "danger",
        "dbtel",
        "dopod",
        "elaine",
        "eric",
        "etouch",
        "fly ",
        "fly_",
        "fly-",
        "go.web",
        "goodaccess",
        "gradiente",
        "grundig",
        "haier",
        "hedy",
        "hitachi",
        "htc",
        "huawei",
        "hutchison",
        "inno",
        "ipad",
        "ipaq",
        "ipod",
        "jbrowser",
        "kddi",
        "kgt",
        "kwc",
        "lenovo",
        "lg ",
        "lg2",
        "lg3",
        "lg4",
        "lg5",
        "lg7",
        "lg8",
        "lg9",
        "lg-",
        "lge-",
        "lge9",
        "longcos",
        "maemo",
        "mercator",
        "meridian",
        "micromax",
        "midp",
        "mini",
        "mitsu",
        "mmm",
        "mmp",
        "mobi",
        "mot-",
        "moto",
        "nec-",
        "netfront",
        "newgen",
        "nexian",
        "nf-browser",
        "nintendo",
        "nitro",
        "nokia",
        "nook",
        "novarra",
        "obigo",
        "palm",
        "panasonic",
        "pantech",
        "philips",
        "phone",
        "pg-",
        "playstation",
        "pocket",
        "pt-",
        "qc-",
        "qtek",
        "rover",
        "sagem",
        "sama",
        "samu",
        "sanyo",
        "samsung",
        "sch-",
        "scooter",
        "sec-",
        "sendo",
        "sgh-",
        "sharp",
        "siemens",
        "sie-",
        "softbank",
        "sony",
        "spice",
        "sprint",
        "spv",
        "symbian",
        "tablet",
        "talkabout",
        "tcl-",
        "teleca",
        "telit",
        "tianyu",
        "tim-",
        "toshiba",
        "tsm",
        "up.browser",
        "utec",
        "utstar",
        "verykool",
        "virgin",
        "vk-",
        "voda",
        "voxtel",
        "vx",
        "wap",
        "wellco",
        "wig browser",
        "wii",
        "windows ce",
        "wireless",
        "xda",
        "xde",
        "zte",
    );

    // Pre-set $is_mobile to false.

    $is_mobile = false;

    // Cycle through the list in $mobile_agents to see if any of them
    // appear in $user_agent.

    foreach ($mobile_agents as $device) {

        // Check each element in $mobile_agents to see if it appears in
        // $user_agent.  If it does, set $is_mobile to true.

        if (stristr($user_agent, $device)) {

            $is_mobile = true;

            // break out of the foreach, we don't need to test
            // any more once we get a true value.

            break;
        }
    }

    return $is_mobile;
}

function debug($var)
{
    echo '<pre>';
    var_dump($var);
    echo '<pre>';
}

//Configuración del algoritmo de encriptación

/*
Encripta el contenido de la variable, enviada como parametro.
 */
function encriptar($valor)
{
    $clave = CLAVEENCRIPTAR;
    $iv    = base64_decode("C9fBxl1EWtYTL1/M8jfstw==");

    $encrypted = openssl_encrypt($valor, "AES-256-CBC", $clave, 0, $iv);
    return $encrypted;
};

/*
Desencripta el texto recibido
 */
function desencriptar($valor)
{
    $clave = CLAVEENCRIPTAR;
    $iv    = base64_decode("C9fBxl1EWtYTL1/M8jfstw==");

    $valor     = str_replace(" ", "+", $valor);
    $decrypted = openssl_decrypt($valor, "AES-256-CBC", $clave, 0, $iv);

    return $decrypted;
};

function resize_image($file, $maxW, $maxH, $name, $crop = false)
{
    $file_info           = pathinfo($file);
    list($origW, $origH) = getimagesize($file);

    $w = $origW;
    $h = $origH;

    # taller
    if ($h > $maxH) {
        $w = ($maxH / $h) * $w;
        $h = $maxH;
    }

    # wider
    if ($w > $maxW) {
        $h = ($maxW / $w) * $h;
        $w = $maxW;
    }

    $resource = imagecreatetruecolor($w, $h);
    # MUST IMPORTANT TWO ROWS
    imagesavealpha($resource, true);
    imagefill($resource, 0, 0, 0x7fffffff);

    $ext = $file_info['extension'];
    if ($ext == 'jpeg' || $ext == 'jpg') {
        $image = imagecreatefromjpeg($file);
    } else if ($ext == 'png') {
        $image = imagecreatefrompng($file);
    } else {
        throw new Exception('Unsupported extension');
    }

    imagecopyresampled(
        $resource,
        $image, 0, 0, 0, 0,
        $w, $h, $origW, $origH
    );

    //list($nombre,$extension)=explode(".", $file_info['basename']);
    imagejpeg($resource, $file_info['dirname'] . "/" . $name . "." . $file_info['extension']);
}

function obtenerTokenEmail()
{
    try {
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);

        curl_setopt_array($curl, array(
            CURLOPT_URL            => URLAPISMTPTOKEN,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 5, // Tiempo de espera en segundos
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => http_build_query([
                'password' => PASSAPISMTPTOKEN
            ]),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            curl_close($curl);
            return "no_hay_token";
        }

        curl_close($curl);

        $response_json = json_decode($response);

        if (isset($response_json->auth->client_token)) {
            return $response_json->auth->client_token;
        } else {
            return "no_hay_token";
        }
    } catch (Exception $ex) {
        return "no_hay_token";
    }
}

function obtenerPassEmail($token)
{
    $curl = curl_init();

    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt_array($curl, array(
        CURLOPT_URL            => URLAPISMTPDATA,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING       => '',
        CURLOPT_MAXREDIRS      => 10,
        CURLOPT_TIMEOUT        => 5,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST  => 'GET',
        CURLOPT_HTTPHEADER     => array(
            'X-Vault-Token: ' . $token,
            'Content-Type: application/json'
        ),
    ));

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        curl_close($curl);
        return array(
            'respuesta' => false,
        );
    }

    curl_close($curl);

    $response_json = json_decode($response);

    if (isset($response_json->data->data->mail) && $response_json->data->data->mail != '') {
        return array(
            'respuesta' => true,
            'datos_correo' => $response_json->data->data,
        );
    } else {
        return array(
            'respuesta' => false,
        );
    }
}

function obtenerDatosCorreo(){
    $correo = array(
        'mail' => MAILFROM,
        'user' => MAILUSER,
        'pass' => MAILPASS,
    );

    $token = obtenerTokenEmail();  

    if ($token != "no_hay_token") {
        $datoscorreo = obtenerPassEmail($token);

        if ($datoscorreo['respuesta'] == true) {
            $correo = array(
                'mail' => $datoscorreo['datos_correo']->mail,
                'user' => $datoscorreo['datos_correo']->user,
                'pass' => $datoscorreo['datos_correo']->pass,
            );
        }
    }
    return $correo;
}
